/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaComparisionService;
import com.dtyunxi.yundt.cube.center.data.dao.das.AreaComparisionDas;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaComparisionEo;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AreaComparisionImpl
implements IAreaComparisionService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AreaComparisionDas areaComparisionDas;

    @Override
    public AreaComparisionEo queryAreaByKey(Long areaComparisionId) {
        if (areaComparisionId == null || this.areaComparisionDas.selectByPrimaryKey(areaComparisionId) == null) {
            this.logger.info("ID\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728ID\u4e3a" + areaComparisionId + "\u7684\u533a\u57df\u5bf9\u7167\u4fe1\u606f");
            throw new BizException(CenterDataExceptionCode.AREACOMPARISION_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREACOMPARISION_NOT_EXISTS.getMsg());
        }
        return (AreaComparisionEo)this.areaComparisionDas.selectByPrimaryKey(areaComparisionId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long saveAreaComparision(AreaComparisionEo areaComparisionEo) {
        AreaComparisionEo queryEo = new AreaComparisionEo();
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)areaComparisionEo, (String[])new String[0]);
        queryEo.setDr(null);
        queryEo.setCreatePerson(null);
        queryEo.setCreateTime(null);
        queryEo.setUpdatePerson(null);
        queryEo.setUpdateTime(null);
        List areaComparisionEoList = this.areaComparisionDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)areaComparisionEoList)) {
            throw new BizException(CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getCode(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg());
        }
        this.areaComparisionDas.insert((BaseEo)areaComparisionEo);
        return areaComparisionEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void removeById(Long areaComparisionId) {
        boolean flag = false;
        if (areaComparisionId == null) {
            this.logger.info("\u5220\u9664\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1aID\u4e3a\u7a7a");
            throw new BizException(CenterDataExceptionCode.AREACOMPARISION_DELETE_DEFULT.getCode(), CenterDataExceptionCode.AREACOMPARISION_DELETE_DEFULT.getMsg());
        }
        this.areaComparisionDas.deleteById(areaComparisionId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void modifyAreaComparision(AreaComparisionEo areaComparisionEo) {
        Long id = areaComparisionEo.getId();
        if (id == null || this.areaComparisionDas.selectByPrimaryKey(id) == null) {
            this.logger.info("\u66f4\u65b0\u533a\u57df\u5bf9\u7167\u4fe1\u606f\u5931\u8d25\uff1aID\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u5bf9\u5e94ID\u5b9e\u4f53");
            throw new BizException(CenterDataExceptionCode.AREA_UPDATE_DEFULT.getCode(), CenterDataExceptionCode.AREA_UPDATE_DEFULT.getMsg());
        }
        this.areaComparisionDas.updateSelective((BaseEo)areaComparisionEo);
    }

    @Override
    public PageInfo<AreaComparisionEo> queryByPage(AreaComparisionEo areaComparisionEo, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = this.areaComparisionDas.selectPage((BaseEo)areaComparisionEo, pageNum, pageSize);
        if (pageInfo == null) {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230ID\u4e3a" + areaComparisionEo.getId() + "\u7684\u533a\u57df\u5bf9\u7167\u76f8\u5173\u4fe1\u606f");
            throw new BizException(CenterDataExceptionCode.AREACOMPARISION_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREACOMPARISION_NOT_EXISTS.getMsg());
        }
        return pageInfo;
    }

    @Override
    public List<AreaComparisionEo> queryAreaByCondition(AreaComparisionEo areaComparisionEo) {
        return this.areaComparisionDas.select((BaseEo)areaComparisionEo);
    }
}

