/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.AreaGroupReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupDetailRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaGroupService;
import com.dtyunxi.yundt.cube.center.data.dao.das.AreaDas;
import com.dtyunxi.yundt.cube.center.data.dao.das.AreaGroupDas;
import com.dtyunxi.yundt.cube.center.data.dao.das.RGroupAreaDas;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaGroupEo;
import com.dtyunxi.yundt.cube.center.data.dao.eo.RGroupAreaEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AreaGroupServiceImpl
implements IAreaGroupService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AreaGroupDas areaGroupDas;
    @Resource
    private RGroupAreaDas rGroupAreaDas;
    @Resource
    private AreaDas areaDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAreaGroup(AreaGroupReqDto areaGroupReqDto) {
        if (areaGroupReqDto.getCode().equals(areaGroupReqDto.getParentCode())) {
            throw new BizException(CenterDataExceptionCode.CODE_IS_REPEATED_PARENT_CODE.getCode(), CenterDataExceptionCode.CODE_IS_REPEATED_PARENT_CODE.getMsg());
        }
        if (null != this.queryAreaGroupEoByCode(areaGroupReqDto.getCode())) {
            throw new BizException(CenterDataExceptionCode.AREA_GREOUP_CODE_IS_EXISTS.getCode(), CenterDataExceptionCode.AREA_GREOUP_CODE_IS_EXISTS.getMsg());
        }
        AreaGroupEo areaGroupEo = new AreaGroupEo();
        DtoHelper.dto2Eo((BaseVo)areaGroupReqDto, (BaseEo)areaGroupEo);
        if (StringUtils.isEmpty((CharSequence)areaGroupEo.getParentCode())) {
            areaGroupEo.setParentCode("0");
        }
        this.areaGroupDas.insert((BaseEo)areaGroupEo);
        this.saveRGroupArea(areaGroupReqDto.getAreaCodes(), areaGroupEo.getCode());
        return areaGroupEo.getId();
    }

    private AreaGroupEo queryAreaGroupEoByCode(String code) {
        AreaGroupEo areaGroupEo = new AreaGroupEo();
        areaGroupEo.setCode(code);
        return (AreaGroupEo)this.areaGroupDas.selectOne((BaseEo)areaGroupEo);
    }

    private void saveRGroupArea(List<String> areaCodes, String groupCode) {
        if (CollectionUtils.isNotEmpty(areaCodes)) {
            ArrayList rGroupAreaEos = new ArrayList(areaCodes.size());
            areaCodes.forEach(areaCode -> {
                RGroupAreaEo rGroupAreaEo = new RGroupAreaEo();
                rGroupAreaEo.setAreaCode(areaCode);
                rGroupAreaEo.setGroupCode(groupCode);
                rGroupAreaEo.setExtension("");
                rGroupAreaEos.add(rGroupAreaEo);
            });
            this.rGroupAreaDas.insertBatch(rGroupAreaEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeById(Long id) {
        AreaGroupEo areaGroupEo = (AreaGroupEo)this.areaGroupDas.selectByPrimaryKey(id);
        if (null == areaGroupEo) {
            throw new BizException(CenterDataExceptionCode.AREA_GREOUP_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREA_GREOUP_NOT_EXISTS.getMsg());
        }
        List<AreaGroupRespDto> areaGroupEoList = this.queryByParentCode(areaGroupEo.getCode());
        ArrayList<Long> idList = new ArrayList<Long>(1 + (CollectionUtils.isEmpty(areaGroupEoList) ? 0 : areaGroupEoList.size()));
        ArrayList<String> groupCodeList = new ArrayList<String>(idList.size());
        if (CollectionUtils.isNotEmpty(areaGroupEoList)) {
            areaGroupEoList.forEach(areaGroup -> {
                idList.add(areaGroup.getId());
                groupCodeList.add(areaGroup.getCode());
            });
        }
        idList.add(id);
        AreaGroupEo deleteTempEo = new AreaGroupEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", idList));
        deleteTempEo.setSqlFilters(sqlFilterList);
        this.areaGroupDas.delete((BaseEo)deleteTempEo);
        groupCodeList.add(areaGroupEo.getCode());
        this.deleteRGroupAreaByGroupCode(groupCodeList);
    }

    private void deleteRGroupAreaByGroupCode(List<String> groupCodeList) {
        RGroupAreaEo rGroupAreaEo = new RGroupAreaEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"group_code", groupCodeList));
        rGroupAreaEo.setSqlFilters(sqlFilterList);
        this.rGroupAreaDas.delete((BaseEo)rGroupAreaEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAreaGroup(Long id, AreaGroupReqDto areaGroupReqDto) {
        AreaGroupEo temp;
        AreaGroupEo areaGroupEo = (AreaGroupEo)this.areaGroupDas.selectByPrimaryKey(id);
        if (null == areaGroupEo) {
            throw new BizException(CenterDataExceptionCode.AREA_GREOUP_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREA_GREOUP_NOT_EXISTS.getMsg());
        }
        if (null != areaGroupReqDto.getCode() && null != (temp = this.queryAreaGroupEoByCode(areaGroupReqDto.getCode())) && !id.equals(temp.getId())) {
            throw new BizException(CenterDataExceptionCode.AREA_GREOUP_CODE_IS_EXISTS.getCode(), CenterDataExceptionCode.AREA_GREOUP_CODE_IS_EXISTS.getMsg());
        }
        AreaGroupEo modifyAreaGroupEo = new AreaGroupEo();
        DtoHelper.dto2Eo((BaseVo)areaGroupReqDto, (BaseEo)modifyAreaGroupEo);
        modifyAreaGroupEo.setId(id);
        if (null != modifyAreaGroupEo.getParentCode()) {
            if (StringUtils.isEmpty((CharSequence)modifyAreaGroupEo.getParentCode())) {
                modifyAreaGroupEo.setParentCode("0");
            } else {
                AreaGroupEo temp2 = this.queryAreaGroupEoByCode(areaGroupReqDto.getParentCode());
                if (null == temp2) {
                    throw new BizException(CenterDataExceptionCode.AREA_GREOUP_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREA_GREOUP_NOT_EXISTS.getMsg());
                }
            }
        }
        this.areaGroupDas.updateSelective((BaseEo)modifyAreaGroupEo);
        if (!areaGroupEo.getCode().equals(modifyAreaGroupEo.getCode())) {
            AreaGroupEo updateAreaGroup = new AreaGroupEo();
            updateAreaGroup.setParentCode(modifyAreaGroupEo.getCode());
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"parentCode", (Object)areaGroupEo.getParentCode()));
            updateAreaGroup.setSqlFilters(sqlFilterList);
            this.areaGroupDas.updateSelectiveSqlFilter((BaseEo)updateAreaGroup);
        }
        ArrayList<String> groupCodeList = new ArrayList<String>(1);
        groupCodeList.add(areaGroupEo.getCode());
        this.deleteRGroupAreaByGroupCode(groupCodeList);
        this.saveRGroupArea(areaGroupReqDto.getAreaCodes(), StringUtils.isNotEmpty((CharSequence)modifyAreaGroupEo.getCode()) ? modifyAreaGroupEo.getCode() : areaGroupEo.getCode());
    }

    @Override
    public AreaGroupDetailRespDto queryByKey(Long id) {
        AreaGroupEo temp = new AreaGroupEo();
        temp.setId(id);
        return this.queryAreaGroupDetail(temp);
    }

    private AreaGroupDetailRespDto queryAreaGroupDetail(AreaGroupEo temp) {
        AreaGroupEo areaGroupEo;
        if (null == temp.getInstanceId()) {
            temp.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        }
        if (null == temp.getTenantId()) {
            temp.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        if (null == (areaGroupEo = (AreaGroupEo)this.areaGroupDas.selectOne((BaseEo)temp))) {
            return null;
        }
        AreaGroupDetailRespDto areaGroupDetailRespDto = new AreaGroupDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)areaGroupEo, (BaseVo)areaGroupDetailRespDto);
        RGroupAreaEo rGroupAreaEo = new RGroupAreaEo();
        rGroupAreaEo.setGroupCode(areaGroupEo.getCode());
        List rGroupAreaEos = this.rGroupAreaDas.select((BaseEo)rGroupAreaEo);
        if (CollectionUtils.isEmpty((Collection)rGroupAreaEos)) {
            return areaGroupDetailRespDto;
        }
        ArrayList areaCodes = new ArrayList(rGroupAreaEos.size());
        rGroupAreaEos.forEach(rGroupArea -> areaCodes.add(rGroupArea.getAreaCode()));
        AreaEo areaEo = new AreaEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", areaCodes));
        areaEo.setSqlFilters(sqlFilters);
        List areaEos = this.areaDas.select((BaseEo)areaEo);
        if (CollectionUtils.isEmpty((Collection)areaEos)) {
            return areaGroupDetailRespDto;
        }
        ArrayList areaDtoList = new ArrayList(areaEos.size());
        DtoHelper.eoList2DtoList((Collection)areaEos, areaDtoList, AreaDto.class);
        areaGroupDetailRespDto.setAreas(areaDtoList);
        return areaGroupDetailRespDto;
    }

    @Override
    public PageInfo<AreaGroupRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        if (StringUtils.isEmpty((CharSequence)filter)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg());
        }
        AreaGroupEo areaGroupEo = (AreaGroupEo)JSON.parseObject((String)filter, AreaGroupEo.class);
        if (null == areaGroupEo.getInstanceId()) {
            areaGroupEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        }
        if (null == areaGroupEo.getTenantId()) {
            areaGroupEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageInfo = this.areaGroupDas.selectPage((BaseEo)areaGroupEo, pageNum, pageSize)).getList())) {
            ArrayList areaGroupRespDtos = new ArrayList(pageInfo.getList().size());
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), areaGroupRespDtos, AreaGroupRespDto.class);
            pageInfo.setList(areaGroupRespDtos);
        }
        return pageInfo;
    }

    @Override
    public AreaGroupDetailRespDto queryByCode(String code) {
        AreaGroupEo temp = new AreaGroupEo();
        temp.setCode(code);
        return this.queryAreaGroupDetail(temp);
    }

    @Override
    public List<AreaGroupRespDto> queryByParentCode(String parentCode) {
        AreaGroupEo temp = new AreaGroupEo();
        temp.setParentCode(parentCode);
        temp.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        temp.setTenantId(ServiceContext.getContext().getRequestTenantId());
        List areaGroupEos = this.areaGroupDas.select((BaseEo)temp);
        if (CollectionUtils.isEmpty((Collection)areaGroupEos)) {
            return null;
        }
        ArrayList<AreaGroupRespDto> areaGroupRespDtos = new ArrayList<AreaGroupRespDto>(areaGroupEos.size());
        DtoHelper.eoList2DtoList((Collection)areaGroupEos, areaGroupRespDtos, AreaGroupRespDto.class);
        return areaGroupRespDtos;
    }

    @Override
    public List<AreaGroupRespDto> queryByAreaCodes(String[] areaCodes) {
        if (null != areaCodes && areaCodes.length < 1) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg());
        }
        List<String> areaCodeList = Arrays.asList(areaCodes);
        RGroupAreaEo rGroupAreaEo = new RGroupAreaEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"area_code", areaCodeList));
        rGroupAreaEo.setSqlFilters(sqlFilterList);
        rGroupAreaEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        rGroupAreaEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        List rGroupAreaEoList = this.rGroupAreaDas.select((BaseEo)rGroupAreaEo);
        if (CollectionUtils.isEmpty((Collection)rGroupAreaEoList)) {
            return null;
        }
        ArrayList groupCodeList = new ArrayList();
        rGroupAreaEoList.forEach(rGroupArea -> groupCodeList.add(rGroupArea.getGroupCode()));
        AreaGroupEo areaGroupEo = new AreaGroupEo();
        sqlFilterList = new ArrayList();
        sqlFilterList.add(SqlFilter.in((String)"code", groupCodeList));
        areaGroupEo.setSqlFilters(sqlFilterList);
        List areaGroupEoList = this.areaGroupDas.select((BaseEo)areaGroupEo);
        if (CollectionUtils.isEmpty((Collection)areaGroupEoList)) {
            return null;
        }
        ArrayList<AreaGroupRespDto> areaGroupRespDtoList = new ArrayList<AreaGroupRespDto>(areaGroupEoList.size());
        DtoHelper.eoList2DtoList((Collection)areaGroupEoList, areaGroupRespDtoList, AreaGroupRespDto.class);
        return areaGroupRespDtoList;
    }

    @Override
    public List<AreaGroupTreeRespDto> queryForTree() {
        AreaGroupEo temp = new AreaGroupEo();
        temp.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        temp.setTenantId(ServiceContext.getContext().getRequestTenantId());
        List areaGroupEoList = this.areaGroupDas.select((BaseEo)temp);
        if (CollectionUtils.isEmpty((Collection)areaGroupEoList)) {
            return null;
        }
        ArrayList<AreaGroupTreeRespDto> areaGroupTreeRespDtoList = new ArrayList<AreaGroupTreeRespDto>();
        Map<String, List<AreaGroupEo>> areaGroupMap = areaGroupEoList.stream().collect(Collectors.groupingBy(areaGroupEo -> StringUtils.isEmpty((CharSequence)areaGroupEo.getParentCode()) ? "0" : areaGroupEo.getParentCode()));
        DtoHelper.eoList2DtoList((Collection)areaGroupMap.get("0"), areaGroupTreeRespDtoList, AreaGroupTreeRespDto.class);
        areaGroupMap.remove("0");
        this.getChildAreaGroup(areaGroupTreeRespDtoList, areaGroupMap);
        return areaGroupTreeRespDtoList;
    }

    private void getChildAreaGroup(List<AreaGroupTreeRespDto> areaGroupTreeRespDtoList, Map<String, List<AreaGroupEo>> areaGroupMap) {
        areaGroupTreeRespDtoList.forEach(areaGroupTreeDto -> {
            List areaGroupEoList = (List)areaGroupMap.get(areaGroupTreeDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)areaGroupEoList)) {
                ArrayList<AreaGroupTreeRespDto> areaGroupChildrenDtoList = new ArrayList<AreaGroupTreeRespDto>(areaGroupEoList.size());
                DtoHelper.eoList2DtoList((Collection)areaGroupEoList, areaGroupChildrenDtoList, AreaGroupTreeRespDto.class);
                areaGroupTreeDto.setChildren(areaGroupChildrenDtoList);
                areaGroupMap.remove(areaGroupTreeDto.getCode());
                this.getChildAreaGroup(areaGroupChildrenDtoList, areaGroupMap);
            }
        });
    }

    @Override
    public List<AreaGroupRespDto> queryByLevel(Integer level) {
        Integer initLevel = 1;
        if (level < initLevel || level > Constants.MAX_AREA_GROUP_QUERY_LEVEL) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg());
        }
        ArrayList<String> parentCodeList = new ArrayList<String>();
        parentCodeList.add("0");
        return this.queryChildAreaGroup(parentCodeList, level, initLevel, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
    }

    private List<AreaGroupRespDto> queryChildAreaGroup(List<String> parentCodeList, Integer level, Integer currentQueryLevel, Long instanceId, Long tenantId) {
        AreaGroupEo areaGroupEo = new AreaGroupEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"parentCode", parentCodeList));
        areaGroupEo.setSqlFilters(sqlFilterList);
        areaGroupEo.setInstanceId(instanceId);
        areaGroupEo.setTenantId(tenantId);
        List areaGroupEoList = this.areaGroupDas.select((BaseEo)areaGroupEo);
        if (CollectionUtils.isEmpty((Collection)areaGroupEoList)) {
            return null;
        }
        if (currentQueryLevel.equals(level)) {
            ArrayList<AreaGroupRespDto> areaGroupRespDtoList = new ArrayList<AreaGroupRespDto>(areaGroupEoList.size());
            DtoHelper.eoList2DtoList((Collection)areaGroupEoList, areaGroupRespDtoList, AreaGroupRespDto.class);
            return areaGroupRespDtoList;
        }
        Integer areaGroupRespDtoList = currentQueryLevel;
        Integer n = currentQueryLevel = Integer.valueOf(currentQueryLevel + 1);
        ArrayList<String> tempParentCodeList = new ArrayList<String>(areaGroupEoList.size());
        areaGroupEoList.forEach(areaGroup -> tempParentCodeList.add(areaGroup.getCode()));
        return this.queryChildAreaGroup(tempParentCodeList, level, currentQueryLevel, instanceId, tenantId);
    }
}

