/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaSyncService;
import com.dtyunxi.yundt.cube.center.data.biz.service.domain.AreaSyncBox;
import com.dtyunxi.yundt.cube.center.data.biz.service.impl.CubeOfficialAreaCrawler;
import com.dtyunxi.yundt.cube.center.data.dao.das.AreaDas;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AreaSyncServiceImpl
implements IAreaSyncService {
    private static final Logger logger = LoggerFactory.getLogger(AreaSyncServiceImpl.class);
    @Value(value="${yundt.cube.center.data.areaSync.url:}")
    private String url = "http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/2019/";
    @Value(value="${yundt.cube.center.data.areaSync.crawlDepth:3}")
    private int crawlDepth = 3;
    @Resource
    private ILockService lockService;
    @Autowired
    private AreaDas areaDas;

    @Override
    public void sync() {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("bd_area", "1225870619528802332", 3, 1800, TimeUnit.SECONDS);
            logger.info("====================sync area info start====================");
            CubeOfficialAreaCrawler crawler = new CubeOfficialAreaCrawler(this.url, this.areaDas, this.crawlDepth);
            AreaSyncBox areaSyncBox = crawler.start();
            this.areaDas.handleAreaSyncData(areaSyncBox.getInsertAreaEoList(), areaSyncBox.getUpdateAreaEoList(), areaSyncBox.getDeleteAreaEoList());
        }
        catch (Exception e) {
            try {
                logger.error("", (Throwable)e);
                throw new BizException(CenterDataExceptionCode.AREA_SYNCING.getCode(), CenterDataExceptionCode.AREA_SYNCING.getMsg());
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                logger.info("====================sync area info end====================");
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        logger.info("====================sync area info end====================");
    }
}

