/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import cn.edu.hfut.dmic.webcollector.conf.Configuration;
import cn.edu.hfut.dmic.webcollector.model.CrawlDatum;
import cn.edu.hfut.dmic.webcollector.model.CrawlDatums;
import cn.edu.hfut.dmic.webcollector.model.Page;
import cn.edu.hfut.dmic.webcollector.plugin.rocks.BreadthCrawler;
import cn.edu.hfut.dmic.webcollector.util.ExceptionUtils;
import com.dtyunxi.yundt.cube.center.data.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.data.biz.service.domain.AreaSyncBox;
import com.dtyunxi.yundt.cube.center.data.biz.util.WeChatNameUtil;
import com.dtyunxi.yundt.cube.center.data.dao.das.AreaDas;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.dtyunxi.yundt.cube.center.data.dao.eo.StdAreaEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CubeOfficialAreaCrawler
extends BreadthCrawler {
    private static final Logger logger = LoggerFactory.getLogger(CubeOfficialAreaCrawler.class);
    private static final List<String> CRAWL_LEVEL_LIST = Arrays.asList("province", "city", "county", "town", "village");
    private AreaSyncBox areaSyncBox = new AreaSyncBox();
    private String url;
    private AreaDas areaDas;
    private int crawlDepth;

    public CubeOfficialAreaCrawler(String url, AreaDas areaDas, int crawlDepth) {
        super("logs", false);
        this.url = url;
        this.areaDas = areaDas;
        this.crawlDepth = crawlDepth;
    }

    public AreaSyncBox start() {
        this.addSeedAndReturn(this.url);
        this.setConf(Configuration.getDefault().setConnectTimeout(Integer.valueOf(10000)).setReadTimeout(Integer.valueOf(20000)).setWaitThreadEndTime(Integer.valueOf(300000)));
        this.setMaxExecuteCount(5);
        this.setThreads(1);
        try {
            this.start(this.crawlDepth);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return this.areaSyncBox;
    }

    public void visit(Page page, CrawlDatums next) {
        CrawlDatum datum = page.crawlDatum();
        try {
            Elements elements = CubeOfficialAreaCrawler.getElements(page);
            if (elements == null) {
                return;
            }
            ArrayList<AreaEo> items = new ArrayList<AreaEo>();
            CubeOfficialAreaCrawler.handle(next, datum, elements, items);
            this.save(items);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u51fa\u9519\u4e86:" + e.getMessage());
            ExceptionUtils.fail((Throwable)e);
        }
    }

    private static void handle(CrawlDatums next, CrawlDatum datum, Elements elements, List<AreaEo> items) {
        switch (datum.type()) {
            case "province": {
                for (Element element : elements) {
                    if ((element = element.getElementsByTag("a").first()) == null) continue;
                    String href = element.attr("href");
                    String id = href.substring(0, href.lastIndexOf(".html")) + "0000000000";
                    String name = element.text();
                    String url = element.attr("abs:href");
                    CubeOfficialAreaCrawler.handleItem(next, datum, id, name, url, items);
                }
                break;
            }
            case "city": 
            case "county": 
            case "town": {
                for (int i = 0; i < elements.size(); i += 2) {
                    Element idElement = (Element)elements.get(i);
                    Element nameElement = (Element)elements.get(i + 1);
                    String id = idElement.text();
                    String name = nameElement.text();
                    String url = idElement.getElementsByTag("a").attr("abs:href");
                    CubeOfficialAreaCrawler.handleItem(next, datum, id, name, url, items);
                }
                break;
            }
            case "village": {
                for (int i = 0; i < elements.size(); i += 3) {
                    Element idElement = (Element)elements.get(i);
                    Element nameElement = (Element)elements.get(i + 2);
                    String id = idElement.text();
                    String name = nameElement.text();
                    String url = idElement.getElementsByTag("a").attr("abs:href");
                    CubeOfficialAreaCrawler.handleItem(next, datum, id, name, url, items);
                }
                break;
            }
            default: {
                logger.debug("\u672a\u652f\u6301\u7684\u7c7b\u578b:{}", (Object)datum.type());
            }
        }
    }

    private static void handleItem(CrawlDatums next, CrawlDatum datum, String id, String name, String url, List<AreaEo> items) {
        AreaEo areaEo = CubeOfficialAreaCrawler.getAreaEo(datum, id, name);
        items.add(areaEo);
        if (StringUtils.hasText((String)url) && CubeOfficialAreaCrawler.matchNext(datum.type())) {
            CrawlDatum nextDatum = new CrawlDatum(url).meta("parentCode", areaEo.getCode()).meta("levelId", areaEo.getLevelId().intValue()).meta("parentName", areaEo.getName());
            next.add(nextDatum);
        }
    }

    private static AreaEo getAreaEo(CrawlDatum datum, String id, String name) {
        AreaEo areaEo = new AreaEo();
        areaEo.setId(Long.valueOf(id));
        areaEo.setCode(id);
        areaEo.setName(name);
        String parentCode = datum.meta("parentCode");
        if (StringUtils.isEmpty((Object)parentCode)) {
            areaEo.setParentCode("0");
        } else {
            areaEo.setParentCode(parentCode);
        }
        String levelId = datum.meta("levelId");
        if (StringUtils.isEmpty((Object)levelId)) {
            areaEo.setLevelId(Integer.valueOf(0));
        } else {
            areaEo.setLevelId(Integer.valueOf(Integer.parseInt(levelId) + 1));
        }
        if (id.length() >= 6) {
            areaEo.setCaCode(id.substring(0, 6));
        } else {
            areaEo.setCaCode(id);
        }
        areaEo.setExtension("");
        String parentName = datum.meta("parentName");
        if (areaEo.getLevelId() < 2 || areaEo.getLevelId() == 2 && Constants.SKIP_NAME_LIST.contains(parentName)) {
            areaEo.setWeChatLevel(areaEo.getLevelId());
            areaEo.setWeChatName(WeChatNameUtil.getWeChatName(name));
        }
        return areaEo;
    }

    private static Elements getElements(Page page) {
        String cssSelector;
        CrawlDatum datum = page.crawlDatum();
        page.charset("GB18030");
        if (page.select("table.villagetable").size() > 0) {
            datum.type("village");
            cssSelector = ".villagetable .villagetr td";
        } else if (page.select("table.towntable").size() > 0) {
            datum.type("town");
            cssSelector = ".towntable .towntr td";
        } else if (page.select("table.countytable").size() > 0) {
            datum.type("county");
            cssSelector = ".countytable .countytr td";
        } else if (page.select("table.citytable").size() > 0) {
            datum.type("city");
            cssSelector = ".citytable .citytr td";
        } else if (page.select("table.provincetable").size() > 0) {
            datum.type("province");
            cssSelector = ".provincetable .provincetr td";
        } else {
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException e) {
                logger.info("\u4e00\u5206\u949f\u7684\u7b49\u5f85\u88ab\u6253\u65ad\u4e86");
            }
            throw new RuntimeException("Unsupported page!\naddSeedAndReturn(\"" + datum.url() + "\");");
        }
        if (!CubeOfficialAreaCrawler.matchVisit(datum.type())) {
            return null;
        }
        Elements elements = page.select(cssSelector);
        if (elements.size() == 0) {
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException e) {
                logger.info("\u4e00\u5206\u949f\u7684\u7b49\u5f85\u88ab\u6253\u65ad\u4e86");
            }
            throw new RuntimeException("Zero size,code:" + datum.code() + "\naddSeedAndReturn(\"" + datum.url() + "\").type(\"" + datum.type() + "\");");
        }
        return elements;
    }

    private static boolean matchVisit(String type) {
        return CRAWL_LEVEL_LIST.contains(type);
    }

    private static boolean matchNext(String type) {
        return CRAWL_LEVEL_LIST.contains(type);
    }

    private List<AreaEo> getChildAreaList(List<AreaEo> areaEoList, String code) {
        List list = this.areaDas.selectByParentCode(code);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            areaEoList.addAll(list);
            for (AreaEo eo : list) {
                this.getChildAreaList(areaEoList, eo.getCode());
            }
        }
        return areaEoList;
    }

    private void save(List<AreaEo> crawlList) {
        if (!CollectionUtils.isEmpty(crawlList)) {
            String parentCode = crawlList.get(0).getParentCode();
            List areaEoList = this.areaDas.selectByParentCode(parentCode);
            if (!CollectionUtils.isEmpty((Collection)areaEoList)) {
                Map<String, List<AreaEo>> crawlMap = crawlList.stream().filter(eo -> !StringUtils.isEmpty((Object)eo.getCode())).collect(Collectors.groupingBy(StdAreaEo::getCode));
                ArrayList comparedCodeList = Lists.newArrayList();
                for (AreaEo areaEo : areaEoList) {
                    comparedCodeList.add(areaEo.getCode());
                    List<AreaEo> crawlEoList = crawlMap.get(areaEo.getCode());
                    AreaEo crawlEo = null;
                    if (!CollectionUtils.isEmpty(crawlEoList)) {
                        crawlEo = crawlEoList.get(0);
                    }
                    if (crawlEo == null) {
                        if (Constants.SKIP_PROVINCE_NAME_LIST.contains(areaEo.getName())) continue;
                        this.areaSyncBox.delete(areaEo);
                        List<AreaEo> list = this.getChildAreaList(Lists.newArrayList(), areaEo.getCode());
                        if (CollectionUtils.isEmpty(list)) continue;
                        this.areaSyncBox.delete(list);
                        continue;
                    }
                    if (Objects.equals(areaEo.getName(), crawlEo.getName()) && Objects.equals(areaEo.getLevelId(), crawlEo.getLevelId()) && Objects.equals(areaEo.getCaCode(), crawlEo.getCaCode())) continue;
                    areaEo.setName(crawlEo.getName());
                    areaEo.setLevelId(crawlEo.getLevelId());
                    areaEo.setCaCode(crawlEo.getCaCode());
                    this.areaSyncBox.update(areaEo);
                }
                for (AreaEo crawlEo : crawlList) {
                    if (comparedCodeList.contains(crawlEo.getCode())) continue;
                    this.areaSyncBox.insert(crawlEo);
                }
            } else {
                this.areaSyncBox.insert(crawlList);
            }
        }
    }
}

