/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictValueDto;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.biz.service.IDictService;
import com.dtyunxi.yundt.cube.center.data.dao.das.DictDas;
import com.dtyunxi.yundt.cube.center.data.dao.das.DictValueDas;
import com.dtyunxi.yundt.cube.center.data.dao.eo.DictEo;
import com.dtyunxi.yundt.cube.center.data.dao.eo.DictValueEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceImpl
implements IDictService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DictDas dictDas;
    @Resource
    private DictValueDas dictValueDas;
    private static final String SYS = "sys";
    private static final String ENUM = "enum";
    @Resource
    private IContext context;
    @Autowired
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDict(DictDto dictDto) {
        this.validationDictDto(dictDto);
        DictEo dictEo = new DictEo();
        DtoHelper.dto2Eo((BaseVo)dictDto, (BaseEo)dictEo);
        DictEo existsEo = new DictEo();
        existsEo.setTenantId(dictDto.getTenantId());
        existsEo.setGroupCode(dictDto.getGroupCode());
        existsEo.setCode(dictDto.getCode());
        if (this.dictDas.count((BaseEo)existsEo) > 0) {
            throw new BizException(CenterDataExceptionCode.DICT_UNIQUE_EXCEPTION.getCode(), CenterDataExceptionCode.DICT_UNIQUE_EXCEPTION.getMsg());
        }
        if (this.dictDas.count((BaseEo)dictEo) > 0) {
            if (ENUM.equals(dictEo.getType())) {
                this.insertOrUpdateValue(dictEo.getId(), dictDto.getDictValueList());
            }
        } else {
            if (CollectionUtils.isEmpty((Collection)dictDto.getDictValueList())) {
                dictEo.setType(SYS);
            } else {
                dictEo.setType(ENUM);
            }
            this.dictDas.insert((BaseEo)dictEo);
            if (ENUM.equals(dictEo.getType())) {
                this.insertOrUpdateValue(dictEo.getId(), dictDto.getDictValueList());
            }
        }
        this.clearQueryDictByGroupCodeAndCode(dictEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDict(Long tenantId, String groupCode, String code) {
        DictEo dictEo = new DictEo();
        dictEo.setTenantId(tenantId);
        dictEo.setGroupCode(groupCode);
        dictEo.setCode(code);
        List dictEoList = this.dictDas.select((BaseEo)dictEo);
        if (CollectionUtils.isEmpty((Collection)dictEoList)) {
            return;
        }
        this.dictDas.delete((BaseEo)dictEo);
        for (DictEo dict : dictEoList) {
            if (!ENUM.equals(dict.getType())) continue;
            DictValueEo dictValueEo = new DictValueEo();
            dictValueEo.setDictId(dict.getId());
            this.dictValueDas.delete((BaseEo)dictValueEo);
        }
        this.clearQueryDictByGroupCodeAndCode(dictEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDict(DictDto dictDto) {
        DictEo dictEo = this.queryDict(dictDto.getTenantId(), dictDto.getGroupCode(), dictDto.getCode());
        if (dictEo == null) {
            this.logger.info("\u627e\u4e0d\u5230tenantId\u4e3a" + dictDto.getTenantId() + ",groupCode\u4e3a" + dictDto.getGroupCode() + ",code\u4e3a" + dictDto.getCode() + "\u7684\u5b57\u5178!");
            throw new BizException(CenterDataExceptionCode.DICT_NOT_EXISTS.getCode(), CenterDataExceptionCode.DICT_NOT_EXISTS.getMsg());
        }
        DtoHelper.dto2Eo((BaseVo)dictDto, (BaseEo)dictEo);
        dictEo.setType(null);
        this.dictDas.updateSelective((BaseEo)dictEo);
        if (ENUM.equals(dictDto.getType()) && CollectionUtils.isNotEmpty((Collection)dictDto.getDictValueList())) {
            this.insertOrUpdateValue(dictEo.getId(), dictDto.getDictValueList());
        }
        this.clearQueryDictByGroupCodeAndCode(dictEo);
    }

    @Override
    public DictDto queryByGroupCodeAndCode(Long tenantId, String groupCode, String code) {
        String key = RedisKeyConstants.combineKey((String)"dictCache", (Object[])new Object[]{"queryByGroupCodeAndCode", tenantId, groupCode, code});
        String cache = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            if ("none_value".equals(cache)) {
                return null;
            }
            return (DictDto)JSON.parseObject((String)cache, DictDto.class);
        }
        DictEo dictEo = this.queryDict(tenantId, groupCode, code);
        if (dictEo == null) {
            this.cacheService.setCache(key, (Object)"none_value");
            this.logger.info("\u627e\u4e0d\u5230tenantId\u4e3a" + tenantId + ",groupCode\u4e3a" + groupCode + ",code\u4e3a" + code + "\u7684\u5b57\u5178!");
            return null;
        }
        DictDto dictDto = new DictDto();
        DtoHelper.eo2Dto((BaseEo)dictEo, (BaseVo)dictDto);
        if (ENUM.equals(dictEo.getType())) {
            dictDto.setDictValueList(this.queryDictValueByDictId(dictEo.getId()));
        }
        this.cacheService.setCache(key, (Object)JSON.toJSONString((Object)dictDto));
        return dictDto;
    }

    @Override
    public List<DictDto> queryByGroupCode(Long tenantId, String groupCode) {
        String key = RedisKeyConstants.combineKey((String)"dictCache", (Object[])new Object[]{"queryByGroupCode", tenantId, groupCode});
        String cache = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            if ("none_value".equals(cache)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)cache, DictDto.class);
        }
        DictEo dictEo = new DictEo();
        dictEo.setTenantId(tenantId);
        dictEo.setGroupCode(groupCode);
        ArrayList<DictDto> dictDtoList = new ArrayList<DictDto>();
        List<DictEo> dictEoList = this.queryDictList(dictEo);
        if (CollectionUtils.isEmpty(dictEoList)) {
            this.cacheService.setCache(key, (Object)"none_value");
            return Collections.emptyList();
        }
        DtoHelper.eoList2DtoList(dictEoList, dictDtoList, DictDto.class);
        for (DictDto dictDto : dictDtoList) {
            if (!ENUM.equals(dictDto.getType())) continue;
            dictDto.setDictValueList(this.queryDictValueByDictId(dictDto.getId()));
        }
        this.cacheService.setCache(key, (Object)JSON.toJSONString(dictDtoList));
        return dictDtoList;
    }

    @Override
    public PageInfo<DictDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo dictDtoPageInfo = new PageInfo();
        if (StringUtils.isBlank((CharSequence)filter)) {
            dictDtoPageInfo.setPageNum(pageNum.intValue());
            dictDtoPageInfo.setPageSize(pageSize.intValue());
            return dictDtoPageInfo;
        }
        DictDto dictDto = (DictDto)JSON.parseObject((String)filter, DictDto.class);
        if (dictDto == null && dictDto.getInstanceId() == null && dictDto.getTenantId() == null) {
            return dictDtoPageInfo;
        }
        if (dictDto.getTenantId() == null) {
            dictDto.setTenantId(this.context.tenantId());
        }
        DictEo dictEo = new DictEo();
        DtoHelper.dto2Eo((BaseVo)dictDto, (BaseEo)dictEo);
        PageInfo dictEoPageInfo = this.dictDas.selectPage((BaseEo)dictEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dictDtoPageInfo, (Object)dictEoPageInfo, (String[])new String[]{"navigatepageNums"});
        ArrayList dictDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dictEoPageInfo.getList(), dictDtoList, DictDto.class);
        for (DictDto dto : dictDtoList) {
            if (!ENUM.equals(dto.getType())) continue;
            dto.setDictValueList(this.queryDictValueByDictId(dto.getId(), dictDto.getDictValueStatus()));
        }
        dictDtoPageInfo.setList(dictDtoList);
        return dictDtoPageInfo;
    }

    public List<DictValueDto> queryDictValueListByDictId(Long dictId) {
        String key = RedisKeyConstants.combineKey((String)"dictCache", (Object[])new Object[]{"queryDictValueListByDictId", dictId});
        String cache = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            if ("none_value".equals(cache)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)cache, DictValueDto.class);
        }
        DictValueEo dictValueEo = new DictValueEo();
        dictValueEo.setDictId(dictId);
        ArrayList<DictValueDto> dictValueDtoList = new ArrayList<DictValueDto>();
        List dictValueEoList = this.dictValueDas.select((BaseEo)dictValueEo);
        if (CollectionUtils.isEmpty((Collection)dictValueEoList)) {
            this.cacheService.setCache(key, (Object)"none_value");
            return dictValueDtoList;
        }
        DtoHelper.eoList2DtoList((Collection)dictValueEoList, dictValueDtoList, DictValueDto.class);
        this.cacheService.setCache(key, (Object)JSON.toJSONString(dictValueDtoList));
        return dictValueDtoList;
    }

    private List<DictValueDto> queryDictValueByDictId(Long dictId, Integer status) {
        List<DictValueDto> dictValueDtoList = this.queryDictValueListByDictId(dictId);
        if (CollectionUtils.isEmpty(dictValueDtoList)) {
            return Collections.emptyList();
        }
        if (status == null) {
            return dictValueDtoList;
        }
        return dictValueDtoList.stream().filter(item -> status.equals(item.getStatus())).collect(Collectors.toList());
    }

    private List<DictValueDto> queryDictValueByDictId(Long dictId) {
        return this.queryDictValueByDictId(dictId, null);
    }

    private void validationDictDto(DictDto dictDto) {
        if (dictDto.getTenantId() == null) {
            throw new BizException(CenterDataExceptionCode.DICT_TENANTID_EMPTY.getCode(), CenterDataExceptionCode.DICT_TENANTID_EMPTY.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)dictDto.getGroupCode())) {
            throw new BizException(CenterDataExceptionCode.DICT_GROUPCODE_EMPTY.getCode(), CenterDataExceptionCode.DICT_GROUPCODE_EMPTY.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)dictDto.getCode())) {
            throw new BizException(CenterDataExceptionCode.DICT_CODE_EMPTY.getCode(), CenterDataExceptionCode.DICT_CODE_EMPTY.getMsg());
        }
        this.checkUnique(dictDto.getTenantId(), dictDto.getGroupCode(), dictDto.getCode());
    }

    private void checkUnique(Long tenantId, String groupCode, String code) {
        if (this.queryDict(tenantId, groupCode, code) != null) {
            this.logger.info("groupCode\u4e3a" + groupCode + ",code\u4e3a" + code + "\u7684\u5b57\u5178\u5df2\u5b58\u5728!");
            throw new BizException(CenterDataExceptionCode.DICT_UNIQUE_EXCEPTION.getCode(), CenterDataExceptionCode.DICT_UNIQUE_EXCEPTION.getMsg());
        }
    }

    private DictEo queryDict(Long tenantId, String groupCode, String code) {
        DictEo dictEo = new DictEo();
        dictEo.setTenantId(tenantId);
        dictEo.setGroupCode(groupCode);
        dictEo.setCode(code);
        dictEo = (DictEo)this.dictDas.selectOne((BaseEo)dictEo);
        return dictEo;
    }

    private List<DictEo> queryDictList(DictEo dictEo) {
        return this.dictDas.select((BaseEo)dictEo);
    }

    private void insertOrUpdateValue(Long dictId, List<DictValueDto> dictValueDtoList) {
        for (DictValueDto dictValueDto : dictValueDtoList) {
            DictValueEo dictValueEo = new DictValueEo();
            DtoHelper.dto2Eo((BaseVo)dictValueDto, (BaseEo)dictValueEo);
            if (dictValueEo.getId() != null) {
                this.dictValueDas.updateSelective((BaseEo)dictValueEo);
                continue;
            }
            dictValueEo.setDictId(dictId);
            this.dictValueDas.insert((BaseEo)dictValueEo);
        }
    }

    public void clearQueryDictByGroupCodeAndCode(DictEo eo) {
        String queryByGroupCodeAndCode = RedisKeyConstants.combineKey((String)"dictCache", (Object[])new Object[]{"queryByGroupCodeAndCode", eo.getTenantId(), eo.getGroupCode(), eo.getCode()});
        String queryByGroupCode = RedisKeyConstants.combineKey((String)"dictCache", (Object[])new Object[]{"queryByGroupCode", eo.getTenantId(), eo.getGroupCode()});
        String queryDictValueList = RedisKeyConstants.combineKey((String)"dictCache", (Object[])new Object[]{"queryDictValueListByDictId", eo.getId()});
        this.cacheService.delCache(queryByGroupCodeAndCode);
        this.cacheService.delCache(queryByGroupCode);
        this.cacheService.delCache(queryDictValueList);
    }
}

