/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.data.api.constants.DocConstants;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.biz.service.IFileService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
implements IFileService {
    private Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired(required=false)
    private IObjectStorageService objectStorageService;

    @Override
    public Map<String, String> uploadFilePolicy() {
        return this.objectStorageService.createPolicy();
    }

    @Override
    public Map<String, Object> uploadFile(MultipartFile file) {
        if (null == file || file.isEmpty()) {
            throw new BusinessRuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        String fileType = this.getFileType(file);
        String fileName = String.format("%s%s" + fileType, "mpc", System.currentTimeMillis());
        String url = "";
        try {
            byte[] buf = file.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            this.objectStorageService.put(DocConstants.OSS_BUCKET_NAME, fileName, (InputStream)byteArrayInputStream);
            url = DocConstants.OOS_DOWNLOAD_FILE_URL + "/" + fileName;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new BusinessRuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("url", url);
        return result;
    }

    public String getFileType(MultipartFile file) {
        if (StringUtils.isBlank((CharSequence)file.getOriginalFilename())) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), "\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int begin = file.getOriginalFilename().lastIndexOf(".");
        int last = file.getOriginalFilename().length();
        return file.getOriginalFilename().substring(begin, last);
    }
}

