
CREATE TABLE IF NOT EXISTS `bd_area_comparison`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `province_code` varchar(32)  NOT NULL COMMENT '省份编码',
  `city_code` varchar(32)  NOT NULL COMMENT '城市编码',
  `area_code` varchar(32)  NOT NULL COMMENT '区域编码',
  `third_planform_code` varchar(32)  NOT NULL COMMENT '可以是名称也可以是编码，由上层业务决定. 单词拼写错了,应该是: third_platform_code',
  `third_province` varchar(32)  NOT NULL COMMENT '第三方省份名称',
  `third_city` varchar(32)  NOT NULL COMMENT '第三方城市名称',
  `third_area` varchar(32)  NOT NULL COMMENT '第三方区域名称',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_area`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(32)  NOT NULL COMMENT '编码',
  `parent_code` varchar(32)  NOT NULL COMMENT '父编码',
  `name` varchar(120)  NOT NULL COMMENT '名称',
  `post_code` varchar(10)  NULL DEFAULT NULL COMMENT '邮编',
  `level_id` int(11) NULL DEFAULT NULL COMMENT '级别',
  `dialling_code` varchar(10)  NULL DEFAULT NULL COMMENT '电话区号',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 1,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT 'init',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT 'init',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  `ca_code` char(6)  NULL DEFAULT NULL COMMENT '民政部编码',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uidx_parentcode_code`(`parent_code`, `code`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '区域信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_area_group`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(32)  NOT NULL COMMENT '编码',
  `parent_code` varchar(32)  NOT NULL DEFAULT '0' COMMENT '父编码',
  `name` varchar(120)  NOT NULL COMMENT '名称',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_parentcode`(`parent_code`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '区域分组信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_group_area`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `group_code` varchar(32)  NOT NULL COMMENT '分组编码',
  `area_code` varchar(32)  NOT NULL COMMENT '区域编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_group_code`(`group_code`) USING BTREE,
  INDEX `idx_area_code`(`area_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '区域分组区域关联信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_dict`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `group_code` varchar(50)  NOT NULL COMMENT '分组',
  `code` varchar(100)  NOT NULL COMMENT '枚举key',
  `value` varchar(2000)  NOT NULL COMMENT '枚举值',
  `statement` varchar(200)  NULL DEFAULT NULL COMMENT '枚举描述',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '0,锁定（不可停用） 1,启用 2.停用',
  `def1` varchar(200)  NULL DEFAULT NULL COMMENT '自定义1',
  `def2` varchar(200)  NULL DEFAULT NULL COMMENT '自定义2',
  `def3` varchar(200)  NULL DEFAULT NULL COMMENT '自定义3',
  `def4` varchar(200)  NULL DEFAULT NULL COMMENT '自定义4',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `type` varchar(64)  NULL DEFAULT 'sys' COMMENT '类型(sys系统常量配置 enum系统枚举值)',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uidx_tenant_groupcode_code`(`tenant_id`, `group_code`, `code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统字典，存放各种配置、开关等字典类型数据' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_dict_value`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `dict_id` bigint(20) NULL DEFAULT NULL COMMENT '枚举ID',
  `value` varchar(256)  NULL DEFAULT NULL COMMENT '值',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '状态(1启用 0停用)',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务定义扩展值',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '实例ID',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '更新人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除(0可用 1已删除)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统枚举关联值，一对多的放这里' ROW_FORMAT = Dynamic;