BEGIN;
ALTER TABLE `bd_area` ADD COLUMN `wechat_level` INT ( 11 ) DEFAULT NULL COMMENT '微信级别',
ADD COLUMN `wechat_name` VARCHAR ( 120 ) DEFAULT NULL COMMENT '微信简称';

-- 初始化微信级别
-- SELECT
-- 	*
-- FROM
-- 	bd_area
-- WHERE
-- 	level_id IN ( 0, 1 );

UPDATE bd_area
SET wechat_level = level_id
WHERE
	level_id IN ( 0, 1 );

-- 初始化微信简称
UPDATE bd_area
SET wechat_name = `name`
WHERE
	level_id IN ( 0, 1 );

-- SELECT
-- 	*
-- FROM
-- 	bd_area
-- WHERE
-- 	parent_code IN (
-- 	SELECT
-- 		`code`
-- 	FROM
-- 		bd_area
-- 	WHERE
-- 	level_id = 1
-- 	AND `name` IN ( '市辖区', '省直辖县级行政区划' ));

UPDATE bd_area
SET wechat_name = `name`
WHERE
	parent_code IN ( SELECT a.`code` FROM ( SELECT `code` AS `code` FROM bd_area WHERE level_id = 1 AND `name` IN ( '市辖区', '省直辖县级行政区划' )) a );

-- 处理微信简称，台湾、香港、澳门无需替换
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'蒙古自治州','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'朝鲜族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'土家族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'苗族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'壮族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'藏族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'羌族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'哈萨克','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'维吾尔','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'蒙古族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'柯尔克孜','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'回族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'傣族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'景颇族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'傈僳族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'彝族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'白族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'哈尼族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'侗族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'布依族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'壮族','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'自治区','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'盟','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'自治州','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'地区','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'省','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'市','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'区','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) > 6;
UPDATE bd_area SET wechat_name = REPLACE(wechat_name,'中国','') WHERE level_id IN ( 0, 1 ) AND length( `code` ) <= 6;

UPDATE bd_area
SET wechat_name = REPLACE(wechat_name,'黎族苗族自治县','')
WHERE
	parent_code IN ( SELECT a.`code` FROM ( SELECT `code` AS `code` FROM bd_area WHERE level_id = 1 AND `name` IN ( '市辖区', '省直辖县级行政区划' )) a );

UPDATE bd_area
SET wechat_name = REPLACE(wechat_name,'黎族自治县','')
WHERE
	parent_code IN ( SELECT a.`code` FROM ( SELECT `code` AS `code` FROM bd_area WHERE level_id = 1 AND `name` IN ( '市辖区', '省直辖县级行政区划' )) a );

UPDATE bd_area
SET wechat_name = REPLACE(wechat_name,'市','')
WHERE
	parent_code IN ( SELECT a.`code` FROM ( SELECT `code` AS `code` FROM bd_area WHERE level_id = 1 AND `name` IN ( '市辖区', '省直辖县级行政区划' )) a );

UPDATE bd_area
SET wechat_name = REPLACE(wechat_name,'区','')
WHERE
	parent_code IN ( SELECT a.`code` FROM ( SELECT `code` AS `code` FROM bd_area WHERE level_id = 1 AND `name` IN ( '市辖区', '省直辖县级行政区划' )) a );

UPDATE bd_area
SET wechat_name = REPLACE(wechat_name,'县','')
WHERE
	parent_code IN ( SELECT a.`code` FROM ( SELECT `code` AS `code` FROM bd_area WHERE level_id = 1 AND `name` IN ( '市辖区', '省直辖县级行政区划' )) a );
COMMIT;