package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions.ApiPropPermissionGrantReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions.ApiPropPermissionSingleGrantReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * API属性权限服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：API属性权限服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IApiPropPermissionApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/api-prop-permission", url = "${yundt.cube.center.data.api:}")
public interface IApiPropPermissionApi {

    /**
     * 批量对API的dto属性权限授权[覆盖更新，取当前最新权限集为最终结果]
     *
     * @author : 萧玄
     * @Date: 14:09 2020/5/8
     */
    @PostMapping("/grant/batch")
    @ApiOperation(value = "批量对API的dto属性权限授权[覆盖更新，取当前最新权限集为最终结果]", notes = "批量对API的dto属性权限授权[覆盖更新，取当前最新权限集为最终结果]")
    @Capability(capabilityCode = "basicdata.api-prop-permission.grant-batch")
    RestResponse<Void> grantBatch(@RequestBody ApiPropPermissionGrantReqDto addReqDto);

    /**
     * 单个开启/关闭API的dto属性权限
     *
     * @param apiPropPermissionReqDto API属性权限请求对象
     * @return 处理结果
     */
    @PostMapping("grant")
    @ApiOperation(value = "单个开启/关闭API的dto属性权限", notes = "单个开启/关闭API的dto属性权限")
    @Capability(capabilityCode = "basicdata.api-prop-permission.grant-single")
    RestResponse<Void> grantSingle(@RequestBody ApiPropPermissionSingleGrantReqDto apiPropPermissionReqDto);

    /**
     * 删除API属性权限
     *
     * @param ids API属性权限删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/by-ids")
    @ApiOperation(value = "关闭API的dto属性权限", notes = "删除API属性权限[如果只勾选关闭父权限，会把该父属性下的全部子属性全部删除；如果只关闭该某个父属性权限下的全部已经勾选的子属性权限，会变成直接取该父属性的权限作为其下全部子属性的权限]")
    @Capability(capabilityCode = "basicdata.api-prop-permission.remove-api-prop-permission")
    RestResponse<Void> removeApiPropPermission(@RequestParam("ids") String ids);
}
