package com.dtyunxi.yundt.cube.center.func.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AddGroup;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ModifyGroup;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizIdCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.BizIdModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid.SpaceIdConfigsReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 业务身份服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：配置项管理：业务身份服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IBizIdApi",
        name = "${yundt.cube.center.data.name:yundt-cube-center-data}", path = "/v1/biz-id", url = "${yundt.cube.center.data.api:}")
@Validated
public interface IBizIdApi {

    /**
     * 新增业务身份
     *
     * @param addReqDto 业务身份请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增业务身份", notes = "新增业务身份")
    @Capability(capabilityCode = "basicdata.biz-id.add-biz-id")
    RestResponse<Long> addBizId(@RequestBody @Validated(AddGroup.class) BizIdCreateReqDto addReqDto);

    /**
     * 修改业务身份
     *
     * @param modifyReqDto 业务身份请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改业务身份", notes = "修改业务身份")
    @Capability(capabilityCode = "basicdata.biz-id.modify-biz-id")
    RestResponse<Void> modifyBizId(@RequestBody @Validated(ModifyGroup.class) BizIdModifyReqDto modifyReqDto);

    /**
     * 删除业务身份
     *
     * @param codes 业务身份删除数据codes
     * @return 处理结果
     */
    @DeleteMapping("")
    @ApiOperation(value = "删除业务身份", notes = "删除业务身份")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "codes", value = "编码列表", paramType = "query", allowMultiple = true, required = true)
    })
    @Capability(capabilityCode = "basicdata.biz-id.remove-biz-id")
    RestResponse<Void> removeBizId(@RequestParam(value = "tenantId", required = false) Long tenantId,
                                   @RequestParam(value = "codes", defaultValue = "") @Size(min = 1, message = "至少要有一个业务身份编码") List<String> codes);


    /**
     * 设置业务空间和业务身份关系
     *
     * @param type       类型：1绑定,2解绑
     * @param idCode     业务身份编码
     * @param spaceCodes 多个业务空间编码
     * @return 处理结果
     */
    @PostMapping("space")
    @ApiOperation(value = "设置业务空间和业务身份关系", notes = "设置业务空间和业务身份关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "type", value = "类型：1新增,2删除", paramType = "query", required = true),
            @ApiImplicitParam(name = "tenantId", value = "租户id  废弃，改由上下文获取", paramType = "query"),
            @ApiImplicitParam(name = "idCode", value = "业务身份编码", paramType = "query", required = true),
            @ApiImplicitParam(name = "spaceCodes", value = "业务空间编码列表", paramType = "query", allowMultiple = true, required = true)
    })
    @Capability(capabilityCode = "basicdata.biz-id.id-space")
    RestResponse<Void> idSpace(@RequestParam("type") @NotNull(message = "类型只能是新增或删除") Integer type,
                               @RequestParam(value = "tenantId", required = false) Long tenantId,
                               @RequestParam("idCode") @NotBlank(message = "业务身份编码不能为空") String idCode,
                               @RequestParam(value = "spaceCodes", defaultValue = "") @Size(min = 1, message = "至少要有一个业务空间编码") List<String> spaceCodes);

    /**
     * 设置业务空间和业务身份下的配置项
     * {
     * "spaceCode": "xxspace",
     * "idCode": "xxidcode",
     * "configs": [
     * {
     * //type类型：1是业务参数,2是扩展点
     * "type": 1,
     * //业务参数code或扩展点code
     * "code": "xxxCode",
     * "values": [
     * "选项编码1或输入值"
     * ]
     * }
     * ]
     * }
     */
    @PutMapping("space-id-configs")
    @ApiOperation(value = "设置业务空间和业务身份下的配置项", notes = "设置业务空间和业务身份下的配置项")
    @Capability(capabilityCode = "basicdata.biz-id.id-space-configs")
    RestResponse<Void> idSpaceConfigs(@RequestBody @Validated SpaceIdConfigsReqDto reqDto);
}
