/*
 * @(#)IDictApi.java1.0 2018年7月17日
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.dtyunxi.yundt.cube.center.func.api.query;


import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionSingleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizExtensionQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 扩展点Query(CQRS)接口
 *
 * @author youyang
 * @since 2.6.21.0
 */
@Api(tags = {"基础数据中心：配置项管理：扩展点服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IBizExtensionQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v2/biz-extension", url = "${yundt.cube.center.data.api:}")
public interface IBizExtensionQueryApi {


    /**
     * 查询单个扩展点详情
     *
     * @param extensionSingleQueryReqDto 其他查询条件或配置
     * @return 字典集合
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    @ApiOperation(value = "查询单个扩展点详情")
    @Capability(capabilityCode = "basicdata.biz-extension.query-by-code")
    RestResponse<BizExtensionQueryRespDto> queryByCode(@SpringQueryMap BizExtensionSingleQueryReqDto extensionSingleQueryReqDto);


    /**
     * 根据查询条件查询数据
     *
     * @param bizExtensionQueryReqDto 查询条件
     * @param pageNum                 当前页
     * @param pageSize                页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询数据", notes = "根据查询条件查询数据")
    @Capability(capabilityCode = "basicdata.biz-extension.query-by-page")
    RestResponse<PageInfo<BizExtensionQueryRespDto>> queryByPage(@SpringQueryMap BizExtensionQueryReqDto bizExtensionQueryReqDto,
                                                                 @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


}
