/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.svr.rest;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.starter.bundle.dto.BundleDescDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDescRespDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.IBundleSyncService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.BundleLoadedQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BundleLoadedRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IWeakReferenceQueryApi;
import com.dtyunxi.yundt.cube.center.func.api.IBundleApi;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleVersionRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ContainerRespDto;
import com.dtyunxi.yundt.cube.center.func.api.query.IBundleQueryApi;
import com.dtyunxi.yundt.cube.center.func.biz.mq.BundleBootDescProcess;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.core.io.UrlResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="bundleRest")
@RequestMapping(value={"/v1/bundle"})
public class BundleRest
implements IBundleApi,
IBundleQueryApi,
IWeakReferenceQueryApi {
    @Autowired
    BundleBootDescProcess bundleBootDescProcess;
    @Resource
    private IBundleApi bundleApi;
    @Resource
    private IBundleQueryApi bundleQueryApi;
    @Resource(name="bundleBaseSettingSyncService")
    private IBundleSyncService bundleSyncService;
    @Resource
    private IWeakReferenceQueryApi weakReferenceQueryApi;

    public RestResponse<Long> addBundle(@RequestBody BundleCreateReqDto addReqDto) {
        return this.bundleApi.addBundle(addReqDto);
    }

    public RestResponse<Void> modifyBundle(@RequestBody BundleModifyReqDto modifyReqDto) {
        return this.bundleApi.modifyBundle(modifyReqDto);
    }

    public RestResponse<Void> removeBundle(@PathVariable(value="code") String code) {
        return this.bundleApi.removeBundle(code);
    }

    public RestResponse<BundleRespDto> queryById(@PathVariable(value="id") Long id) {
        return this.bundleQueryApi.queryById(id);
    }

    public RestResponse<BundleVersionRespDto> queryVersionByCode(@PathVariable(value="bundleCode") String bundleCode) {
        return this.bundleQueryApi.queryVersionByCode(bundleCode);
    }

    public RestResponse<PageInfo<BundleRespDto>> queryByParentCode(@PathVariable(value="parentCode") String parentCode, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="100") Integer pageSize) {
        return this.bundleQueryApi.queryByParentCode(parentCode, pageNum, pageSize);
    }

    public RestResponse<PageInfo<BundleRespDto>> queryByPage(@SpringQueryMap BundleQueryReqDto bundleQueryReqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="2000") Integer pageSize) {
        return this.bundleQueryApi.queryByPage(bundleQueryReqDto, pageNum, pageSize);
    }

    public RestResponse<PageInfo<ContainerRespDto>> queryContainerByBundleId(@RequestParam(value="bundleId") Long bundleId, @RequestParam(name="containerType", required=false) Integer containerType, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="2000") Integer pageSize) {
        return this.bundleQueryApi.queryContainerByBundleId(bundleId, containerType, pageNum, pageSize);
    }

    public RestResponse<BundleQueryRespDto> queryBundleBaseInfo(BundleReqDto bundleReqDto) {
        return this.bundleQueryApi.queryBundleBaseInfo(bundleReqDto);
    }

    public RestResponse<BundleRespDto> queryByCode(@PathVariable(value="code") String code) {
        return this.bundleQueryApi.queryByCode(code);
    }

    @GetMapping(value={"/pull"})
    public RestResponse<Void> pullBundleInfo(@SpringQueryMap BundleDescDto bundleDescDto) {
        this.bundleBootDescProcess.process(bundleDescDto);
        return new RestResponse();
    }

    public RestResponse<BundleLoadedRespDto> queryBundleLoadedInfo(@RequestBody BundleLoadedQueryReqDto bundleLoadedQueryReqDto) {
        return this.weakReferenceQueryApi.queryBundleLoadedInfo(bundleLoadedQueryReqDto);
    }

    @GetMapping(value={"/pull-from-local-file"})
    public RestResponse<Void> pullBundleInfo() {
        List bundleDescList = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> jsonFiles = null;
        try {
            jsonFiles = classLoader.getResources("bundle-periodic-center-identity.json");
            while (jsonFiles.hasMoreElements()) {
                URL url = jsonFiles.nextElement();
                UrlResource resource = new UrlResource(url);
                StringBuilder json = new StringBuilder();
                IOUtils.readLines((InputStream)resource.getInputStream()).forEach(line -> json.append((String)line));
                bundleDescList = JSONArray.parseArray((String)json.toString(), BundleDescRespDto.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bundleSyncService.handle(bundleDescList, BundleDataTypeEnum.BASE_SETTING);
        return new RestResponse();
    }
}

