/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.channel.biz.channel.wechat;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.notifier.api.RawFeignClientCaller;
import com.dtyunxi.cube.notifier.config.NotifierFeignClientConfig;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.channel.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.channel.api.dto.wechat.WechatTokenReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.query.raw.WechatApi;
import com.dtyunxi.yundt.cube.center.channel.biz.channel.AbstractChannelService;
import com.dtyunxi.yundt.cube.center.channel.biz.channel.ChannelSelector;
import com.dtyunxi.yundt.cube.center.channel.biz.config.CubeWechatConfig;
import com.dtyunxi.yundt.cube.center.channel.dao.eo.ChannelAccountEo;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractWechatChannelService
extends AbstractChannelService<WechatTokenReqDto> {
    NotifierFeignClientConfig notifierFeignClientConfig = new NotifierFeignClientConfig();
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractWechatChannelService.class);
    protected static final String WECHAT_DOMAIN = "api.weixin.qq.com";
    @Resource
    private CubeWechatConfig cubeWechatConfig;
    @Resource
    private ICacheService cacheService;

    public AbstractWechatChannelService(int channelType, ChannelSelector channelSelector) {
        super(channelType, channelSelector);
        this.notifierFeignClientConfig.setProtocol("https");
    }

    @Override
    public WechatTokenReqDto getRequestTokenParam(ChannelAccountEo channelAccountEo) {
        WechatTokenReqDto wechatTokenReqDto = (WechatTokenReqDto)JSONObject.parseObject((String)channelAccountEo.getConfig(), WechatTokenReqDto.class);
        wechatTokenReqDto.initType(channelAccountEo.getType().intValue());
        return wechatTokenReqDto;
    }

    @Override
    public String getToken(WechatTokenReqDto wechatTokenReqDto) {
        String key = RedisKeyConstants.combineKey((String)"ACCESS_TOKEN", (Object[])new Object[]{wechatTokenReqDto.getAppId(), wechatTokenReqDto.readType()});
        String accessToken = (String)this.cacheService.getCache("WECHAT", key, String.class);
        if (accessToken != null) {
            return accessToken;
        }
        Map<String, Object> result = this.getAccessTokenMap(wechatTokenReqDto);
        LOGGER.info("\u83b7\u53d6\u5fae\u4fe1token\u7ed3\u679c\uff1a{}", result);
        accessToken = (String)result.get("access_token");
        if (accessToken == null) {
            throw new BizException("\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25,\u5fae\u4fe1\u54cd\u5e94\u7ed3\u679c\uff1a" + result);
        }
        Integer expiresIn = (Integer)result.get("expires_in");
        if (expiresIn != null) {
            expiresIn = expiresIn - this.cubeWechatConfig.getAdvance();
        }
        this.cacheService.setCache("WECHAT", key, (Object)accessToken, expiresIn.intValue());
        return accessToken;
    }

    protected Map<String, Object> getAccessTokenMap(WechatTokenReqDto wechatTokenReqDto) {
        RawFeignClientCaller rawFeignClientCaller = new RawFeignClientCaller();
        return (Map)rawFeignClientCaller.processDefault(wechatApi -> wechatApi.getAccessToken(wechatTokenReqDto.getAppId(), wechatTokenReqDto.getAppSecret()), WECHAT_DOMAIN, WechatApi.class, this.notifierFeignClientConfig, null, null);
    }

    @Override
    public String refreshAccessToken(WechatTokenReqDto wechatTokenReqDto) {
        String key = RedisKeyConstants.combineKey((String)"ACCESS_TOKEN", (Object[])new Object[]{wechatTokenReqDto.getAppId(), wechatTokenReqDto.readType()});
        this.cacheService.delCache("WECHAT", key);
        return this.getToken(wechatTokenReqDto);
    }

    @Override
    public JSONObject getAllMsgTemplates(String accessToken) {
        RawFeignClientCaller rawFeignClientCaller = new RawFeignClientCaller();
        JSONObject result = (JSONObject)rawFeignClientCaller.processDefault(wechatApi -> wechatApi.getAllMsgTemplates(accessToken), WECHAT_DOMAIN, WechatApi.class, this.notifierFeignClientConfig, null, null);
        String errcode = result.getString("errcode");
        if (errcode != null) {
            throw new BizException("\u83b7\u53d6\u5fae\u4fe1\u6d88\u606f\u6a21\u677f\u5217\u8868\u5f02\u5e38\uff0c\u5fae\u4fe1\u54cd\u5e94\u7ed3\u679c\uff1a" + result);
        }
        LOGGER.info("\u83b7\u53d6\u5fae\u4fe1\u6d88\u606f\u6a21\u677f\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }
}

