/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.channel.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.channel.api.dto.ChannelMsgTemplate;
import com.dtyunxi.yundt.cube.center.channel.api.dto.IChannelTokenRequestParam;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountQueryReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.enums.ChannelAccountTypeEnum;
import com.dtyunxi.yundt.cube.center.channel.api.enums.EnumUtils;
import com.dtyunxi.yundt.cube.center.channel.api.enums.IEnum;
import com.dtyunxi.yundt.cube.center.channel.biz.channel.AbstractChannelService;
import com.dtyunxi.yundt.cube.center.channel.biz.channel.ChannelSelector;
import com.dtyunxi.yundt.cube.center.channel.biz.service.IChannelAccountService;
import com.dtyunxi.yundt.cube.center.channel.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.channel.dao.das.ChannelAccountDas;
import com.dtyunxi.yundt.cube.center.channel.dao.eo.ChannelAccountEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelAccountServiceImpl
implements IChannelAccountService {
    @Resource
    private ChannelAccountDas channelAccountDas;
    @Resource
    private ChannelSelector channelSelector;

    @Override
    public Long add(ChannelAccountReqDto addReqDto) {
        ChannelAccountEo selectParam = new ChannelAccountEo();
        selectParam.setAccount(addReqDto.getAccount());
        selectParam.setType(addReqDto.getType());
        ChannelAccountEo existEo = (ChannelAccountEo)this.channelAccountDas.selectOne((BaseEo)selectParam);
        if (existEo != null) {
            throw new BizException(String.format("%s\u6e20\u9053\u7684\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\u8be5\u8d26\u53f7[%s]\u4fe1\u606f", EnumUtils.getValue((IEnum[])ChannelAccountTypeEnum.values(), (Integer)addReqDto.getType()), addReqDto.getAccount()));
        }
        ChannelAccountEo channelAccountEo = new ChannelAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)channelAccountEo);
        this.channelAccountDas.insert((BaseEo)channelAccountEo);
        return channelAccountEo.getId();
    }

    @Override
    public void modify(Long id, ChannelAccountReqDto modifyReqDto) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(id);
        if (channelAccountEo == null) {
            throw new BizException("\u6e20\u9053\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u4fee\u6539\u5931\u8d25");
        }
        ChannelAccountEo selectParam = new ChannelAccountEo();
        selectParam.setAccount(modifyReqDto.getAccount());
        selectParam.setType(modifyReqDto.getType());
        selectParam.setSqlFilters(SqlFilterBuilder.buildNotEqualsSqlFilter("id", id).get());
        ChannelAccountEo existEo = (ChannelAccountEo)this.channelAccountDas.selectOne((BaseEo)selectParam);
        if (existEo != null) {
            throw new BizException(String.format("%s\u6e20\u9053\u7684\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\u8be5\u8d26\u53f7[%s]\u4fe1\u606f", EnumUtils.getValue((IEnum[])ChannelAccountTypeEnum.values(), (Integer)modifyReqDto.getType()), modifyReqDto.getAccount()));
        }
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)channelAccountEo);
        channelAccountEo.setId(id);
        this.channelAccountDas.updateSelective((BaseEo)channelAccountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.channelAccountDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ChannelAccountReqDto queryById(Long id) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(id);
        ChannelAccountReqDto channelAccountReqDto = new ChannelAccountReqDto();
        DtoHelper.eo2Dto((BaseEo)channelAccountEo, (BaseVo)channelAccountReqDto);
        return channelAccountReqDto;
    }

    @Override
    public PageInfo<ChannelAccountReqDto> queryByPage(ChannelAccountQueryReqDto channelAccountQueryReqDto) {
        ChannelAccountReqDto channelAccountReqDto = new ChannelAccountReqDto();
        BeanUtils.copyProperties((Object)channelAccountQueryReqDto, (Object)channelAccountReqDto);
        ChannelAccountEo channelAccountEo = new ChannelAccountEo();
        DtoHelper.dto2Eo((BaseVo)channelAccountReqDto, (BaseEo)channelAccountEo);
        PageInfo eoPageInfo = this.channelAccountDas.selectPage((BaseEo)channelAccountEo, Integer.valueOf(channelAccountQueryReqDto.getPager().getPageNum()), Integer.valueOf(channelAccountQueryReqDto.getPager().getPageSize()));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChannelAccountReqDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ChannelMsgTemplate queryMsgTemplateList(Long channelAccountId) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(channelAccountId);
        Pair<String, AbstractChannelService<IChannelTokenRequestParam>> pair = this.getChannelServices(channelAccountEo, false);
        return new ChannelMsgTemplate().setMsgTemplates(((AbstractChannelService)pair.value).getAllMsgTemplates((String)pair.key));
    }

    private Pair<String, AbstractChannelService<IChannelTokenRequestParam>> getChannelServices(ChannelAccountEo channelAccountEo, boolean refresh) {
        if (channelAccountEo == null) {
            throw new BizException("\u6e20\u9053\u8d26\u53f7\u5c1a\u672a\u521b\u5efa");
        }
        AbstractChannelService<IChannelTokenRequestParam> abstractChannelService = this.channelSelector.select(channelAccountEo.getType());
        IChannelTokenRequestParam channelTokenRequestParam = (IChannelTokenRequestParam)abstractChannelService.getRequestTokenParam(channelAccountEo);
        return new Pair((Object)(refresh ? abstractChannelService.refreshAccessToken(channelTokenRequestParam) : abstractChannelService.getToken(channelTokenRequestParam)), abstractChannelService);
    }

    @Override
    public String getAccessToken(Long channelAccountId, boolean refresh) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(channelAccountId);
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)refresh).key;
    }

    @Override
    public String getAccessToken(String channelAccount, int type, boolean refresh) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByAccountAndType(channelAccount, type);
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)refresh).key;
    }

    @Override
    public String getAccessToken(int type, boolean refresh) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByType(type);
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)refresh).key;
    }

    @Override
    public ChannelMsgTemplate queryMsgTemplateList(String channelAccount, int type) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByAccountAndType(channelAccount, type);
        Pair<String, AbstractChannelService<IChannelTokenRequestParam>> pair = this.getChannelServices(channelAccountEo, false);
        return new ChannelMsgTemplate().setMsgTemplates(((AbstractChannelService)pair.value).getAllMsgTemplates((String)pair.key));
    }
}

