/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.channel.biz.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.channel.api.dto.ChannelMsgTemplate;
import com.dtyunxi.yundt.cube.center.channel.api.dto.EnumRespDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.IChannelTokenRequestParam;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.AccessTokenReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountQueryReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.enums.ChannelAccountTypeEnum;
import com.dtyunxi.yundt.cube.center.channel.api.enums.EnumUtils;
import com.dtyunxi.yundt.cube.center.channel.api.enums.IEnum;
import com.dtyunxi.yundt.cube.center.channel.biz.channel.AbstractChannelService;
import com.dtyunxi.yundt.cube.center.channel.biz.channel.ChannelSelector;
import com.dtyunxi.yundt.cube.center.channel.biz.service.IChannelAccountEventService;
import com.dtyunxi.yundt.cube.center.channel.biz.service.IChannelAccountService;
import com.dtyunxi.yundt.cube.center.channel.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.channel.dao.das.ChannelAccountDas;
import com.dtyunxi.yundt.cube.center.channel.dao.eo.ChannelAccountEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelAccountServiceImpl
implements IChannelAccountService {
    @Resource
    private ChannelAccountDas channelAccountDas;
    @Resource
    private ChannelSelector channelSelector;
    @Resource
    private IChannelAccountEventService channelAccountEventService;

    @Override
    public Long add(ChannelAccountReqDto addReqDto) {
        Assert.notBlank((CharSequence)addReqDto.getConfig(), (String)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ChannelAccountEo selectParam = new ChannelAccountEo();
        selectParam.setAccount(addReqDto.getAccount());
        selectParam.setType(addReqDto.getType());
        ChannelAccountEo existEo = (ChannelAccountEo)this.channelAccountDas.selectOne((BaseEo)selectParam);
        if (existEo != null) {
            throw new BizException(String.format("%s\u6e20\u9053\u7684\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\u8be5\u8d26\u53f7[%s]\u4fe1\u606f", EnumUtils.getValue((IEnum[])ChannelAccountTypeEnum.values(), (Integer)addReqDto.getType()), addReqDto.getAccount()));
        }
        ChannelAccountEo channelAccountEo = new ChannelAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)channelAccountEo);
        channelAccountEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        channelAccountEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        this.channelAccountDas.insert((BaseEo)channelAccountEo);
        if (ObjectUtil.equal((Object)ChannelAccountTypeEnum.WECHAT_ENTERPRISE_ACCOUNT.getKey(), (Object)addReqDto.getType())) {
            this.channelAccountEventService.pushEvent(channelAccountEo, "ADD");
        }
        return channelAccountEo.getId();
    }

    @Override
    public void modify(Long id, ChannelAccountReqDto modifyReqDto) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(id);
        if (channelAccountEo == null) {
            throw new BizException("\u6e20\u9053\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u4fee\u6539\u5931\u8d25");
        }
        ChannelAccountEo selectParam = new ChannelAccountEo();
        selectParam.setAccount(modifyReqDto.getAccount());
        selectParam.setType(modifyReqDto.getType());
        selectParam.setSqlFilters(SqlFilterBuilder.buildNotEqualsSqlFilter("id", id).get());
        selectParam.setDr(0);
        ChannelAccountEo existEo = (ChannelAccountEo)this.channelAccountDas.selectOne((BaseEo)selectParam);
        if (existEo != null) {
            throw new BizException(String.format("%s\u6e20\u9053\u7684\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\u8be5\u8d26\u53f7[%s]\u4fe1\u606f", EnumUtils.getValue((IEnum[])ChannelAccountTypeEnum.values(), (Integer)modifyReqDto.getType()), modifyReqDto.getAccount()));
        }
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)channelAccountEo);
        channelAccountEo.setId(id);
        channelAccountEo.setTenantId(null);
        channelAccountEo.setInstanceId(null);
        this.channelAccountDas.updateSelective((BaseEo)channelAccountEo);
        if (ObjectUtil.equal((Object)ChannelAccountTypeEnum.WECHAT_ENTERPRISE_ACCOUNT.getKey(), (Object)channelAccountEo.getType())) {
            this.channelAccountEventService.pushEvent(channelAccountEo, "UPDATE");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.channelAccountDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ChannelAccountReqDto queryById(Long id) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(id);
        ChannelAccountReqDto channelAccountReqDto = new ChannelAccountReqDto();
        DtoHelper.eo2Dto((BaseEo)channelAccountEo, (BaseVo)channelAccountReqDto);
        return channelAccountReqDto;
    }

    @Override
    public ChannelAccountReqDto queryByAccount(String channelAccount, Integer type) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByAccountAndType(channelAccount, type.intValue());
        ChannelAccountReqDto channelAccountReqDto = new ChannelAccountReqDto();
        DtoHelper.eo2Dto((BaseEo)channelAccountEo, (BaseVo)channelAccountReqDto);
        return channelAccountReqDto;
    }

    @Override
    public PageInfo<ChannelAccountReqDto> queryByPage(ChannelAccountQueryReqDto channelAccountQueryReqDto) {
        ChannelAccountReqDto channelAccountReqDto = new ChannelAccountReqDto();
        BeanUtils.copyProperties((Object)channelAccountQueryReqDto, (Object)channelAccountReqDto);
        ChannelAccountEo channelAccountEo = new ChannelAccountEo();
        DtoHelper.dto2Eo((BaseVo)channelAccountReqDto, (BaseEo)channelAccountEo);
        if (StrUtil.isNotBlank((CharSequence)channelAccountReqDto.getAccounts())) {
            channelAccountEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"account", Arrays.asList(channelAccountReqDto.getAccounts().split(",")))));
            channelAccountEo.setAccount(null);
        } else if (StrUtil.isNotBlank((CharSequence)channelAccountEo.getAccount())) {
            channelAccountEo.setSqlFilters(Collections.singletonList(SqlFilter.like((String)"account", (Object)("%" + channelAccountEo.getAccount() + "%"))));
            channelAccountEo.setAccount(null);
        }
        PageInfo eoPageInfo = this.channelAccountDas.selectPage((BaseEo)channelAccountEo, Integer.valueOf(channelAccountQueryReqDto.getPageNum()), Integer.valueOf(channelAccountQueryReqDto.getPageSize()));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChannelAccountReqDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<EnumRespDto> queryChannelAccountType() {
        ChannelAccountTypeEnum[] values = ChannelAccountTypeEnum.values();
        ArrayList<EnumRespDto> enumRespDtoList = new ArrayList<EnumRespDto>(values.length);
        for (ChannelAccountTypeEnum typeEnum : values) {
            EnumRespDto enumRespDto = new EnumRespDto();
            enumRespDto.setKey(typeEnum.getKey());
            enumRespDto.setValue(typeEnum.getValue());
            enumRespDtoList.add(enumRespDto);
        }
        return enumRespDtoList;
    }

    @Override
    public ChannelMsgTemplate queryMsgTemplateList(Long channelAccountId) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(channelAccountId);
        Pair<String, AbstractChannelService<IChannelTokenRequestParam>> pair = this.getChannelServices(channelAccountEo, false);
        return new ChannelMsgTemplate().setMsgTemplates(((AbstractChannelService)pair.value).getAllMsgTemplates((String)pair.key));
    }

    private Pair<String, AbstractChannelService<IChannelTokenRequestParam>> getChannelServices(ChannelAccountEo channelAccountEo, boolean refresh) {
        if (channelAccountEo == null) {
            throw new BizException("\u6e20\u9053\u8d26\u53f7\u5c1a\u672a\u521b\u5efa");
        }
        AbstractChannelService<IChannelTokenRequestParam> abstractChannelService = this.channelSelector.select(channelAccountEo.getType());
        IChannelTokenRequestParam channelTokenRequestParam = (IChannelTokenRequestParam)abstractChannelService.getRequestTokenParam(channelAccountEo);
        return new Pair((Object)(refresh ? abstractChannelService.refreshAccessToken(channelTokenRequestParam) : abstractChannelService.getToken(channelTokenRequestParam)), abstractChannelService);
    }

    @Override
    public String getAccessToken(Long channelAccountId, boolean refresh) {
        ChannelAccountEo channelAccountEo = (ChannelAccountEo)this.channelAccountDas.selectByPrimaryKey(channelAccountId);
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)refresh).key;
    }

    @Override
    public String getAccessToken(String channelAccount, int type, boolean refresh) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByAccountAndType(channelAccount, type);
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)refresh).key;
    }

    @Override
    public String getAccessToken(AccessTokenReqDto accessTokenReqDto) {
        ChannelAccountEo channelAccountEo = new ChannelAccountEo();
        channelAccountEo.setType(accessTokenReqDto.getType());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("appid", accessTokenReqDto.getAppId());
        config.put("appsecret", accessTokenReqDto.getAppSecret());
        channelAccountEo.setConfig(JSON.toJSONString(config));
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)accessTokenReqDto.isRefresh()).key;
    }

    @Override
    public String getAccessToken(int type, boolean refresh) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByType(type);
        return (String)this.getChannelServices((ChannelAccountEo)channelAccountEo, (boolean)refresh).key;
    }

    @Override
    public ChannelMsgTemplate queryMsgTemplateList(String channelAccount, int type) {
        ChannelAccountEo channelAccountEo = this.channelAccountDas.selectByAccountAndType(channelAccount, type);
        Pair<String, AbstractChannelService<IChannelTokenRequestParam>> pair = this.getChannelServices(channelAccountEo, false);
        return new ChannelMsgTemplate().setMsgTemplates(((AbstractChannelService)pair.value).getAllMsgTemplates((String)pair.key));
    }
}

