package com.dtyunxi.yundt.cube.bundle.org.center.user.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostAssignmentReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 岗位分配服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"用户中心：岗位服务(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-bundle-org-center-user-api-IPostAssignmentApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/post-assignment"
)
public interface IPostAssignmentApi {

    /**
     * 给员工分配岗位
     *
     * @param postAssignmentReqDto 岗位分配请求参数对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "给员工分配岗位", notes = "给员工分配岗位")
    RestResponse<Void> assign(@RequestBody PostAssignmentReqDto postAssignmentReqDto);

    /**
     * 移除员工岗位
     *
     * @param employeeNo 员工工号
     * @param postCode   岗位编码
     * @return 处理结果
     */
    @DeleteMapping("/{employeeNo}/{postCode}")
    @ApiOperation(value = "移除员工岗位", notes = "移除员工岗位")
    RestResponse<Void> unassign(@PathVariable("employeeNo") String employeeNo, @PathVariable("postCode") String postCode);


}
