package com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
* 岗位分配
*
* @author 萧玄
*/
@Validated
@ApiModel(value = "PostAssignmentReqDto", description = "岗位分配")
public class PostAssignmentReqDto extends RequestDto {

    /**
    *  员工工号
    */
    @NotEmpty(message = "员工工号不能为空")
    @ApiModelProperty(name = "employeeNo", value = "员工工号")
    private String employeeNo;

    @ApiModelProperty(name = "postCodes", value = "岗位编码列表")
    private List<String> postCodes;

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public List<String> getPostCodes() {
        return postCodes;
    }

    public void setPostCodes(List<String> postCodes) {
        this.postCodes = postCodes;
    }
}