package com.dtyunxi.yundt.cube.bundle.org.center.user.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.EmployeePostQueryReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostEmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePostPagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.PostEmployeePagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.PostPagerRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * 岗位分配服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"用户中心：岗位分配服务(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-bundle-org-center-user-api-query-IPostAssignmentQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/post-assignment"
)
public interface IPostAssignmentQueryApi {

    /**
     * 根据查询员工关联的岗位信息
     *
     * @param employeeNo 根据查询员工关联的岗位信息
     * @return 处理结果
     */
    @GetMapping("/{employeeNo}")
    @ApiOperation(value = "根据查询员工关联的岗位信息", notes = "根据查询员工关联的岗位信息")
    RestResponse<List<PostPagerRespDto>> postList(@PathVariable("employeeNo") String employeeNo);

    /**
     * 员工-岗位树结构 列表
     *
     * @param employeePostQueryReqDto
     * @return 处理结果
     */
    @GetMapping("/employee-post/list")
    @ApiOperation(value = "员工-岗位树结构 列表", notes = "员工-岗位树结构 列表")
    RestResponse<List<EmployeePostPagerRespDto>> employeePostList(@SpringQueryMap EmployeePostQueryReqDto employeePostQueryReqDto);

    /**
     * 岗位-员工树结构 列表
     *
     * @param postEmployeeQueryReqDto
     * @return 处理结果
     */
    @GetMapping("/post-employee/list")
    @ApiOperation(value = "岗位-员工树结构 列表", notes = "岗位-员工树结构 列表")
    RestResponse<List<PostEmployeePagerRespDto>> postEmployeeList(@SpringQueryMap PostEmployeeQueryReqDto postEmployeeQueryReqDto);


}
