package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgSyncReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author 大颠
 * @since 1.0.0
 */
@Api(tags = {"用户中心：组织机构管理服务拓展(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IBizOrganizationApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/organization"
)
public interface IBizOrganizationApi {
    @RequestMapping(value = {"/biz/{instanceId}"}, method = {RequestMethod.POST})
    @ApiOperation(value = "添加组织",
            notes = "请求参数为： Application-Key  应用id， parentId 该组织所属父id，为空则为根节点   name 组织名称 description 描述  sortNO 序号"
    )
    @Capability(capabilityCode = "user.biz-organization.add-org")
    RestResponse<Long> addOrg(@PathVariable("instanceId") Long instanceId, @RequestBody OrgReqDto orgReqDto);

    @RequestMapping(value = {"/biz/addOrgs/{instanceId}"}, method = {RequestMethod.POST}
    )
    @ApiOperation(value = "批量添加组织")
    @Capability(capabilityCode = "user.biz-organization.add-orgs")
    RestResponse<String> addOrgs(@PathVariable("instanceId") Long instanceId, @RequestBody List<OrgReqDto> orgReqDtos);

    @RequestMapping(value = {"/biz/{instanceId}/{organizationId}"}, method = {RequestMethod.PUT})
    @ApiOperation(value = "修改组织",
            notes = "请求参数为：  Application-Key  应用id  organizationId 需要更新的组织的id  parentId 该组织所属父id，为空则为根节点 name 组织名称 description 描述  sortNO 序号"
    )
    @Capability(capabilityCode = "user.biz-organization.modify-org")
    RestResponse<String> modifyOrg(@PathVariable("instanceId") Long instanceId, @PathVariable("organizationId") Long organizationId, @RequestBody OrgReqDto orgReqDto);

    @RequestMapping(value = {"/biz/sort"}, method = {RequestMethod.PUT})
    @ApiOperation(value = "组织排序")
    @Capability(capabilityCode = "user.biz-organization.sort")
    RestResponse<String> sort(@RequestParam(name = "parentId") Long parentId, @RequestParam(name = "orgId") Long orgId, @RequestParam(name = "sort") Integer sort);

    @RequestMapping(value = {"/biz/{organizationId}"}, method = {RequestMethod.DELETE})
    @ApiOperation(value = "删除组织"
    )
    @Capability(capabilityCode = "user.biz-organization.delete")
    RestResponse<String> delete(@PathVariable(name = "organizationId") Long orgId);

    @RequestMapping(value = {"/biz/sync/{parentCode}"}, method = {RequestMethod.POST})
    @ApiOperation(value = "组织同步")
    @Capability(capabilityCode = "user.biz-organization.sync-org")
    RestResponse<String> syncOrg(@PathVariable(name = "parentCode") String parentCode, @RequestBody List<OrgSyncReqDto> orgSyncReqDtos);

    @Deprecated
    @RequestMapping(value = {"/biz/updateOrgLvRv/{orgId}"}, method = {RequestMethod.PUT})
    @ApiOperation(value = "更新rv,lv值(功能已不再支持)")
    @Capability(capabilityCode = "user.biz-organization.update-org-lv-rv")
    RestResponse<String> updateOrgLvRv(@PathVariable(name = "orgId") Long orgId);
}
