package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgSortReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 组织服务接口
 *
 * @author qiuzhi
 * @since 2020-09-02
 */
@Api(tags = {"用户中心：组织服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IOrgGroupApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/org-group"
)
public interface IOrgGroupApi {

    /**
     * 新增组织
     *
     * @param addReqDto 组织请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增组织", notes = "新增组织")
    @Capability(capabilityCode = "user.organization.addOrgGroup")
    RestResponse<Long> addOrgGroup(@RequestBody OrgGroupAddReqDto addReqDto);

    /**
     * 修改组织
     *
     * @param modifyReqDto 组织请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改组织", notes = "修改组织")
    @Capability(capabilityCode = "user.organization.modifyOrgGroup")
    RestResponse<Void> modifyOrgGroup(@RequestBody OrgGroupModifyReqDto modifyReqDto);

    /**
     * 删除组织
     *
     * @param ids 组织删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除组织", notes = "删除组织")
    @Capability(capabilityCode = "user.organization.removeOrgGroup")
    RestResponse<Void> removeOrgGroup(@PathVariable("ids") String ids);

    /**
     * 更新序号
     */
    @PutMapping("sort")
    @ApiOperation(value = "更新组织单元排序", notes = "更新组织单元排序")
    @Capability(capabilityCode = "user.organization.updateOrgSort")
    RestResponse<Void> updateSortNo(@RequestBody OrgSortReqDto reqDto);
}
