package com.dtyunxi.yundt.cube.center.user.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 缓存键
 * @author : 萧玄
 * @Date: 10:51 2019/7/11
 */
public class RedisKeyConstants {

    /**
     * 员工缓存键
     */
    public static final String FIND_BY_USER_ID = "findByUserId";

    public static final String FIND_BY_EMPLOYEE_ID = "findByEmployeeId";


    /**
     * 组合成最终键，按冒号分割各参数
     * @author : 萧玄
     * @Date   : 10:55 2019/7/11
     * @param prefix
     * @param params
     * @return : java.lang.String
     */
    public static String combineKey(String prefix,Object... params){
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if(params != null){
            for(Object param:params){
                if (param != null && StringUtils.isNotEmpty(param.toString())){
                    sb.append(":").append(param);
                }
            }
        }
        return sb.toString();
    }
}
