/**
 * @(#) CustomerDto.java 1.0 2019-01-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 客户
 *
 * @author 刘备
 * @since 1.0.0
 */
@Deprecated
@ApiModel(value = "CustomerDto", description = "客户信息")
public class CustomerDto extends BaseDto {

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 业务识别码, 在租户下唯一，值为客户信息在业务方的唯一标识，如主键
     */
    @ApiModelProperty(value = "业务识别码, 在租户下唯一，值为客户信息在业务方的唯一标识，如主键")
    private String businessCode;

    /**
     * 客户昵称
     */
    @ApiModelProperty(value = "客户昵称")
    private String nickName;

    /**
     * 客户的真实姓名
     */
    @ApiModelProperty(value = "客户的真实姓名")
    private String name;

    /**
     * 客户手机号码
     */
    @ApiModelProperty(value = "客户手机号码")
    private String phone;

    /**
     * 客户邮箱
     */
    @ApiModelProperty(value = "客户邮箱")
    private String email;

    /**
     * 客户所在的企业名称
     */
    @ApiModelProperty(value = "客户所在的企业名称")
    private String company;

    /**
     * 客户QQ号
     */
    @ApiModelProperty(value = "客户QQ号")
    private String qq;

    /**
     * 客户微信号
     */
    @ApiModelProperty(value = "客户微信号")
    private String weixin;

    /**
     * 省编号
     */
    @ApiModelProperty(value = "省编号")
    private String provinceCode;

    /**
     * 市编号
     */
    @ApiModelProperty(value = "市编号")
    private String cityCode;

    /**
     * 区编号
     */
    @ApiModelProperty(value = "区编号")
    private String districtCode;

    /**
     * 街道编号
     */
    @ApiModelProperty(value = "街道编号")
    private String streetCode;


    /**
     * 所在省名称
     */
    @ApiModelProperty(value = "所在省名称")
    private String province;

    /**
     * 所在市名称
     */
    @ApiModelProperty(value = "所在市名称")
    private String city;

    /**
     * 所在区名称
     */
    @ApiModelProperty(value = "所在区名称")
    private String district;

    /**
     * 客户所在地址
     */
    @ApiModelProperty(value = "客户所在地址")
    private String address;

    /**
     * 客户类型，1:潜在客户  2:目标客户 3:现实客户 4:流失客户
     */
    @ApiModelProperty(value = "客户类型，1:潜在客户  2:目标客户 3:现实客户 4:流失客户")
    private Integer type;

    /**
     * 客户标签，多个标签用逗号隔开，如：理智型，教师
     */
    @ApiModelProperty(value = "客户标签，多个标签用逗号隔开，如：理智型，教师")
    private String tag;

    /**
     * 客户状态， 1:有效 0:失效
     */
    @ApiModelProperty(value = "客户状态， 1:有效 0:失效")
    private Integer status;

    /**
     * 客户所用设备
     */
    @ApiModelProperty(value = "客户所用设备")
    private String device;

    /**
     * 客户所用设备ID
     */
    @ApiModelProperty(value = "客户所用设备ID")
    private String deviceId;

    /**
     * 客户转化为注册用户时对应的用户ID
     */
    @ApiModelProperty(value = "客户转化为注册用户时对应的用户ID")
    private Long userId;

    /**
     * 客户转化为会员时对应的会员ID
     */
    @ApiModelProperty(value = "客户转化为会员时对应的会员ID")
    private Long memberId;

    /**
     * 业务定义扩展值
     */
    @ApiModelProperty(value = "业务定义扩展值")
    private String extension;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getWeixin() {
        return weixin;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public String toString() {
        return "CustomerDto{" +
                "nickName='" + nickName + '\'' +
                ", name='" + name + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                '}';
    }
}