package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author chen.tainian 2019.7.3
 */
public class OrganizationTreeDto extends BaseDto {

    private static final long serialVersionUID = 8214864658606865115L;

    @ApiModelProperty(
            name = "selectAble",
            value = "可选择的"
    )
    private Boolean selectAble;

    @ApiModelProperty(
            name = "id",
            value = "组织id",
            hidden = true
    )
    private Long id;
    @ApiModelProperty(
            name = "parentId",
            value = "父组织id"
    )
    private Long parentId;
    @ApiModelProperty(
            name = "name",
            value = "组织名称"
    )
    private String name;

    /**
     * 组织名称1
     */
    @ApiModelProperty(value = "组织名称1, 选填")
    private String nameI1;

    /**
     * 组织名称2
     */
    @ApiModelProperty(value = "组织名称2, 选填")
    private String nameI2;

    @ApiModelProperty(
            name = "description",
            value = "组织描述"
    )
    private String description;
    @ApiModelProperty(
            name = "sortNO",
            value = "排序号"
    )
    private Integer sortNO;
    @ApiModelProperty(
            name = "type",
            value = "组织类型"
    )
    private String type;
    @ApiModelProperty(
            name = "code",
            value = "组织编号"
    )
    private String code;
    @ApiModelProperty(
            name = "children",
            value = "子组织",
            hidden = true
    )
    private List<OrganizationTreeDto> children;
    @ApiModelProperty(
            name = "employees",
            value = "组织员工",
            hidden = true
    )
    private List<EmployeeDto> employees;

    public OrganizationTreeDto() {
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getSortNO() {
        return this.sortNO;
    }

    public void setSortNO(Integer sortNO) {
        this.sortNO = sortNO;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<OrganizationTreeDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<OrganizationTreeDto> children) {
        this.children = children;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<EmployeeDto> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<EmployeeDto> employees) {
        this.employees = employees;
    }

    public Boolean getSelectAble() {
        return selectAble;
    }

    public void setSelectAble(Boolean selectAble) {
        this.selectAble = selectAble;
    }

    public String getNameI1() {
        return nameI1;
    }

    public void setNameI1(String nameI1) {
        this.nameI1 = nameI1;
    }

    public String getNameI2() {
        return nameI2;
    }

    public void setNameI2(String nameI2) {
        this.nameI2 = nameI2;
    }
}
