/**
 * @(#)EmployeeDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


/**
 * 员工信息请求Dto
 *
 * @author qiuzhi
 * @since 1.0.0
 */
@ApiModel(value = "EmployeeExtQueryReqDto", description = "员工信息")
public class EmployeeExtQueryReqDto extends RequestDto {

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织Id")
    private Long orgGroupId;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织Id")
    private Long orgId;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名, 选填")
    private String name;

    /**
     * 员工号
     */
    @ApiModelProperty(value = "员工号, 选填")
    private String employeeNo;

    /**
     * 员工号列表
     */
    @ApiModelProperty(value = "员工号列表,多个用英文逗号分隔，选填")
    private List<String> employeeNoList;

    @ApiModelProperty(value = "手机号码, 选填")
    private String phoneNum;

    /**
     * 员工状态：1，启用，2禁用
     */
    @ApiModelProperty(value = "员工状态: 1启用,2禁用.默认启用")
    private Integer status;

    /**
     * 是否查询机构
     */
    @ApiModelProperty(value = "是否查询机构")
    private Boolean withOrg;

    /**
     * 是否查询岗位
     */
    @ApiModelProperty(value = "是否查询岗位")
    private Boolean withPost;

    /**
     * 是否查询关联用户名
     */
    @ApiModelProperty(value = "是否查询关联用户名")
    private Boolean withUserName;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id，选填。当用户id有值时，忽略其他查询条件")
    private Long userId;

    /**
     * 登录名
     */
    @ApiModelProperty(value = "用户名，选填。当用户名有值时，用户id为空时，忽略其他查询条件")
    private String userName;

    @ApiModelProperty(hidden = true)
    private List<Long> userIdList;


    public Long getOrgGroupId() {
        return orgGroupId;
    }

    public void setOrgGroupId(Long orgGroupId) {
        this.orgGroupId = orgGroupId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean getWithOrg() {
        return withOrg;
    }

    public void setWithOrg(Boolean withOrg) {
        this.withOrg = withOrg;
    }

    public Boolean getWithPost() {
        return withPost;
    }

    public void setWithPost(Boolean withPost) {
        this.withPost = withPost;
    }

    public Boolean getWithUserName() {
        return withUserName;
    }

    public void setWithUserName(Boolean withUserName) {
        this.withUserName = withUserName;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<Long> getUserIdList() {
        return userIdList;
    }

    public void setUserIdList(List<Long> userIdList) {
        this.userIdList = userIdList;
    }

    public List<String> getEmployeeNoList() {
        return employeeNoList;
    }

    public void setEmployeeNoList(List<String> employeeNoList) {
        this.employeeNoList = employeeNoList;
    }
}
