package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 员工查询请求
 *
 * @author youyang
 * @date 2019/9/29
 * @since 2.5.20.0
 */
@ApiModel(value = "EmployeeQueryReqDto", description = "员工查询请求, 没有查询类型的属性都是精确查询")
public class EmployeeQueryReqDto extends BaseVo {


    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID, 选填")
    private Long organizationId;
    /**
     * 员工号
     */
    @ApiModelProperty(value = "员工号, 选填,模糊查询")
    private String employeeNo;


    /**
     * 岗位
     */
    @ApiModelProperty(value = "岗位, 选填,模糊查询")
    private String station;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名, 选填,模糊查询")
    private String name;

    /**
     * 邮箱号
     */
    @ApiModelProperty(value = "邮箱号, 选填,模糊查询")
    private String email;


    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码, 选填,模糊查询")
    private String phoneNum;

    /**
     * 员工状态：1，启用，2禁用
     * TODO 实现这个
     */
     @ApiModelProperty(value = "员工状态, 1，启用，2禁用, 默认启用")
     private Integer status;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id, 选填")
    private Long userId;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 实例ID
     */
    @ApiModelProperty(value = "实例ID")
    private Long instanceId;

    /**
     * 是否响应员工关联的用户信息,默认:true
     */
    @ApiModelProperty(value = "是否响应员工关联的用户信息,默认:true")
    private Boolean returnWithUser;
    /**
     * 是否返回员工关联的所有组织id,设置为true则 响应包含 orgIdSet 属性,默认:ture
     */
    @ApiModelProperty(value = "是否返回员工关联的所有组织id,默认:true")
    private Boolean returnWithOrgIds;


    public Long getOrganizationId() {
        return organizationId;
    }

    public EmployeeQueryReqDto setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public EmployeeQueryReqDto setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
        return this;
    }

    public String getStation() {
        return station;
    }

    public EmployeeQueryReqDto setStation(String station) {
        this.station = station;
        return this;
    }

    public String getName() {
        return name;
    }

    public EmployeeQueryReqDto setName(String name) {
        this.name = name;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public EmployeeQueryReqDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public EmployeeQueryReqDto setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public EmployeeQueryReqDto setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public EmployeeQueryReqDto setTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public EmployeeQueryReqDto setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public Boolean getReturnWithUser() {
        return returnWithUser;
    }

    public EmployeeQueryReqDto setReturnWithUser(Boolean returnWithUser) {
        this.returnWithUser = returnWithUser;
        return this;
    }

    public Boolean getReturnWithOrgIds() {
        return returnWithOrgIds;
    }

    public EmployeeQueryReqDto setReturnWithOrgIds(Boolean returnWithOrgIds) {
        this.returnWithOrgIds = returnWithOrgIds;
        return this;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
