package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 高级用户组织功能包的禁用启用组织单元请求dto
 *
 * @author shuangqing
 */
@ApiModel(value = "OrgAdvEnableReqDto", description = "禁用启用组织单元请求dto")
public class OrgAdvEnableReqDto extends BaseDto {

    /**
     * 组织单元ids
     */
    @ApiModelProperty(value = "组织单元ids（业务单元、虚拟单元）")
    private List<Long> ids;


    /**
     * 组织单元编码
     */
    @NotNull
    @ApiModelProperty(value = "组织单元编码（业务单元、虚拟单元）")
    private List<String> codes;

    @NotNull
    @ApiModelProperty(value = "状态(0禁用,1启用)")
    private String status;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public List<String> getCodes() {
        return codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
