package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 高级用户组织功能包的新增组织单元请求dto
 *
 * @author shuangqing
 */
@ApiModel(value = "OrgAdvQueryReqDto", description = "新增组织单元请求dto")
public class OrgAdvQueryReqDto extends BaseDto {


    /**
     * 组织单元编码（业务单元、虚拟单元）
     */
    @ApiModelProperty(value = "组织单元编码（业务单元、虚拟单元）")
    private String code;

    /**
     * 父级组织单元Id（业务单元、虚拟单元）,在树结构选择一个节点，列表展示所有下级业务单元组织
     */
    @ApiModelProperty(value = "父级组织单元编码（业务单元、虚拟单元）")
    private Long parentId;

    /**
     * 组织单元类型
     */
    @ApiModelProperty(value = "用户组织功能包需求 0：公司 1：部门 2：业务组织单元 3：虚拟组织单元")
    private String type;

    /**
     * 组织单元名称
     */
    @ApiModelProperty(value = "组织单元名称")
    private String name;

    /**
     * 状态(0禁用,1启用)
     */
    @ApiModelProperty(value = "状态(0禁用,1启用)")
    private String status;

    /**
     * 公司组织机构码
     */
    @ApiModelProperty(value = "公司组织机构码")
    private String companyOrgCode;

    /**
     * 公司组织机构名称
     */
    @ApiModelProperty(value = "公司组织机构名称")
    private String companyOrgName;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCompanyOrgCode() {
        return companyOrgCode;
    }

    public void setCompanyOrgCode(String companyOrgCode) {
        this.companyOrgCode = companyOrgCode;
    }

    public String getCompanyOrgName() {
        return companyOrgName;
    }

    public void setCompanyOrgName(String companyOrgName) {
        this.companyOrgName = companyOrgName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
}
