/*
 * @(#) OrgReqDto.java 1.1.0 2019-06-28
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author 大颠
 * @since 1.0.0
 */
@ApiModel(value = "OrgReqDto", description = "新增组织DTO")
public class OrgReqDto extends BaseVo {

    @ApiModelProperty(value = "组织id")
    private Long id;

    @ApiModelProperty(value = "父组织id")
    private Long parentId;

    @ApiModelProperty(value = "组织名")
    @NotBlank
    @Size(max = 50)
    private String name;

    /**
     * 组织名称1
     */
    @ApiModelProperty(value = "组织名称1, 选填")
    private String nameI1;

    /**
     * 组织名称2
     */
    @ApiModelProperty(value = "组织名称2, 选填")
    private String nameI2;

    @ApiModelProperty(value = "组织编码")
    @NotBlank
    @Size(max = 100)
    private String code;

    private String parentCode;

    @ApiModelProperty(value = "组织描述")
    @Size(max = 128)
    private String description;

    @ApiModelProperty(value = "实例id")
    @NotNull
    private Long instanceId;

    @ApiModelProperty(value = "是否数据隔离")
    @NotNull
    private Integer isDataIsolate;

    @ApiModelProperty(value = "是否叶子节点")
    private Integer isLeaf;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Integer getIsDataIsolate() {
        return isDataIsolate;
    }

    public void setIsDataIsolate(Integer isDataIsolate) {
        this.isDataIsolate = isDataIsolate;
    }

    public Integer getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Integer isLeaf) {
        this.isLeaf = isLeaf;
    }

    public String getNameI1() {
        return nameI1;
    }

    public void setNameI1(String nameI1) {
        this.nameI1 = nameI1;
    }

    public String getNameI2() {
        return nameI2;
    }

    public void setNameI2(String nameI2) {
        this.nameI2 = nameI2;
    }
}
