package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 岗位添加请求对象
 *
 * @author qiuzhi
 * @since 2020-09-04
 */
@ApiModel(value = "PostAddReqDto", description = "岗位添加请求对象")
public class PostAddReqDto extends RequestDto {
    /**
     * 岗位名称
     */
    @NotNull(message = "岗位名称不能为空")
    @Size(message = "岗位名称字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "岗位名称")
    private String name;
    /**
     * 岗位编码
     */
    @NotNull(message = "岗位编码不能为空")
    @Size(message = "岗位编码字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "岗位编码")
    private String code;
    /**
     * 备注
     */
    @Size(message = "备注最大不能超过200字符", max = 200)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**
     * 状态 [0禁用 1启用]
     */
    @ApiModelProperty(value = "状态 [0禁用 1启用]", allowableValues = "0,1")
    private Integer status;

    @ApiModelProperty("关联的组织单元")
    private List<OrgOrgDto> orgDtoList;
    
    @ApiModelProperty(value = "父级id")
    private Long parentId;
    
    @ApiModelProperty(value = "父级编码")
    private String parentCode;

    public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getParentCode() {
		return parentCode;
	}

	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}

	public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<OrgOrgDto> getOrgDtoList() {
        return orgDtoList;
    }

    public void setOrgDtoList(List<OrgOrgDto> orgDtoList) {
        this.orgDtoList = orgDtoList;
    }
}
