package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 岗位查询请求对象
 *
 * @author qiuzhi
 * @since 2020-09-04
 */
@ApiModel(value = "PostQueryReqDto", description = "岗位查询请求对象")
public class PostQueryReqDto extends RequestDto {

    /**
     * 岗位名称
     */
    @Size(message = "岗位编码长度为[1-50]", max = 50)
    @ApiModelProperty(value = "岗位名称")
    private String name;
    /**
     * 岗位编码
     */
    @Size(message = "岗位编码长度为[1-50]", max = 50)
    @ApiModelProperty(value = "岗位编码")
    private String code;

    /**
     * 组织单元Id
     */
    @ApiModelProperty(value = "组织单元Id")
    private Long orgId;

    /**
     * 状态 [0禁用 1启用]
     */
    @ApiModelProperty(value = "状态 [0禁用 1启用]", allowableValues = "0,1")
    private Integer status;

    /**
     * 组织编码
     */
    @NotNull(message = "组织ID不能为空")
    @Size(message = "组织ID长度为[1-50]", max = 50)
    @ApiModelProperty(value = "组织ID")
    private Long orgGroupId;

    /**
     * 是否查询机构
     */
    @ApiModelProperty(value = "是否查询机构")
    private Boolean withOrg;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Long getOrgGroupId() {
        return orgGroupId;
    }

    public void setOrgGroupId(Long orgGroupId) {
        this.orgGroupId = orgGroupId;
    }

    public Boolean getWithOrg() {
        return withOrg;
    }

    public void setWithOrg(Boolean withOrg) {
        this.withOrg = withOrg;
    }
}
