package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 高级用户组织功能包的新增组织单元请求dto
 *
 * @author shuangqing
 */
@ApiModel(value = "OrgAdvRespDto", description = "新增组织单元请求dto")
public class OrgAdvRespDto extends BaseDto {
    /**
     * 组织单元id
     */
    @ApiModelProperty(value = "组织单元id")
    private Long id;

    /**
     * 组织单元编号
     */
    @ApiModelProperty(value = "组织单元编号")
    private String code;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "用户组织功能包需求 0：公司 1：部门 2：业务组织单元 3：虚拟组织单元")
    private String type;

    /**
     * 组织单元名称
     */
    @ApiModelProperty(value = "组织单元名称")
    private String name;

    /**
     * 父级名称
     */
    @ApiModelProperty(value = "父级名称")
    private String parentName;

    /**
     * 状态(0禁用,1启用)
     */
    @ApiModelProperty(value = "状态(0禁用,1启用)")
    private String status;

    /**
     * 实体属性编码
     */
    @ApiModelProperty(value = "实体属性编码")
    private String entityPropCode;
    /**
     * 实体属性名称
     */
    @ApiModelProperty(value = "实体属性名称")
    private String entityPropName;

    /**
     * 公司组织机构码
     */
    @ApiModelProperty(value = "公司组织机构码")
    private String companyOrgCode;

    /**
     * 公司组织机构名称
     */
    @ApiModelProperty(value = "公司组织机构名称")
    private String companyOrgName;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String telephone;
    /**
     * 负责人
     */
    @ApiModelProperty(value = "负责人")
    private String principal;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    private String address;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNO;

    /**
     * 父级id(保存当前组织单元的上级组织单元id)
     */
    @ApiModelProperty(value = "父级id(保存当前组织单元的上级组织单元id)")
    private Long parentId;

    /**
     * 组织名称(国际语言1约定为英文，组织信息同步到企业微信作为部门英文名称时使用)
     */
    @ApiModelProperty(value = "组织名称(国际语言1约定为英文，组织信息同步到企业微信作为部门英文名称时使用)")
    private String nameI1;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEntityPropCode() {
        return entityPropCode;
    }

    public void setEntityPropCode(String entityPropCode) {
        this.entityPropCode = entityPropCode;
    }

    public String getCompanyOrgCode() {
        return companyOrgCode;
    }

    public void setCompanyOrgCode(String companyOrgCode) {
        this.companyOrgCode = companyOrgCode;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getPrincipal() {
        return principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getSortNO() {
        return sortNO;
    }

    public void setSortNO(Integer sortNO) {
        this.sortNO = sortNO;
    }

    public String getEntityPropName() {
        return entityPropName;
    }

    public void setEntityPropName(String entityPropName) {
        this.entityPropName = entityPropName;
    }

    public String getCompanyOrgName() {
        return companyOrgName;
    }

    public void setCompanyOrgName(String companyOrgName) {
        this.companyOrgName = companyOrgName;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getNameI1() {
        return nameI1;
    }

    public void setNameI1(String nameI1) {
        this.nameI1 = nameI1;
    }
}
