package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.CustomerOrgInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author yufan
 * @time 2020/9/27 16:50
 */
@Api(tags = {"用户中心：【客商中心】客户组织信息查询服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-ICustomerOrgInfoQueryApi"
        , name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}"
        , path = "/v1/customer-org-info"
        , url = "${dtyunxi.yundt.cube_organization-center-user_api:}")
public interface ICustomerOrgInfoQueryApi {
    /**
     * 查询客户组织信息详情
     *
     * @param id 组织信息id
     */
    @GetMapping("/get")
    @ApiOperation(value = "查询客户组织信息详情", notes = "查询客户组织信息详情")
    @Capability(capabilityCode = "user.customer.query-org-info")
    RestResponse<CustomerOrgInfoDto> queryById(@RequestParam("id") Long id);


    /**
     * 分页查查询客户组织信息列表
     *
     * @param customerOrgInfoQueryReqDto 组织信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查查询客户组织信息列表", notes = "分页查询客户组织信息列表")
    @Capability(capabilityCode = "user.customer.query-page-org-info")
    RestResponse<PageInfo<CustomerOrgInfoDto>> queryPage(@SpringQueryMap CustomerOrgInfoQueryReqDto customerOrgInfoQueryReqDto,
                                                    @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
