package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 员工信息表查询服务接口
 *
 * @author qiuzhi
 * @since 2020-09-25
 */
@Api(tags = {"用户中心：员工信息表服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IEmployeeQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:bundle-organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/employee"
)
public interface IEmployeeQueryApi {

    /**
     * 根据id查询员工信息表
     *
     * @param id 员工信息表id
     * @return 员工信息表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询员工信息表", notes = "根据id查询员工信息表")
    @Capability(capabilityCode = "queryEmployeeById")
    RestResponse<EmployeeRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 查询用户关联员工的组织列表及岗位列表，请求头需设置Access-Token的值
     *
     * @return 员工信息表数据
     */
    @GetMapping("/current-login-user")
    @ApiOperation(value = "查询用户关联员工的组织列表及岗位列表，请求头需设置Access-Token的值", notes = "查询用户关联员工的组织列表及岗位列表，请求头需设置Access-Token的值")
    @Capability(capabilityCode = "queryEmployeeById")
    RestResponse<EmployeeRespDto> queryByUserId();

    /**
     * 员工信息表分页数据
     *
     * @param reqDto   员工信息表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 员工信息表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "员工信息表分页数据", notes = "根据查询条件查询员工信息表数据")
    @Capability(capabilityCode = "queryEmployeeByPage")
    RestResponse<PageInfo<EmployeeRespDto>> queryByPage(@SpringQueryMap EmployeeExtQueryReqDto reqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据id查询员工信息表
     *
     * @param employeeNo 员工编号
     * @return 员工信息表数据
     */
    @GetMapping("/queryByEmployeeNo/{employeeNo}")
    @ApiOperation(value = "根据id查询员工信息表", notes = "根据id查询员工信息表")
    @Capability(capabilityCode = "queryByEmployeeNo")
    RestResponse<EmployeeRespDto> queryByEmployeeNo(@PathVariable("employeeNo") String employeeNo);
}
