/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjPropertyQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjPropertyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj.BizObjQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizObjPropertyQueryResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizObjQueryResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.bizobj.BizObjCreateResDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.bizobj.BizObjModifyResDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizObjService;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityGroupDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizObjDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizObjPropertyDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizObjEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizObjPropertyEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizObjEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizObjPropertyEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BizObjServiceImpl
implements IBizObjService {
    @Resource
    private BizObjDas bizObjDas;
    @Resource
    private BizObjPropertyDas bizObjPropertyDas;
    @Resource
    private AbilityGroupDas abilityGroupDas;

    private static <T> List<T> getDuplicateElements(List<T> c) {
        return c.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizObjCreateResDto addBizObj(BizObjCreateReqDto reqDto) {
        BizObjCreateResDto result = new BizObjCreateResDto();
        List propertyDtos = reqDto.getProperties();
        try {
            List duplicateCodes = BizObjServiceImpl.getDuplicateElements(propertyDtos.stream().peek(e -> {
                if (!StringUtils.hasText((String)e.getCode())) {
                    throw new BizException("1993", "\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }).map(BizObjPropertyReqDto::getCode).collect(Collectors.toList()));
            if (duplicateCodes.size() > 0) {
                throw new BizException("1991", "\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u7f16\u7801\u91cd\u590d:" + StringUtils.collectionToCommaDelimitedString(duplicateCodes));
            }
            List duplicateNames = BizObjServiceImpl.getDuplicateElements(propertyDtos.stream().map(BizObjPropertyReqDto::getName).collect(Collectors.toList()));
            if (duplicateNames.size() > 0) {
                throw new BizException("1992", "\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u540d\u79f0\u91cd\u590d:" + StringUtils.collectionToCommaDelimitedString(duplicateNames));
            }
            BizObjEo record = new BizObjEo();
            record.setCode(reqDto.getCode());
            if (this.bizObjDas.count((BaseEo)record) > 0) {
                throw new BizException("2001", "\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u5df2\u5b58\u5728");
            }
            record = new BizObjEo();
            record.setName(reqDto.getName());
            if (this.bizObjDas.count((BaseEo)record) > 0) {
                throw new BizException("2002", "\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        catch (BizException e2) {
            result.setResultCode(e2.getCode());
            result.setResultMsg(e2.getMessage());
            return result;
        }
        BizObjEo bizObjEo = new BizObjEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)bizObjEo);
        bizObjEo.setExtension("");
        this.bizObjDas.insert((BaseEo)bizObjEo);
        if (!CollectionUtils.isEmpty((Collection)propertyDtos)) {
            ArrayList propertyEos = new ArrayList(propertyDtos.size());
            DtoHelper.dtoList2EoList((Collection)propertyDtos, propertyEos, BizObjPropertyEo.class);
            propertyEos.forEach(e -> {
                e.setBizObjCode(reqDto.getCode());
                e.setExtension("");
                if (!StringUtils.hasText((String)e.getOptionValue())) {
                    e.setOptionValue("{}");
                }
            });
            this.bizObjPropertyDas.insertBatch(propertyEos);
        }
        result.setId(bizObjEo.getId());
        result.setResultCode("0");
        result.setResultMsg("success");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizObjModifyResDto modifyBizObj(BizObjModifyReqDto reqDto) {
        BizObjEo bizObjEo;
        List propertyDtos;
        BizObjModifyResDto result = new BizObjModifyResDto();
        try {
            propertyDtos = reqDto.getProperties();
            List duplicateCodes = BizObjServiceImpl.getDuplicateElements(propertyDtos.stream().peek(e -> {
                if (!StringUtils.hasText((String)e.getCode())) {
                    throw new BizException("1993", "\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }).map(BizObjPropertyReqDto::getCode).collect(Collectors.toList()));
            if (duplicateCodes.size() > 0) {
                throw new BizException("1991", "\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u7f16\u7801\u91cd\u590d:" + StringUtils.collectionToCommaDelimitedString(duplicateCodes));
            }
            List duplicateNames = BizObjServiceImpl.getDuplicateElements(propertyDtos.stream().map(BizObjPropertyReqDto::getName).collect(Collectors.toList()));
            if (duplicateNames.size() > 0) {
                throw new BizException("1992", "\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u540d\u79f0\u91cd\u590d:" + StringUtils.collectionToCommaDelimitedString(duplicateNames));
            }
            bizObjEo = this.bizObjDas.selectByCode(reqDto.getCode());
            if (bizObjEo == null) {
                throw new BizException("2000", "\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            BizObjEo record = new BizObjEo();
            record.setName(reqDto.getName());
            record.setSqlFilters(Collections.singletonList(SqlFilter.ne((String)"id", (Object)bizObjEo.getId())));
            if (this.bizObjDas.count((BaseEo)record) > 0) {
                throw new BizException("2002", "\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        catch (BizException e2) {
            result.setResultCode(e2.getCode());
            result.setResultMsg(e2.getMessage());
            return result;
        }
        List propertyEos = this.bizObjPropertyDas.selectByBizCode(bizObjEo.getCode());
        Map<String, BizObjPropertyEo> propertyEoMap = propertyEos.stream().collect(Collectors.toMap(StdBizObjPropertyEo::getCode, e -> e));
        ArrayList inserts = new ArrayList();
        BizObjEo finalBizObjEo = bizObjEo;
        propertyDtos.forEach(e -> {
            if (propertyEoMap.containsKey(e.getCode())) {
                BizObjPropertyEo bizObjPropertyEo = (BizObjPropertyEo)propertyEoMap.get(e.getCode());
                boolean isUsed = this.bizObjPropertyDas.isUsed(finalBizObjEo.getCode(), e.getCode());
                if (isUsed) {
                    bizObjPropertyEo.setName(e.getName());
                    ArrayList<String> notUpdates = result.getNotAllUpdates();
                    if (notUpdates == null) {
                        notUpdates = new ArrayList<String>();
                    }
                    notUpdates.add(e.getName());
                } else {
                    DtoHelper.dto2Eo((BaseVo)e, (BaseEo)bizObjPropertyEo);
                }
                this.bizObjPropertyDas.update((BaseEo)bizObjPropertyEo);
            } else {
                BizObjPropertyEo insert = new BizObjPropertyEo();
                DtoHelper.dto2Eo((BaseVo)e, (BaseEo)insert);
                insert.setExtension("");
                if (!StringUtils.hasText((String)insert.getOptionValue())) {
                    insert.setOptionValue("{}");
                }
                inserts.add(insert);
            }
        });
        this.bizObjPropertyDas.insertBatch(inserts);
        Map<String, BizObjPropertyReqDto> propertyDtoMap = propertyDtos.stream().collect(Collectors.toMap(BizObjPropertyReqDto::getCode, e -> e));
        BizObjEo finalBizObjEo1 = bizObjEo;
        propertyEos.forEach(e -> {
            if (!propertyDtoMap.containsKey(e.getCode())) {
                boolean isUsed = this.bizObjPropertyDas.isUsed(finalBizObjEo1.getCode(), e.getCode());
                if (isUsed) {
                    ArrayList<String> notDeletes = result.getNotDeletes();
                    if (notDeletes == null) {
                        notDeletes = new ArrayList<String>();
                    }
                    notDeletes.add(e.getName());
                } else {
                    this.bizObjPropertyDas.logicDeleteById(e.getId());
                }
            }
        });
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)bizObjEo, (String[])new String[]{"id", "code"});
        this.bizObjDas.updateSelective((BaseEo)bizObjEo);
        if (CollectionUtils.isEmpty((Collection)result.getNotAllUpdates()) && CollectionUtils.isEmpty((Collection)result.getNotDeletes())) {
            result.setResultCode("0");
            result.setResultMsg("success");
        } else {
            result.setResultCode("2000");
            result.setResultMsg("\u63d0\u4ea4\u5931\u8d25\uff0c\u67d0\u4e9b\u5c5e\u6027\u540d\u79f0\u91cd\u590d\u6216\u5df2\u88ab\u4e1a\u52a1\u8eab\u4efd\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u548c\u5220\u9664");
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyBizObjStatus(String code, Integer status) {
        if (!Constants.DISABLE.equals(status) && !Constants.ENABLE.equals(status)) {
            throw new BizException("\u72b6\u6001\u53ea\u80fd\u662f\u542f\u7528\u6216\u7981\u7528");
        }
        BizObjEo bizObjEo = this.bizObjDas.selectByCode(code);
        if (bizObjEo == null) {
            throw new BizException("\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        if (Constants.DISABLE.equals(status)) {
            List propertyEos = this.bizObjPropertyDas.selectByBizCode(bizObjEo.getCode());
            for (BizObjPropertyEo propertyEo : propertyEos) {
                if (!this.bizObjPropertyDas.isUsed(bizObjEo.getCode(), propertyEo.getCode())) continue;
                throw new BizException("\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u88ab\u4f7f\u7528,\u4e0d\u80fd\u7981\u7528");
            }
        }
        bizObjEo.setStatus(status);
        this.bizObjDas.updateSelective((BaseEo)bizObjEo);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> linkAbilityGroup(String code, String abilityGroupCode) {
        BizObjEo bizObjEo = this.bizObjDas.selectByCode(code);
        if (bizObjEo == null) {
            throw new BizException("\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(bizObjEo.getAbilityGroupCode(), abilityGroupCode)) {
            return RestResponse.VOID;
        }
        BizObjEo eo = new BizObjEo();
        eo.setId(bizObjEo.getId());
        if (StringUtils.hasText((String)abilityGroupCode)) {
            List list = this.abilityGroupDas.selectByCodes(Collections.singletonList(abilityGroupCode), null, AbilityConstants.REALM);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new BizException("\u9886\u57df\u4e0d\u5b58\u5728");
            }
            if (list.size() != 1) {
                throw new BusinessRuntimeException("\u6570\u636e\u5f02\u5e38:code\u4e3a" + code + "\u7684\u6570\u636e\u6709" + list.size() + "\u6761(\u8d85\u8fc7\u4e00\u6761)");
            }
            eo.setAbilityGroupCode(abilityGroupCode);
        } else {
            eo.setAbilityGroupCode("");
        }
        this.bizObjDas.updateSelective((BaseEo)eo);
        return RestResponse.VOID;
    }

    @Override
    public BizObjQueryResDto queryByCode(String code, Boolean withProperties) {
        BizObjEo bizObjEo = this.bizObjDas.selectByCode(code);
        if (bizObjEo == null) {
            return null;
        }
        BizObjQueryResDto bizObjReqDto = new BizObjQueryResDto();
        DtoHelper.eo2Dto((BaseEo)bizObjEo, (BaseVo)bizObjReqDto);
        if (withProperties != null && withProperties.booleanValue()) {
            List bizObjPropertyEos = this.bizObjPropertyDas.selectByBizCode(code);
            ArrayList bizObjPropertyDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)bizObjPropertyEos, bizObjPropertyDtos, BizObjPropertyQueryResDto.class);
            bizObjReqDto.setProperties(bizObjPropertyDtos);
        }
        return bizObjReqDto;
    }

    @Override
    public PageInfo<BizObjQueryResDto> queryByPage(BizObjQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        BizObjEo record = new BizObjEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)record);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.hasText((String)reqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + reqDto.getCode() + "%")));
        }
        if (StringUtils.hasText((String)reqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + reqDto.getName() + "%")));
        }
        record.setSqlFilters(sqlFilters);
        record.setCode(null);
        record.setName(null);
        PageInfo eoPageInfo = this.bizObjDas.selectPage((BaseEo)record, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BizObjQueryResDto.class);
        dtoPageInfo.setList(dtoList);
        if (reqDto.getWithProperties() != null && reqDto.getWithProperties().booleanValue()) {
            List objCodes = eoPageInfo.getList().stream().map(StdBizObjEo::getCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(objCodes)) {
                return dtoPageInfo;
            }
            Map<String, List<BizObjPropertyEo>> propertyMap = this.bizObjPropertyDas.selectByBizCodes(objCodes).stream().collect(Collectors.groupingBy(StdBizObjPropertyEo::getBizObjCode));
            dtoList.forEach(e -> {
                List propertyEos = (List)propertyMap.get(e.getCode());
                if (!CollectionUtils.isEmpty((Collection)propertyEos)) {
                    ArrayList propertyDtos = new ArrayList();
                    DtoHelper.eoList2DtoList((Collection)propertyEos, propertyDtos, BizObjPropertyQueryResDto.class);
                    e.setProperties(propertyDtos);
                }
            });
        }
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBizObjProperty(BizObjPropertyReqDto modifyReqDto) {
        BizObjPropertyEo bizObjPropertyEo = this.bizObjPropertyDas.selectByCode(modifyReqDto.getCode());
        if (bizObjPropertyEo == null) {
            throw new BizException("\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u4e0d\u5b58\u5b58");
        }
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)bizObjPropertyEo);
        this.bizObjPropertyDas.updateSelective((BaseEo)bizObjPropertyEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBizObjProperty(List<String> codes) {
        this.bizObjPropertyDas.logicDeleteByCodes(codes);
    }

    @Override
    public BizObjPropertyQueryResDto queryPropertyByCode(String code) {
        BizObjPropertyEo bizObjPropertyEo = this.bizObjPropertyDas.selectByCode(code);
        if (bizObjPropertyEo == null) {
            return null;
        }
        BizObjPropertyQueryResDto queryResDto = new BizObjPropertyQueryResDto();
        DtoHelper.eo2Dto((BaseEo)bizObjPropertyEo, (BaseVo)queryResDto);
        return queryResDto;
    }

    @Override
    public PageInfo<BizObjPropertyQueryResDto> queryPropertyByPage(BizObjPropertyQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        BizObjPropertyEo record = new BizObjPropertyEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)record);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.hasText((String)reqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + reqDto.getCode() + "%")));
        }
        if (StringUtils.hasText((String)reqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + reqDto.getName() + "%")));
        }
        record.setSqlFilters(sqlFilters);
        record.setCode(null);
        record.setName(null);
        PageInfo eoPageInfo = this.bizObjPropertyDas.selectPage((BaseEo)record, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BizObjPropertyQueryResDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

