/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.starter.bundle.dto.BundleBaseDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleDepdDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleDependencyService;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleDependencyDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleDependencyHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleDependencyEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleDependencyHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleHistoryEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class BundleDependencyServiceImpl
implements IBundleDependencyService {
    @Resource
    private BundleDependencyDas bundleDependencyDas;
    @Resource
    private BundleDependencyHistoryDas bundleDependencyHistoryDas;
    @Resource
    private BundleDas bundleDas;
    @Resource
    private BundleHistoryDas bundleHistoryDas;

    @Override
    public List<BundleDepdDto> getBundleDependency(String bundleCode, String bundleVersion) {
        ArrayList<BundleDepdDto> bundleDependencies;
        block3: {
            List results;
            block2: {
                bundleDependencies = new ArrayList<BundleDepdDto>();
                BundleDependencyEo bundleDependencyEo = new BundleDependencyEo();
                bundleDependencyEo.setCode(bundleCode);
                bundleDependencyEo.setVersion(bundleVersion);
                results = this.bundleDependencyDas.select((BaseEo)bundleDependencyEo, Integer.valueOf(1), Integer.valueOf(500));
                if (!CollectionUtils.isEmpty((Collection)results)) break block2;
                BundleDependencyHistoryEo bundleDependencyHistoryEo = new BundleDependencyHistoryEo();
                bundleDependencyHistoryEo.setCode(bundleCode);
                bundleDependencyHistoryEo.setVersion(bundleVersion);
                List historyEos = this.bundleDependencyHistoryDas.select((BaseEo)bundleDependencyHistoryEo, Integer.valueOf(1), Integer.valueOf(500));
                if (!CollectionUtils.isNotEmpty((Collection)historyEos)) break block3;
                for (BundleDependencyHistoryEo dependBundle : historyEos) {
                    BundleDepdDto bundleDepdDto = this.getDependBundle(dependBundle.getDependentCode(), dependBundle.getDependentVersion());
                    bundleDependencies.add(bundleDepdDto);
                }
                break block3;
            }
            for (BundleDependencyEo dependBundle : results) {
                BundleDepdDto bundleDepdDto = this.getDependBundle(dependBundle.getDependentCode(), dependBundle.getDependentVersion());
                bundleDependencies.add(bundleDepdDto);
            }
        }
        return bundleDependencies;
    }

    private BundleDepdDto getDependBundle(String dependBundleCode, String dependBundleVersion) {
        BundleDepdDto bundleDepdDto = new BundleDepdDto();
        BundleEo bundleEo = this.bundleDas.selectByCode(dependBundleCode, dependBundleVersion);
        if (null == bundleEo) {
            BundleHistoryEo bundleHistoryEo = this.bundleHistoryDas.selectByCode(dependBundleCode, dependBundleVersion);
            if (null == bundleHistoryEo) {
                bundleDepdDto.setCode(dependBundleCode);
                bundleDepdDto.setName(dependBundleCode);
                bundleDepdDto.setVersion(dependBundleVersion);
            } else {
                bundleDepdDto.setCode(bundleHistoryEo.getCode());
                bundleDepdDto.setName(bundleHistoryEo.getName());
                bundleDepdDto.setVersion(bundleHistoryEo.getVersion());
            }
        } else {
            bundleDepdDto.setCode(bundleEo.getCode());
            bundleDepdDto.setName(bundleEo.getName());
            bundleDepdDto.setVersion(bundleEo.getVersion());
        }
        return bundleDepdDto;
    }

    public void addOrUpdateBundleDependencies(List<BundleBaseDto> dependencies, String bundleCode, String bundleGroupId, String bundleArtifactId, String bundleVersion, String dbBundleVersion) {
        BundleDependencyEo dependenciesEo = new BundleDependencyEo();
        dependenciesEo.setCode(bundleCode);
        dependenciesEo.setVersion(dbBundleVersion);
        List backUpResults = this.bundleDependencyDas.select((BaseEo)dependenciesEo, Integer.valueOf(1), Integer.valueOf(500));
        if (dbBundleVersion != null && !dbBundleVersion.equals(bundleVersion) && CollectionUtils.isNotEmpty((Collection)backUpResults)) {
            this.dependenciesBackUp(dbBundleVersion, bundleCode, bundleVersion, backUpResults);
        }
        if (CollectionUtils.isNotEmpty(dependencies)) {
            this.bundleDependencyDas.logicDelete(dbBundleVersion, bundleCode);
            HashSet<String> dependencyCodeSet = new HashSet<String>();
            ArrayList<BundleDependencyEo> insertEos = new ArrayList<BundleDependencyEo>();
            for (BundleBaseDto dependency : dependencies) {
                BundleDependencyEo eo = this.toDependenciesEo(dependency, bundleCode, bundleGroupId, bundleArtifactId, bundleVersion);
                if (dependencyCodeSet.contains(eo.getDependentCode())) continue;
                insertEos.add(eo);
                dependencyCodeSet.add(eo.getCode());
            }
            if (CollectionUtils.isNotEmpty(insertEos)) {
                this.bundleDependencyDas.insertBatch(insertEos);
            }
        }
    }

    protected BundleDependencyEo toDependenciesEo(BundleBaseDto dependenciesDto, String bundleCode, String bundleGroupId, String bundleArtifactId, String bundleVersion) {
        BundleDependencyEo dependenciesEo = new BundleDependencyEo();
        dependenciesEo.setCode(bundleCode);
        dependenciesEo.setVersion(bundleVersion);
        dependenciesEo.setArtifactId(bundleArtifactId);
        dependenciesEo.setGroupId(bundleGroupId);
        dependenciesEo.setDependentCode(dependenciesDto.getGroupId() + "_" + dependenciesDto.getArtifactId());
        dependenciesEo.setDependentArtifactId(dependenciesDto.getArtifactId());
        dependenciesEo.setDependentGroupId(dependenciesDto.getGroupId());
        dependenciesEo.setDependentVersion(dependenciesDto.getVersion());
        dependenciesEo.setExtension("");
        return dependenciesEo;
    }

    protected void dependenciesBackUp(String dbBundleVersion, String bundleCode, String version, List<BundleDependencyEo> dbDependenciesEos) {
        this.bundleDependencyHistoryDas.logicDelete(dbBundleVersion, bundleCode);
        if (CollectionUtils.isNotEmpty(dbDependenciesEos)) {
            ArrayList<BundleDependencyHistoryEo> dependenciesHistoryEos = new ArrayList<BundleDependencyHistoryEo>();
            for (BundleDependencyEo eo : dbDependenciesEos) {
                BundleDependencyHistoryEo insertEo = new BundleDependencyHistoryEo();
                CubeBeanUtils.copyProperties((Object)insertEo, (Object)eo, (String[])new String[]{"id", "create_time", "create_person", "update_time", "update_person"});
                dependenciesHistoryEos.add(insertEo);
            }
            if (CollectionUtils.isNotEmpty(dependenciesHistoryEos)) {
                this.bundleDependencyHistoryDas.insertBatch(dependenciesHistoryEos);
            }
        }
        this.bundleDependencyHistoryDas.logicDelete(version, bundleCode);
    }
}

