/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleHistoryService;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleHistoryEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BundleHistoryServiceImpl
implements IBundleHistoryService {
    @Resource
    private BundleHistoryDas bundleHistoryDas;
    @Resource
    private ApiDas apiDas;
    @Resource
    private ApiHistoryDas apiHistoryDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bundleBackUp(String groupId, String artifactId, String version, BundleEo bundleEo) {
        List bundleHistoryEoList = this.bundleHistoryDas.select(groupId, artifactId, bundleEo.getVersion());
        BundleHistoryEo bundleHistoryEo = CollectionUtils.isNotEmpty((Collection)bundleHistoryEoList) ? (BundleHistoryEo)bundleHistoryEoList.get(0) : new BundleHistoryEo();
        BeanUtils.copyProperties((Object)bundleEo, (Object)bundleHistoryEo, (String[])new String[]{"id", "create_time", "create_person", "update_time", "update_person"});
        String code = bundleEo.getCode().replace("_bundle-", "_");
        bundleHistoryEo.setCode(code);
        if (StringUtils.isNotBlank((CharSequence)bundleEo.getParentCode())) {
            String parentCode = bundleEo.getParentCode().replace("_bundle-", "_");
            bundleHistoryEo.setParentCode(parentCode);
        }
        this.bundleHistoryDas.insertOrUpdate(bundleHistoryEo);
        this.bundleHistoryDas.logicDelete(groupId, artifactId, version);
        this.apiBackUp(code, version);
    }

    public BundleEo convert(com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.BundleEo bundleEo) {
        BundleEo bundleEo1 = new BundleEo();
        CubeBeanUtils.copyProperties((Object)bundleEo1, (Object)bundleEo, (String[])new String[0]);
        return bundleEo1;
    }

    private void apiBackUp(String bundleCode, String version) {
        if (StringUtils.isBlank((CharSequence)bundleCode)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)bundleCode)) {
            return;
        }
        List apiEoList = this.apiDas.select(bundleCode);
        if (CollectionUtils.isNotEmpty((Collection)apiEoList)) {
            String apiVersion = ((ApiEo)apiEoList.get(0)).getVersion();
            this.apiHistoryDas.logicDelete(bundleCode, apiVersion);
            ArrayList<ApiHistoryEo> apiHistoryEoList = new ArrayList<ApiHistoryEo>();
            for (ApiEo dbEo : apiEoList) {
                ApiHistoryEo insertEo = new ApiHistoryEo();
                CubeBeanUtils.copyProperties((Object)insertEo, (Object)dbEo, (String[])new String[]{"id", "create_time", "create_person", "update_time", "update_person"});
                apiHistoryEoList.add(insertEo);
            }
            if (CollectionUtils.isNotEmpty(apiHistoryEoList)) {
                this.apiHistoryDas.insertBatch(apiHistoryEoList);
            }
        }
        this.apiHistoryDas.logicDelete(bundleCode, version);
    }

    @Override
    public List<BundleHistoryEo> queryByCode(String code) {
        BundleHistoryEo eo = new BundleHistoryEo();
        eo.setCode(code);
        return this.bundleHistoryDas.select((BaseEo)eo);
    }

    @Override
    public List<BundleHistoryEo> queryByCodeVersion(String code, String version) {
        BundleHistoryEo eo = new BundleHistoryEo();
        eo.setCode(code);
        eo.setVersion(version);
        eo.setOrderByDesc("update_time");
        return this.bundleHistoryDas.select((BaseEo)eo);
    }
}

