/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.BundleEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.StdBundleEo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.BundleType;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.BundleBaseDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleAppRelateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleModuleRelateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleDepdDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleVersionRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ContainerRespDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.FuncExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleDependencyService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.TreeBuilder;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ContainerBundleRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ContainerBundleRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBundleHistoryEo;
import com.dtyunxi.yundt.cube.meta.utils.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BundleServiceImpl
extends TreeBuilder<BundleRespDto>
implements IBundleService {
    private static final Logger logger = LoggerFactory.getLogger(BundleServiceImpl.class);
    @Resource
    private BundleDas bundleDas;
    @Resource
    private SettingDas settingDas;
    @Resource
    private SettingOptionDas settingOptionDas;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private ContainerBundleRelationDas containerBundleRelationDas;
    @Resource
    private Validator validator;
    @Resource
    private BundleHistoryDas bundleHistoryDas;
    @Resource
    private IBundleDependencyService bundleDependencyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBundle(BundleCreateReqDto addReqDto) {
        this.validateDtoParameter((BundleBaseDto)addReqDto);
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo queryCodeEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        queryCodeEo.setCode(addReqDto.getCode());
        AssertUtil.isTrue(0 == this.bundleDas.count((BaseEo)queryCodeEo), "11001", "\u529f\u80fd\u5305\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo queryNameEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        queryNameEo.setName(addReqDto.getName());
        AssertUtil.isTrue(0 == this.bundleDas.count((BaseEo)queryNameEo), "11001", "\u529f\u80fd\u5305\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        if (StringUtils.isBlank((CharSequence)addReqDto.getParentCode())) {
            addReqDto.setParentCode("ROOT_NODE");
        }
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)bundleEo);
        if (addReqDto.getParentCode() != null && !"ROOT_NODE".equals(addReqDto.getParentCode())) {
            com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo parentBundle = this.bundleDas.selectByCode(addReqDto.getParentCode());
            AssertUtil.isTrue(parentBundle != null, "\u4e00\u7ea7\u529f\u80fd\u5305\u4e0d\u5b58\u5728");
            parentBundle = this.flag2type(parentBundle);
            List<String> parentTypeList = Arrays.asList(StringUtils.split((String)parentBundle.getType(), (String)","));
            List<String> newTypeList = Arrays.asList(StringUtils.split((String)this.type2flag(bundleEo, (Boolean)true).getType(), (String)","));
            AssertUtil.isTrue(parentTypeList.containsAll(newTypeList), "\u529f\u80fd\u5305\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        this.bundleDas.insert((BaseEo)this.type2flag(bundleEo, (Boolean)true));
        this.handleContainer(bundleEo.getId(), addReqDto.getType(), addReqDto.getBundleAppRelateReqDtoList(), addReqDto.getBundleModuleRelateReqDtoList());
        return bundleEo.getId();
    }

    private void handleContainer(Long bundleId, String bundleType, List<BundleAppRelateReqDto> appRelateReqDtoList, List<BundleModuleRelateReqDto> moduleRelateReqDtoList) {
        if (!CollectionUtils.isEmpty(appRelateReqDtoList) || !CollectionUtils.isEmpty(moduleRelateReqDtoList)) {
            ContainerBundleRelationEo relationEo;
            List<String> bundleTypeList = Arrays.asList(StringUtils.split((String)bundleType, (String)","));
            ArrayList<ContainerBundleRelationEo> relationEoList = new ArrayList<ContainerBundleRelationEo>();
            for (BundleAppRelateReqDto bundleAppRelateReqDto : appRelateReqDtoList) {
                AssertUtil.isTrue(bundleTypeList.contains(bundleAppRelateReqDto.getType()), "\u529f\u80fd\u5305\u7c7b\u578b\u4e0d\u5339\u914d");
                relationEo = new ContainerBundleRelationEo();
                relationEo.setExtension("");
                relationEo.setBundleId(bundleId);
                relationEo.setContainerId(bundleAppRelateReqDto.getId());
                relationEo.setType(Constants.APP);
                relationEoList.add(relationEo);
            }
            for (BundleModuleRelateReqDto bundleModuleRelateReqDto : moduleRelateReqDtoList) {
                AssertUtil.isTrue(bundleTypeList.contains(bundleModuleRelateReqDto.getType()), "\u529f\u80fd\u5305\u7c7b\u578b\u4e0d\u5339\u914d");
                relationEo = new ContainerBundleRelationEo();
                relationEo.setExtension("");
                relationEo.setBundleId(bundleId);
                relationEo.setContainerId(bundleModuleRelateReqDto.getId());
                relationEo.setType(Constants.MODULE);
                relationEoList.add(relationEo);
            }
            this.containerBundleRelationDas.insertBatch(relationEoList);
        }
    }

    public com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo type2flag(com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo, Boolean isSetFlagWhenZero) {
        if (bundleEo != null && StringUtils.isNotBlank((CharSequence)bundleEo.getType())) {
            List<String> paramBundleTypes = Arrays.asList(bundleEo.getType().split(","));
            for (BundleType bundleType : BundleType.values()) {
                int flagValue = paramBundleTypes.contains(bundleType.getFrontendName()) ? 1 : 0;
                try {
                    if (1 != flagValue && !isSetFlagWhenZero.booleanValue()) continue;
                    PropertyUtils.setProperty((Object)bundleEo, (String)bundleType.getDbFieldName(), (Object)flagValue);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("\u8bbe\u7f6eBundleEo\u529f\u80fd\u5305\u7c7b\u578b\u6807\u5fd7\u5931\u8d25\uff0cbundleEo: {}", (Object)JSON.toJSONString((Object)bundleEo), (Object)e);
                }
            }
        }
        return bundleEo;
    }

    public com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo convert(BundleEo bundleEo) {
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo1 = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        CubeBeanUtils.copyProperties((Object)bundleEo1, (Object)bundleEo, (String[])new String[0]);
        return bundleEo1;
    }

    @Override
    public com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo flag2type(com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo) {
        if (bundleEo != null) {
            ArrayList<String> typeList = new ArrayList<String>();
            for (BundleType bundleType : BundleType.values()) {
                try {
                    Integer flag = (Integer)PropertyUtils.getProperty((Object)bundleEo, (String)bundleType.getDbFieldName());
                    if (1 != flag) continue;
                    typeList.add(bundleType.getFrontendName());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("\u4eceBundleEo\u83b7\u53d6\u529f\u80fd\u5305\u7c7b\u578b\u6807\u5fd7\u5931\u8d25\uff0cbundleEo: {}", (Object)JSON.toJSONString((Object)bundleEo), (Object)e);
                }
            }
            bundleEo.setType(StringUtils.join(typeList, (String)","));
        }
        return bundleEo;
    }

    @Override
    public List<String> getEnableBundleCodes(Integer status) {
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setStatus(status);
        List bundleEos = this.bundleDas.select((BaseEo)bundleEo, Integer.valueOf(1), Integer.valueOf(5000));
        if (!CollectionUtils.isEmpty((Collection)bundleEos)) {
            return bundleEos.stream().map(StdBundleEo::getCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getTenantEnableBundleCodes(Long tenantId) {
        return this.getEnableBundleCodes(Constants.ENABLE);
    }

    @Override
    public PageInfo<ContainerRespDto> queryContainerByBundleId(Long bundleId, Integer containerType, Integer pageNum, Integer pageSize) {
        ContainerBundleRelationEo relationQueryEo = new ContainerBundleRelationEo();
        relationQueryEo.setBundleId(bundleId);
        if (containerType != null) {
            relationQueryEo.setType(containerType);
        }
        List relationEoList = this.containerBundleRelationDas.select((BaseEo)relationQueryEo);
        ArrayList containerRespDtoList = new ArrayList();
        return PageInfoUtil.doPage(containerRespDtoList, (Integer)pageNum, (Integer)pageSize);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBundle(BundleModifyReqDto modifyReqDto) {
        this.validateDtoParameter((BundleBaseDto)modifyReqDto);
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo queryCodeEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        queryCodeEo.setCode(modifyReqDto.getCode());
        queryCodeEo = (com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo)this.bundleDas.selectOne((BaseEo)queryCodeEo);
        AssertUtil.isTrue(null != queryCodeEo, "11002", "\u529f\u80fd\u5305\u7f16\u7801\u4e0d\u5b58\u5728");
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo queryNameEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        queryNameEo.setName(modifyReqDto.getName());
        queryNameEo.setSqlFilters(Arrays.asList(SqlFilter.ne((String)"code", (Object)modifyReqDto.getCode())));
        AssertUtil.isTrue(0 == this.bundleDas.count((BaseEo)queryNameEo), "11001", "\u529f\u80fd\u5305\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)bundleEo, (String[])new String[]{"code", "parentCode"});
        bundleEo.setId(queryCodeEo.getId());
        this.bundleDas.updateSelective((BaseEo)this.type2flag(bundleEo, (Boolean)true));
        ContainerBundleRelationEo relationEo = new ContainerBundleRelationEo();
        relationEo.setBundleId(queryCodeEo.getId());
        this.containerBundleRelationDas.delete((BaseEo)relationEo);
        this.handleContainer(bundleEo.getId(), modifyReqDto.getType(), modifyReqDto.getBundleAppRelateReqDtoList(), modifyReqDto.getBundleModuleRelateReqDtoList());
    }

    private void validateDtoParameter(BundleBaseDto bundleBaseDto) {
        Set validateResult = this.validator.validate((Object)bundleBaseDto, new Class[0]);
        if (!CollectionUtils.isEmpty((Collection)validateResult)) {
            throw new BizException("10002", ((ConstraintViolation)CollectionUtils.lastElement((Set)validateResult)).getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBundle(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        HashSet codeSet = Sets.newHashSet((Object[])new String[]{code});
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo queryChildren = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        queryChildren.setParentCode(code);
        List childrenBundleList = this.bundleDas.select((BaseEo)queryChildren);
        if (!CollectionUtils.isEmpty((Collection)childrenBundleList)) {
            codeSet.addAll(childrenBundleList.stream().map(StdBundleEo::getCode).collect(Collectors.toSet()));
        }
        CapabilityEo capabilityEo = new CapabilityEo();
        capabilityEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"bundle", (Object)codeSet)));
        AssertUtil.isTrue(0 == this.capabilityDas.count((BaseEo)capabilityEo), FuncExceptionCode.BUNDLE_DELETE_FORBIDDEN);
        SettingEo settingEo = new SettingEo();
        settingEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"bundle", (Object)codeSet)));
        AssertUtil.isTrue(0 == this.settingDas.count((BaseEo)settingEo), FuncExceptionCode.BUNDLE_DELETE_FORBIDDEN);
        SettingOptionEo settingOptionEo = new SettingOptionEo();
        settingOptionEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"bundle", (Object)codeSet)));
        AssertUtil.isTrue(0 == this.settingOptionDas.count((BaseEo)settingOptionEo), FuncExceptionCode.BUNDLE_DELETE_FORBIDDEN);
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo containerRelatedBundleEo = this.bundleDas.selectByCode(code);
        ContainerBundleRelationEo containerBundleRelationEo = new ContainerBundleRelationEo();
        containerBundleRelationEo.setBundleId(containerRelatedBundleEo.getId());
        AssertUtil.isTrue(0 == this.containerBundleRelationDas.count((BaseEo)containerBundleRelationEo), FuncExceptionCode.BUNDLE_DELETE_FORBIDDEN);
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"code", (Object)codeSet)));
        this.bundleDas.logicDelete((BaseEo)bundleEo);
    }

    @Override
    public BundleRespDto queryById(Long id) {
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = (com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo)this.bundleDas.selectByPrimaryKey(id);
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo parent = this.bundleDas.selectByCode(bundleEo.getCode());
        BundleRespDto bundleRespDto = new BundleRespDto();
        DtoHelper.eo2Dto((BaseEo)this.flag2type(bundleEo), (BaseVo)bundleRespDto);
        bundleRespDto.setParent(parent.getName());
        return bundleRespDto;
    }

    @Override
    public BundleRespDto queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleQueryEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleQueryEo.setCode(code);
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = (com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo)this.bundleDas.selectOne((BaseEo)bundleQueryEo);
        AssertUtil.isTrue(null != bundleEo, "11002", "\u529f\u80fd\u5305\u7f16\u7801\u4e0d\u5b58\u5728");
        BundleRespDto bundleRespDto = new BundleRespDto();
        DtoHelper.eo2Dto((BaseEo)bundleEo, (BaseVo)bundleRespDto);
        return bundleRespDto;
    }

    @Override
    public BundleVersionRespDto queryVersionByCode(String bundleCode) {
        ArrayList versionList;
        if (StringUtils.isBlank((CharSequence)bundleCode)) {
            return null;
        }
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setCode(bundleCode);
        List bundleEoList = this.bundleDas.select((BaseEo)bundleEo);
        if (CollectionUtils.isEmpty((Collection)bundleEoList)) {
            return null;
        }
        BundleVersionRespDto bundleVersionRespDto = new BundleVersionRespDto();
        bundleVersionRespDto.setCode(bundleCode);
        Set versionSet = bundleEoList.stream().map(StdBundleEo::getVersion).collect(Collectors.toSet());
        BundleHistoryEo bundleHistoryEo = new BundleHistoryEo();
        bundleHistoryEo.setCode(bundleCode);
        List bundleHistoryEoList = this.bundleHistoryDas.select((BaseEo)bundleHistoryEo);
        if (!CollectionUtils.isEmpty((Collection)bundleHistoryEoList)) {
            versionSet.addAll(bundleHistoryEoList.stream().map(StdBundleHistoryEo::getVersion).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(versionList = new ArrayList(versionSet)) && versionList.size() > 1) {
            Collections.sort(versionList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s2.compareTo(s1);
                }
            });
        }
        bundleVersionRespDto.setVersionList(versionList);
        return bundleVersionRespDto;
    }

    @Override
    public List<BundleRespDto> queryChildren(String parentCode, Integer pageNum, Integer pageSize) {
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setParentCode(parentCode);
        PageInfo page = this.bundleDas.selectPage((BaseEo)bundleEo, pageNum, pageSize);
        page.getList().forEach(eo -> this.flag2type((com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo)eo));
        ArrayList<BundleRespDto> respDtoList = new ArrayList<BundleRespDto>();
        DtoHelper.eoList2DtoList((Collection)page.getList(), respDtoList, BundleRespDto.class);
        return respDtoList;
    }

    @Override
    public PageInfo<BundleRespDto> queryByParentCode(String parentCode, Integer pageNum, Integer pageSize) {
        ArrayList<com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo> bundleEoList = new ArrayList<com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo>();
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setParentCode(parentCode);
        bundleEo.setOrderByDesc("update_time");
        PageInfo page = this.bundleDas.selectPage((BaseEo)bundleEo, pageNum, pageSize);
        if (page != null && !CollectionUtils.isEmpty((Collection)page.getList())) {
            bundleEoList.addAll(page.getList());
        }
        bundleEo.setParentCode(null);
        bundleEo.setCode(parentCode);
        bundleEo = (com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo)this.bundleDas.selectOne((BaseEo)bundleEo);
        if (bundleEo != null) {
            bundleEoList.add(0, bundleEo);
        }
        bundleEoList.forEach(this::flag2type);
        ArrayList respDtoList = new ArrayList();
        DtoHelper.eoList2DtoList(bundleEoList, respDtoList, BundleRespDto.class);
        Comparator<BundleRespDto> byUpdateTimeDESC = Comparator.comparing(BaseReqDto::getUpdateTime, Comparator.nullsLast(Date::compareTo)).reversed();
        return new PageInfo(this.buildByParentKey(respDtoList, true, byUpdateTimeDESC));
    }

    @Override
    public PageInfo<BundleRespDto> queryByPage(BundleQueryReqDto bundleQueryReqDto, Integer pageNum, Integer pageSize) {
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        DtoHelper.dto2Eo((BaseVo)bundleQueryReqDto, (BaseEo)bundleEo);
        List bundleEoList = this.bundleDas.selectBundleEos(this.type2flag(bundleEo, (Boolean)false), pageNum, pageSize);
        bundleEoList.forEach(this::flag2type);
        List<BundleRespDto> bundleRespDtoList = new ArrayList<BundleRespDto>();
        DtoHelper.eoList2DtoList((Collection)bundleEoList, bundleRespDtoList, BundleRespDto.class);
        bundleRespDtoList = this.setRelationNo(bundleRespDtoList);
        Comparator<BundleRespDto> byUpdateTimeDESC = Comparator.comparing(BaseReqDto::getUpdateTime, Comparator.nullsLast(Date::compareTo)).reversed();
        return new PageInfo(this.buildByParentKey(bundleRespDtoList, true, byUpdateTimeDESC));
    }

    private List<BundleRespDto> setRelationNo(List<BundleRespDto> bundleRespDtoList) {
        for (BundleRespDto bundleRespDto : bundleRespDtoList) {
            ContainerBundleRelationEo relationEo = new ContainerBundleRelationEo();
            relationEo.setBundleId(bundleRespDto.getId());
            relationEo.setType(Constants.APP);
            bundleRespDto.setRelateAppNo(Integer.valueOf(this.containerBundleRelationDas.count((BaseEo)relationEo)));
            relationEo.setType(Constants.MODULE);
            bundleRespDto.setRelateModuleNo(Integer.valueOf(this.containerBundleRelationDas.count((BaseEo)relationEo)));
        }
        return bundleRespDtoList;
    }

    @Override
    protected List<BundleRespDto> queryNodeByKeys(Set<String> keySet) {
        if (CollectionUtils.isEmpty(keySet)) {
            return new ArrayList<BundleRespDto>();
        }
        if (CollectionUtils.isEmpty(keySet = keySet.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet()))) {
            return new ArrayList<BundleRespDto>();
        }
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"code", new ArrayList<String>(keySet))));
        List eoList = this.bundleDas.select((BaseEo)bundleEo);
        eoList.forEach(this::flag2type);
        List<BundleRespDto> respDtoList = new ArrayList<BundleRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, respDtoList, BundleRespDto.class);
        respDtoList = this.setRelationNo(respDtoList);
        return respDtoList;
    }

    @Override
    public List<String> getBundleCodeList(String code) {
        List<String> codeList = new ArrayList<String>();
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = this.bundleDas.selectByCode(code);
        if (bundleEo != null) {
            if ("ROOT_NODE".equals(bundleEo.getParentCode())) {
                List bundleEoList = this.bundleDas.selectByParentCode(bundleEo.getCode());
                if (!CollectionUtils.isEmpty((Collection)bundleEoList)) {
                    codeList = bundleEoList.stream().map(StdBundleEo::getCode).collect(Collectors.toList());
                }
            } else {
                codeList.add(code);
            }
        }
        return codeList;
    }

    @Override
    public BundleQueryRespDto queryBundleBaseInfo(BundleReqDto bundleReqDto) {
        BundleQueryRespDto respDto = new BundleQueryRespDto();
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo respBundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        CubeBeanUtils.copyProperties((Object)bundleEo, (Object)bundleReqDto, (String[])new String[0]);
        List bundleEoList = this.bundleDas.select((BaseEo)bundleEo);
        if (CollectionUtils.isEmpty((Collection)bundleEoList) && StringUtils.isNotEmpty((CharSequence)bundleReqDto.getVersion())) {
            BundleHistoryEo historyEo = new BundleHistoryEo();
            CubeBeanUtils.copyProperties((Object)historyEo, (Object)bundleEo, (String[])new String[0]);
            List historyEoList = this.bundleHistoryDas.select((BaseEo)historyEo);
            if (!CollectionUtils.isEmpty((Collection)historyEoList)) {
                BundleHistoryEo eo = (BundleHistoryEo)historyEoList.get(0);
                CubeBeanUtils.copyProperties((Object)respBundleEo, (Object)eo, (String[])new String[0]);
            }
        } else {
            respBundleEo = (com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo)bundleEoList.get(0);
        }
        this.flag2type(respBundleEo);
        DtoHelper.eo2Dto((BaseEo)respBundleEo, (BaseVo)respDto);
        List<BundleDepdDto> dependencies = this.bundleDependencyService.getBundleDependency(respBundleEo.getCode(), respBundleEo.getVersion());
        respDto.setBundleDependencies(dependencies);
        return respDto;
    }

    @Override
    public List<com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo> queryByParentCode(String parentCode) {
        com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo bundleEo = new com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo();
        bundleEo.setParentCode(parentCode);
        bundleEo.setOrderByDesc("update_time");
        ArrayList bundleEos = this.bundleDas.select((BaseEo)bundleEo);
        if (CollectionUtils.isEmpty((Collection)bundleEos)) {
            BundleHistoryEo bundleHistoryEo = new BundleHistoryEo();
            bundleHistoryEo.setParentCode(parentCode);
            bundleHistoryEo.setOrderByDesc("update_time");
            List bundleHistoryEos = this.bundleHistoryDas.select((BaseEo)bundleHistoryEo);
            bundleEos = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)bundleHistoryEos)) {
                CubeBeanUtils.copyCollection(bundleEos, (Collection)bundleHistoryEos, com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo.class);
            }
        }
        return bundleEos;
    }
}

