/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DomainDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityDomainService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IDataMetaService;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdDomainEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CapabilityDomainServiceImpl
implements ICapabilityDomainService {
    @Resource
    private IDataMetaService dataMetaService;

    @Override
    public List<DomainEo> sortDomain(List<DomainEo> domainEos) {
        if (CollectionUtils.isEmpty(domainEos)) {
            return new ArrayList<DomainEo>();
        }
        Comparator<DomainEo> bySortASC = Comparator.comparing(StdDomainEo::getSort, Comparator.nullsLast(Integer::compareTo));
        Comparator<DomainEo> byCodeASC = Comparator.comparing(StdDomainEo::getCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<DomainEo> finalComparator = bySortASC.thenComparing(byCodeASC);
        return domainEos.stream().sorted(finalComparator).collect(Collectors.toList());
    }

    @Override
    public List<DomainEo> getDomains(String domainCode, String domainName) {
        ArrayList<DomainEo> domainResultList = new ArrayList<DomainEo>();
        DomainDto domainDto = new DomainDto();
        domainDto.setCode(domainCode);
        domainDto.setName(domainName);
        domainDto.setExtFields(null);
        PageInfo<DomainDto> domainPageInfo = this.dataMetaService.queryDomainByPage(domainDto, 1, 100);
        if (domainPageInfo != null && !CollectionUtils.isEmpty((Collection)domainPageInfo.getList())) {
            DtoHelper.dtoList2EoList((Collection)domainPageInfo.getList(), domainResultList, DomainEo.class);
        }
        List<DomainEo> domainAfterSort = this.sortDomain(domainResultList);
        return domainAfterSort;
    }

    @Override
    public List<DomainEo> getDomainByCodes(List<String> codes) {
        return this.dataMetaService.queryDomainByCodes(codes);
    }

    @Override
    public void updateDomainSort(List<DomainEo> domainEos) {
        this.dataMetaService.updateDomainSort(domainEos);
    }

    @Override
    public String getDomainNameByDomainCode(String domainCode) {
        List<DomainEo> domainEoList = this.getDomainByCodes(Arrays.asList(domainCode));
        if (!CollectionUtils.isEmpty(domainEoList)) {
            return domainEoList.get(0).getName();
        }
        return null;
    }
}

