/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DomainDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IDataMetaService;
import com.dtyunxi.yundt.cube.center.func.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdDomainEo;
import com.github.pagehelper.PageInfo;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataMetaServiceImpl
implements IDataMetaService {
    private static final Logger logger = LoggerFactory.getLogger(DataMetaServiceImpl.class);
    @Resource
    private DomainDas domainDas;

    @Override
    public List<DomainEo> queryDomainByCodes(List<String> domainCodes) {
        if (CollectionUtils.isEmpty(domainCodes)) {
            return new ArrayList<DomainEo>();
        }
        DomainEo domainEo = new DomainEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(domainCodes, (String)",")));
        domainEo.setSqlFilters(sqlFilters);
        return this.domainDas.select((BaseEo)domainEo);
    }

    @Override
    public void updateDomainSort(List<DomainEo> domainEos) {
        if (CollectionUtils.isNotEmpty(domainEos)) {
            Map<String, DomainEo> code2Eo = domainEos.stream().collect(Collectors.toMap(StdDomainEo::getCode, v -> v, (v1, v2) -> v1));
            List<DomainEo> results = this.queryDomainByCodes(new ArrayList<String>(code2Eo.keySet()));
            for (DomainEo domainEo : results) {
                DomainEo paramEo = code2Eo.get(domainEo.getCode());
                if (paramEo == null) continue;
                domainEo.setSort(paramEo.getSort());
                this.domainDas.updateSelective((BaseEo)domainEo);
            }
        }
    }

    @Override
    public PageInfo<DomainDto> queryDomainByPage(DomainDto domainDto, Integer pageNum, Integer pageSize) {
        DomainEo domainEo = new DomainEo();
        DtoHelper.dto2Eo((BaseVo)domainDto, (BaseEo)domainEo);
        if (StringUtils.isNotBlank((CharSequence)domainEo.getName())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + domainEo.getName() + "%")));
            domainEo.setSqlFilters(sqlFilters);
        }
        domainEo.setOrderBy("code");
        PageInfo eoPageInfo = this.domainDas.selectPage((BaseEo)domainEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DomainDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public DomainDto getDomain(Long domainId) {
        DomainEo domainEo = (DomainEo)this.domainDas.selectByPrimaryKey(domainId);
        Assert.isTrue((domainEo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        DomainDto domainDto = new DomainDto();
        DtoHelper.eo2Dto((BaseEo)domainEo, (BaseVo)domainDto);
        return domainDto;
    }

    @Override
    public void addDomain(DomainDto domainDto) {
        DomainEo domainEo = new DomainEo();
        DtoHelper.dto2Eo((BaseVo)domainDto, (BaseEo)domainEo);
        domainEo.setId(null);
        this.domainDas.insert((BaseEo)domainEo);
    }

    @Override
    public void modifyDomain(DomainDto domainDto) {
        DomainEo domainEo = new DomainEo();
        DtoHelper.dto2Eo((BaseVo)domainDto, (BaseEo)domainEo);
        this.domainDas.updateSelective((BaseEo)domainEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delDomain(Long domainId) {
        this.domainDas.deleteById(domainId);
    }
}

