/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.starter.bundle.config.FeignClientConfig;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AppBundleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.EoCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.EoQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppStartedRecordRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.EoAttributeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.EoRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppStartedRecordService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleHistoryService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IEoService;
import com.dtyunxi.yundt.cube.center.func.dao.das.EoAttributeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.EoDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.EoAttributeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.EoEo;
import com.dtyunxi.yundt.cube.meta.dto.request.EntityDto;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EoServiceImpl
implements IEoService {
    private static final Logger logger = LoggerFactory.getLogger(EoServiceImpl.class);
    public static final String META_ENTITY_URL = "http://%s:%d/v1/meta/entity-detail/by-ip-port?bundleCode=%s&pageNum=%d&pageSize=%d";
    @Resource
    private EoDas eoDas;
    @Resource
    private EoAttributeDas eoAttributeDas;
    @Resource
    IBundleService bundleService;
    @Resource
    IBundleHistoryService bundleHistoryService;
    @Resource
    IAppBundleService appBundleService;
    @Resource
    IAppStartedRecordService appStartedRecordService;
    @Resource
    ICacheService cacheService;
    @Autowired
    private FeignClientConfig feignClientConfig;

    @Override
    public Long addEo(EoCreateReqDto addReqDto) {
        EoEo eoEo = new EoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)eoEo);
        this.eoDas.insert((BaseEo)eoEo);
        return eoEo.getId();
    }

    @Override
    public void modifyEo(EoCreateReqDto modifyReqDto) {
        EoEo eoEo = new EoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)eoEo);
        this.eoDas.updateSelective((BaseEo)eoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.eoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PageInfo<EntityDto> queryByPage(@Valid EoQueryReqDto eoReqDto, Integer pageNum, Integer pageSize) {
        List<EntityDto> entityDtoList = new ArrayList<EntityDto>();
        BundleRespDto bundleRespDto = this.bundleService.queryByCode(eoReqDto.getBundleCode());
        List<EntityDto> queryList = null;
        if (null == bundleRespDto) {
            bundleRespDto = this.getBundleRespDto(eoReqDto.getBundleCode(), eoReqDto.getBundleVersion());
            if (null == bundleRespDto) {
                return new PageInfo();
            }
            queryList = this.getEos(bundleRespDto);
            if (null != queryList) {
                entityDtoList.addAll(queryList);
            }
        } else if (bundleRespDto.isRootNode().booleanValue()) {
            List<BundleRespDto> bundles = this.bundleService.queryChildren(eoReqDto.getBundleCode(), 1, 1000);
            if (CollectionUtils.isEmpty(bundles)) {
                return new PageInfo(new ArrayList());
            }
            for (BundleRespDto dto : bundles) {
                queryList = this.getEos(dto);
                if (null == queryList) continue;
                entityDtoList.addAll(queryList);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)eoReqDto.getBundleVersion()) && !eoReqDto.getBundleVersion().equals(bundleRespDto.getVersion()) && null == (bundleRespDto = this.getBundleRespDto(eoReqDto.getBundleCode(), eoReqDto.getBundleVersion()))) {
                return new PageInfo();
            }
            queryList = this.getEos(bundleRespDto);
            if (null != queryList) {
                entityDtoList.addAll(queryList);
            }
        }
        entityDtoList = this.filterEoRespDto(entityDtoList, eoReqDto);
        return new PageInfo(entityDtoList);
    }

    private BundleRespDto getBundleRespDto(String bundleCode, String bundleVersion) {
        List<BundleHistoryEo> bundleHistoryEoList = this.bundleHistoryService.queryByCodeVersion(bundleCode, bundleVersion);
        if (CollectionUtils.isEmpty(bundleHistoryEoList)) {
            return null;
        }
        BundleRespDto bundleRespDto = new BundleRespDto();
        CubeBeanUtils.copyProperties((Object)bundleRespDto, (Object)bundleHistoryEoList.get(0), (String[])new String[0]);
        return bundleRespDto;
    }

    private List<EntityDto> getEos(BundleRespDto bundleRespDto) {
        String keyCache = this.getEoCacheKey(bundleRespDto.getCode(), bundleRespDto.getVersion());
        String valueCache = (String)this.cacheService.getCache(keyCache, String.class);
        if (StringUtils.isNotBlank((CharSequence)valueCache)) {
            return JSONArray.parseArray((String)valueCache, EntityDto.class);
        }
        List<EntityDto> entityDtoList = null;
        try {
            AppBundleRespDto appBundleRespDto = this.appBundleService.queryByBundleCodeAndVersion(bundleRespDto.getCode(), bundleRespDto.getVersion());
            List<AppStartedRecordRespDto> appStartedRecordEoList = this.appStartedRecordService.queryByAppCodeAndVersion(appBundleRespDto.getCode(), appBundleRespDto.getVersion());
            for (AppStartedRecordRespDto appStartedRecordEo : appStartedRecordEoList) {
                entityDtoList = this.queryEosFromApp(bundleRespDto, appStartedRecordEo);
                if (null == entityDtoList) continue;
                this.cacheService.add(keyCache, (Object)JSON.toJSONString(entityDtoList), Constants.BUNDLE_EO_CACHE_TIME.intValue());
                break;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return entityDtoList;
    }

    private List<EntityDto> filterEoRespDto(List<EntityDto> entityDtoList, EoQueryReqDto eoReqDto) {
        if (CollectionUtils.isEmpty(entityDtoList) || null == eoReqDto) {
            return entityDtoList;
        }
        return entityDtoList.stream().filter(entityDto -> {
            if (StringUtils.isNotBlank((CharSequence)eoReqDto.getCode()) && !entityDto.getCode().contains(eoReqDto.getCode())) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)eoReqDto.getName()) && !entityDto.getName().contains(eoReqDto.getName())) {
                return false;
            }
            return !StringUtils.isNotBlank((CharSequence)eoReqDto.getDomainList()) || eoReqDto.getDomainList().contains(entityDto.getDomainCode());
        }).collect(Collectors.toList());
    }

    private List<EntityDto> queryEosFromApp(BundleRespDto bundleRespDto, AppStartedRecordRespDto appStartedRecordEo) {
        if (appStartedRecordEo.getIp().contains("/")) {
            appStartedRecordEo.setIp(appStartedRecordEo.getIp().split("/")[1]);
        }
        logger.info("\u67e5\u8be2EO\u8bf7\u6c42\u5730\u5740\u4fe1\u606f\uff0cAppStartedRecordRespDto={}", JSON.toJSON((Object)appStartedRecordEo));
        String respJson = HttpUtil.sendGet((String)String.format(META_ENTITY_URL, appStartedRecordEo.getIp(), appStartedRecordEo.getPort(), bundleRespDto.getCode(), 1, 999));
        logger.info("respJson={}", (Object)respJson);
        RestResponse respDto = (RestResponse)JSON.parseObject((String)respJson, (TypeReference)new TypeReference<RestResponse<PageInfo<EntityDto>>>(){}, (Feature[])new Feature[0]);
        if (null != respDto && "0".equals(respDto.getResultCode())) {
            List list = ((PageInfo)respDto.getData()).getList();
            return ((PageInfo)respDto.getData()).getList();
        }
        return null;
    }

    @Override
    public String getEoCacheKey(String bundleCode, String bundleVersion) {
        return "BUNDLE_EO_" + bundleCode;
    }

    @Override
    public EoRespDto fillEoAttribute(EoRespDto eoRespDto) {
        if (null == eoRespDto) {
            return null;
        }
        EoAttributeEo eoQueryAttributeEo = new EoAttributeEo();
        eoQueryAttributeEo.setEoCode(eoRespDto.getCode());
        List eoAttributeEoList = this.eoAttributeDas.select((BaseEo)eoQueryAttributeEo);
        ArrayList eoAttributeRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoAttributeEoList, eoAttributeRespDtoList, EoAttributeRespDto.class);
        eoRespDto.setEoAttributeRespDtoList(eoAttributeRespDtoList);
        return eoRespDto;
    }

    @Override
    public List<EntityDto> queryByAppCodeAndVersion(String code, String version) {
        List<AppBundleRespDto> appBundleRespDtos = this.appBundleService.queryByAppCodeAndVersion(code, version);
        if (appBundleRespDtos.isEmpty()) {
            Collections.emptyList();
        }
        ArrayList<EntityDto> result = new ArrayList<EntityDto>();
        BundleRespDto bundleRespDto = new BundleRespDto();
        for (AppBundleRespDto dto : appBundleRespDtos) {
            bundleRespDto.setCode(dto.getBundleCode());
            bundleRespDto.setVersion(dto.getBundleVersion());
            List eos = this.getAppEos(bundleRespDto, code, version).stream().filter(entityDto -> dto.getBundleVersion().equals(entityDto.getVersion())).collect(Collectors.toList());
            result.addAll(eos);
        }
        return result;
    }

    private List<EntityDto> getAppEos(BundleRespDto bundleRespDto, String appCode, String appVerison) {
        String keyCache = this.getEoCacheKey(bundleRespDto.getCode(), bundleRespDto.getVersion());
        String valueCache = (String)this.cacheService.getCache(keyCache, String.class);
        if (StringUtils.isNotBlank((CharSequence)valueCache)) {
            return JSONArray.parseArray((String)valueCache, EntityDto.class);
        }
        List<EntityDto> entityDtoList = null;
        try {
            List<AppStartedRecordRespDto> appStartedRecordEoList = this.appStartedRecordService.queryByAppCodeAndVersion(appCode, appVerison);
            for (AppStartedRecordRespDto appStartedRecordEo : appStartedRecordEoList) {
                entityDtoList = this.queryEosFromApp(bundleRespDto, appStartedRecordEo);
                if (null == entityDtoList) continue;
                this.cacheService.add(keyCache, (Object)JSON.toJSONString(entityDtoList), Constants.BUNDLE_EO_CACHE_TIME.intValue());
                break;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return entityDtoList;
    }
}

