/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizRuleRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IRBizRuleSpaceIdentityService;
import com.dtyunxi.yundt.cube.center.func.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizRuleSpaceIdentityDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizRuleSpaceIdentityEo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RBizRuleSpaceIdentityServiceImpl
implements IRBizRuleSpaceIdentityService {
    @Resource
    private RBizRuleSpaceIdentityDas bizRuleSpaceIdentityDas;

    @Override
    public List<RBizRuleSpaceIdentityEo> queryByRuleIds(Collection<Long> bizRuleIds) {
        RBizRuleSpaceIdentityEo selectParam = new RBizRuleSpaceIdentityEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("biz_rule_id", bizRuleIds).get());
        return this.bizRuleSpaceIdentityDas.select((BaseEo)selectParam);
    }

    @Override
    public List<BizRuleRespDto.BizIdentity2Space> queryOwnersOfRules(Collection<Long> bizRuleIds) {
        return this.queryByRuleIds(bizRuleIds).stream().map(eo -> {
            BizRuleRespDto.BizIdentity2Space owner = new BizRuleRespDto.BizIdentity2Space();
            owner.setBizIdentityCode(eo.getBizIdentityCode());
            owner.setBizSpaceCode(eo.getBizSpaceCode());
            owner.setBizRuleId(eo.getBizRuleId());
            return owner;
        }).collect(Collectors.toList());
    }
}

