/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.param.CubeParam;
import com.dtyunxi.cube.notifier.config.NotifierFeignClientConfig;
import com.dtyunxi.cube.starter.bundle.config.FeignClientConfig;
import com.dtyunxi.cube.starter.bundle.dto.request.OptionQueryReqDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleDescRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleSettingRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.OptionRespDto;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.StdBundleEo;
import com.dtyunxi.cube.starter.bundle.rest.FeignClientApiCaller;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.DomainEventQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AppBundleRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.DomainEventRespDto;
import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbortPolicy;
import com.dtyunxi.yundt.cube.center.func.api.constants.AppStartedPullStatus;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.OptionSourceType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingDisplayLevel;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingEditType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingExtptExecMechanism;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingValueType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingViewNodeType;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.SettingOptionBaseDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleDepdSettingReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BundleSettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingOptionImportDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingOptionReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingRemoveReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppStartedRecordRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BundleSettingTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilitySimpleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingDetailRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingOptionRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppStartedRecordService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IROptionSettingService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingTabularService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingValueService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.TreeBuilder;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.util.IRawBundleSettingApi;
import com.dtyunxi.yundt.cube.center.func.biz.util.IntervalUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.BundleDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.OptionSettingRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ViewCapabilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BundleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.OptionSettingRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdOptionSettingRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingOptionEo;
import com.dtyunxi.yundt.module.context.biz.RawFeignClientContextFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SettingServiceImpl
implements ISettingService {
    @Resource
    private SettingDas settingDas;
    @Resource
    private SettingOptionDas settingOptionDas;
    @Resource
    private ICapabilityService capabilityService;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private BundleDas bundleDas;
    @Resource
    private ISettingValueService settingValueService;
    @Resource
    private SettingValueDas settingValueDas;
    @Resource
    private SettingHistoryDas settingHistoryDas;
    @Resource
    private SettingOptionHistoryDas settingOptionHistoryDas;
    @Resource
    private IBundleService bundleService;
    @Resource
    private OptionSettingRelationDas optionSettingRelationDas;
    @Resource
    private IROptionSettingService rOptionSettingService;
    @Resource
    private ISettingTabularService settingTabularService;
    @Resource
    private IAppBundleService appBundleService;
    @Resource
    private IAppStartedRecordService appStartedRecordService;
    @Resource
    private ViewCapabilityRelationDas viewCapabilityRelationDas;
    @Autowired
    private FeignClientConfig feignClientConfig;
    private static final Logger logger = LoggerFactory.getLogger(SettingServiceImpl.class);
    private static final String SETTING_OPTION_URL = "http://%s:%d/v1/bundle/setting-option?%s";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createSetting(SettingCreateReqDto settingCreateReqDto) {
        Iterator iterator;
        SettingEo settingEo = new SettingEo();
        DtoHelper.dto2Eo((BaseVo)settingCreateReqDto, (BaseEo)settingEo);
        settingEo.setBundle(settingCreateReqDto.getBundleCode());
        List options = settingCreateReqDto.getOptions();
        this.validateParamSettingField(settingEo, options, settingCreateReqDto.getTabularViewDto(), true);
        if (settingCreateReqDto.getIsControlled() == null) {
            settingEo.setIsControlled(Constants.FALSE);
        }
        if (settingCreateReqDto.getDisplayLevel() == null) {
            settingEo.setDisplayLevel(Integer.valueOf(SettingDisplayLevel.BIZID.getCode()));
        }
        if (StringUtils.isBlank((CharSequence)settingCreateReqDto.getExtension())) {
            settingEo.setExtension("");
        }
        settingEo.setOptionSourceType(Integer.valueOf(OptionSourceType.STATIC.getValue()));
        ArrayList<String> capabilityCodes = new ArrayList<String>();
        capabilityCodes.add(settingCreateReqDto.getCapabilityCode());
        Set viewIdSet = this.viewCapabilityRelationDas.getViewIdByCapabilityCodes(capabilityCodes);
        Long viewId = null;
        if (CollectionUtils.isNotEmpty((Collection)viewIdSet) && (iterator = viewIdSet.iterator()).hasNext()) {
            Long view;
            viewId = view = (Long)iterator.next();
        }
        if (settingCreateReqDto.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            settingEo.setDefaultValue(JSONObject.toJSONString((Object)settingCreateReqDto.getTabularViewDto()));
        }
        if (null != viewId && settingCreateReqDto.getEditType().equals(SettingEditType.INPUT.getCode())) {
            this.processGlobalInputSettingValue(settingCreateReqDto.getCode(), settingCreateReqDto.getDefaultValue(), settingCreateReqDto.getIsControlled());
        } else if (settingCreateReqDto.getEditType().equals(SettingEditType.CHOICE.getCode())) {
            if (settingCreateReqDto.getValueType().equals(SettingValueType.TABULAR.getCode())) {
                SettingValueEo settingValueEo = new SettingValueEo();
                settingValueEo.setSettingCode(settingCreateReqDto.getCode());
                settingValueEo.setSettingValue(settingEo.getDefaultValue());
                settingValueEo.setIsControlled(settingCreateReqDto.getIsControlled());
                settingValueEo.setExtension("");
                ArrayList<SettingValueEo> settingValueEos = new ArrayList<SettingValueEo>();
                settingValueEos.add(settingValueEo);
                this.settingValueService.createSettingValue(settingValueEos);
            } else {
                this.processSettingOption(settingEo, options, true, viewId);
            }
        }
        this.settingDas.insert((BaseEo)settingEo);
        return settingEo.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifySetting(SettingModifyReqDto settingModifyReqDto) {
        Iterator iterator;
        SettingEo updateEo = new SettingEo();
        DtoHelper.dto2Eo((BaseVo)settingModifyReqDto, (BaseEo)updateEo);
        updateEo.setBundle(settingModifyReqDto.getBundleCode());
        List options = settingModifyReqDto.getOptions();
        this.validateParamSettingField(updateEo, options, settingModifyReqDto.getTabularViewDto(), false);
        SettingEo resultEo = this.settingDas.selectByCode(settingModifyReqDto.getCode());
        if (resultEo.getEditType().equals(SettingEditType.INPUT.getCode()) && StringUtils.isNotBlank((CharSequence)settingModifyReqDto.getValueScope()) && StringUtils.isNotBlank((CharSequence)resultEo.getValueScope()) && !settingModifyReqDto.getValueScope().equals(resultEo.getValueScope())) {
            Assert.isTrue((!this.settingValueService.validateSettingWithValue(resultEo.getCode(), null, null) ? 1 : 0) != 0, (String)"\u8be5\u914d\u7f6e\u9879\u9009\u9879\u5df2\u88ab\u8bbe\u7f6e\u503c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        updateEo.setId(resultEo.getId());
        updateEo.setCapabilityCode(resultEo.getCapabilityCode());
        updateEo.setOptionSourceType(Integer.valueOf(OptionSourceType.STATIC.getValue()));
        if (StringUtils.isBlank((CharSequence)settingModifyReqDto.getExtension())) {
            updateEo.setExtension("");
        }
        if (settingModifyReqDto.getViewVisible() == null) {
            updateEo.setViewVisible(resultEo.getViewVisible());
        }
        if (settingModifyReqDto.getValueType().equals(SettingValueType.TABULAR.getCode()) && resultEo.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            TabularDto dbDto;
            List paramHeaders = new ArrayList();
            TabularDto paramDto = settingModifyReqDto.getTabularViewDto();
            Set<Object> paramHeaderCodeSet = new HashSet();
            if (null != paramDto && CollectionUtils.isNotEmpty(paramHeaders = paramDto.getHeaders())) {
                paramHeaderCodeSet = paramHeaders.stream().map(TabularDto.Header::getCode).collect(Collectors.toSet());
            }
            if (null != (dbDto = (TabularDto)JSONObject.parse((String)resultEo.getDefaultValue()))) {
                List dbHeaders = dbDto.getHeaders();
                Assert.isTrue((dbHeaders != null && dbHeaders.size() > paramHeaders.size() ? 1 : 0) != 0, (String)"\u7f16\u8f91\u8868\u683c\u65f6\u53ea\u5141\u8bb8\u7f16\u8f91\u5217\u540d\u79f0\u548c\u7b80\u4ecb\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5217");
                for (TabularDto.Header dbHeader : dbHeaders) {
                    Assert.isTrue((boolean)paramHeaderCodeSet.contains(dbHeader.getCode()), (String)"\u7f16\u8f91\u8868\u683c\u65f6\u53ea\u5141\u8bb8\u7f16\u8f91\u5217\u540d\u79f0\u548c\u7b80\u4ecb\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5217");
                }
            }
            updateEo.setDefaultValue(JSONObject.toJSONString((Object)settingModifyReqDto.getTabularViewDto()));
        }
        this.settingDas.update((BaseEo)updateEo);
        ArrayList<String> capabilityCodes = new ArrayList<String>();
        capabilityCodes.add(resultEo.getCapabilityCode());
        Set viewIdSet = this.viewCapabilityRelationDas.getViewIdByCapabilityCodes(capabilityCodes);
        Long viewId = null;
        if (CollectionUtils.isNotEmpty((Collection)viewIdSet) && (iterator = viewIdSet.iterator()).hasNext()) {
            Long view;
            viewId = view = (Long)iterator.next();
        }
        this.processSettingOption(updateEo, options, false, viewId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSetting(SettingRemoveReqDto settingRemoveReqDto) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)settingRemoveReqDto.getCode()), (String)"\u80fd\u529b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!this.settingValueService.validateSettingWithValue(settingRemoveReqDto.getCode(), null, null) ? 1 : 0) != 0, (String)"\u8be5\u914d\u7f6e\u9879\u9009\u9879\u5df2\u88ab\u8bbe\u7f6e\u503c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        SettingEo settingEo = new SettingEo();
        DtoHelper.dto2Eo((BaseVo)settingRemoveReqDto, (BaseEo)settingEo);
        this.settingDas.delete((BaseEo)settingEo);
        SettingOptionEo settingOptionEo = new SettingOptionEo();
        settingOptionEo.setSettingCode(settingRemoveReqDto.getCode());
        this.settingOptionDas.delete((BaseEo)settingOptionEo);
    }

    @Override
    public SettingDetailRespDto queryByCode(String code) {
        SettingEo settingResult = this.settingDas.selectByCode(code);
        SettingDetailRespDto settingDetailRespDto = new SettingDetailRespDto();
        if (settingResult != null) {
            CapabilitySimpleRespDto capabilitySimpleRespDto;
            DtoHelper.eo2Dto((BaseEo)settingResult, (BaseVo)settingDetailRespDto);
            BundleEo bundleEo = this.bundleDas.selectByCode(settingResult.getBundle());
            if (bundleEo != null) {
                settingDetailRespDto.setBundleCode(settingResult.getBundle());
                settingDetailRespDto.setBundleName(bundleEo.getName());
                settingDetailRespDto.setBundleParentCode(bundleEo.getParentCode());
            }
            if ((capabilitySimpleRespDto = this.capabilityService.queryByCode(settingResult.getCapabilityCode())) != null) {
                settingDetailRespDto.setCapabilityName(capabilitySimpleRespDto.getName());
            }
            if (settingResult.getValueType().equals(SettingValueType.TABULAR.getCode())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)settingResult.getDefaultValue()), (String)("\u914d\u7f6e\u9879[" + settingResult.getCode() + "]\u6570\u636e\u4e0d\u6b63\u786e"));
                TabularDto tabularDto = this.settingTabularService.getViewTabularDto(settingResult, settingResult.getDefaultValue());
                settingDetailRespDto.setTabularViewDto(tabularDto);
            } else {
                List<Object> options = new ArrayList<SettingOptionRespDto>();
                if (CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.getValue().equals(settingResult.getOptionSourceType())) {
                    Map<String, List<OptionRespDto>> result = this.optionsFromBundle(Collections.singletonList(code), settingResult.getBundle(), settingResult.getVersion());
                    if (result != null && CollectionUtils.isNotEmpty((Collection)result.get("code"))) {
                        options = result.get(code).stream().map(e -> {
                            SettingOptionRespDto respDto = new SettingOptionRespDto();
                            respDto.setCode(e.getCode());
                            respDto.setOptionValue(e.getValue());
                            respDto.setName(e.getName());
                            respDto.setDescr(e.getDescr());
                            respDto.setBundleCode(settingResult.getBundle());
                            respDto.setBundleName(bundleEo == null ? "" : bundleEo.getName());
                            return respDto;
                        }).collect(Collectors.toList());
                    }
                } else {
                    List settingOptionEos = this.settingOptionDas.selectBySettingCode(code);
                    Map<Object, Object> bundleCodeMap = new HashMap();
                    if (CollectionUtils.isNotEmpty((Collection)settingOptionEos)) {
                        List<String> bundleCodes = settingOptionEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getBundle())).map(StdSettingOptionEo::getBundle).collect(Collectors.toList());
                        bundleCodeMap = this.getBundle(bundleCodes);
                    }
                    for (SettingOptionEo settingOptionEo : settingOptionEos) {
                        SettingOptionRespDto settingOptionRespDto = new SettingOptionRespDto();
                        DtoHelper.eo2Dto((BaseEo)settingOptionEo, (BaseVo)settingOptionRespDto);
                        String optionBundleCode = settingOptionEo.getBundle();
                        if (StringUtils.isNotBlank((CharSequence)optionBundleCode)) {
                            BundleEo optionBundle = (BundleEo)bundleCodeMap.get(optionBundleCode);
                            settingOptionRespDto.setBundleCode(optionBundleCode);
                            settingOptionRespDto.setBundleName(optionBundle.getName());
                            settingOptionRespDto.setBundleParentCode(optionBundle.getParentCode());
                        }
                        options.add(settingOptionRespDto);
                    }
                    if (CollectionUtils.isNotEmpty(options) && !settingDetailRespDto.getValueType().equals(SettingValueType.BOOLEAN.getCode())) {
                        options.sort(Comparator.comparing(SettingOptionBaseDto::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(SettingOptionBaseDto::getCode, String.CASE_INSENSITIVE_ORDER));
                    }
                }
                settingDetailRespDto.setOptions(options);
            }
        }
        return settingDetailRespDto;
    }

    @Override
    public SettingEo queryEoByCode(String code) {
        return this.settingDas.selectByCode(code);
    }

    @Override
    public PageInfo<SettingRespDto> querySettingsPage(SettingQueryReqDto settingQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo settingRespDtoPageInfo = new PageInfo();
        ArrayList<SettingRespDto> settingRespDtos = new ArrayList<SettingRespDto>();
        PageInfo settingEoPageInfo = new PageInfo();
        SettingEo querySettingEo = new SettingEo();
        DtoHelper.dto2Eo((BaseVo)settingQueryReqDto, (BaseEo)querySettingEo, (String[])new String[]{"code", "name"});
        querySettingEo.setBundle(settingQueryReqDto.getBundleCode());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)settingQueryReqDto.getDomainCode()) && StringUtils.isBlank((CharSequence)settingQueryReqDto.getCapabilityCode())) {
            querySettingEo.setCode(settingQueryReqDto.getCode());
            querySettingEo.setName(settingQueryReqDto.getName());
            settingEoPageInfo = this.settingDas.selectPageByDomain(settingQueryReqDto.getDomainCode(), querySettingEo, pageNum, pageSize);
        } else {
            CapabilityEo capabilityEo;
            if (StringUtils.isBlank((CharSequence)settingQueryReqDto.getDomainCode()) && StringUtils.isNotBlank((CharSequence)settingQueryReqDto.getCapabilityCode()) && (capabilityEo = this.capabilityDas.selectByCode(settingQueryReqDto.getCapabilityCode())).getParentCode().equals("ROOT_NODE")) {
                List<CapabilityEo> capabilityEos = this.capabilityService.getChildrenEoByCapabilityCode(capabilityEo.getCode());
                if (CollectionUtils.isEmpty(capabilityEos)) {
                    settingRespDtoPageInfo.setList(settingRespDtos);
                    return settingRespDtoPageInfo;
                }
                querySettingEo.setCapabilityCode(null);
                Set capabilityCodeSet = capabilityEos.stream().map(StdCapabilityEo::getCode).collect(Collectors.toSet());
                sqlFilters.add(SqlFilter.in((String)"capability_code", (Object)StringUtils.join(capabilityCodeSet, (String)",")));
            }
            if (StringUtils.isNotBlank((CharSequence)settingQueryReqDto.getCode())) {
                sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + settingQueryReqDto.getCode() + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)settingQueryReqDto.getName())) {
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + settingQueryReqDto.getName() + "%")));
            }
            querySettingEo.setSqlFilters(sqlFilters);
            querySettingEo.setOrderByDesc("create_time");
            settingEoPageInfo = this.settingDas.selectPage((BaseEo)querySettingEo, pageNum, pageSize);
        }
        CubeBeanUtils.copyProperties((Object)settingRespDtoPageInfo, (Object)settingEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List settingEoList = settingEoPageInfo.getList();
        Map<Object, Object> bundleCodeMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settingEoList)) {
            List<String> bundleCodes = settingEoList.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getBundle())).map(StdSettingEo::getBundle).collect(Collectors.toList());
            bundleCodeMap = this.getBundle(bundleCodes);
        }
        for (SettingEo eo2 : settingEoList) {
            SettingRespDto settingRespDto = new SettingRespDto();
            DtoHelper.eo2Dto((BaseEo)eo2, (BaseVo)settingRespDto);
            settingRespDto.setBundleCode(eo2.getBundle());
            BundleEo bundle = (BundleEo)bundleCodeMap.get(eo2.getBundle());
            if (bundle != null) {
                settingRespDto.setBundleName(bundle.getName());
            }
            settingRespDtos.add(settingRespDto);
        }
        settingRespDtoPageInfo.setList(settingRespDtos);
        return settingRespDtoPageInfo;
    }

    @Override
    public List<SettingEo> getSettingByCondition(List<String> bundleCodes, List<String> capabilityCodes, Integer viewVisible) {
        return this.settingDas.getSettingByCondition(bundleCodes, capabilityCodes, viewVisible);
    }

    @Override
    public List<SettingOptionEo> getSettingOptionBySetting(List<String> settingCodes, List<String> bundleCodes) {
        return this.settingOptionDas.selectBySettingCodeList(settingCodes, bundleCodes);
    }

    @Override
    public List<SettingEo> getSettingEoByCodes(List<String> settingCodes) {
        return this.settingDas.selectByCodeList(settingCodes, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSettingEos(List<SettingEo> settingEos) {
        for (SettingEo eo : settingEos) {
            this.settingDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void updateSendFlag(String settingCode, Integer flag) {
        SettingEo queryEo = new SettingEo();
        queryEo.setCode(settingCode);
        SettingEo updateEo = (SettingEo)this.settingDas.selectOne((BaseEo)queryEo);
        if (null == updateEo) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)updateEo.getParameter());
        jsonObject.put("sendFlag", (Object)flag);
        updateEo.setParameter(jsonObject.toJSONString());
        this.settingDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public List<SettingEo> getSettingByName(String name, List<String> bundleCodes) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name + "%")));
        if (CollectionUtils.isNotEmpty(bundleCodes)) {
            sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
        }
        SettingEo settingEo = new SettingEo();
        settingEo.setSqlFilters(sqlFilters);
        return this.settingDas.select((BaseEo)settingEo);
    }

    @Override
    public boolean isChoiceSetting(String settingCode) {
        SettingEo settingEo = this.settingDas.selectByCode(settingCode);
        if (settingEo != null) {
            return SettingEditType.CHOICE.getCode() == settingEo.getEditType().intValue();
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateSetting(BundleDescRespDto bundleDesc, String bundleCode, String dbBundleVersion) {
        List settings = bundleDesc.getSettings();
        List options = bundleDesc.getOptions();
        List depdSettings = bundleDesc.getDepdSettings();
        String groupId = bundleDesc.getGroupId();
        String artifactId = bundleDesc.getArtifactId();
        String version = bundleDesc.getVersion();
        if (CollectionUtils.isNotEmpty((Collection)settings)) {
            this.importSetting(groupId, artifactId, version, dbBundleVersion, bundleCode, settings);
        }
        if (CollectionUtils.isNotEmpty((Collection)options)) {
            ArrayList<SettingOptionImportDto> optionImportDtos = new ArrayList<SettingOptionImportDto>();
            Map<String, List<BundleSettingRespDto.Option>> setting2OptionsMap = options.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSettingCode())).collect(Collectors.groupingBy(BundleSettingRespDto.Option::getSettingCode));
            for (String settingCode : setting2OptionsMap.keySet()) {
                int sortNo = 0;
                List<BundleSettingRespDto.Option> values = setting2OptionsMap.get(settingCode);
                if (CollectionUtils.isEmpty(values)) continue;
                for (BundleSettingRespDto.Option option : values) {
                    SettingOptionImportDto importDto = new SettingOptionImportDto();
                    CubeBeanUtils.copyProperties((Object)importDto, (Object)option, (String[])new String[0]);
                    importDto.setOptionValue(option.getValue());
                    if (option.getIsDefault() == null) {
                        importDto.setIsDefault(Constants.FALSE);
                    }
                    importDto.setVersion(version);
                    importDto.setGroupId(groupId);
                    importDto.setArtifactId(artifactId);
                    importDto.setSort(Integer.valueOf(sortNo));
                    optionImportDtos.add(importDto);
                    ++sortNo;
                }
            }
            this.processOptionsImport(groupId, artifactId, version, dbBundleVersion, bundleCode, optionImportDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)depdSettings)) {
            this.importDepdSetting(depdSettings);
        }
    }

    private void importSetting(String groupId, String artifactId, String version, String dbBundleVersion, String bundleCode, List<BundleSettingRespDto.Setting> settings) {
        SettingEo queryEo = new SettingEo();
        queryEo.setBundle(bundleCode);
        List dbSettings = this.settingDas.select((BaseEo)queryEo);
        if (dbBundleVersion != null && !dbBundleVersion.equals(version) && CollectionUtils.isNotEmpty((Collection)dbSettings)) {
            this.backupSetting(bundleCode, version, dbSettings);
        } else {
            this.settingDas.logicDelete(bundleCode);
            Set settingCodes = settings.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCode())).map(BundleSettingRespDto.Setting::getCode).collect(Collectors.toSet());
            this.settingDas.logicDelete(settingCodes);
            if (CollectionUtils.isNotEmpty((Collection)dbSettings)) {
                dbSettings.clear();
            }
        }
        ArrayList<SettingEo> processedEos = new ArrayList<SettingEo>();
        Map<Object, Object> code2dbSetting = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbSettings)) {
            code2dbSetting = dbSettings.stream().collect(Collectors.toMap(StdSettingEo::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<SettingEo> settingInsertEos = new ArrayList<SettingEo>();
        ArrayList<String> deleteCodes = new ArrayList<String>();
        for (BundleSettingRespDto.Setting settingDto : settings) {
            SettingEo settingEo = this.getImportSettingEo(settingDto, groupId, artifactId, version, bundleCode);
            deleteCodes.add(settingEo.getCode());
            SettingEo dbSetting = null;
            if (code2dbSetting.size() > 0) {
                dbSetting = (SettingEo)code2dbSetting.get(settingEo.getCode());
            }
            if (null == dbSetting) {
                settingInsertEos.add(settingEo);
                continue;
            }
            settingEo.setId(dbSetting.getId());
            this.settingDas.update((BaseEo)settingEo);
            processedEos.add(dbSetting);
        }
        if (CollectionUtils.isNotEmpty(processedEos)) {
            dbSettings.removeAll(processedEos);
            for (SettingEo eo : dbSettings) {
                this.settingDas.logicDelete((BaseEo)eo);
            }
        }
        this.settingDas.insertBatch(settingInsertEos);
        this.deleteSettingByCodes(deleteCodes, bundleCode);
    }

    private void deleteSettingByCodes(List<String> codes, String bundleCode) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        SettingEo querySettingEo = new SettingEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
        querySettingEo.setSqlFilters(sqlFilters);
        List settingEoList = this.settingDas.select((BaseEo)querySettingEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isNotEmpty((Collection)settingEoList)) {
            settingEoList.forEach(settingEo -> {
                if (settingEo.getBundle() == null || !bundleCode.equals(settingEo.getBundle())) {
                    this.settingDas.logicDelete((BaseEo)settingEo);
                }
            });
        }
    }

    private void backupSetting(String bundleCode, String version, List<SettingEo> dbSettings) {
        if (CollectionUtils.isEmpty(dbSettings)) {
            return;
        }
        String settingVersion = dbSettings.get(0).getVersion();
        this.settingHistoryDas.logicDelete(bundleCode, settingVersion);
        ArrayList<SettingHistoryEo> insertSettingHistoryEos = new ArrayList<SettingHistoryEo>();
        for (SettingEo dbEo : dbSettings) {
            SettingHistoryEo insertEo = new SettingHistoryEo();
            CubeBeanUtils.copyProperties((Object)insertEo, (Object)dbEo, (String[])new String[]{"id", "create_time", "create_person", "update_time", "update_person"});
            insertSettingHistoryEos.add(insertEo);
        }
        if (CollectionUtils.isNotEmpty(insertSettingHistoryEos)) {
            this.settingHistoryDas.insertBatch(insertSettingHistoryEos);
        }
        this.settingHistoryDas.logicDelete(bundleCode, version);
    }

    private void backupSettingOption(String bundleCode, String version, List<SettingOptionEo> dbOptions) {
        String dbOptionVersion = dbOptions.get(0).getVersion();
        this.settingOptionHistoryDas.logicDelete(bundleCode, dbOptionVersion);
        ArrayList<SettingOptionHistoryEo> insertOptionHistoryEos = new ArrayList<SettingOptionHistoryEo>();
        for (SettingOptionEo dbEo : dbOptions) {
            SettingOptionHistoryEo insertEo = new SettingOptionHistoryEo();
            CubeBeanUtils.copyProperties((Object)insertEo, (Object)dbEo, (String[])new String[]{"id", "create_time", "create_person", "update_time", "update_person"});
            insertOptionHistoryEos.add(insertEo);
        }
        if (CollectionUtils.isNotEmpty(insertOptionHistoryEos)) {
            this.settingOptionHistoryDas.insertBatch(insertOptionHistoryEos);
        }
        this.settingOptionHistoryDas.logicDelete(bundleCode, version);
    }

    private SettingEo getImportSettingEo(BundleSettingRespDto.Setting settingDto, String groupId, String artifactId, String version, String bundleCode) {
        SettingEo settingEo = new SettingEo();
        CubeBeanUtils.copyProperties((Object)settingEo, (Object)settingDto, (String[])new String[0]);
        settingEo.setBundle(bundleCode);
        if (settingDto.getIsControlled() == null) {
            settingEo.setIsControlled(Constants.TRUE);
        }
        if (settingDto.getExecMechanism() == null) {
            settingEo.setExecMechanism(Integer.valueOf(SettingExtptExecMechanism.SEQUENTIAL.getCode()));
        }
        if (settingDto.getOptionSourceType() == null) {
            settingEo.setOptionSourceType(Integer.valueOf(OptionSourceType.STATIC.getValue()));
        }
        if (settingDto.getAbortPolicy() == null) {
            settingEo.setAbortPolicy(Integer.valueOf(AbortPolicy.BREAK.getValue()));
        }
        if (settingDto.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            TabularDto tabularDto = (TabularDto)JSONObject.parseObject((String)settingEo.getDefaultValue(), TabularDto.class);
            this.checkTabularValues(tabularDto);
        }
        settingEo.setDisplayLevel(Integer.valueOf(SettingDisplayLevel.BIZID.getCode()));
        settingEo.setExtension("");
        settingEo.setBundle(bundleCode);
        settingEo.setVersion(version);
        settingEo.setGroupId(groupId);
        settingEo.setArtifactId(artifactId);
        this.validSettingBeforeImport(settingEo);
        String settingEoName = settingEo.getName();
        if (settingEoName != null && settingEoName.length() > 20) {
            settingEo.setName(settingEoName.substring(0, 17) + "...");
        }
        return settingEo;
    }

    @Override
    public DomainEventRespDto queryDomainEvent(DomainEventQueryReqDto domainEventQueryReqDto) {
        DomainEventRespDto domainEventRespDto = new DomainEventRespDto();
        if (CollectionUtils.isEmpty((Collection)domainEventQueryReqDto.getDomainCodeList())) {
            domainEventRespDto.setSettings(new ArrayList());
            return domainEventRespDto;
        }
        SettingEo settingEo = new SettingEo();
        settingEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"code", (Object)domainEventQueryReqDto.getDomainCodeList())));
        List settingEoList = this.settingDas.select((BaseEo)settingEo);
        ArrayList settingRespDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(settingRespDtoList, (Collection)settingEoList, DomainEventRespDto.Setting.class);
        domainEventRespDto.setSettings(settingRespDtoList);
        return domainEventRespDto;
    }

    @Override
    public PageInfo<BundleSettingTreeRespDto> queryBundleSetting(BundleSettingQueryReqDto bundleSettingQueryReqDto) {
        Map<String, List<SettingOptionEo>> setting2Options;
        List<SettingEo> resultSettings;
        List<CapabilityEo> resultCaps;
        String bundleCode = bundleSettingQueryReqDto.getBundleCode();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)bundleCode), (String)"\u529f\u80fd\u5305\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String version = bundleSettingQueryReqDto.getVersion();
        String firstCapabilityCode = bundleSettingQueryReqDto.getFirstCapabilityCode();
        HashSet<String> bundleQueryCodes = new HashSet<String>();
        bundleQueryCodes.add(bundleCode);
        List<BundleEo> bundleEos = this.bundleService.queryByParentCode(bundleCode);
        if (CollectionUtils.isNotEmpty(bundleEos)) {
            Set childrenBundleCode = bundleEos.stream().map(StdBundleEo::getCode).collect(Collectors.toSet());
            bundleQueryCodes.addAll(childrenBundleCode);
        }
        if (CollectionUtils.isEmpty(resultCaps = this.getBundleCapability(bundleQueryCodes, resultSettings = this.getBundleSetting(bundleQueryCodes, version, setting2Options = this.getBundleSetting2Options(bundleQueryCodes, version))))) {
            return new PageInfo();
        }
        List<BundleSettingTreeRespDto> processTreeDtos = this.getProcessTreeDtos(resultCaps, resultSettings, setting2Options, firstCapabilityCode);
        Comparator<BundleSettingTreeRespDto> byParentCodeASC = Comparator.comparing(BundleSettingTreeRespDto::getParentCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<BundleSettingTreeRespDto> byCodeASC = Comparator.comparing(BundleSettingTreeRespDto::getCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<BundleSettingTreeRespDto> finalComparator = byParentCodeASC.thenComparing(byCodeASC);
        TreeBuilder<BundleSettingTreeRespDto> treeBuilder = new TreeBuilder<BundleSettingTreeRespDto>();
        List<BundleSettingTreeRespDto> result = treeBuilder.buildByParentKey(processTreeDtos, false, finalComparator);
        return new PageInfo(result);
    }

    @Override
    public List<BundleSettingTreeRespDto> getBundleSettingDepdSetting(BundleDepdSettingReqDto bundleDepdSettingReqDto) {
        Map<Integer, List<SettingEo>> sourceTypeMapSetting;
        Set staticSettingCodes;
        ArrayList resultOptionEos;
        String settingCode = bundleDepdSettingReqDto.getSettingCode();
        String optionCode = bundleDepdSettingReqDto.getOptionCode();
        String bundleCode = bundleDepdSettingReqDto.getBundleCode();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)bundleCode), (String)"\u529f\u80fd\u5305\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String version = bundleDepdSettingReqDto.getVersion();
        OptionSettingRelationEo relationEo = new OptionSettingRelationEo();
        relationEo.setSettingCode(settingCode);
        relationEo.setOptionCode(optionCode);
        List relationEos = this.optionSettingRelationDas.select((BaseEo)relationEo, Integer.valueOf(1), Integer.valueOf(20));
        if (CollectionUtils.isEmpty((Collection)relationEos)) {
            return new ArrayList<BundleSettingTreeRespDto>();
        }
        Set settingCodes = relationEos.stream().map(StdOptionSettingRelationEo::getDepdSettingCode).collect(Collectors.toSet());
        ArrayList settingEos = this.settingDas.getSettingByCondition(new ArrayList(settingCodes), bundleCode, version);
        if (CollectionUtils.isEmpty((Collection)settingEos)) {
            settingEos = new ArrayList();
            List settingHistoryEos = this.settingHistoryDas.getHistorySettingByCondition(new ArrayList(settingCodes), bundleCode, version);
            if (CollectionUtils.isNotEmpty((Collection)settingHistoryEos)) {
                CubeBeanUtils.copyCollection(settingEos, (Collection)settingHistoryEos, SettingEo.class);
            } else {
                return new ArrayList<BundleSettingTreeRespDto>();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(resultOptionEos = this.settingOptionDas.getOptionByCondition(new ArrayList(staticSettingCodes = (sourceTypeMapSetting = settingEos.stream().collect(Collectors.groupingBy(StdSettingEo::getOptionSourceType))).get(CubeParam.OptionSourceType.STATIC.getValue()).stream().map(StdSettingEo::getCode).collect(Collectors.toSet())), bundleCode, version)))) {
            resultOptionEos = new ArrayList();
            List optionHistoryEos = this.settingOptionHistoryDas.getHistoryOptionByCondition(new ArrayList(settingCodes), bundleCode, version);
            if (CollectionUtils.isNotEmpty((Collection)optionHistoryEos)) {
                CubeBeanUtils.copyCollection(resultOptionEos, (Collection)optionHistoryEos, SettingOptionEo.class);
            }
        }
        HashMap<String, List<SettingOptionEo>> setting2Options = new HashMap<String, List<SettingOptionEo>>();
        if (!CollectionUtils.isEmpty(resultOptionEos)) {
            setting2Options.putAll(resultOptionEos.stream().collect(Collectors.groupingBy(StdSettingOptionEo::getSettingCode)));
        }
        List<SettingEo> dynamicFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.getValue());
        Map<String, List<OptionRespDto>> dynamicOptionMap = this.optionsFromBundle(dynamicFromBundleSetting.stream().map(StdSettingEo::getCode).collect(Collectors.toList()), bundleCode, version);
        dynamicOptionMap.forEach((settingCodeResp, optionsResp) -> {
            List options = optionsResp.stream().map(e -> {
                SettingOptionEo eo = new SettingOptionEo();
                eo.setSettingCode(settingCodeResp);
                eo.setCode(e.getCode());
                eo.setOptionValue(e.getValue());
                eo.setName(e.getName());
                eo.setDescr(e.getDescr());
                return eo;
            }).collect(Collectors.toList());
            setting2Options.put((String)settingCodeResp, options);
        });
        ArrayList<BundleSettingTreeRespDto> processSettingDtos = new ArrayList<BundleSettingTreeRespDto>();
        for (SettingEo setting : settingEos) {
            List<BundleSettingTreeRespDto> respDtos = this.getBundleSettingAndOption(setting, setting2Options, true, settingCode, optionCode);
            processSettingDtos.addAll(respDtos);
        }
        Comparator<BundleSettingTreeRespDto> byParentCodeASC = Comparator.comparing(BundleSettingTreeRespDto::getParentCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<BundleSettingTreeRespDto> byCodeASC = Comparator.comparing(BundleSettingTreeRespDto::getCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<BundleSettingTreeRespDto> finalComparator = byParentCodeASC.thenComparing(byCodeASC);
        TreeBuilder<BundleSettingTreeRespDto> treeBuilder = new TreeBuilder<BundleSettingTreeRespDto>();
        return treeBuilder.buildByParentKey(processSettingDtos, false, finalComparator);
    }

    private List<BundleSettingTreeRespDto> getBundleSettingAndOption(SettingEo setting, Map<String, List<SettingOptionEo>> setting2Options, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        ArrayList<BundleSettingTreeRespDto> results = new ArrayList<BundleSettingTreeRespDto>();
        BundleSettingTreeRespDto settingDto = new BundleSettingTreeRespDto();
        DtoHelper.eo2Dto((BaseEo)setting, (BaseVo)settingDto);
        settingDto.setRemark(setting.getDescr());
        settingDto.setType(Integer.valueOf(SettingViewNodeType.SETTING.getCode()));
        if (setting.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            String settingValue = setting.getDefaultValue();
            if (StringUtils.isNotBlank((CharSequence)settingValue)) {
                TabularDto tabularDto = this.settingTabularService.getViewTabularDto(setting, settingValue);
                settingDto.setTabularViewDto(tabularDto);
                settingDto.setSettingValue(null);
            }
        } else if (setting.getEditType().equals(SettingEditType.INPUT.getCode())) {
            settingDto.setSettingValue(setting.getDefaultValue());
        } else if (setting.getEditType().equals(SettingEditType.CHOICE.getCode())) {
            List<SettingOptionEo> optionEos;
            if (setting.getValueType().equals(SettingValueType.ENUM.getCode()) || setting.getValueType().equals(SettingValueType.SPIEXTPT.getCode())) {
                settingDto.setViewVisible(setting.getViewVisible());
            }
            if (setting.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) {
                JSONObject jsonObject = JSON.parseObject((String)setting.getParameter());
                settingDto.setSendFlag(jsonObject.getInteger("sendFlag"));
            }
            if (null != setting2Options && setting2Options.size() > 0 && CollectionUtils.isNotEmpty(optionEos = setting2Options.get(setting.getCode()))) {
                ArrayList<String> selectOptions = new ArrayList<String>();
                for (SettingOptionEo option : optionEos) {
                    BundleSettingTreeRespDto optionDto = new BundleSettingTreeRespDto();
                    DtoHelper.eo2Dto((BaseEo)option, (BaseVo)optionDto);
                    optionDto.setType(Integer.valueOf(SettingViewNodeType.OPTION.getCode()));
                    optionDto.setParentCode(setting.getCode());
                    if (null != option.getIsDefault() && option.getIsDefault().equals(Constants.TRUE)) {
                        selectOptions.add(option.getCode());
                    }
                    optionDto.setRemark(option.getDescr());
                    if (this.optionSettingRelationDas.count(optionDto.getParentCode(), option.getCode()) > 0) {
                        optionDto.setWithDepdSetting(Constants.TRUE);
                    } else {
                        optionDto.setWithDepdSetting(Constants.FALSE);
                    }
                    results.add(optionDto);
                }
                settingDto.setOptionCodes(selectOptions);
            }
        }
        Integer paramSettingSubType = this.rOptionSettingService.getParamSettingSubType(setting.getCode(), needValidParam, parentSettingCode, parentOptionCode);
        settingDto.setParamSettingSubType(paramSettingSubType);
        if (paramSettingSubType.equals(Constants.FALSE)) {
            settingDto.setIsRefForOtherSetting(this.rOptionSettingService.isRefForOtherSetting(setting.getCode()));
        }
        settingDto.setParentCode(setting.getCapabilityCode());
        results.add(settingDto);
        return results;
    }

    private Map<String, List<SettingOptionEo>> getBundleSetting2Options(Set<String> bundleCodes, String version) {
        if (CollectionUtils.isEmpty(bundleCodes)) {
            return new HashMap<String, List<SettingOptionEo>>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
        SettingOptionEo optionQueryEo = new SettingOptionEo();
        optionQueryEo.setSqlFilters(sqlFilters);
        optionQueryEo.setVersion(version);
        ArrayList resultOptions = this.settingOptionDas.select((BaseEo)optionQueryEo);
        Map<Object, Object> setting2Options = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)resultOptions)) {
            setting2Options = resultOptions.stream().collect(Collectors.groupingBy(StdSettingOptionEo::getSettingCode));
        } else {
            SettingOptionHistoryEo optionHistoryQueryEo = new SettingOptionHistoryEo();
            optionHistoryQueryEo.setSqlFilters(sqlFilters);
            optionHistoryQueryEo.setVersion(version);
            List resultHistory = this.settingOptionHistoryDas.select((BaseEo)optionHistoryQueryEo);
            if (CollectionUtils.isNotEmpty((Collection)resultHistory)) {
                resultOptions = new ArrayList();
                CubeBeanUtils.copyCollection(resultOptions, (Collection)resultHistory, SettingOptionEo.class);
                setting2Options = resultOptions.stream().collect(Collectors.groupingBy(StdSettingOptionEo::getSettingCode));
            }
        }
        return setting2Options;
    }

    private List<SettingEo> getBundleSetting(Set<String> bundleCodes, String version, Map<String, List<SettingOptionEo>> setting2Options) {
        List<SettingEo> removeSettingEos;
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(bundleCodes)) {
            sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
        }
        SettingEo settingQueryEo = new SettingEo();
        settingQueryEo.setSqlFilters(sqlFilters);
        settingQueryEo.setVersion(version);
        ArrayList<SettingEo> resultSettings = this.settingDas.select((BaseEo)settingQueryEo);
        resultSettings.stream().filter(e -> CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.getValue().equals(e.getOptionSourceType())).collect(Collectors.groupingBy(StdSettingEo::getBundle)).forEach((bundleCode, settings) -> {
            SettingEo settingEo = (SettingEo)settings.get(0);
            this.optionsFromBundle(settings.stream().map(StdSettingEo::getCode).collect(Collectors.toList()), settingEo.getBundle(), settingEo.getVersion()).forEach((settingCodeResp, optionsResp) -> {
                List options = optionsResp.stream().map(e -> {
                    SettingOptionEo eo = new SettingOptionEo();
                    eo.setSettingCode(settingCodeResp);
                    eo.setCode(e.getCode());
                    eo.setOptionValue(e.getValue());
                    eo.setName(e.getName());
                    eo.setDescr(e.getDescr());
                    return eo;
                }).collect(Collectors.toList());
                setting2Options.putIfAbsent((String)settingCodeResp, options);
            });
        });
        List<Object> settingCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultSettings)) {
            settingCodes = resultSettings.stream().map(StdSettingEo::getCode).collect(Collectors.toList());
        } else {
            SettingHistoryEo settingHistoryEo = new SettingHistoryEo();
            settingHistoryEo.setSqlFilters(sqlFilters);
            settingHistoryEo.setVersion(version);
            List resultHistory = this.settingHistoryDas.select((BaseEo)settingHistoryEo);
            if (CollectionUtils.isNotEmpty((Collection)resultHistory)) {
                resultSettings = new ArrayList<SettingEo>();
                CubeBeanUtils.copyCollection(resultSettings, (Collection)resultHistory, SettingEo.class);
                settingCodes = resultSettings.stream().map(StdSettingEo::getCode).collect(Collectors.toList());
            }
        }
        ArrayList<String> settingCodesNeesSelect = new ArrayList<String>();
        if (CollectionUtils.isEmpty(settingCodes)) {
            if (null != setting2Options && setting2Options.size() > 0) {
                settingCodesNeesSelect.addAll(setting2Options.keySet());
            }
        } else {
            for (String settingCode : setting2Options.keySet()) {
                if (settingCodes.contains(settingCode)) continue;
                settingCodesNeesSelect.add(settingCode);
            }
        }
        if (CollectionUtils.isNotEmpty(settingCodesNeesSelect)) {
            List settingEos = this.settingDas.selectByCodeList(settingCodesNeesSelect, null);
            resultSettings.addAll(settingEos);
        }
        if (CollectionUtils.isNotEmpty(resultSettings) && CollectionUtils.isNotEmpty(removeSettingEos = this.rOptionSettingService.getRemoveParamSetting(resultSettings))) {
            resultSettings.removeAll(removeSettingEos);
        }
        return resultSettings;
    }

    private List<CapabilityEo> getBundleCapability(Set<String> bundleCodes, List<SettingEo> settingEos) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(bundleCodes)) {
            sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
        }
        CapabilityEo queryCapabilityEo = new CapabilityEo();
        queryCapabilityEo.setSqlFilters(sqlFilters);
        List resultCaps = this.capabilityDas.select((BaseEo)queryCapabilityEo);
        ArrayList<String> capabilityCodeNeedSelect = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultCaps)) {
            List capabilityCodes = resultCaps.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
            for (SettingEo setting : settingEos) {
                if (!StringUtils.isNotBlank((CharSequence)setting.getCapabilityCode()) || capabilityCodes.contains(setting.getCapabilityCode())) continue;
                capabilityCodeNeedSelect.add(setting.getCapabilityCode());
            }
        } else {
            capabilityCodeNeedSelect = settingEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getCapabilityCode())).map(StdSettingEo::getCapabilityCode).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(capabilityCodeNeedSelect)) {
            List<CapabilityEo> parent = this.capabilityService.getCapabilityAndParentByCodes(capabilityCodeNeedSelect);
            resultCaps.addAll(parent);
        }
        return resultCaps;
    }

    private List<BundleSettingTreeRespDto> getProcessTreeDtos(List<CapabilityEo> capabilityEos, List<SettingEo> settingEos, Map<String, List<SettingOptionEo>> setting2Options, String firstCapabilityCode) {
        Map<String, List<CapabilityEo>> parentCode2Caps;
        List<CapabilityEo> childrenCap;
        ArrayList<Object> processTreeDtos = new ArrayList<BundleSettingTreeRespDto>();
        Comparator<BundleSettingTreeRespDto> byParentCodeASC = Comparator.comparing(BundleSettingTreeRespDto::getParentCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<BundleSettingTreeRespDto> byCodeASC = Comparator.comparing(BundleSettingTreeRespDto::getCode, String.CASE_INSENSITIVE_ORDER);
        Comparator<BundleSettingTreeRespDto> finalComparator = byParentCodeASC.thenComparing(byCodeASC);
        List firstCapabilitys = capabilityEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getParentCode()) && eo.getParentCode().equals("ROOT_NODE")).map(eo -> {
            BundleSettingTreeRespDto bundleSettingTreeRespDto = new BundleSettingTreeRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)bundleSettingTreeRespDto);
            bundleSettingTreeRespDto.setParentCode(eo.getDomain());
            bundleSettingTreeRespDto.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
            return bundleSettingTreeRespDto;
        }).sorted(finalComparator).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(firstCapabilitys)) {
            return processTreeDtos;
        }
        processTreeDtos = new ArrayList(firstCapabilitys);
        if (StringUtils.isBlank((CharSequence)firstCapabilityCode)) {
            firstCapabilityCode = ((BundleSettingTreeRespDto)firstCapabilitys.get(0)).getCode();
        }
        if (CollectionUtils.isNotEmpty(childrenCap = (parentCode2Caps = capabilityEos.stream().collect(Collectors.groupingBy(StdCapabilityEo::getParentCode))).get(firstCapabilityCode))) {
            ArrayList<String> capCodeWithSetting = new ArrayList<String>();
            List childrenCapDtos = childrenCap.stream().map(eo -> {
                BundleSettingTreeRespDto bundleSettingTreeRespDto = new BundleSettingTreeRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)bundleSettingTreeRespDto);
                bundleSettingTreeRespDto.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
                capCodeWithSetting.add(eo.getCode());
                return bundleSettingTreeRespDto;
            }).collect(Collectors.toList());
            processTreeDtos.addAll(childrenCapDtos);
            List<BundleSettingTreeRespDto> processSettingDtos = this.getProcessSettingDtos(capCodeWithSetting, settingEos, setting2Options);
            if (CollectionUtils.isNotEmpty(processSettingDtos)) {
                processTreeDtos.addAll(processSettingDtos);
            }
        }
        return processTreeDtos;
    }

    private List<BundleSettingTreeRespDto> getProcessSettingDtos(List<String> capCodeWithSetting, List<SettingEo> settingEos, Map<String, List<SettingOptionEo>> setting2Options) {
        ArrayList<BundleSettingTreeRespDto> processSettingDtos = new ArrayList<BundleSettingTreeRespDto>();
        for (SettingEo setting : settingEos) {
            if (!capCodeWithSetting.contains(setting.getCapabilityCode())) continue;
            List<BundleSettingTreeRespDto> respDtos = this.getBundleSettingAndOption(setting, setting2Options, false, null, null);
            processSettingDtos.addAll(respDtos);
        }
        return processSettingDtos;
    }

    private void processOptionsImport(String groupId, String artifactId, String version, String dbBundleVersion, String bundleCode, List<SettingOptionImportDto> options) {
        Map<String, List<SettingOptionImportDto>> setting2OptionsMap;
        SettingOptionEo queryEo = new SettingOptionEo();
        queryEo.setBundle(bundleCode);
        List dbOptions = this.settingOptionDas.select((BaseEo)queryEo);
        Map<Object, Object> setting2OptionDbMap = new HashMap();
        if (CollectionUtils.isNotEmpty(options)) {
            if (dbBundleVersion != null && !dbBundleVersion.equals(version) && CollectionUtils.isNotEmpty((Collection)dbOptions)) {
                this.backupSettingOption(bundleCode, version, dbOptions);
            } else {
                this.settingOptionDas.logicDelete(bundleCode);
                if (CollectionUtils.isNotEmpty((Collection)dbOptions)) {
                    dbOptions.clear();
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)dbOptions)) {
                setting2OptionDbMap = dbOptions.stream().collect(Collectors.toMap(item -> item.getSettingCode() + item.getCode(), Function.identity(), (k1, k2) -> k1));
            }
        }
        if (null != (setting2OptionsMap = options.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSettingCode())).collect(Collectors.groupingBy(SettingOptionImportDto::getSettingCode))) && setting2OptionsMap.size() > 0) {
            List settingEos = this.settingDas.selectByCodeList(new ArrayList<String>(setting2OptionsMap.keySet()), null);
            Map<Object, Object> code2SettingEoMap = new HashMap();
            Map capabilityCode2ViewIdMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)settingEos)) {
                code2SettingEoMap = settingEos.stream().collect(Collectors.toMap(StdSettingEo::getCode, Function.identity(), (k1, k2) -> k1));
                List capabilityCodes = settingEos.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCapabilityCode())).map(StdSettingEo::getCapabilityCode).collect(Collectors.toList());
                capabilityCode2ViewIdMap = this.viewCapabilityRelationDas.getCapabilityCode2Value(capabilityCodes);
            }
            ArrayList<SettingOptionEo> processedEos = new ArrayList<SettingOptionEo>();
            ArrayList<String> deleteCodes = new ArrayList<String>();
            ArrayList<String> deleteOptionCodes = new ArrayList<String>();
            for (String settingCode : setting2OptionsMap.keySet()) {
                SettingEo settingEo = (SettingEo)code2SettingEoMap.get(settingCode);
                List<SettingOptionImportDto> setting2Options = setting2OptionsMap.get(settingCode);
                Long viewId = null;
                if (null != settingEo && StringUtils.isNotBlank((CharSequence)settingEo.getCapabilityCode()) && null != capabilityCode2ViewIdMap && capabilityCode2ViewIdMap.size() > 0) {
                    viewId = (Long)capabilityCode2ViewIdMap.get(settingEo.getCapabilityCode());
                }
                ArrayList<SettingOptionEo> insertEos = new ArrayList<SettingOptionEo>();
                for (SettingOptionImportDto option : setting2Options) {
                    SettingOptionEo dbOption;
                    SettingOptionEo settingOptionEo = new SettingOptionEo();
                    DtoHelper.dto2Eo((BaseVo)option, (BaseEo)settingOptionEo, (String[])new String[]{"createTime", "updateTime"});
                    settingOptionEo.setSettingCode(settingCode);
                    settingOptionEo.setGroupId(groupId);
                    settingOptionEo.setArtifactId(artifactId);
                    settingOptionEo.setVersion(version);
                    settingOptionEo.setBundle(bundleCode);
                    if (StringUtils.isBlank((CharSequence)settingOptionEo.getCode())) {
                        settingOptionEo.setCode(option.getOptionValue());
                    }
                    if (StringUtils.isBlank((CharSequence)option.getExtension())) {
                        settingOptionEo.setExtension("");
                    }
                    if (null == (dbOption = (SettingOptionEo)setting2OptionDbMap.get(settingCode + option.getCode()))) {
                        insertEos.add(settingOptionEo);
                    } else {
                        settingOptionEo.setId(dbOption.getId());
                        this.settingOptionDas.updateSelective((BaseEo)settingOptionEo);
                        processedEos.add(dbOption);
                    }
                    deleteCodes.add(settingCode);
                    deleteOptionCodes.add(settingOptionEo.getCode());
                }
                if (!CollectionUtils.isNotEmpty(insertEos)) continue;
                this.settingOptionDas.insertBatch(insertEos);
                if (null == viewId) continue;
                this.processGlobalOptionValue(settingEo, insertEos);
            }
            if (CollectionUtils.isNotEmpty(processedEos)) {
                dbOptions.removeAll(processedEos);
                for (SettingOptionEo settingOption : dbOptions) {
                    this.settingOptionDas.logicDelete((BaseEo)settingOption);
                }
            }
            this.deleteSettingOptionByCodes(deleteCodes, deleteOptionCodes, bundleCode);
        }
    }

    private void deleteSettingOptionByCodes(List<String> codes, List<String> optionCodes, String bundleCode) {
        if (CollectionUtils.isEmpty(codes) || CollectionUtils.isEmpty(optionCodes)) {
            return;
        }
        SettingOptionEo querySettingOptionEo = new SettingOptionEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join(codes, (String)",")));
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(optionCodes, (String)",")));
        querySettingOptionEo.setSqlFilters(sqlFilters);
        List settingOptionEoList = this.settingOptionDas.select((BaseEo)querySettingOptionEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isNotEmpty((Collection)settingOptionEoList)) {
            settingOptionEoList.forEach(settingOptionEo -> {
                if (settingOptionEo.getBundle() == null || !bundleCode.equals(settingOptionEo.getBundle())) {
                    this.settingOptionDas.logicDelete((BaseEo)settingOptionEo);
                }
            });
        }
    }

    private void importDepdSetting(List<BundleSettingRespDto.DepdSetting> depdSettings) {
        StringBuilder removeSettingCodes = new StringBuilder();
        StringBuilder removeOptionCodes = new StringBuilder();
        ArrayList<OptionSettingRelationEo> insertRelationEos = new ArrayList<OptionSettingRelationEo>();
        HashSet<String> settingOptionSet = new HashSet<String>();
        for (BundleSettingRespDto.DepdSetting depdSetting : depdSettings) {
            String settingOption = depdSetting.getSettingCode() + depdSetting.getOptionCode();
            if (settingOptionSet.contains(settingOption)) continue;
            settingOptionSet.add(settingOption);
            removeSettingCodes.append(depdSetting.getSettingCode()).append(",");
            removeOptionCodes.append(depdSetting.getOptionCode()).append(",");
            HashSet<String> depdSettingCodeSet = new HashSet<String>();
            for (String depdSettingCode : depdSetting.getDepdSettingCode()) {
                if (depdSettingCodeSet.contains(depdSettingCode)) continue;
                depdSettingCodeSet.add(depdSettingCode);
                OptionSettingRelationEo insertEo = new OptionSettingRelationEo();
                CubeBeanUtils.copyProperties((Object)insertEo, (Object)depdSetting, (String[])new String[0]);
                insertEo.setExtension("");
                insertEo.setDepdSettingCode(depdSettingCode);
                insertRelationEos.add(insertEo);
            }
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (removeSettingCodes.length() > 1) {
            sqlFilters.add(SqlFilter.in((String)"setting_code", (Object)removeSettingCodes.substring(0, removeSettingCodes.lastIndexOf(","))));
        }
        if (removeOptionCodes.length() > 1) {
            sqlFilters.add(SqlFilter.in((String)"option_code", (Object)removeOptionCodes.substring(0, removeOptionCodes.lastIndexOf(","))));
        }
        OptionSettingRelationEo removeEo = new OptionSettingRelationEo();
        removeEo.setSqlFilters(sqlFilters);
        this.optionSettingRelationDas.logicDelete((BaseEo)removeEo);
        if (CollectionUtils.isNotEmpty(insertRelationEos)) {
            this.optionSettingRelationDas.insertBatch(insertRelationEos);
        }
    }

    private void processGlobalOptionValue(SettingEo settingEo, List<SettingOptionEo> optionEos) {
        ArrayList<SettingValueEo> settingValueEos = new ArrayList<SettingValueEo>();
        for (SettingOptionEo option : optionEos) {
            Boolean existValue;
            Boolean result;
            if (option.getIsDefault().equals(Constants.FALSE) || (result = this.settingValueService.isExsitChoiceValue(settingEo.getCode(), option.getCode())).booleanValue() || settingEo.getIsMultiChoice().equals(Constants.FALSE) && (existValue = this.settingValueService.isExsitChoiceValue(settingEo.getCode(), null)).booleanValue()) continue;
            SettingValueEo settingValueEo = new SettingValueEo();
            settingValueEo.setSettingCode(settingEo.getCode());
            settingValueEo.setOptionCode(option.getCode());
            settingValueEo.setSettingValue(option.getOptionValue());
            settingValueEo.setIsControlled(settingEo.getIsControlled());
            settingValueEo.setExtension("");
            settingValueEo.setTenantId(Long.valueOf(1L));
            settingValueEos.add(settingValueEo);
        }
        this.settingValueService.createSettingValue(settingValueEos);
    }

    private void processGlobalInputSettingValue(String settingCode, String defaultValue, Integer isControlled) {
        SettingValueEo settingValueEo = new SettingValueEo();
        settingValueEo.setSettingCode(settingCode);
        settingValueEo.setSettingValue(defaultValue);
        settingValueEo.setIsControlled(isControlled);
        settingValueEo.setTenantId(Long.valueOf(1L));
        settingValueEo.setExtension("");
        ArrayList<SettingValueEo> settingValueEos = new ArrayList<SettingValueEo>();
        settingValueEos.add(settingValueEo);
        this.settingValueService.createSettingValue(settingValueEos);
    }

    private Long validSettingBeforeImport(SettingEo settingEo) {
        Integer editType = settingEo.getEditType();
        this.validSettingByEditType(editType, settingEo, new ArrayList<SettingOptionReqDto>(), false);
        Long viewId = null;
        if (StringUtils.isNotBlank((CharSequence)settingEo.getCapabilityCode())) {
            Iterator iterator;
            ArrayList<String> capabilityCodes = new ArrayList<String>();
            capabilityCodes.add(settingEo.getCapabilityCode());
            Set viewIdSet = this.viewCapabilityRelationDas.getViewIdByCapabilityCodes(capabilityCodes);
            if (CollectionUtils.isNotEmpty((Collection)viewIdSet) && (iterator = viewIdSet.iterator()).hasNext()) {
                Long view;
                viewId = view = (Long)iterator.next();
            }
        }
        if (null != viewId) {
            boolean op = false;
            if (editType.equals(SettingEditType.INPUT.getCode())) {
                op = true;
            } else if (settingEo.getValueType() != null && settingEo.getValueType().equals(SettingValueType.TABULAR.getCode())) {
                op = true;
            }
            if (op) {
                SettingValueEo queryEo = new SettingValueEo();
                queryEo.setSettingCode(settingEo.getCode());
                if (this.settingValueDas.count((BaseEo)queryEo) == 0) {
                    this.processGlobalInputSettingValue(settingEo.getCode(), settingEo.getDefaultValue(), settingEo.getIsControlled());
                }
            }
        }
        return viewId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validSettingByEditType(Integer editType, SettingEo settingEo, List<SettingOptionReqDto> options, boolean isValidOption) {
        if (editType == null) throw new BizException("\u503c\u7f16\u8f91\u7c7b\u578b\u53ea\u80fd\u662f\u8f93\u5165\u3001\u9009\u62e9");
        if (editType.equals(SettingEditType.INPUT.getCode())) {
            this.validateInputSettingField(settingEo, options, isValidOption);
            return;
        } else {
            if (!editType.equals(SettingEditType.CHOICE.getCode())) throw new BizException("\u503c\u7f16\u8f91\u7c7b\u578b\u53ea\u80fd\u662f\u8f93\u5165\u3001\u9009\u62e9");
            this.validateChoiceSettingField(settingEo, options, isValidOption);
        }
    }

    private void validateParamSettingField(SettingEo settingEo, List<SettingOptionReqDto> options, TabularDto tabularViewDto, Boolean isCreateSettingMethod) {
        String settingCode = settingEo.getCode();
        String settingName = settingEo.getName();
        if (isCreateSettingMethod.booleanValue()) {
            SettingEo settingCodeEo = new SettingEo();
            settingCodeEo.setCode(settingCode);
            Assert.isTrue((this.settingDas.count((BaseEo)settingCodeEo) == 0 ? 1 : 0) != 0, (String)"\u914d\u7f6e\u9879\u7f16\u7801\u91cd\u590d,\u8bf7\u91cd\u8f93");
            SettingEo settingNameEo = new SettingEo();
            settingNameEo.setName(settingName);
            Assert.isTrue((this.settingDas.count((BaseEo)settingNameEo) == 0 ? 1 : 0) != 0, (String)"\u914d\u7f6e\u9879\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
        } else if (StringUtils.isNotBlank((CharSequence)settingName)) {
            SettingEo queryNameEo = new SettingEo();
            queryNameEo.setName(settingName);
            List settingEos = this.settingDas.select((BaseEo)queryNameEo);
            if (CollectionUtils.isNotEmpty((Collection)settingEos)) {
                Assert.isTrue((settingEos.size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u822c\u671f\u5f85\u6570\u636e\u53ea\u6709\u4e00\u6761");
                if (!((SettingEo)settingEos.get(0)).getCode().equals(settingCode)) {
                    throw new BizException("\u914d\u7f6e\u9879\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
                }
            }
        }
        Integer editType = settingEo.getEditType();
        this.validSettingByEditType(editType, settingEo, options, true);
        if (StringUtils.isNotBlank((CharSequence)settingEo.getBundle())) {
            Assert.isTrue((null != this.bundleDas.selectByCode(settingEo.getBundle()) ? 1 : 0) != 0, (String)"\u529f\u80fd\u5305\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)settingEo.getCapabilityCode())) {
            CapabilitySimpleRespDto capabilitySimpleRespDto = this.capabilityService.queryByCode(settingEo.getCapabilityCode());
            Assert.isTrue((null != capabilitySimpleRespDto ? 1 : 0) != 0, (String)"\u80fd\u529b\u4e0d\u5b58\u5728");
        }
        if (settingEo.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            this.checkTabularValues(tabularViewDto);
        }
    }

    private void validateInputSettingField(SettingEo settingEo, List<SettingOptionReqDto> options, boolean isValidOption) {
        Integer valueType;
        if (isValidOption) {
            Assert.isTrue((boolean)CollectionUtils.isEmpty(options), (String)"\u503c\u7f16\u8f91\u7c7b\u578b\u4e3a\u8f93\u5165\u65e0\u5019\u9009\u9879");
        }
        if ((valueType = settingEo.getValueType()) != null) {
            String defaultValue = settingEo.getDefaultValue();
            SettingValueType valueTypeEnum = SettingValueType.fromCode((int)valueType);
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                switch (valueTypeEnum) {
                    case STRING: 
                    case TABULAR: {
                        break;
                    }
                    case INTEGER: {
                        AssertUtil.isTrue(SettingServiceImpl.isInteger(defaultValue), "\u9ed8\u8ba4\u503c\u5e94\u4e3a\u6574\u578b\u7c7b\u578b");
                        break;
                    }
                    case NUMBERIC: {
                        AssertUtil.isTrue(SettingServiceImpl.isDECIMAL(defaultValue), "\u9ed8\u8ba4\u503c\u5e94\u4e3a\u6570\u503c\u7c7b\u578b");
                        break;
                    }
                    case DATE: {
                        AssertUtil.isTrue(null != DateUtil.parse((String)defaultValue, (String)"yyyy-MM-dd HH:mm:ss"), "\u9ed8\u8ba4\u503c\u5e94\u4e3a\u65e5\u671f\u7c7b\u578b");
                        break;
                    }
                    case TIME_SLOT: {
                        AssertUtil.isTrue(SettingServiceImpl.isTimeSlot(defaultValue), "\u9ed8\u8ba4\u503c\u5e94\u4e3a\u65f6\u95f4\u6bb5\u7c7b\u578bHH:mm-HH:mm\uff0c\u598222:00-08:00");
                        break;
                    }
                    default: {
                        throw new BizException("\u503c\u7f16\u8f91\u7c7b\u578b\u4e3a\u8f93\u5165\u65f6\uff0c\u5bf9\u5e94\u503c\u7c7b\u578b\u53ea\u80fd\u662f\u6574\u578b\u3001\u6570\u503c\u3001\u65e5\u671f\u3001\u5b57\u7b26\u4e32\u3001\u65f6\u95f4\u6bb5");
                    }
                }
            }
            if (valueType.equals(SettingValueType.DATE.getCode()) || valueType.equals(SettingValueType.STRING.getCode())) {
                Assert.isTrue((boolean)StringUtils.isBlank((CharSequence)settingEo.getValueScope()), (String)"\u503c\u7f16\u8f91\u7c7b\u578b\u4e3a\u8f93\u5165\u4e14\u503c\u7c7b\u578b\u4e3a\u65e5\u671f\u3001\u65f6\u95f4\u6bb5\u6216\u5b57\u7b26\u4e32\u65f6\uff0c\u4e0d\u5b58\u5728\u6709\u6548\u533a\u95f4");
            }
            if (StringUtils.isNotBlank((CharSequence)settingEo.getValueScope()) && StringUtils.isNotBlank((CharSequence)settingEo.getDefaultValue())) {
                Assert.isTrue((boolean)IntervalUtil.isInTheInterval(settingEo.getDefaultValue(), settingEo.getValueScope()), (String)"\u914d\u7f6e\u503c\u4e0d\u5728\u9ed8\u8ba4\u533a\u95f4\u5185\uff0c\u8bf7\u91cd\u8f93");
            }
        }
    }

    private void validateChoiceSettingField(SettingEo settingEo, List<SettingOptionReqDto> options, boolean isValidOption) {
        Integer valueType;
        if (isValidOption) {
            if (settingEo.getValueType().equals(SettingValueType.TABULAR.getCode())) {
                Assert.isTrue((boolean)CollectionUtils.isEmpty(options), (String)"\u503c\u7f16\u8f91\u7c7b\u578b\u4e3a\u9009\u62e9\u4e14\u503c\u7c7b\u578b\u4e3a\u8868\u683c\u7684\u65e0\u5019\u9009\u9879");
            } else {
                Assert.isTrue((!CollectionUtils.isEmpty(options) ? 1 : 0) != 0, (String)"\u503c\u7f16\u8f91\u7c7b\u578b\u4e3a\u9009\u62e9\u6709\u5019\u9009\u9879");
            }
            for (SettingOptionReqDto option : options) {
                String optionCode = option.getCode();
                String optionValue = option.getOptionValue();
                if (StringUtils.isNotBlank((CharSequence)optionCode) && optionCode.length() > Constants.OPTION_VALUE_LENGTH) {
                    throw new BizException("\u5b58\u50a8\u503c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7512\u4e2a\u5b57\u7b26");
                }
                if (!StringUtils.isNotBlank((CharSequence)optionValue) || optionValue.length() <= Constants.OPTION_VALUE_LENGTH) continue;
                throw new BizException("\u5b58\u50a8\u503c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7512\u4e2a\u5b57\u7b26");
            }
            Set optionValueSet = options.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOptionValue())).map(SettingOptionBaseDto::getOptionValue).collect(Collectors.toSet());
            Set optionNameSet = options.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getName())).map(SettingOptionBaseDto::getName).collect(Collectors.toSet());
            if (optionValueSet.size() != options.size() || optionNameSet.size() != options.size()) {
                throw new BizException("\u5019\u9009\u9879\u7684\u663e\u793a\u503c\u3001\u5b58\u50a8\u503c\u5728\u914d\u7f6e\u9879\u4e0b\u5fc5\u987b\u552f\u4e00");
            }
        }
        if ((valueType = settingEo.getValueType()) != null) {
            SettingValueType valueTypeEnum = SettingValueType.fromCode((int)valueType);
            Assert.isTrue((null != valueTypeEnum ? 1 : 0) != 0, (String)"\u914d\u7f6e\u9879\u503c\u7c7b\u578b\u9519\u8bef");
            switch (valueTypeEnum) {
                case TABULAR: 
                case BOOLEAN: 
                case ENUM: 
                case SPIEXTPT: 
                case DOMAINEVENT_EXTPT: {
                    break;
                }
                default: {
                    throw new BizException("\u503c\u7f16\u8f91\u7c7b\u578b\u4e3a\u9009\u62e9\u65f6\uff0c\u5bf9\u5e94\u503c\u7c7b\u578b\u53ea\u80fd\u662f\u5e03\u5c14\u3001\u679a\u4e3e\u3001SPI\u6269\u5c55\u70b9\u3001\u9886\u57df\u4e8b\u4ef6\u6269\u5c55\u70b9");
                }
            }
        }
    }

    private static boolean isInteger(String str) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)str), "\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        Pattern pattern = Pattern.compile("^[-+]?[0-9][\\d]*$");
        return pattern.matcher(str).matches();
    }

    private static boolean isDECIMAL(String str) {
        return StringUtils.isNumeric((CharSequence)str) || NumberUtils.isNumber((String)str);
    }

    private static boolean isTimeSlot(String str) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)str), "\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        Pattern pattern = Pattern.compile("((0\\d{1}|1\\d{1}|2[0-3]):([0-5]\\d{1})-(0\\d{1}|1\\d{1}|2[0-3]):([0-5]\\d{1}))");
        return pattern.matcher(str).matches();
    }

    private Map<String, BundleEo> getBundle(List<String> bundleCodes) {
        HashMap<String, BundleEo> bundleCodeMap = new HashMap<String, BundleEo>();
        if (CollectionUtils.isNotEmpty(bundleCodes)) {
            ArrayList<SqlFilter> bundleFilters = new ArrayList<SqlFilter>();
            bundleFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(bundleCodes, (String)",")));
            BundleEo queryBundleEo = new BundleEo();
            queryBundleEo.setSqlFilters(bundleFilters);
            List resultBundles = this.bundleDas.select((BaseEo)queryBundleEo);
            for (BundleEo bundleEo : resultBundles) {
                bundleCodeMap.put(bundleEo.getCode(), bundleEo);
            }
        }
        return bundleCodeMap;
    }

    private void processSettingOption(SettingEo settingEo, List<SettingOptionReqDto> options, Boolean isCreateSettingMethod, Long viewId) {
        if (CollectionUtils.isEmpty(options)) {
            if (!isCreateSettingMethod.booleanValue()) {
                this.validAndDeleteOption(settingEo.getCode());
            }
        } else {
            List<SettingOptionEo> updateParamEos;
            ArrayList<SettingOptionEo> resultEos = new ArrayList<SettingOptionEo>();
            for (SettingOptionReqDto option : options) {
                SettingOptionEo settingOptionEo = new SettingOptionEo();
                DtoHelper.dto2Eo((BaseVo)option, (BaseEo)settingOptionEo, (String[])new String[]{"createTime", "updateTime"});
                if (settingEo.getValueType().equals(SettingValueType.BOOLEAN.getCode())) {
                    if (StringUtils.isBlank((CharSequence)option.getBundleCode())) {
                        option.setBundleCode(settingEo.getBundle());
                    } else if (!option.getBundleCode().equals(settingEo.getBundle())) {
                        throw new BizException("\u503c\u7c7b\u578b\u4e3a\u5e03\u5c14\u7684\u5019\u9009\u9879\u6765\u6e90\u529f\u80fd\u5305\u5fc5\u987b\u548c\u5176\u914d\u7f6e\u9879\u4e00\u81f4");
                    }
                }
                settingOptionEo.setSettingCode(settingEo.getCode());
                settingOptionEo.setBundle(option.getBundleCode());
                if (StringUtils.isBlank((CharSequence)option.getCode())) {
                    settingOptionEo.setCode(option.getOptionValue());
                }
                if (StringUtils.isBlank((CharSequence)option.getExtension())) {
                    settingOptionEo.setExtension("");
                }
                resultEos.add(settingOptionEo);
            }
            List<Object> dbOptions = new ArrayList<SettingOptionEo>();
            if (!isCreateSettingMethod.booleanValue()) {
                dbOptions = this.settingOptionDas.selectBySettingCode(settingEo.getCode());
            }
            if (CollectionUtils.isNotEmpty(updateParamEos = this.getUpdateOptionByDb(dbOptions, resultEos))) {
                resultEos.removeAll(updateParamEos);
            }
            if (CollectionUtils.isNotEmpty(resultEos)) {
                this.settingOptionDas.insertBatch(resultEos);
                if (viewId != null) {
                    this.processGlobalOptionValue(settingEo, resultEos);
                }
            }
        }
    }

    private void validAndDeleteOption(String settingCode) {
        Set<String> optionCodes = this.settingValueService.getOptionCodeListBySettingInValue(settingCode);
        Assert.isTrue((boolean)CollectionUtils.isEmpty(optionCodes), (String)"\u8be5\u914d\u7f6e\u9879\u9009\u9879\u5df2\u88ab\u8bbe\u7f6e\u503c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        SettingOptionEo removeSettingOptionEo = new SettingOptionEo();
        removeSettingOptionEo.setSettingCode(settingCode);
        this.settingOptionDas.delete((BaseEo)removeSettingOptionEo);
    }

    private List<SettingOptionEo> getUpdateOptionByDb(List<SettingOptionEo> dbOptions, List<SettingOptionEo> paramOptions) {
        ArrayList<SettingOptionEo> updateParamEos = new ArrayList<SettingOptionEo>();
        if (!CollectionUtils.isEmpty(dbOptions)) {
            Map paramOptionMap = paramOptions.stream().collect(Collectors.toMap(StdSettingOptionEo::getCode, Function.identity()));
            for (SettingOptionEo dbEo : dbOptions) {
                String dbCode = dbEo.getCode();
                SettingOptionEo paramOption = (SettingOptionEo)paramOptionMap.get(dbCode);
                if (paramOption != null) {
                    Assert.isTrue((!this.settingValueService.validateSettingWithValue(dbEo.getSettingCode(), dbEo.getCode(), paramOption.getOptionValue()) ? 1 : 0) != 0, (String)"\u8be5\u914d\u7f6e\u9879\u9009\u9879\u5df2\u88ab\u8bbe\u7f6e\u503c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
                    SettingOptionEo updateEo = (SettingOptionEo)paramOptionMap.get(dbCode);
                    updateEo.setId(dbEo.getId());
                    this.settingOptionDas.updateSelective((BaseEo)updateEo);
                    updateParamEos.add(updateEo);
                    continue;
                }
                Assert.isTrue((!this.settingValueService.validateSettingWithValue(dbEo.getSettingCode(), dbEo.getCode(), null) ? 1 : 0) != 0, (String)"\u8be5\u914d\u7f6e\u9879\u9009\u9879\u5df2\u88ab\u8bbe\u7f6e\u503c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                this.settingOptionDas.delete((BaseEo)dbEo);
            }
        }
        return updateParamEos;
    }

    private void checkTabularValues(TabularDto tabularViewDto) {
        List headerList = tabularViewDto.getHeaders();
        HashSet<String> headerCodeSet = new HashSet<String>();
        HashSet<String> headerNameSet = new HashSet<String>();
        for (TabularDto.Header header : headerList) {
            if (StringUtils.isNotBlank((CharSequence)header.getRemark())) {
                Assert.isTrue((header.getRemark().length() <= 200 ? 1 : 0) != 0, (String)"\u5217\u7b80\u4ecb\u957f\u5ea6\u4e3a200\uff0c\u8bf7\u91cd\u8f93");
            }
            headerCodeSet.add(header.getCode());
            headerNameSet.add(header.getName());
        }
        Assert.isTrue((headerCodeSet.size() == headerList.size() ? 1 : 0) != 0, (String)"\u5217\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        Assert.isTrue((headerNameSet.size() == headerList.size() ? 1 : 0) != 0, (String)"\u5217\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
    }

    @Override
    public Map<String, List<OptionRespDto>> optionsFromBundle(List<String> settingCodes, String bundleCode, String bundleVersion) {
        AppBundleRespDto appBundleRespDto = this.appBundleService.queryByBundleCodeAndVersion(bundleCode, bundleVersion);
        List<AppStartedRecordRespDto> appStartedRecordEoList = this.appStartedRecordService.queryByAppCodeAndVersion(appBundleRespDto.getCode(), appBundleRespDto.getVersion());
        Collection resultAppStartedRecordDtos = appStartedRecordEoList.stream().filter(r -> AppStartedPullStatus.DONE.name().equals(r.getStatus())).collect(Collectors.toMap(dto -> dto.getIp() + "_" + dto.getPort(), Function.identity(), (k1, k2) -> k1)).values();
        OptionQueryReqDto optionQueryReqDto = new OptionQueryReqDto();
        optionQueryReqDto.setSettingCodes(new ArrayList());
        for (int i = 0; i < settingCodes.size(); ++i) {
            optionQueryReqDto.getSettingCodes().add(settingCodes.get(i));
        }
        for (AppStartedRecordRespDto appStartedRecordEo : resultAppStartedRecordDtos) {
            if (appStartedRecordEo.getIp().contains("/")) {
                appStartedRecordEo.setIp(appStartedRecordEo.getIp().split("/")[1]);
            }
            logger.info("\u67e5\u8be2\u529f\u80fd\u5305\u914d\u7f6e\u9879\u9009\u9879\u8bf7\u6c42\u5730\u5740\u4fe1\u606f\uff0cAppStartedRecordRespDto={}", (Object)JacksonUtil.toJson((Object)appStartedRecordEo));
            try {
                FeignClientApiCaller feignClientApiCaller;
                RestResponse result;
                String ip = appStartedRecordEo.getIp();
                if (ip.indexOf("/") != -1) {
                    ip = ip.split("/")[1];
                }
                if (null == (result = (RestResponse)(feignClientApiCaller = new FeignClientApiCaller()).process(rawBundleSettingApi -> rawBundleSettingApi.bundleSettingOptions(optionQueryReqDto), ip, appStartedRecordEo.getPort().intValue(), IRawBundleSettingApi.class, (NotifierFeignClientConfig)this.feignClientConfig, (RequestInterceptor)new RawFeignClientContextFilter())) || !"0".equals(result.getResultCode())) continue;
                return (Map)result.getData();
            }
            catch (Exception e) {
                logger.error("\u4ece\u5e94\u7528\u83b7\u53d6\u52a8\u6001\u914d\u7f6e\u9879\u51fa\u9519", (Throwable)e);
            }
        }
        return Maps.newHashMap();
    }
}

