/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.param.CubeParam;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.DEParameterChangedDto;
import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.OptionSourceType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingDisplayLevel;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingEditType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingValueType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingViewNodeType;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.OptionDepdSettingDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingOptionDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingValueDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingValueQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingViewQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SettingViewReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ViewBindSettingDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ViewDescReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ViewNodeQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ViewSettingDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ViewSettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingValueTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SettingViewRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ViewDescRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ViewSettingTreeDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityDomainService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IROptionSettingService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingTabularService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingValueService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingViewService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IUserTenantService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.TreeBuilder;
import com.dtyunxi.yundt.cube.center.func.biz.util.IntervalUtil;
import com.dtyunxi.yundt.cube.center.func.biz.vo.OptionValueVo;
import com.dtyunxi.yundt.cube.center.func.biz.vo.ValueCapabilityVo;
import com.dtyunxi.yundt.cube.center.func.biz.vo.ValueChoiceSettingVo;
import com.dtyunxi.yundt.cube.center.func.biz.vo.ValueInputSettingVo;
import com.dtyunxi.yundt.cube.center.func.biz.vo.ViewCapabilityVo;
import com.dtyunxi.yundt.cube.center.func.biz.vo.ViewDescCapVo;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.OptionSettingRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingViewDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ViewCapabilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.OptionSettingRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingViewEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdDomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdOptionSettingRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ViewCapabilityRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SettingViewServiceImpl
implements ISettingViewService {
    private static final Logger logger = LoggerFactory.getLogger(SettingViewServiceImpl.class);
    private static final String NULL_VALUE = "NULL_VALUE";
    @Resource
    private SettingViewDas settingViewDas;
    @Resource
    private ICapabilityDomainService capabilityDomainService;
    @Resource
    private ICapabilityService capabilityService;
    @Resource
    private ISettingService settingService;
    @Resource
    private IBundleService bundleService;
    @Resource
    private ISettingValueService settingValueService;
    @Resource
    private IUserTenantService userTenantService;
    @Resource
    private SettingValueDas settingValueDas;
    @Resource
    private SettingOptionDas settingOptionDas;
    @Resource
    private SettingDas settingDas;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private OptionSettingRelationDas optionSettingRelationDas;
    @Resource
    private IROptionSettingService rOptionSettingService;
    @Resource
    private ISettingTabularService settingTabularService;
    @Resource
    private ViewCapabilityRelationDas viewCapabilityRelationDas;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createSettingView(SettingViewReqDto createReqDto) {
        this.validateSettingViewParam(createReqDto.getCode(), createReqDto.getName(), null, true);
        SettingViewEo settingViewEo = new SettingViewEo();
        DtoHelper.dto2Eo((BaseVo)createReqDto, (BaseEo)settingViewEo);
        this.settingViewDas.insert((BaseEo)settingViewEo);
        return settingViewEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifySettingView(SettingViewReqDto modifyReqDto) {
        this.validateSettingViewParam(null, modifyReqDto.getName(), modifyReqDto.getId(), false);
        SettingViewEo settingViewEo = new SettingViewEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)settingViewEo, (String[])new String[]{"code"});
        this.settingViewDas.updateSelective((BaseEo)settingViewEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSettingView(Long id) {
        this.settingViewDas.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String setSettingInView(ViewBindSettingDto viewBindSettingDto) {
        List<SettingEo> settingEosByCapability;
        String resultString = "\u4fdd\u5b58\u6210\u529f";
        List<String> bundleCodes = this.bundleService.getEnableBundleCodes(Constants.ENABLE);
        Long viewId = viewBindSettingDto.getViewId();
        Assert.isTrue((null != viewId ? 1 : 0) != 0, (String)"\u89c6\u56feID\u4e0d\u80fd\u4e3anull");
        List viewSettingDtos = viewBindSettingDto.getViewSettingDtos();
        List<ViewSettingDto> resultDtos = this.getNodeInTree(viewSettingDtos);
        Map<Integer, List<ViewSettingDto>> type2Dtos = resultDtos.stream().collect(Collectors.groupingBy(ViewSettingDto::getType));
        List<ViewSettingDto> capabilityDtos = type2Dtos.get(SettingViewNodeType.CAPABILITY.getCode());
        if (CollectionUtils.isEmpty(capabilityDtos)) {
            throw new BizException("\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u624d\u80fd\u4fdd\u5b58");
        }
        ArrayList<DomainEo> domainEos = new ArrayList<DomainEo>();
        List<ViewSettingDto> domainDtos = type2Dtos.get(SettingViewNodeType.DOMAIN.getCode());
        DtoHelper.dtoList2EoList(domainDtos, domainEos, DomainEo.class);
        this.capabilityDomainService.updateDomainSort(domainEos);
        Map<String, Integer> capabilityCode2Sort = capabilityDtos.stream().collect(Collectors.toMap(ViewSettingDto::getCode, ViewSettingDto::getSort, (k1, k2) -> k1));
        ArrayList<String> capabilityCodes = new ArrayList<String>(capabilityCode2Sort.keySet());
        List<CapabilityEo> validateEos = this.capabilityService.getCapabilityByCodes(capabilityCodes);
        if (CollectionUtils.isEmpty(validateEos)) {
            throw new BizException("\u4fdd\u5b58\u5931\u8d25\uff0c\u9009\u62e9\u7684\u80fd\u529b\u6216\u914d\u7f6e\u9879\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u77e5\u6089");
        }
        if (validateEos.size() != capabilityCodes.size()) {
            resultString = "\u4fdd\u5b58\u6210\u529f\uff0c\u90e8\u5206\u88ab\u5220\u9664\u7684\u80fd\u529b\u6216\u914d\u7f6e\u9879\u672a\u4fdd\u5b58\uff0c\u8bf7\u77e5\u6089";
        }
        List<CapabilityEo> childrenCapability = this.capabilityService.getChildrenEoByCapabilityCodeList(capabilityCodes);
        ArrayList<CapabilityEo> capabilityEos = new ArrayList<CapabilityEo>();
        ArrayList<ViewCapabilityRelationEo> viewCapabilityRelationEos = new ArrayList<ViewCapabilityRelationEo>();
        for (CapabilityEo capabilityEo : validateEos) {
            capabilityEo.setSort(capabilityCode2Sort.get(capabilityEo.getCode()));
            viewCapabilityRelationEos.add(this.toViewCapabilityRelationEo(viewId, capabilityEo.getCode()));
            capabilityEos.add(capabilityEo);
        }
        for (CapabilityEo child : childrenCapability) {
            if (capabilityCodes.contains(child.getCode())) continue;
            viewCapabilityRelationEos.add(this.toViewCapabilityRelationEo(viewId, child.getCode()));
            capabilityEos.add(child);
            capabilityCodes.add(child.getCode());
        }
        Assert.isTrue((!this.capabilityService.validateViewCancelTenantCapability(viewId, capabilityCodes) ? 1 : 0) != 0, (String)"\u5f53\u524d\u914d\u7f6e\u89c6\u56fe\u5173\u8054\u7684\u529f\u80fd\u5305\u5df2\u88ab\u79df\u6237\u5f00\u901a\uff0c\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u9886\u57df/\u80fd\u529b");
        this.capabilityService.updateCapabilityEos(capabilityEos);
        this.viewCapabilityRelationDas.insertBatch(viewCapabilityRelationEos);
        List<ViewSettingDto> settingDtos = type2Dtos.get(SettingViewNodeType.SETTING.getCode());
        if (!CollectionUtils.isEmpty(settingDtos)) {
            Map<String, Integer> settingCode2Sort = settingDtos.stream().collect(Collectors.toMap(ViewSettingDto::getCode, ViewSettingDto::getSort, (k1, k2) -> k1));
            List<SettingEo> settingEos = this.settingService.getSettingEoByCodes(new ArrayList<String>(settingCode2Sort.keySet()));
            for (SettingEo settingEo : settingEos) {
                settingEo.setSort(settingCode2Sort.get(settingEo.getCode()));
            }
            this.settingService.updateSettingEos(settingEos);
        }
        if (CollectionUtils.isEmpty(settingEosByCapability = this.settingService.getSettingByCondition(bundleCodes, capabilityCodes, Constants.TRUE))) {
            return resultString;
        }
        List<String> settingCodes = settingEosByCapability.stream().map(StdSettingEo::getCode).collect(Collectors.toList());
        List<SettingOptionEo> settingOptionEos = this.settingService.getSettingOptionBySetting(settingCodes, null);
        Long tenantId = this.userTenantService.getCurrentTenantId();
        this.settingValueService.setSettingValue(settingEosByCapability, settingOptionEos, tenantId);
        return resultString;
    }

    private ViewCapabilityRelationEo toViewCapabilityRelationEo(Long viewId, String capabilityCode) {
        ViewCapabilityRelationEo viewCapabilityRelationEo = new ViewCapabilityRelationEo();
        viewCapabilityRelationEo.setCapabilityCode(capabilityCode);
        viewCapabilityRelationEo.setViewId(viewId);
        viewCapabilityRelationEo.setExtension("");
        return viewCapabilityRelationEo;
    }

    private List<ViewSettingDto> getNodeInTree(List<ViewSettingDto> viewSettingDtos) {
        ArrayList<ViewSettingDto> results = new ArrayList<ViewSettingDto>();
        if (!CollectionUtils.isEmpty(viewSettingDtos)) {
            results.addAll(viewSettingDtos);
            for (ViewSettingDto dto : viewSettingDtos) {
                results.addAll(this.getNodeInTree(dto.getChildren()));
            }
        }
        return results;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setSettingValueInView(SettingValueReqDto settingValueReqDto) {
        String bizSpaceCode = settingValueReqDto.getBizSpaceCode();
        String bizIdCode = settingValueReqDto.getBizIdCode();
        Long currentTenantId = this.userTenantService.getCurrentTenantId();
        List settingValueDtos = settingValueReqDto.getSettingValueDtos();
        List<String> settingCodes = settingValueDtos.stream().map(SettingValueDto::getCode).collect(Collectors.toList());
        List<SettingValueEo> settingValueEos = this.settingValueService.getSettingValueByCondition(settingCodes, currentTenantId, bizSpaceCode, bizIdCode);
        Map<String, List<SettingValueEo>> settingValueMap = settingValueEos.stream().collect(Collectors.groupingBy(StdSettingValueEo::getSettingCode));
        List<SettingValueEo> parentValues = this.getParentLevelValue(bizSpaceCode, bizIdCode, currentTenantId, settingCodes);
        Map<String, List<SettingValueEo>> parentValueMap = parentValues.stream().collect(Collectors.groupingBy(StdSettingValueEo::getSettingCode));
        HashMap<String, List<String>> settingCode2Value = new HashMap<String, List<String>>(settingValueDtos.size());
        ArrayList<SettingValueEo> insertEos = new ArrayList<SettingValueEo>();
        ArrayList<SettingValueEo> removeEos = new ArrayList<SettingValueEo>();
        Map<String, SettingValueDto> settingCode2Dto = settingValueDtos.stream().collect(Collectors.toMap(SettingValueDto::getCode, Function.identity(), (k1, k2) -> k1));
        for (SettingValueDto dto : settingValueDtos) {
            List<SettingValueEo> dbValues = settingValueMap.get(dto.getCode());
            Long globalTenantId = this.userTenantService.getGlobalTenantId();
            if (null != dto.getIsControlled()) {
                SettingValueEo eo;
                if (!currentTenantId.equals(globalTenantId) && null != parentValueMap.get(dto.getCode()) && (eo = parentValueMap.get(dto.getCode()).get(0)) != null && null != eo.getIsControlled() && eo.getIsControlled().equals(Constants.FALSE)) {
                    throw new BizException("\u53c2\u6570\u9519\u8bef");
                }
                if (dto.getIsControlled().equals(Constants.FALSE)) {
                    Assert.isTrue((!this.settingValueService.validateIsCtrlWithChildValue(dto.getCode(), currentTenantId, bizSpaceCode, bizIdCode) ? 1 : 0) != 0, (String)"\u4e0b\u7ea7\u6709\u503c\uff0c\u4e0d\u80fd\u5173\u95ed");
                }
            }
            this.validValueParamDuplicated(dto.getEditType(), dto, dbValues, settingCode2Value);
            if (dto.getEditType().equals(SettingEditType.INPUT.getCode())) {
                this.setInputSettingValue(dto, dbValues, bizSpaceCode, bizIdCode, currentTenantId, insertEos, removeEos, settingCode2Dto);
                continue;
            }
            if (!dto.getEditType().equals(SettingEditType.CHOICE.getCode())) continue;
            this.setChoiceSettingValue(dto, dbValues, bizSpaceCode, bizIdCode, currentTenantId, insertEos, removeEos, settingCode2Dto);
        }
        this.settingValueService.createSettingValue(insertEos);
        this.settingValueService.removeSettingValue(removeEos);
        this.updateSendFlag(settingValueDtos);
        this.sendFlagChangedMq(settingValueDtos);
    }

    @Override
    public void updateSendFlag(List<SettingValueDto> settingValueDtos) {
        if (CollectionUtils.isEmpty(settingValueDtos)) {
            return;
        }
        settingValueDtos.forEach(dto -> {
            if (dto.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) {
                this.settingService.updateSendFlag(dto.getCode(), dto.getSendFlag());
            }
        });
    }

    @Override
    public void sendFlagChangedMq(List<SettingValueDto> settingValueDtos) {
        if (CollectionUtils.isEmpty(settingValueDtos)) {
            return;
        }
        List<String> settingCodes = settingValueDtos.stream().map(SettingValueDto::getCode).collect(Collectors.toList());
        List<SettingEo> settingEos = this.settingService.getSettingEoByCodes(settingCodes);
        DEParameterChangedDto domainEventSendFlagChangedDto = new DEParameterChangedDto();
        HashMap map = new HashMap();
        settingValueDtos.forEach(dto -> {
            SettingEo settingEo;
            if (dto.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode()) && null != (settingEo = (SettingEo)settingEos.stream().filter(eo -> eo.getCode().equals(dto.getCode())).findFirst().orElse(null))) {
                DEParameterChangedDto.DomainEventParameter parameter = (DEParameterChangedDto.DomainEventParameter)JSON.parseObject((String)settingEo.getParameter(), DEParameterChangedDto.DomainEventParameter.class);
                map.put(settingEo.getCode(), parameter);
            }
        });
        domainEventSendFlagChangedDto.setDomainEventParameterMap(map);
        if (map.size() > 0) {
            this.commonsMqService.publishMessageAsync("${dtyunxi.bundle.mq.domain_event_send_flag.topic:DOMAIN_EVENT_SEND_FLAG_TOPIC}", "DOMAIN_EVENT_SEND_FLAG_TAG", (Object)domainEventSendFlagChangedDto);
        }
    }

    private void setInputSettingValue(SettingValueDto settingValueDto, List<SettingValueEo> dbValues, String bizSpaceCode, String bizIdCode, Long currentTenantId, List<SettingValueEo> insertEos, List<SettingValueEo> removeEos, Map<String, SettingValueDto> settingCode2Dto) {
        if (settingValueDto.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            settingValueDto.setSettingValue(JSONObject.toJSONString((Object)settingValueDto.getTabularViewDto()));
        }
        if (StringUtils.isBlank((CharSequence)settingValueDto.getSettingValue()) && !CollectionUtils.isEmpty(dbValues)) {
            removeEos.addAll(dbValues);
        } else {
            if (!settingValueDto.getValueType().equals(SettingValueType.SPIEXTPT.getCode()) && !settingValueDto.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) {
                settingValueDto.setIsControlled(this.getParamSettingIsCtrl(settingValueDto.getIsControlled(), settingValueDto.getCode(), settingCode2Dto));
            }
            if (!CollectionUtils.isEmpty(dbValues)) {
                SettingValueEo updateEo = dbValues.get(0);
                Assert.isTrue((boolean)this.validateInputSettingValueScope(updateEo.getSettingCode(), settingValueDto.getSettingValue()), (String)"\u914d\u7f6e\u503c\u4e0d\u5728\u9ed8\u8ba4\u533a\u95f4\u5185\uff0c\u8bf7\u91cd\u8f93");
                updateEo.setSettingValue(settingValueDto.getSettingValue());
                updateEo.setIsControlled(settingValueDto.getIsControlled());
                this.settingValueService.updateSettingValue(updateEo);
            } else {
                SettingValueEo insertEo = new SettingValueEo();
                Assert.isTrue((boolean)this.validateInputSettingValueScope(settingValueDto.getCode(), settingValueDto.getSettingValue()), (String)"\u914d\u7f6e\u503c\u4e0d\u5728\u9ed8\u8ba4\u533a\u95f4\u5185\uff0c\u8bf7\u91cd\u8f93");
                insertEo.setSettingCode(settingValueDto.getCode());
                insertEo.setSettingValue(settingValueDto.getSettingValue());
                insertEo.setBizSpaceCode(bizSpaceCode);
                insertEo.setBizId(bizIdCode);
                insertEo.setTenantId(currentTenantId);
                insertEo.setExtension("");
                insertEo.setIsControlled(settingValueDto.getIsControlled());
                insertEos.add(insertEo);
            }
        }
    }

    private void setChoiceSettingValue(SettingValueDto settingValueDto, List<SettingValueEo> dbValues, String bizSpaceCode, String bizIdCode, Long currentTenantId, List<SettingValueEo> insertEos, List<SettingValueEo> removeEos, Map<String, SettingValueDto> settingCode2Dto) {
        SettingEo exitedSettingEo = this.settingDas.selectByCode(settingValueDto.getCode());
        ArrayList<String> processedOptionCodes = new ArrayList<String>();
        List<Object> dbOptionCodes = new ArrayList();
        if (dbValues != null) {
            dbOptionCodes = dbValues.stream().map(StdSettingValueEo::getOptionCode).collect(Collectors.toList());
        }
        List paramOptionCodes = settingValueDto.getOptionCodes();
        if (settingValueDto.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            TabularDto tabularViewDto = settingValueDto.getTabularViewDto();
            List list = tabularViewDto.getRows();
            ArrayList updateRows = new ArrayList();
            for (Object viewRow : list) {
                JSONObject j = (JSONObject)JSONObject.toJSON(viewRow);
                Integer isSelected = (Integer)j.get((Object)"isSelected");
                if (!isSelected.equals(Constants.TRUE)) continue;
                updateRows.add(viewRow);
            }
            tabularViewDto.setRows(updateRows);
            SettingValueEo tabularValueEo = new SettingValueEo();
            tabularValueEo.setSettingValue(JSONObject.toJSONString((Object)tabularViewDto));
            tabularValueEo.setSettingCode(settingValueDto.getCode());
            tabularValueEo.setBizSpaceCode(bizSpaceCode);
            tabularValueEo.setBizId(bizIdCode);
            tabularValueEo.setIsControlled(settingValueDto.getIsControlled());
            tabularValueEo.setDisplayLevel(Integer.valueOf(SettingDisplayLevel.BIZID.getCode()));
            tabularValueEo.setExtension("");
            if (CollectionUtils.isEmpty(dbValues)) {
                insertEos.add(tabularValueEo);
            } else {
                tabularValueEo.setId(dbValues.get(0).getId());
                this.settingValueService.updateSettingValue(tabularValueEo);
            }
        } else if (CollectionUtils.isEmpty((Collection)settingValueDto.getOptionCodes()) && !CollectionUtils.isEmpty(dbValues)) {
            removeEos.addAll(dbValues);
        } else {
            if (!settingValueDto.getValueType().equals(SettingValueType.SPIEXTPT.getCode()) && !settingValueDto.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) {
                settingValueDto.setIsControlled(this.getParamSettingIsCtrl(settingValueDto.getIsControlled(), settingValueDto.getCode(), settingCode2Dto));
            }
            if (settingValueDto.getValueType().equals(SettingValueType.SPIEXTPT.getCode()) || settingValueDto.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) {
                this.rOptionSettingService.selectAndUpdateParamSettingIsCtrl(settingValueDto.getCode(), settingValueDto.getIsControlled(), currentTenantId, bizSpaceCode, bizIdCode);
            }
            for (String string : paramOptionCodes) {
                if (!CollectionUtils.isEmpty(dbOptionCodes) && dbOptionCodes.contains(string)) {
                    if (!CollectionUtils.isEmpty(dbValues)) {
                        for (SettingValueEo updateEo : dbValues) {
                            updateEo.setIsControlled(settingValueDto.getIsControlled());
                            this.settingValueService.updateSettingValue(updateEo);
                        }
                    }
                    processedOptionCodes.add(string);
                    continue;
                }
                SettingValueEo insertEo = new SettingValueEo();
                insertEo.setSettingCode(settingValueDto.getCode());
                insertEo.setOptionCode(string);
                if (StringUtils.isNotBlank((CharSequence)settingValueDto.getSettingValue())) {
                    insertEo.setSettingValue(settingValueDto.getSettingValue());
                } else if (exitedSettingEo.getOptionSourceType() != null && exitedSettingEo.getOptionSourceType().compareTo(OptionSourceType.DYNAMIC_FROM_APP.getValue()) == 0) {
                    insertEo.setSettingValue(this.readSettingOptionValue(string, settingValueDto.getChildren()));
                } else {
                    SettingOptionEo settingOptionEo = new SettingOptionEo();
                    settingOptionEo.setSettingCode(settingValueDto.getCode());
                    settingOptionEo.setCode(string);
                    List settingOptionEos = this.settingOptionDas.select((BaseEo)settingOptionEo, Integer.valueOf(0), Integer.valueOf(1));
                    if (CollectionUtils.isEmpty((Collection)settingOptionEos)) {
                        logger.warn("\u8b66\u544a!\u5f53\u524d\u9009\u9879\u4e0d\u5b58\u5728:\u914d\u7f6e\u9879\u7f16\u7801:{},\u914d\u7f6e\u9009\u9879\u7f16\u7801: {}", (Object)settingValueDto.getCode(), (Object)string);
                        continue;
                    }
                    insertEo.setSettingValue(((SettingOptionEo)settingOptionEos.get(0)).getOptionValue());
                }
                insertEo.setExtension("");
                insertEo.setIsControlled(settingValueDto.getIsControlled());
                insertEo.setBizSpaceCode(bizSpaceCode);
                insertEo.setBizId(bizIdCode);
                insertEos.add(insertEo);
                processedOptionCodes.add(string);
            }
            if (!CollectionUtils.isEmpty(dbOptionCodes)) {
                dbOptionCodes.removeAll(processedOptionCodes);
                for (String string : dbOptionCodes) {
                    SettingValueEo removeEo = new SettingValueEo();
                    removeEo.setSettingCode(settingValueDto.getCode());
                    removeEo.setOptionCode(string);
                    removeEo.setTenantId(currentTenantId);
                    removeEo.setBizSpaceCode(bizSpaceCode);
                    removeEo.setBizId(bizIdCode);
                    removeEos.add(removeEo);
                }
            }
        }
    }

    private String readSettingOptionValue(String optionCode, List<SettingOptionDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.stream().filter(item -> item.getCode().equals(optionCode)).findFirst().get().getSettingValue();
    }

    private Integer getParamSettingIsCtrl(Integer reqParamIsCtrl, String settingCode, Map<String, SettingValueDto> settingCode2Dto) {
        OptionSettingRelationEo queryEo = new OptionSettingRelationEo();
        queryEo.setDepdSettingCode(settingCode);
        List relationEos = this.optionSettingRelationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(2));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relationEos) && relationEos.size() == 1) {
            OptionSettingRelationEo parentSettingByRelation = (OptionSettingRelationEo)relationEos.get(0);
            String parentSettingCode = parentSettingByRelation.getSettingCode();
            if (null != settingCode2Dto.get(parentSettingCode)) {
                reqParamIsCtrl = settingCode2Dto.get(parentSettingCode).getIsControlled();
            } else {
                SettingValueEo settingValueEo = new SettingValueEo();
                settingValueEo.setSettingCode(parentSettingCode);
                List parentValueEos = this.settingValueDas.select((BaseEo)settingValueEo, Integer.valueOf(1), Integer.valueOf(1));
                if (CollectionUtils.isEmpty((Collection)parentValueEos)) {
                    SettingEo settingEo = new SettingEo();
                    settingEo.setCode(parentSettingCode);
                    List parentSettingEos = this.settingDas.select((BaseEo)settingEo, Integer.valueOf(1), Integer.valueOf(1));
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)parentSettingEos)) {
                        reqParamIsCtrl = ((SettingEo)parentSettingEos.get(0)).getIsControlled();
                    }
                } else {
                    reqParamIsCtrl = ((SettingValueEo)parentValueEos.get(0)).getIsControlled();
                }
            }
        }
        return reqParamIsCtrl;
    }

    private void validValueParamDuplicated(Integer type, SettingValueDto settingValueDto, List<SettingValueEo> dbValues, Map<String, List<String>> settingCode2Value) {
        if (StringUtils.isBlank((CharSequence)settingValueDto.getSettingValue()) && !CollectionUtils.isEmpty(dbValues)) {
            List<String> settingValue = settingCode2Value.get(settingValueDto.getCode());
            if (CollectionUtils.isEmpty(settingValue)) {
                settingValue = new ArrayList<String>();
                settingValue.add(NULL_VALUE);
                settingCode2Value.put(settingValueDto.getCode(), settingValue);
            } else if (!settingValue.contains(NULL_VALUE)) {
                throw new BizException("10002", "\u8bf7\u6c42\u53c2\u6570\u76f8\u540c\u914d\u7f6e\u9879\u7f16\u7801\u7684\u914d\u7f6e\u503c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a\u503c");
            }
        } else if (type.equals(SettingEditType.INPUT.getCode())) {
            List<String> settingValue = settingCode2Value.get(settingValueDto.getCode());
            if (CollectionUtils.isEmpty(settingValue)) {
                settingValue = new ArrayList<String>();
                if (StringUtils.isBlank((CharSequence)settingValueDto.getSettingValue())) {
                    settingValue.add(NULL_VALUE);
                } else {
                    settingValue.add(settingValueDto.getSettingValue());
                }
                settingCode2Value.put(settingValueDto.getCode(), settingValue);
            } else if (StringUtils.isBlank((CharSequence)settingValueDto.getSettingValue()) ? !settingValue.contains(NULL_VALUE) : !settingValue.contains(settingValueDto.getSettingValue())) {
                throw new BizException("10002", "\u8bf7\u6c42\u53c2\u6570\u76f8\u540c\u914d\u7f6e\u9879\u7f16\u7801\u7684\u914d\u7f6e\u503c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a\u503c");
            }
        } else if (type.equals(SettingEditType.CHOICE.getCode())) {
            List paramOptionCodes = settingValueDto.getOptionCodes();
            List<String> settingValue = settingCode2Value.get(settingValueDto.getCode());
            if (CollectionUtils.isEmpty(settingValue)) {
                settingValue = new ArrayList<String>();
                if (CollectionUtils.isEmpty((Collection)paramOptionCodes)) {
                    settingValue.add(NULL_VALUE);
                } else {
                    settingValue.addAll(paramOptionCodes);
                }
                settingCode2Value.put(settingValueDto.getCode(), settingValue);
            } else if (CollectionUtils.isEmpty((Collection)paramOptionCodes) ? !settingValue.contains(NULL_VALUE) : !settingValue.containsAll(paramOptionCodes)) {
                throw new BizException("10002", "\u8bf7\u6c42\u53c2\u6570\u76f8\u540c\u914d\u7f6e\u9879\u7f16\u7801\u7684\u914d\u7f6e\u503c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a\u503c");
            }
        }
    }

    @Override
    public PageInfo<ViewSettingTreeDto> queryViewSettingTree(ViewSettingQueryReqDto viewSettingQueryReqDto) {
        Integer withAllChildren = viewSettingQueryReqDto.getWithAllChildren();
        List<Object> processCapabilityTreeDtos = new ArrayList();
        List<String> bundleCodes = this.bundleService.getEnableBundleCodes(Constants.ENABLE);
        if (StringUtils.isNotBlank((CharSequence)viewSettingQueryReqDto.getName())) {
            processCapabilityTreeDtos = this.getSettingViewTreeNodeByName(viewSettingQueryReqDto.getName(), bundleCodes);
        } else {
            List<Object> capabilityEos = new ArrayList();
            capabilityEos = withAllChildren == null || withAllChildren.equals(Constants.FALSE) ? this.capabilityService.getCapabilityByCondition(bundleCodes, "ROOT_NODE") : this.capabilityService.getCapabilityByCondition(bundleCodes, null);
            if (CollectionUtils.isEmpty(capabilityEos)) {
                return new PageInfo();
            }
            ViewCapabilityVo viewCapabilityVo = this.getCapability(capabilityEos, viewSettingQueryReqDto.getViewId());
            List<String> domainCodes = viewCapabilityVo.getDomainCodes();
            List<String> capabilityCodes = viewCapabilityVo.getCapabilityCodes();
            List<ViewSettingTreeDto> capabilitys = viewCapabilityVo.getCapabilitys();
            processCapabilityTreeDtos.addAll(capabilitys);
            if (withAllChildren != null && withAllChildren.equals(Constants.TRUE)) {
                List<SettingEo> settingEos = this.settingService.getSettingByCondition(bundleCodes, capabilityCodes, Constants.TRUE);
                for (SettingEo settingEo : settingEos) {
                    ViewSettingTreeDto setting = new ViewSettingTreeDto();
                    DtoHelper.eo2Dto((BaseEo)settingEo, (BaseVo)setting);
                    setting.setRemark(settingEo.getDescr());
                    setting.setType(Integer.valueOf(SettingViewNodeType.SETTING.getCode()));
                    setting.setParentCode(settingEo.getCapabilityCode());
                    processCapabilityTreeDtos.add(setting);
                }
            }
            ArrayList<ViewSettingTreeDto> domains = new ArrayList<ViewSettingTreeDto>();
            List<DomainEo> domainEos = this.capabilityDomainService.getDomainByCodes(domainCodes);
            for (DomainEo domainEo : domainEos) {
                ViewSettingTreeDto domain = new ViewSettingTreeDto();
                DtoHelper.eo2Dto((BaseEo)domainEo, (BaseVo)domain);
                domain.setType(Integer.valueOf(SettingViewNodeType.DOMAIN.getCode()));
                domain.setParentCode("ROOT_NODE");
                domains.add(domain);
            }
            processCapabilityTreeDtos.addAll(domains);
        }
        TreeBuilder<ViewSettingTreeDto> treeBuilder = new TreeBuilder<ViewSettingTreeDto>();
        List<ViewSettingTreeDto> viewSettingTreeDtos = treeBuilder.buildByParentKey(processCapabilityTreeDtos, false, this.getViewSettingTreeDtoComparator());
        return new PageInfo(viewSettingTreeDtos);
    }

    private ViewCapabilityVo getCapability(List<CapabilityEo> capabilityEos, Long viewId) {
        ViewCapabilityVo viewCapabilityVo = new ViewCapabilityVo();
        Set relationCapabilityCodes = this.viewCapabilityRelationDas.getCapabilityCodesByViewId(viewId);
        HashSet domainCodes = new HashSet();
        ArrayList<String> capabilityCodes = new ArrayList<String>();
        List<ViewSettingTreeDto> capabilitys = capabilityEos.stream().map(eo -> {
            domainCodes.add(eo.getDomain());
            capabilityCodes.add(eo.getCode());
            ViewSettingTreeDto capability = new ViewSettingTreeDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)capability);
            capability.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
            capability.setRemark(eo.getDescr());
            if (relationCapabilityCodes.contains(eo.getCode())) {
                capability.setIsSelected(Constants.TRUE);
            } else {
                capability.setIsSelected(Constants.FALSE);
            }
            capability.setDisabled(Constants.FALSE);
            if (eo.getParentCode().equals("ROOT_NODE")) {
                capability.setParentCode(eo.getDomain());
            }
            return capability;
        }).collect(Collectors.toList());
        viewCapabilityVo.setCapabilityCodes(capabilityCodes);
        viewCapabilityVo.setDomainCodes(new ArrayList<String>(domainCodes));
        viewCapabilityVo.setCapabilitys(capabilitys);
        return viewCapabilityVo;
    }

    private List<ViewSettingTreeDto> getSettingViewTreeNodeByName(String name, List<String> bundleCodes) {
        ArrayList<ViewSettingTreeDto> resultDtos = new ArrayList<ViewSettingTreeDto>();
        List<CapabilityEo> capabilityEos = this.capabilityService.getCapabilityByName(name, bundleCodes);
        List<SettingEo> settingEos = this.settingService.getSettingByName(name, bundleCodes);
        List<DomainEo> domainEos = this.capabilityDomainService.getDomains(null, name);
        ArrayList<String> parentCapabilityCodes = new ArrayList<String>();
        ArrayList<String> domainCodes = new ArrayList<String>();
        for (CapabilityEo capabilityEo : capabilityEos) {
            parentCapabilityCodes.add(capabilityEo.getParentCode());
            domainCodes.add(capabilityEo.getDomain());
        }
        List settingCapabilityCodes = settingEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getCapabilityCode())).map(StdSettingEo::getCapabilityCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(settingCapabilityCodes)) {
            parentCapabilityCodes.addAll(settingCapabilityCodes);
        }
        List<CapabilityEo> parentCapabilityEos = this.capabilityService.getCapabilityAndParentByCodes(parentCapabilityCodes);
        capabilityEos.addAll(parentCapabilityEos);
        ArrayList<Object> setting = new ArrayList<Object>();
        for (SettingEo settingEo : settingEos) {
            ViewSettingTreeDto viewSettingTreeDto = new ViewSettingTreeDto();
            viewSettingTreeDto.setCode(settingEo.getCode());
            viewSettingTreeDto.setParentCode(settingEo.getCapabilityCode());
            viewSettingTreeDto.setType(Integer.valueOf(SettingViewNodeType.SETTING.getCode()));
            viewSettingTreeDto.setName(settingEo.getName());
            setting.add(viewSettingTreeDto);
        }
        ArrayList<ViewSettingTreeDto> capability = new ArrayList<ViewSettingTreeDto>();
        HashSet<String> capabilityCodeSet = new HashSet<String>();
        for (CapabilityEo capabilityEo : capabilityEos) {
            if (capabilityCodeSet.contains(capabilityEo.getCode())) continue;
            ViewSettingTreeDto viewSettingTreeDto = new ViewSettingTreeDto();
            viewSettingTreeDto.setCode(capabilityEo.getCode());
            viewSettingTreeDto.setParentCode(capabilityEo.getParentCode());
            if (capabilityEo.getParentCode().equals("ROOT_NODE")) {
                viewSettingTreeDto.setParentCode(capabilityEo.getDomain());
            }
            viewSettingTreeDto.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
            viewSettingTreeDto.setName(capabilityEo.getName());
            capability.add(viewSettingTreeDto);
            capabilityCodeSet.add(capabilityEo.getCode());
        }
        List<DomainEo> capabilityDomain = this.capabilityDomainService.getDomainByCodes(domainCodes);
        domainEos.addAll(capabilityDomain);
        ArrayList<ViewSettingTreeDto> domain = new ArrayList<ViewSettingTreeDto>();
        HashSet<String> domainSet = new HashSet<String>();
        for (DomainEo domainEo : domainEos) {
            if (domainSet.contains(domainEo.getCode())) continue;
            ViewSettingTreeDto viewSettingTreeDto = new ViewSettingTreeDto();
            viewSettingTreeDto.setCode(domainEo.getCode());
            viewSettingTreeDto.setParentCode("ROOT_NODE");
            viewSettingTreeDto.setType(Integer.valueOf(SettingViewNodeType.DOMAIN.getCode()));
            viewSettingTreeDto.setName(domainEo.getName());
            viewSettingTreeDto.setSort(domainEo.getSort());
            domain.add(viewSettingTreeDto);
            domainSet.add(domainEo.getCode());
        }
        resultDtos.addAll(domain);
        resultDtos.addAll(capability);
        resultDtos.addAll(setting);
        return resultDtos;
    }

    @Override
    public PageInfo<SettingValueTreeRespDto> querySettingValueTree(SettingValueQueryReqDto settingValueQueryReqDto) {
        Long currentTenantId = this.userTenantService.getCurrentTenantId();
        Long globalTenantId = this.userTenantService.getGlobalTenantId();
        String bizSpaceCode = settingValueQueryReqDto.getBizSpaceCode();
        String bizIdCode = settingValueQueryReqDto.getBizIdCode();
        Long viewId = settingValueQueryReqDto.getViewId();
        String firstCapabilityCode = settingValueQueryReqDto.getFirstCapabilityCode();
        if (null == currentTenantId && null == globalTenantId) {
            return new PageInfo();
        }
        List<String> bundleCodes = this.getBundleCodes(globalTenantId, currentTenantId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bundleCodes)) {
            return new PageInfo();
        }
        ValueCapabilityVo valueCapabilityVo = this.getCapability(viewId, firstCapabilityCode, bundleCodes);
        if (valueCapabilityVo == null) {
            return new PageInfo();
        }
        Set<String> capabilityCodes = valueCapabilityVo.getCapabilityCodes();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(capabilityCodes)) {
            return new PageInfo();
        }
        List<SettingValueTreeRespDto> settingValueTreeRespDtos = new ArrayList<SettingValueTreeRespDto>(valueCapabilityVo.getCapabilityDtos());
        List<SettingEo> settingEos = this.getSettingEos(capabilityCodes, currentTenantId, globalTenantId, bizSpaceCode, bizIdCode);
        if (!CollectionUtils.isEmpty(settingEos)) {
            List<SettingValueTreeRespDto> settingDtos;
            List<SettingEo> dynamicFromBundleSetting;
            Map<Integer, List<SettingEo>> sourceTypeMapSetting = settingEos.stream().collect(Collectors.groupingBy(StdSettingEo::getOptionSourceType));
            HashMap settingCode2OptionDtos = Maps.newHashMap();
            List<SettingEo> staticFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.STATIC.getValue());
            Set<Object> settingCodes = Sets.newHashSet();
            if (!CollectionUtils.isEmpty(staticFromBundleSetting)) {
                settingCodes = staticFromBundleSetting.stream().map(StdSettingEo::getCode).collect(Collectors.toSet());
                settingCode2OptionDtos.putAll(this.getSetting2OptionDtos(settingCodes));
            }
            if (!CollectionUtils.isEmpty(dynamicFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.getValue()))) {
                Map<String, List<SettingValueTreeRespDto>> dynamicSettingOptions = this.getSetting2OptionFromBundle(dynamicFromBundleSetting);
                settingCode2OptionDtos.putAll(dynamicSettingOptions);
            }
            if (!CollectionUtils.isEmpty(settingDtos = this.getTreeSettingDtos(currentTenantId, globalTenantId, bizSpaceCode, bizIdCode, settingCodes, settingEos, settingCode2OptionDtos, false, null, null))) {
                settingValueTreeRespDtos.addAll(settingDtos);
            }
        }
        TreeBuilder<SettingValueTreeRespDto> treeBuilder = new TreeBuilder<SettingValueTreeRespDto>();
        settingValueTreeRespDtos = treeBuilder.buildByParentKey(settingValueTreeRespDtos, false, this.getSettingValueTreeRespDtoComparator());
        return new PageInfo(settingValueTreeRespDtos);
    }

    private List<String> getBundleCodes(Long globalTenantId, Long currentTenantId) {
        if (null != globalTenantId && globalTenantId.equals(currentTenantId)) {
            return this.bundleService.getEnableBundleCodes(Constants.ENABLE);
        }
        if (null != currentTenantId) {
            return this.bundleService.getTenantEnableBundleCodes(currentTenantId);
        }
        return null;
    }

    private List<SettingEo> getSettingEos(Set<String> capabilityCodes, Long currentTenantId, Long globalTenantId, String bizSpaceCode, String bizIdCode) {
        SettingEo settingQueryEo = new SettingEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"capability_code", (Object)StringUtils.join(capabilityCodes, (String)",")));
        settingQueryEo.setSqlFilters(filters);
        settingQueryEo.setViewVisible(Constants.TRUE);
        List<Object> settingEos = this.settingDas.select((BaseEo)settingQueryEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)settingEos)) {
            Map code2SettingEo = settingEos.stream().collect(Collectors.toMap(StdSettingEo::getCode, Function.identity(), (k1, k2) -> k1));
            List<SettingEo> removeSettingEos = this.rOptionSettingService.getRemoveParamSetting(settingEos = new ArrayList<SettingEo>(code2SettingEo.values()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(removeSettingEos)) {
                settingEos.removeAll(removeSettingEos);
            }
            if (!(null != currentTenantId && currentTenantId.equals(globalTenantId) && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode))) {
                settingEos = settingEos.stream().filter(eo -> !eo.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())).collect(Collectors.toList());
            }
        }
        return settingEos;
    }

    private Map<String, List<SettingValueTreeRespDto>> getSetting2OptionDtos(Set<String> settingCodes) {
        if (CollectionUtils.isEmpty(settingCodes)) {
            return new HashMap<String, List<SettingValueTreeRespDto>>();
        }
        SettingOptionEo optionQueryEo = new SettingOptionEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters = new ArrayList();
        filters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join(settingCodes, (String)",")));
        optionQueryEo.setSqlFilters(filters);
        List optionEos = this.settingOptionDas.select((BaseEo)optionQueryEo);
        if (CollectionUtils.isEmpty((Collection)optionEos)) {
            return new HashMap<String, List<SettingValueTreeRespDto>>();
        }
        HashSet settingCodeOptionCodeSet = new HashSet();
        return optionEos.stream().map(option -> {
            String key = option.getSettingCode() + option.getCode();
            if (settingCodeOptionCodeSet.contains(key)) {
                return null;
            }
            settingCodeOptionCodeSet.add(key);
            SettingValueTreeRespDto optionDto = new SettingValueTreeRespDto();
            DtoHelper.eo2Dto((BaseEo)option, (BaseVo)optionDto);
            optionDto.setParentCode(option.getSettingCode());
            optionDto.setType(Integer.valueOf(SettingViewNodeType.OPTION.getCode()));
            optionDto.setRemark(option.getDescr());
            if (this.optionSettingRelationDas.count(option.getSettingCode(), option.getCode()) > 0) {
                optionDto.setWithDepdSetting(Constants.TRUE);
            } else {
                optionDto.setWithDepdSetting(Constants.FALSE);
            }
            return optionDto;
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(ViewSettingTreeDto::getParentCode));
    }

    private Map<String, List<SettingValueTreeRespDto>> getSetting2OptionFromBundle(List<SettingEo> settingEos) {
        HashMap<String, List<SettingValueTreeRespDto>> result = new HashMap<String, List<SettingValueTreeRespDto>>();
        if (settingEos != null && settingEos.size() > 0) {
            settingEos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBundle())).collect(Collectors.groupingBy(StdSettingEo::getBundle)).forEach((bundleCode, v) -> {
                if (!CollectionUtils.isEmpty((Collection)v)) {
                    SettingEo settingEo = (SettingEo)v.get(0);
                    AtomicInteger sort = new AtomicInteger();
                    this.settingService.optionsFromBundle(v.stream().map(StdSettingEo::getCode).collect(Collectors.toList()), (String)bundleCode, settingEo.getVersion()).forEach((settingCode, options) -> result.put((String)settingCode, options.stream().map(optionRespDto -> {
                        SettingValueTreeRespDto optionDto = new SettingValueTreeRespDto();
                        BeanUtils.copyProperties((Object)settingEo, (Object)optionDto);
                        optionDto.setCode(optionRespDto.getCode());
                        optionDto.setSettingValue(optionRespDto.getValue());
                        optionDto.setName(optionRespDto.getName());
                        optionDto.setRemark(optionRespDto.getDescr());
                        optionDto.setSort(Integer.valueOf(sort.incrementAndGet()));
                        optionDto.setParentCode(settingCode);
                        return optionDto;
                    }).collect(Collectors.toList())));
                }
            });
        }
        return result;
    }

    private List<SettingValueTreeRespDto> processedSettingAndValue(Long globalTenantId, Long currentTenantId, String bizSpaceCode, String bizIdCode, List<SettingEo> settingEos, Map<String, List<SettingValueTreeRespDto>> settingCode2OptionDtos, Map<String, List<SettingValueEo>> settingCode2Values, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        ArrayList<SettingValueTreeRespDto> settingValueTreeRespDtos = new ArrayList<SettingValueTreeRespDto>();
        for (SettingEo settingEo : settingEos) {
            List<SettingValueTreeRespDto> optionDtos;
            List<SettingValueTreeRespDto> respDtoList;
            if (needValidParam && (settingEo.getValueType().equals(SettingValueType.SPIEXTPT.getCode()) || settingEo.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode()))) {
                needValidParam = false;
            }
            List<SettingValueEo> values = settingCode2Values.get(settingEo.getCode());
            if (settingEo.getEditType().equals(SettingEditType.INPUT.getCode())) {
                SettingValueTreeRespDto settingDto = this.getInputSettingValueTreeDto(settingEo, globalTenantId, currentTenantId, bizSpaceCode, bizIdCode, values, needValidParam, parentSettingCode, parentOptionCode);
                if (null == settingDto) continue;
                settingValueTreeRespDtos.add(settingDto);
                continue;
            }
            if (!settingEo.getEditType().equals(SettingEditType.CHOICE.getCode()) || CollectionUtils.isEmpty(respDtoList = this.getChoiceSettingValueTreeDto(settingEo, optionDtos = settingCode2OptionDtos.get(settingEo.getCode()), globalTenantId, currentTenantId, bizSpaceCode, bizIdCode, values, needValidParam, parentSettingCode, parentOptionCode))) continue;
            settingValueTreeRespDtos.addAll(respDtoList);
        }
        return settingValueTreeRespDtos;
    }

    private SettingValueTreeRespDto getInputSettingValueTreeDto(SettingEo settingEo, Long globalTenantId, Long currentTenantId, String bizSpaceCode, String bizIdCode, List<SettingValueEo> values, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        if (null == currentTenantId && null != globalTenantId) {
            ValueInputSettingVo valueInputSettingVo = this.getInputGlobalValueAndIsCtrl(settingEo, globalTenantId, values);
            return this.processedInputSettingValueDto(settingEo, valueInputSettingVo, needValidParam, parentSettingCode, parentOptionCode);
        }
        if (null != currentTenantId && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            ValueInputSettingVo valueInputSettingVo = this.getInputTenantValueAndIsCtrl(settingEo, globalTenantId, currentTenantId, values);
            return this.processedInputSettingValueDto(settingEo, valueInputSettingVo, needValidParam, parentSettingCode, parentOptionCode);
        }
        if (StringUtils.isNotBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            ValueInputSettingVo valueInputSettingVo = this.getInputBizSpaceValueAndIsCtrl(settingEo, globalTenantId, currentTenantId, bizSpaceCode, values);
            return this.processedInputSettingValueDto(settingEo, valueInputSettingVo, needValidParam, parentSettingCode, parentOptionCode);
        }
        if (StringUtils.isNotBlank((CharSequence)bizIdCode)) {
            ValueInputSettingVo valueInputSettingVo = this.getInputBizIdValueAndIsCtrl(settingEo, globalTenantId, currentTenantId, bizIdCode, values);
            return this.processedInputSettingValueDto(settingEo, valueInputSettingVo, needValidParam, parentSettingCode, parentOptionCode);
        }
        return null;
    }

    private SettingValueTreeRespDto processedInputSettingValueDto(SettingEo settingEo, ValueInputSettingVo valueInputSettingVo, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        SettingValueTreeRespDto settingDto = new SettingValueTreeRespDto();
        DtoHelper.eo2Dto((BaseEo)settingEo, (BaseVo)settingDto);
        settingDto.setType(Integer.valueOf(SettingViewNodeType.SETTING.getCode()));
        settingDto.setParentCode(settingEo.getCapabilityCode());
        settingDto.setRemark(settingEo.getDescr());
        settingDto.setSettingValue(valueInputSettingVo.getSettingValue());
        settingDto.setIsControlled(valueInputSettingVo.getIsCtrl());
        settingDto.setIsSelected(valueInputSettingVo.getIsSelected());
        Integer paramSettingSubType = this.rOptionSettingService.getParamSettingSubType(settingEo.getCode(), needValidParam, parentSettingCode, parentOptionCode);
        settingDto.setParamSettingSubType(paramSettingSubType);
        if (paramSettingSubType.equals(Constants.FALSE)) {
            settingDto.setIsRefForOtherSetting(this.rOptionSettingService.isRefForOtherSetting(settingEo.getCode()));
        }
        if (settingEo.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)settingEo.getDefaultValue()), (String)("\u914d\u7f6e\u9879[" + settingEo.getCode() + "]\u6570\u636e\u4e0d\u6b63\u786e"));
            String settingValue = valueInputSettingVo.getSettingValue();
            if (StringUtils.isBlank((CharSequence)settingValue)) {
                settingValue = settingEo.getDefaultValue();
            }
            TabularDto tabularViewDto = this.settingTabularService.getViewTabularDto(settingEo, settingValue);
            settingDto.setTabularViewDto(tabularViewDto);
            settingDto.setSettingValue(null);
        }
        return settingDto;
    }

    private ValueInputSettingVo getInputGlobalValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, List<SettingValueEo> values) {
        String settingValue = null;
        Integer isCtrl = null;
        Integer isSelected = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(values)) {
            for (SettingValueEo valueEo : values) {
                if (!valueEo.getTenantId().equals(globalTenantId) || !StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) || !StringUtils.isBlank((CharSequence)valueEo.getBizId())) continue;
                settingValue = valueEo.getSettingValue();
                isCtrl = valueEo.getIsControlled();
                isSelected = Constants.TRUE;
                break;
            }
        }
        if (isCtrl == null) {
            isCtrl = settingEo.getIsControlled();
            isSelected = Constants.FALSE;
        }
        ValueInputSettingVo valueInputSettingVo = new ValueInputSettingVo();
        valueInputSettingVo.setSettingValue(settingValue);
        valueInputSettingVo.setIsCtrl(isCtrl);
        valueInputSettingVo.setIsSelected(isSelected);
        return valueInputSettingVo;
    }

    private ValueInputSettingVo getInputTenantValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, List<SettingValueEo> values) {
        String settingValue = null;
        Integer isSelected = Constants.FALSE;
        String globalValue = null;
        Integer isCtrlTenant = null;
        Integer isCtrlGlobal = null;
        if (!CollectionUtils.isEmpty(values)) {
            for (SettingValueEo value : values) {
                if (value.getTenantId().equals(currentTenantId) && StringUtils.isBlank((CharSequence)value.getBizSpaceCode()) && StringUtils.isBlank((CharSequence)value.getBizId())) {
                    settingValue = value.getSettingValue();
                    isCtrlTenant = value.getIsControlled();
                    continue;
                }
                if (!value.getTenantId().equals(globalTenantId) || !StringUtils.isBlank((CharSequence)value.getBizSpaceCode()) || !StringUtils.isBlank((CharSequence)value.getBizId())) continue;
                globalValue = value.getSettingValue();
                isCtrlGlobal = value.getIsControlled();
            }
        }
        Integer isCtrl = isCtrlTenant = this.getIsCtrl(isCtrlTenant, SettingDisplayLevel.TENANT.getCode(), settingEo.getIsControlled(), isCtrlGlobal, null, null);
        if (StringUtils.isBlank(settingValue) && StringUtils.isNotBlank(globalValue)) {
            settingValue = globalValue;
        }
        if (StringUtils.isNotBlank(settingValue)) {
            isSelected = Constants.TRUE;
        }
        ValueInputSettingVo valueInputSettingVo = new ValueInputSettingVo();
        valueInputSettingVo.setSettingValue(settingValue);
        valueInputSettingVo.setIsCtrl(isCtrl);
        valueInputSettingVo.setIsSelected(isSelected);
        return valueInputSettingVo;
    }

    private ValueInputSettingVo getInputBizSpaceValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, String bizSpaceCode, List<SettingValueEo> values) {
        String settingValue = null;
        Integer isSelected = Constants.FALSE;
        Integer isCtrlTenant = null;
        Integer isCtrlGlobal = null;
        Integer isCtrlBizSpace = null;
        String tenantValue = null;
        String globalValue = null;
        if (!CollectionUtils.isEmpty(values)) {
            for (SettingValueEo value : values) {
                if (value.getTenantId().equals(currentTenantId) && StringUtils.isNotBlank((CharSequence)value.getBizSpaceCode()) && StringUtils.isBlank((CharSequence)value.getBizId()) && bizSpaceCode.equals(value.getBizSpaceCode())) {
                    isCtrlBizSpace = value.getIsControlled();
                    settingValue = value.getSettingValue();
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)value.getBizSpaceCode()) && value.getTenantId().equals(currentTenantId)) {
                    tenantValue = value.getSettingValue();
                    isCtrlTenant = value.getIsControlled();
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)value.getBizSpaceCode()) || !value.getTenantId().equals(globalTenantId)) continue;
                globalValue = value.getSettingValue();
                isCtrlGlobal = value.getIsControlled();
            }
        }
        Integer isCtrl = isCtrlBizSpace = this.getIsCtrl(isCtrlBizSpace, SettingDisplayLevel.BIZSPACE.getCode(), settingEo.getIsControlled(), isCtrlGlobal, isCtrlTenant, null);
        if (StringUtils.isBlank(settingValue)) {
            if (StringUtils.isNotBlank(tenantValue)) {
                settingValue = tenantValue;
            } else if (StringUtils.isNotBlank(globalValue)) {
                settingValue = globalValue;
            }
        }
        if (StringUtils.isNotBlank(settingValue)) {
            isSelected = Constants.TRUE;
        }
        ValueInputSettingVo valueInputSettingVo = new ValueInputSettingVo();
        valueInputSettingVo.setSettingValue(settingValue);
        valueInputSettingVo.setIsCtrl(isCtrl);
        valueInputSettingVo.setIsSelected(isSelected);
        return valueInputSettingVo;
    }

    private ValueInputSettingVo getInputBizIdValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, String bizIdCode, List<SettingValueEo> values) {
        String settingValue = null;
        Integer isSelected = Constants.FALSE;
        Integer isCtrlTenant = null;
        Integer isCtrlGlobal = null;
        Integer isCtrlBizSpace = null;
        Integer isCtrlBizId = null;
        String tenantValue = null;
        String globalValue = null;
        String bizSpaceValue = null;
        if (!CollectionUtils.isEmpty(values)) {
            for (SettingValueEo value : values) {
                if (value.getTenantId().equals(currentTenantId) && StringUtils.isNotBlank((CharSequence)value.getBizId()) && bizIdCode.equals(value.getBizId())) {
                    isCtrlBizId = value.getIsControlled();
                    settingValue = value.getSettingValue();
                    continue;
                }
                if (value.getTenantId().equals(currentTenantId) && StringUtils.isBlank((CharSequence)value.getBizId()) && StringUtils.isNotBlank((CharSequence)value.getBizSpaceCode())) {
                    isCtrlBizSpace = value.getIsControlled();
                    bizSpaceValue = value.getSettingValue();
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)value.getBizSpaceCode()) && value.getTenantId().equals(currentTenantId)) {
                    isCtrlTenant = value.getIsControlled();
                    tenantValue = value.getSettingValue();
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)value.getBizSpaceCode()) || !value.getTenantId().equals(globalTenantId)) continue;
                isCtrlGlobal = value.getIsControlled();
                globalValue = value.getSettingValue();
            }
        }
        Integer isCtrl = isCtrlBizId = this.getIsCtrl(isCtrlBizId, SettingDisplayLevel.BIZID.getCode(), settingEo.getIsControlled(), isCtrlGlobal, isCtrlTenant, isCtrlBizSpace);
        if (StringUtils.isBlank(settingValue)) {
            if (StringUtils.isNotBlank(bizSpaceValue)) {
                settingValue = bizSpaceValue;
            } else if (StringUtils.isNotBlank(tenantValue)) {
                settingValue = tenantValue;
            } else if (StringUtils.isNotBlank(globalValue)) {
                settingValue = globalValue;
            }
        }
        if (StringUtils.isNotBlank(settingValue)) {
            isSelected = Constants.TRUE;
        }
        ValueInputSettingVo valueInputSettingVo = new ValueInputSettingVo();
        valueInputSettingVo.setSettingValue(settingValue);
        valueInputSettingVo.setIsCtrl(isCtrl);
        valueInputSettingVo.setIsSelected(isSelected);
        return valueInputSettingVo;
    }

    private List<SettingValueTreeRespDto> getChoiceSettingValueTreeDto(SettingEo settingEo, List<SettingValueTreeRespDto> optionDtos, Long globalTenantId, Long currentTenantId, String bizSpaceCode, String bizIdCode, List<SettingValueEo> values, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        ArrayList<SettingValueTreeRespDto> respDtoList = new ArrayList<SettingValueTreeRespDto>();
        SettingValueTreeRespDto settingDto = new SettingValueTreeRespDto();
        DtoHelper.eo2Dto((BaseEo)settingEo, (BaseVo)settingDto);
        settingDto.setType(Integer.valueOf(SettingViewNodeType.SETTING.getCode()));
        settingDto.setParentCode(settingEo.getCapabilityCode());
        settingDto.setRemark(settingEo.getDescr());
        if (settingDto.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) {
            JSONObject jsonObject = JSON.parseObject((String)settingDto.getParameter());
            settingDto.setSendFlag(jsonObject.getInteger("sendFlag"));
        }
        ValueChoiceSettingVo valueChoiceSettingVo = this.getChoiceValueAndIsCtrl(settingEo, globalTenantId, currentTenantId, bizSpaceCode, bizIdCode, values);
        if (settingEo.getValueType().equals(SettingValueType.TABULAR.getCode())) {
            List<SettingValueEo> settingValueEos = valueChoiceSettingVo.getSettingValueEos();
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)settingEo.getDefaultValue()), (String)("\u914d\u7f6e\u9879[" + settingEo.getCode() + "]\u6570\u636e\u4e0d\u6b63\u786e"));
            String settingValue = null;
            if (!CollectionUtils.isEmpty(settingValueEos)) {
                settingValue = settingValueEos.get(0).getSettingValue();
            }
            settingDto.setTabularViewDto(this.settingTabularService.getViewTabularDto(settingEo, settingValue));
        } else {
            Map<Object, Object> code2value = new HashMap();
            List<Object> resultValues = new ArrayList();
            if (null != valueChoiceSettingVo) {
                resultValues = valueChoiceSettingVo.getSettingValueEos();
                Integer isCtrlResult = valueChoiceSettingVo.getIsCtrl();
                settingDto.setIsControlled(isCtrlResult);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(resultValues)) {
                    code2value = resultValues.stream().collect(Collectors.toMap(item -> item.getSettingCode() + item.getOptionCode(), Function.identity(), (k1, k2) -> k1));
                }
            }
            ArrayList<SettingValueEo> processedValues = new ArrayList<SettingValueEo>();
            ArrayList<String> selectedOptionCodes = new ArrayList<String>();
            if (code2value.size() == 0 && !CollectionUtils.isEmpty(optionDtos)) {
                for (SettingValueTreeRespDto optionDto : optionDtos) {
                    optionDto.setIsSelected(Constants.FALSE);
                    if (this.optionSettingRelationDas.count(optionDto.getParentCode(), optionDto.getCode()) > 0) {
                        optionDto.setWithDepdSetting(Constants.TRUE);
                    } else {
                        optionDto.setWithDepdSetting(Constants.FALSE);
                    }
                    respDtoList.add(optionDto);
                }
            } else if (!CollectionUtils.isEmpty(optionDtos)) {
                for (SettingValueTreeRespDto optionDto : optionDtos) {
                    SettingValueEo valueEo = (SettingValueEo)code2value.get(settingEo.getCode() + optionDto.getCode());
                    if (null != valueEo) {
                        if (optionDto.getCode() != null) {
                            selectedOptionCodes.add(optionDto.getCode());
                        }
                        optionDto.setIsSelected(Constants.TRUE);
                        processedValues.add(valueEo);
                    } else {
                        optionDto.setIsSelected(Constants.FALSE);
                    }
                    if (this.optionSettingRelationDas.count(optionDto.getParentCode(), optionDto.getCode()) > 0) {
                        optionDto.setWithDepdSetting(Constants.TRUE);
                    } else {
                        optionDto.setWithDepdSetting(Constants.FALSE);
                    }
                    respDtoList.add(optionDto);
                }
            }
            if (!CollectionUtils.isEmpty(resultValues) && !CollectionUtils.isEmpty(processedValues)) {
                resultValues.removeAll(processedValues);
            }
            if (!CollectionUtils.isEmpty(resultValues)) {
                OptionValueVo optionValueVo = this.processedValueWithoutOption(settingEo.getCode(), resultValues);
                if (null != optionValueVo && !CollectionUtils.isEmpty(optionValueVo.getSelectedOptionCodes())) {
                    selectedOptionCodes.addAll(optionValueVo.getSelectedOptionCodes());
                }
                if (null != optionValueVo && !CollectionUtils.isEmpty(optionValueVo.getValuesWithoutOption())) {
                    respDtoList.addAll(optionValueVo.getValuesWithoutOption());
                }
            }
            if (!CollectionUtils.isEmpty(selectedOptionCodes)) {
                settingDto.setIsSelected(Constants.TRUE);
            } else {
                settingDto.setIsSelected(Constants.FALSE);
            }
            settingDto.setOptionCodes(selectedOptionCodes);
        }
        Integer paramSettingSubType = this.rOptionSettingService.getParamSettingSubType(settingEo.getCode(), needValidParam, parentSettingCode, parentOptionCode);
        settingDto.setParamSettingSubType(paramSettingSubType);
        if (paramSettingSubType.equals(Constants.FALSE)) {
            settingDto.setIsRefForOtherSetting(this.rOptionSettingService.isRefForOtherSetting(settingEo.getCode()));
        }
        respDtoList.add(settingDto);
        return respDtoList;
    }

    private ValueChoiceSettingVo getChoiceValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, String bizSpaceCode, String bizIdCode, List<SettingValueEo> values) {
        if (null == currentTenantId && null != globalTenantId) {
            return this.getChoiceGlobalValueAndIsCtrl(settingEo, globalTenantId, values);
        }
        if (null != currentTenantId && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            return this.getChoiceTenantValueAndIsCtrl(settingEo, globalTenantId, currentTenantId, values);
        }
        if (StringUtils.isNotBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            return this.getChoiceBizSpaceValueAndIsCtrl(settingEo, globalTenantId, currentTenantId, bizSpaceCode, values);
        }
        if (StringUtils.isNotBlank((CharSequence)bizIdCode)) {
            return this.getChoiceBizIdValueAndIsCrtl(settingEo, globalTenantId, currentTenantId, bizSpaceCode, bizIdCode, values);
        }
        return new ValueChoiceSettingVo();
    }

    private ValueChoiceSettingVo getChoiceGlobalValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, List<SettingValueEo> values) {
        ArrayList<SettingValueEo> resultValues = new ArrayList<SettingValueEo>();
        Integer isCtrl = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(values)) {
            for (SettingValueEo valueEo : values) {
                if (!valueEo.getTenantId().equals(globalTenantId) || !StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) || !StringUtils.isBlank((CharSequence)valueEo.getBizId())) continue;
                resultValues.add(valueEo);
                isCtrl = valueEo.getIsControlled();
            }
            if (isCtrl == null) {
                isCtrl = settingEo.getIsControlled();
            }
        } else {
            isCtrl = settingEo.getIsControlled();
        }
        ValueChoiceSettingVo valueChoiceSettingVo = new ValueChoiceSettingVo();
        valueChoiceSettingVo.setSettingValueEos(resultValues);
        valueChoiceSettingVo.setIsCtrl(isCtrl);
        return valueChoiceSettingVo;
    }

    private ValueChoiceSettingVo getChoiceTenantValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, List<SettingValueEo> values) {
        ArrayList<Object> resultValues = new ArrayList<SettingValueEo>();
        Integer isCtrlTenant = null;
        Integer isCtrlGlobal = null;
        ArrayList<SettingValueEo> globalValues = new ArrayList<SettingValueEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(values)) {
            for (SettingValueEo valueEo : values) {
                if (valueEo.getTenantId().equals(currentTenantId) && StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) && StringUtils.isBlank((CharSequence)valueEo.getBizId())) {
                    resultValues.add(valueEo);
                    isCtrlTenant = valueEo.getIsControlled();
                    continue;
                }
                if (!valueEo.getTenantId().equals(globalTenantId) || !StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) || !StringUtils.isBlank((CharSequence)valueEo.getBizId())) continue;
                globalValues.add(valueEo);
                isCtrlGlobal = valueEo.getIsControlled();
            }
        }
        Integer isCtrl = isCtrlTenant = this.getIsCtrl(isCtrlTenant, SettingDisplayLevel.TENANT.getCode(), settingEo.getIsControlled(), isCtrlGlobal, null, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(resultValues) && org.apache.commons.collections.CollectionUtils.isNotEmpty(globalValues)) {
            resultValues = new ArrayList(globalValues);
        }
        ValueChoiceSettingVo valueChoiceSettingVo = new ValueChoiceSettingVo();
        valueChoiceSettingVo.setSettingValueEos(resultValues);
        valueChoiceSettingVo.setIsCtrl(isCtrl);
        return valueChoiceSettingVo;
    }

    private ValueChoiceSettingVo getChoiceBizSpaceValueAndIsCtrl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, String bizSpaceCode, List<SettingValueEo> values) {
        ArrayList<Object> resultValues = new ArrayList<SettingValueEo>();
        Integer isCtrlTenant = null;
        Integer isCtrlGlobal = null;
        Integer isCtrlBizSpace = null;
        ArrayList<SettingValueEo> globalValues = new ArrayList<SettingValueEo>();
        ArrayList<SettingValueEo> tenantValues = new ArrayList<SettingValueEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(values)) {
            for (SettingValueEo valueEo : values) {
                if (valueEo.getTenantId().equals(currentTenantId) && StringUtils.isNotBlank((CharSequence)valueEo.getBizSpaceCode()) && valueEo.getBizSpaceCode().equals(bizSpaceCode) && StringUtils.isBlank((CharSequence)valueEo.getBizId())) {
                    resultValues.add(valueEo);
                    isCtrlBizSpace = valueEo.getIsControlled();
                    continue;
                }
                if (valueEo.getTenantId().equals(currentTenantId) && StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) && StringUtils.isBlank((CharSequence)valueEo.getBizId())) {
                    tenantValues.add(valueEo);
                    isCtrlTenant = valueEo.getIsControlled();
                    continue;
                }
                if (!valueEo.getTenantId().equals(globalTenantId) || !StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) || !StringUtils.isBlank((CharSequence)valueEo.getBizId())) continue;
                globalValues.add(valueEo);
                isCtrlGlobal = valueEo.getIsControlled();
            }
        }
        Integer isCtrl = isCtrlBizSpace = this.getIsCtrl(isCtrlBizSpace, SettingDisplayLevel.BIZSPACE.getCode(), settingEo.getIsControlled(), isCtrlGlobal, isCtrlTenant, null);
        if (CollectionUtils.isEmpty(resultValues)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tenantValues)) {
                resultValues = new ArrayList(tenantValues);
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(globalValues)) {
                resultValues = new ArrayList(globalValues);
            }
        }
        ValueChoiceSettingVo valueChoiceSettingVo = new ValueChoiceSettingVo();
        valueChoiceSettingVo.setSettingValueEos(resultValues);
        valueChoiceSettingVo.setIsCtrl(isCtrl);
        return valueChoiceSettingVo;
    }

    private ValueChoiceSettingVo getChoiceBizIdValueAndIsCrtl(SettingEo settingEo, Long globalTenantId, Long currentTenantId, String bizSpaceCode, String bizIdCode, List<SettingValueEo> values) {
        ArrayList<Object> resultValues = new ArrayList<SettingValueEo>();
        Integer isCtrlTenant = null;
        Integer isCtrlGlobal = null;
        Integer isCtrlBizSpace = null;
        Integer isCtrlBizId = null;
        ArrayList<SettingValueEo> globalValues = new ArrayList<SettingValueEo>();
        ArrayList<SettingValueEo> tenantValues = new ArrayList<SettingValueEo>();
        ArrayList<SettingValueEo> bizSpaceValues = new ArrayList<SettingValueEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(values)) {
            for (SettingValueEo valueEo : values) {
                if (valueEo.getTenantId().equals(currentTenantId) && StringUtils.isNotBlank((CharSequence)valueEo.getBizSpaceCode()) && valueEo.getBizSpaceCode().equals(bizSpaceCode) && StringUtils.isNotBlank((CharSequence)valueEo.getBizId()) && valueEo.getBizId().equals(bizIdCode)) {
                    resultValues.add(valueEo);
                    isCtrlBizId = valueEo.getIsControlled();
                    continue;
                }
                if (valueEo.getTenantId().equals(currentTenantId) && StringUtils.isNotBlank((CharSequence)valueEo.getBizSpaceCode()) && valueEo.getBizSpaceCode().equals(bizSpaceCode) && StringUtils.isBlank((CharSequence)valueEo.getBizId())) {
                    bizSpaceValues.add(valueEo);
                    isCtrlBizSpace = valueEo.getIsControlled();
                    continue;
                }
                if (valueEo.getTenantId().equals(currentTenantId) && StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) && StringUtils.isBlank((CharSequence)valueEo.getBizId())) {
                    tenantValues.add(valueEo);
                    isCtrlTenant = valueEo.getIsControlled();
                    continue;
                }
                if (!valueEo.getTenantId().equals(globalTenantId) || !StringUtils.isBlank((CharSequence)valueEo.getBizSpaceCode()) || !StringUtils.isBlank((CharSequence)valueEo.getBizId())) continue;
                globalValues.add(valueEo);
                isCtrlGlobal = valueEo.getIsControlled();
            }
        }
        Integer isCtrl = isCtrlBizId = this.getIsCtrl(isCtrlBizId, SettingDisplayLevel.BIZID.getCode(), settingEo.getIsControlled(), isCtrlGlobal, isCtrlTenant, isCtrlBizSpace);
        if (CollectionUtils.isEmpty(resultValues)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bizSpaceValues)) {
                resultValues = new ArrayList(bizSpaceValues);
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tenantValues)) {
                resultValues = new ArrayList(tenantValues);
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(globalValues)) {
                resultValues = new ArrayList(globalValues);
            }
        }
        ValueChoiceSettingVo valueChoiceSettingVo = new ValueChoiceSettingVo();
        valueChoiceSettingVo.setSettingValueEos(resultValues);
        valueChoiceSettingVo.setIsCtrl(isCtrl);
        return valueChoiceSettingVo;
    }

    @Override
    public PageInfo<SettingValueTreeRespDto> getDepdSetting(OptionDepdSettingDto optionDepdSettingDto) {
        List<SettingValueTreeRespDto> settingValueTreeRespDtos = new ArrayList<SettingValueTreeRespDto>();
        String settingCode = optionDepdSettingDto.getSettingCode();
        String optionCode = optionDepdSettingDto.getOptionCode();
        Long currentTenantId = this.userTenantService.getCurrentTenantId();
        Long globalTenantId = this.userTenantService.getGlobalTenantId();
        String bizSpaceCode = optionDepdSettingDto.getBizSpaceCode();
        String bizIdCode = optionDepdSettingDto.getBizIdCode();
        OptionSettingRelationEo relationEo = new OptionSettingRelationEo();
        relationEo.setSettingCode(settingCode);
        relationEo.setOptionCode(optionCode);
        List relationEos = this.optionSettingRelationDas.select((BaseEo)relationEo, Integer.valueOf(1), Integer.valueOf(20));
        if (!CollectionUtils.isEmpty((Collection)relationEos)) {
            List<SettingValueTreeRespDto> settingDtos;
            List<SettingEo> dynamicFromBundleSetting;
            Set<String> settingCodes = relationEos.stream().map(StdOptionSettingRelationEo::getDepdSettingCode).collect(Collectors.toSet());
            List settingEos = this.settingDas.selectByCodeList(new ArrayList(settingCodes), Constants.TRUE);
            Map<Integer, List<SettingEo>> sourceTypeMapSetting = settingEos.stream().collect(Collectors.groupingBy(StdSettingEo::getOptionSourceType));
            HashSet staticSettingCodes = Sets.newHashSet();
            HashMap settingCode2OptionDtos = Maps.newHashMap();
            List<SettingEo> staticFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.STATIC.getValue());
            if (!CollectionUtils.isEmpty(staticFromBundleSetting)) {
                staticSettingCodes.addAll(staticFromBundleSetting.stream().map(StdSettingEo::getCode).collect(Collectors.toSet()));
                settingCode2OptionDtos.putAll(this.getSetting2OptionDtos(staticSettingCodes));
            }
            if (!CollectionUtils.isEmpty(dynamicFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.getValue()))) {
                Map<String, List<SettingValueTreeRespDto>> dynamicSettingOptions = this.getSetting2OptionFromBundle(dynamicFromBundleSetting);
                settingCode2OptionDtos.putAll(dynamicSettingOptions);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(settingDtos = this.getTreeSettingDtos(currentTenantId, globalTenantId, bizSpaceCode, bizIdCode, settingCodes, settingEos, settingCode2OptionDtos, true, settingCode, optionCode))) {
                settingValueTreeRespDtos.addAll(settingDtos);
            }
            TreeBuilder<SettingValueTreeRespDto> treeBuilder = new TreeBuilder<SettingValueTreeRespDto>();
            settingValueTreeRespDtos = treeBuilder.buildByParentKey(settingValueTreeRespDtos, false, this.getSettingValueTreeRespDtoComparator());
        }
        return new PageInfo(settingValueTreeRespDtos);
    }

    @Override
    public ViewDescRespDto getViewAllItemDescByViewId(ViewDescReqDto viewDescReqDto) {
        ViewDescRespDto result = new ViewDescRespDto();
        Long viewId = viewDescReqDto.getViewId();
        String bizSpaceCode = viewDescReqDto.getBizSpaceCode();
        String bizIdCode = viewDescReqDto.getBizIdCode();
        Long currentTenantId = this.userTenantService.getCurrentTenantId();
        Long globalTenantId = this.userTenantService.getGlobalTenantId();
        if (null == currentTenantId && null == globalTenantId) {
            return null;
        }
        ViewDescCapVo viewDescCapVo = this.getViewCapabilityDesc(viewId, currentTenantId, globalTenantId);
        if (null == viewDescCapVo || CollectionUtils.isEmpty(viewDescCapVo.getCapabilityCodes())) {
            return null;
        }
        result.setCapabilityDescList(viewDescCapVo.getCapabilityItemDtos());
        List<ViewDescRespDto.ViewSettingItemDto> settingDescList = this.getViewSettingDesc(viewDescCapVo.getCapabilityCodes(), bizSpaceCode, bizIdCode, currentTenantId, globalTenantId);
        result.setSettingDescList(settingDescList);
        return result;
    }

    private ViewDescCapVo getViewCapabilityDesc(Long viewId, Long currentTenantId, Long globalTenantId) {
        List capabilityEos;
        List<String> bundleCodes = this.getBundleCodes(globalTenantId, currentTenantId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bundleCodes)) {
            return null;
        }
        CapabilityEo capabilityQueryEo = new CapabilityEo();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bundleCodes)) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
            capabilityQueryEo.setSqlFilters(filters);
        }
        if (CollectionUtils.isEmpty((Collection)(capabilityEos = this.capabilityDas.select((BaseEo)capabilityQueryEo)))) {
            return null;
        }
        Set relationCapabilityCodes = this.viewCapabilityRelationDas.getCapabilityCodesByViewId(viewId);
        List<CapabilityEo> afterFilterCaps = capabilityEos.stream().filter(eo -> relationCapabilityCodes.contains(eo.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(afterFilterCaps)) {
            return null;
        }
        ArrayList<ViewDescRespDto.ViewCapabilityItemDto> capabilityDescList = new ArrayList<ViewDescRespDto.ViewCapabilityItemDto>();
        HashSet<String> capabilityCodes = new HashSet<String>();
        afterFilterCaps.forEach(item -> {
            capabilityCodes.add(item.getCode());
            if (StringUtils.isNotBlank((CharSequence)item.getDescr())) {
                ViewDescRespDto.ViewCapabilityItemDto capabilityItemDto = new ViewDescRespDto.ViewCapabilityItemDto();
                DtoHelper.eo2Dto((BaseEo)item, (BaseVo)capabilityItemDto);
                capabilityItemDto.setRemark(item.getDescr());
                capabilityDescList.add(capabilityItemDto);
            }
        });
        capabilityDescList.sort(Comparator.comparing(ViewDescRespDto.ViewBaseItemDto::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(ViewDescRespDto.ViewBaseItemDto::getCode, String.CASE_INSENSITIVE_ORDER));
        ViewDescCapVo viewDescCapVo = new ViewDescCapVo();
        viewDescCapVo.setCapabilityItemDtos(capabilityDescList);
        viewDescCapVo.setCapabilityCodes(capabilityCodes);
        return viewDescCapVo;
    }

    private List<ViewDescRespDto.ViewSettingItemDto> getViewSettingDesc(Set<String> capabilityCodes, String bizSpaceCode, String bizIdCode, Long currentTenantId, Long globalTenantId) {
        List<SettingEo> dynamicFromBundleSetting;
        SettingEo settingQueryEo = new SettingEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"capability_code", (Object)StringUtils.join(capabilityCodes, (String)",")));
        settingQueryEo.setSqlFilters(filters);
        settingQueryEo.setViewVisible(Constants.TRUE);
        List settingEos = this.settingDas.select((BaseEo)settingQueryEo);
        if (CollectionUtils.isEmpty((Collection)settingEos)) {
            return null;
        }
        if (!(null != currentTenantId && currentTenantId.equals(globalTenantId) && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode))) {
            settingEos = settingEos.stream().filter(eo -> !eo.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(settingEos)) {
            return null;
        }
        ArrayList<ViewDescRespDto.ViewSettingItemDto> settingDescList = new ArrayList<ViewDescRespDto.ViewSettingItemDto>();
        HashMap settingCode2OptionDtos = Maps.newHashMap();
        Map<Integer, List<SettingEo>> sourceTypeMapSetting = settingEos.stream().collect(Collectors.groupingBy(StdSettingEo::getOptionSourceType));
        List<SettingEo> staticFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.STATIC.getValue());
        Set<Object> settingCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(staticFromBundleSetting) && !CollectionUtils.isEmpty((Collection)(settingCodes = staticFromBundleSetting.stream().map(StdSettingEo::getCode).collect(Collectors.toSet())))) {
            SettingOptionEo optionQueryEo = new SettingOptionEo();
            ArrayList<SqlFilter> optionFilters = new ArrayList<SqlFilter>();
            optionFilters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join((Iterable)settingCodes, (String)",")));
            optionQueryEo.setSqlFilters(optionFilters);
            List optionEos = this.settingOptionDas.select((BaseEo)optionQueryEo);
            optionEos.stream().collect(Collectors.groupingBy(StdSettingOptionEo::getSettingCode)).forEach((settingCode, options) -> settingCode2OptionDtos.put(settingCode, options.stream().map(eo -> {
                if (!StringUtils.isBlank((CharSequence)eo.getDescr())) {
                    ViewDescRespDto.ViewOptionItemDto optionDto = new ViewDescRespDto.ViewOptionItemDto();
                    DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)optionDto);
                    optionDto.setRemark(eo.getDescr());
                    return optionDto;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList())));
        }
        if (!CollectionUtils.isEmpty(dynamicFromBundleSetting = sourceTypeMapSetting.get(CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.getValue()))) {
            dynamicFromBundleSetting.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBundle())).collect(Collectors.groupingBy(StdSettingEo::getBundle)).forEach((bundleCode, v) -> {
                if (!CollectionUtils.isEmpty((Collection)v)) {
                    SettingEo settingEo = (SettingEo)v.get(0);
                    AtomicInteger sort = new AtomicInteger();
                    this.settingService.optionsFromBundle(v.stream().map(StdSettingEo::getCode).collect(Collectors.toList()), (String)bundleCode, settingEo.getVersion()).forEach((settingCode, options) -> settingCode2OptionDtos.put(settingCode, options.stream().map(optionRespDto -> {
                        if (!StringUtils.isBlank((CharSequence)optionRespDto.getDescr())) {
                            ViewDescRespDto.ViewOptionItemDto optionDto = new ViewDescRespDto.ViewOptionItemDto();
                            CubeBeanUtils.copyProperties((Object)optionDto, (Object)optionRespDto, (String[])new String[0]);
                            optionDto.setRemark(optionRespDto.getDescr());
                            optionDto.setSort(Integer.valueOf(sort.incrementAndGet()));
                            return optionDto;
                        }
                        return null;
                    }).filter(Objects::nonNull).collect(Collectors.toList())));
                }
            });
        }
        for (SettingEo settingEo : settingEos) {
            if (StringUtils.isBlank((CharSequence)settingEo.getDescr())) continue;
            ViewDescRespDto.ViewSettingItemDto settingItemDto = new ViewDescRespDto.ViewSettingItemDto();
            DtoHelper.eo2Dto((BaseEo)settingEo, (BaseVo)settingItemDto);
            settingItemDto.setRemark(settingEo.getDescr());
            List options2 = (List)settingCode2OptionDtos.get(settingEo.getCode());
            if (!CollectionUtils.isEmpty((Collection)options2)) {
                options2.sort(Comparator.comparing(ViewDescRespDto.ViewBaseItemDto::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(ViewDescRespDto.ViewBaseItemDto::getCode, String.CASE_INSENSITIVE_ORDER));
                settingItemDto.setOptionDescList(options2);
            }
            settingDescList.add(settingItemDto);
        }
        settingDescList.sort(Comparator.comparing(ViewDescRespDto.ViewBaseItemDto::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(ViewDescRespDto.ViewBaseItemDto::getCode, String.CASE_INSENSITIVE_ORDER));
        return settingDescList;
    }

    private List<SettingValueTreeRespDto> getTreeSettingDtos(Long currentTenantId, Long globalTenantId, String bizSpaceCode, String bizIdCode, Set<String> settingCodes, List<SettingEo> settingEos, Map<String, List<SettingValueTreeRespDto>> settingCode2OptionDtos, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        List<SettingValueTreeRespDto> settingDtos = new ArrayList<SettingValueTreeRespDto>();
        if (null != currentTenantId && currentTenantId.equals(globalTenantId) && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            Map<String, List<SettingValueEo>> settingCode2Values = this.getLevelValueByCondition(settingCodes, globalTenantId, null, null, null);
            settingDtos = this.processedSettingAndValue(globalTenantId, null, null, null, settingEos, settingCode2OptionDtos, settingCode2Values, needValidParam, parentSettingCode, parentOptionCode);
        } else if (null != currentTenantId && !currentTenantId.equals(globalTenantId) && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            Map<String, List<SettingValueEo>> settingCode2Values = this.getLevelValueByCondition(settingCodes, globalTenantId, currentTenantId, null, null);
            settingDtos = this.processedSettingAndValue(globalTenantId, currentTenantId, null, null, settingEos, settingCode2OptionDtos, settingCode2Values, needValidParam, parentSettingCode, parentOptionCode);
        } else if (StringUtils.isNotBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            Map<String, List<SettingValueEo>> settingCode2Values = this.getLevelValueByCondition(settingCodes, globalTenantId, currentTenantId, bizSpaceCode, null);
            settingDtos = this.processedSettingAndValue(globalTenantId, currentTenantId, bizSpaceCode, null, settingEos, settingCode2OptionDtos, settingCode2Values, needValidParam, parentSettingCode, parentOptionCode);
        } else if (StringUtils.isNotBlank((CharSequence)bizIdCode)) {
            Map<String, List<SettingValueEo>> settingCode2Values = this.getLevelValueByCondition(settingCodes, globalTenantId, currentTenantId, bizSpaceCode, bizIdCode);
            settingDtos = this.processedSettingAndValue(globalTenantId, currentTenantId, bizSpaceCode, bizIdCode, settingEos, settingCode2OptionDtos, settingCode2Values, needValidParam, parentSettingCode, parentOptionCode);
        }
        return settingDtos;
    }

    private Integer getIsCtrl(Integer currentCtrl, Integer currentLevel, Integer settingCtrl, Integer isCtrlGlobal, Integer isCtrlTenant, Integer isCtrlBizSpace) {
        Integer parentCtrl = null;
        if (currentLevel.equals(SettingDisplayLevel.BIZID.getCode())) {
            parentCtrl = null != isCtrlBizSpace ? isCtrlBizSpace : (null != isCtrlTenant ? isCtrlTenant : (null != isCtrlGlobal ? isCtrlGlobal : settingCtrl));
        } else if (currentLevel.equals(SettingDisplayLevel.BIZSPACE.getCode())) {
            parentCtrl = null != isCtrlTenant ? isCtrlTenant : (null != isCtrlGlobal ? isCtrlGlobal : settingCtrl);
        } else if (currentLevel.equals(SettingDisplayLevel.TENANT.getCode())) {
            parentCtrl = null != isCtrlGlobal ? isCtrlGlobal : settingCtrl;
        }
        if (null != parentCtrl && null != currentCtrl && parentCtrl.equals(Constants.FALSE)) {
            return null;
        }
        if (null != parentCtrl && null == currentCtrl && parentCtrl.equals(Constants.TRUE)) {
            return parentCtrl;
        }
        return currentCtrl;
    }

    private OptionValueVo processedValueWithoutOption(String settingCode, List<SettingValueEo> settingValueEos) {
        OptionValueVo optionValueVo = new OptionValueVo();
        ArrayList<String> selectedOptionCodes = new ArrayList<String>();
        ArrayList<SettingValueTreeRespDto> valuesWithoutOption = new ArrayList<SettingValueTreeRespDto>();
        for (SettingValueEo onlyValue : settingValueEos) {
            SettingValueTreeRespDto onlyValueOptionDto = new SettingValueTreeRespDto();
            onlyValueOptionDto.setParentCode(settingCode);
            onlyValueOptionDto.setCode(onlyValue.getOptionCode());
            onlyValueOptionDto.setName("-");
            onlyValueOptionDto.setRemark("-");
            onlyValueOptionDto.setIsSelected(Constants.TRUE);
            onlyValueOptionDto.setType(Integer.valueOf(SettingViewNodeType.OPTION.getCode()));
            selectedOptionCodes.add(onlyValue.getOptionCode());
            valuesWithoutOption.add(onlyValueOptionDto);
        }
        optionValueVo.setSelectedOptionCodes(selectedOptionCodes);
        optionValueVo.setValuesWithoutOption(valuesWithoutOption);
        return optionValueVo;
    }

    private ValueCapabilityVo getCapability(Long viewId, String firstCapabilityCode, List<String> bundleCodes) {
        ValueCapabilityVo valueCapabilityVo = new ValueCapabilityVo();
        HashSet<String> capabilityCodes = new HashSet<String>();
        ArrayList<SettingValueTreeRespDto> settingValueTreeRespDtos = new ArrayList<SettingValueTreeRespDto>();
        CapabilityEo capabilityQueryEo = new CapabilityEo();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bundleCodes)) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
            capabilityQueryEo.setSqlFilters(filters);
        }
        capabilityQueryEo.setParentCode("ROOT_NODE");
        List firstCapabilityEos = this.capabilityDas.select((BaseEo)capabilityQueryEo);
        if (CollectionUtils.isEmpty((Collection)firstCapabilityEos)) {
            return null;
        }
        Set relationCapabilityCodes = this.viewCapabilityRelationDas.getCapabilityCodesByViewId(viewId);
        List afterFilterCaps = firstCapabilityEos.stream().filter(eo -> relationCapabilityCodes.contains(eo.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(afterFilterCaps)) {
            return null;
        }
        HashSet domainCodes = new HashSet();
        Map<String, List<SettingValueTreeRespDto>> domain2FirstCapability = afterFilterCaps.stream().map(eo -> {
            SettingValueTreeRespDto firstCapabilityDto = new SettingValueTreeRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)firstCapabilityDto);
            firstCapabilityDto.setParentCode(eo.getDomain());
            firstCapabilityDto.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
            domainCodes.add(eo.getDomain());
            return firstCapabilityDto;
        }).collect(Collectors.groupingBy(ViewSettingTreeDto::getParentCode));
        ArrayList<SettingValueTreeRespDto> firstCapabilityAfterSort = new ArrayList<SettingValueTreeRespDto>();
        List<DomainEo> domainEos = this.capabilityDomainService.getDomainByCodes(new ArrayList<String>(domainCodes));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(domainEos)) {
            domainEos.sort(Comparator.comparing(StdDomainEo::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(StdDomainEo::getCode, String.CASE_INSENSITIVE_ORDER));
            int sort = 0;
            for (DomainEo domain : domainEos) {
                List<SettingValueTreeRespDto> caps = domain2FirstCapability.get(domain.getCode());
                if (CollectionUtils.isEmpty(caps)) continue;
                caps.sort(Comparator.comparing(ViewSettingTreeDto::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(ViewSettingTreeDto::getCode, String.CASE_INSENSITIVE_ORDER));
                for (SettingValueTreeRespDto cap : caps) {
                    cap.setSort(Integer.valueOf(sort));
                    ++sort;
                    firstCapabilityAfterSort.add(cap);
                }
            }
        } else {
            for (List<SettingValueTreeRespDto> capDtos : domain2FirstCapability.values()) {
                firstCapabilityAfterSort.addAll(capDtos);
            }
            firstCapabilityAfterSort.sort(Comparator.comparing(ViewSettingTreeDto::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(ViewSettingTreeDto::getCode, String.CASE_INSENSITIVE_ORDER));
        }
        if (CollectionUtils.isEmpty(firstCapabilityAfterSort)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)firstCapabilityCode)) {
            firstCapabilityCode = ((SettingValueTreeRespDto)firstCapabilityAfterSort.get(0)).getCode();
        }
        capabilityCodes.add(firstCapabilityCode);
        List<CapabilityEo> childrenCapabilityEos = this.capabilityService.getChildrenEoByCapabilityCode(firstCapabilityCode);
        childrenCapabilityEos.forEach(eo -> {
            SettingValueTreeRespDto capability = new SettingValueTreeRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)capability);
            capability.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
            capabilityCodes.add(eo.getCode());
            settingValueTreeRespDtos.add(capability);
        });
        settingValueTreeRespDtos.addAll(firstCapabilityAfterSort);
        valueCapabilityVo.setCapabilityCodes(capabilityCodes);
        valueCapabilityVo.setCapabilityDtos(settingValueTreeRespDtos);
        return valueCapabilityVo;
    }

    private Map<String, List<SettingValueEo>> getLevelValueByCondition(Set<String> settingCodes, Long globalTenantId, Long currentTenantId, String bizSpaceCode, String bizIdCode) {
        SettingValueEo settingValueQueryEo = new SettingValueEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (null != globalTenantId && null == currentTenantId && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            filters.add(SqlFilter.isNull((String)"biz_id"));
            filters.add(SqlFilter.isNull((String)"biz_space_code"));
            settingValueQueryEo.setTenantId(globalTenantId);
        } else if (null != currentTenantId && currentTenantId.equals(globalTenantId) && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            filters.add(SqlFilter.isNull((String)"biz_id"));
            filters.add(SqlFilter.isNull((String)"biz_space_code"));
            settingValueQueryEo.setTenantId(globalTenantId);
        } else {
            ArrayList<Long> tenantIds = new ArrayList<Long>();
            tenantIds.add(globalTenantId);
            tenantIds.add(currentTenantId);
            filters.add(SqlFilter.in((String)"tenant_id", (Object)StringUtils.join(tenantIds, (String)",")));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(settingCodes)) {
            filters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join(settingCodes, (String)",")));
        }
        settingValueQueryEo.setSqlFilters(filters);
        List settingValueEos = this.settingValueDas.select((BaseEo)settingValueQueryEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)settingValueEos)) {
            return new HashMap<String, List<SettingValueEo>>();
        }
        return settingValueEos.stream().collect(Collectors.groupingBy(StdSettingValueEo::getSettingCode));
    }

    @Override
    public PageInfo<ViewSettingTreeDto> queryViewNodeChildren(ViewNodeQueryReqDto viewNodeQueryReqDto) {
        Long viewId = viewNodeQueryReqDto.getViewId();
        Assert.isTrue((null != viewId ? 1 : 0) != 0, (String)"\u89c6\u56feID\u4e0d\u80fd\u4e3anull");
        Integer type = viewNodeQueryReqDto.getType();
        String code = viewNodeQueryReqDto.getCode();
        List<String> bundleCodes = this.bundleService.getEnableBundleCodes(Constants.ENABLE);
        Set relationCapCodes = this.viewCapabilityRelationDas.getCapabilityCodesByViewId(viewId);
        List<Object> viewSettingTreeDtos = new ArrayList<Object>();
        if (type.equals(SettingViewNodeType.DOMAIN.getCode())) {
            List<CapabilityEo> capabilityEos = this.capabilityService.getCapabilityByDomain(code);
            for (CapabilityEo cap : capabilityEos) {
                ViewSettingTreeDto dto = new ViewSettingTreeDto();
                DtoHelper.eo2Dto((BaseEo)cap, (BaseVo)dto);
                dto.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
                if (relationCapCodes.contains(cap.getCode())) {
                    dto.setIsSelected(Constants.TRUE);
                } else {
                    dto.setIsSelected(Constants.FALSE);
                }
                dto.setDisabled(Constants.FALSE);
                viewSettingTreeDtos.add(dto);
            }
        }
        if (type.equals(SettingViewNodeType.CAPABILITY.getCode())) {
            ArrayList<ViewSettingTreeDto> processTreeDtos = new ArrayList<ViewSettingTreeDto>();
            ArrayList<String> capabilityCodes = new ArrayList<String>();
            capabilityCodes.add(code);
            List<CapabilityEo> resultEos = this.capabilityService.getCapabilityAndChildrenByCodes(capabilityCodes);
            for (CapabilityEo capabilityEo : resultEos) {
                ViewSettingTreeDto dto = new ViewSettingTreeDto();
                DtoHelper.eo2Dto((BaseEo)capabilityEo, (BaseVo)dto);
                dto.setType(Integer.valueOf(SettingViewNodeType.CAPABILITY.getCode()));
                if (relationCapCodes.contains(capabilityEo.getCode())) {
                    dto.setIsSelected(Constants.TRUE);
                } else {
                    dto.setIsSelected(Constants.FALSE);
                }
                dto.setDisabled(Constants.FALSE);
                processTreeDtos.add(dto);
            }
            List<SettingEo> settingEos = this.settingService.getSettingByCondition(bundleCodes, capabilityCodes, Constants.TRUE);
            for (SettingEo settingEo : settingEos) {
                ViewSettingTreeDto settingDto = new ViewSettingTreeDto();
                DtoHelper.eo2Dto((BaseEo)settingEo, (BaseVo)settingDto);
                settingDto.setType(Integer.valueOf(SettingViewNodeType.SETTING.getCode()));
                settingDto.setParentCode(settingEo.getCapabilityCode());
                processTreeDtos.add(settingDto);
            }
            TreeBuilder<ViewSettingTreeDto> treeBuilder = new TreeBuilder<ViewSettingTreeDto>();
            viewSettingTreeDtos = treeBuilder.buildByParentKey(processTreeDtos, false, this.getViewSettingTreeDtoComparator());
        }
        return new PageInfo(viewSettingTreeDtos);
    }

    @Override
    public SettingViewRespDto queryById(Long id) {
        SettingViewEo settingViewEo = (SettingViewEo)this.settingViewDas.selectByPrimaryKey(id);
        SettingViewRespDto settingViewRespDto = new SettingViewRespDto();
        DtoHelper.eo2Dto((BaseEo)settingViewEo, (BaseVo)settingViewRespDto);
        return settingViewRespDto;
    }

    @Override
    public PageInfo<SettingViewRespDto> queryByPage(SettingViewQueryReqDto settingViewQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo dtoPageInfo = new PageInfo();
        Set<Object> viewIds = new HashSet();
        if (null != settingViewQueryReqDto.getWithCapabilityView() && settingViewQueryReqDto.getWithCapabilityView().equals(Constants.TRUE) && CollectionUtils.isEmpty(viewIds = this.getViewIds())) {
            return dtoPageInfo;
        }
        SettingViewEo settingViewEo = new SettingViewEo();
        DtoHelper.dto2Eo((BaseVo)settingViewQueryReqDto, (BaseEo)settingViewEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(viewIds)) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(viewIds, (String)",")));
        }
        if (StringUtils.isNotBlank((CharSequence)settingViewQueryReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + settingViewQueryReqDto.getName() + "%")));
        }
        settingViewEo.setSqlFilters(sqlFilters);
        settingViewEo.setOrderBy("code");
        PageInfo eoPageInfo = this.settingViewDas.selectPage((BaseEo)settingViewEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SettingViewRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private Set<Long> getViewIds() {
        List<SettingEo> settingEos;
        List<String> settingCodes;
        List<SettingEo> setByOption;
        List<String> bundleCodes = this.getBundleCodes();
        if (CollectionUtils.isEmpty(bundleCodes)) {
            return new HashSet<Long>();
        }
        HashSet capabilityCodes = new HashSet();
        List<SettingOptionEo> settingOptionEos = this.settingService.getSettingOptionBySetting(null, bundleCodes);
        if (!CollectionUtils.isEmpty(settingOptionEos) && !CollectionUtils.isEmpty(setByOption = this.settingService.getSettingEoByCodes(settingCodes = settingOptionEos.stream().map(StdSettingOptionEo::getSettingCode).collect(Collectors.toList())))) {
            Set capCodesByOption = setByOption.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCapabilityCode())).map(StdSettingEo::getCapabilityCode).collect(Collectors.toSet());
            capabilityCodes.addAll(capCodesByOption);
        }
        if (!CollectionUtils.isEmpty(settingEos = this.settingService.getSettingByCondition(bundleCodes, null, Constants.TRUE))) {
            Set capCodesBySetting = settingEos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCapabilityCode())).map(StdSettingEo::getCapabilityCode).collect(Collectors.toSet());
            capabilityCodes.addAll(capCodesBySetting);
        }
        Set<Long> viewIds = new HashSet<Long>();
        List<CapabilityEo> capabilityEos = this.capabilityService.getCapabilityByCondition(bundleCodes, null);
        if (!CollectionUtils.isEmpty(capabilityEos)) {
            capabilityCodes.addAll(capabilityEos.stream().map(StdCapabilityEo::getCode).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(capabilityCodes)) {
            viewIds = this.viewCapabilityRelationDas.getViewIdByCapabilityCodes(new ArrayList(capabilityCodes));
        }
        return viewIds;
    }

    private void validateSettingViewParam(String code, String name, Long id, boolean isCreateViewMethod) {
        if (isCreateViewMethod) {
            SettingViewEo queryCodeEo = new SettingViewEo();
            queryCodeEo.setCode(code);
            Assert.isTrue((this.settingViewDas.count((BaseEo)queryCodeEo) == 0 ? 1 : 0) != 0, (String)"\u914d\u7f6e\u89c6\u56fe\u7f16\u7801\u91cd\u590d,\u8bf7\u91cd\u8f93");
            SettingViewEo queryNameEo = new SettingViewEo();
            queryNameEo.setName(name);
            Assert.isTrue((this.settingViewDas.count((BaseEo)queryNameEo) == 0 ? 1 : 0) != 0, (String)"\u914d\u7f6e\u89c6\u56fe\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            SettingViewEo queryNameEo = new SettingViewEo();
            queryNameEo.setName(name);
            List settingViewEos = this.settingViewDas.select((BaseEo)queryNameEo);
            if (!CollectionUtils.isEmpty((Collection)settingViewEos)) {
                Assert.isTrue((settingViewEos.size() == 1 ? 1 : 0) != 0, (String)"\u914d\u7f6e\u89c6\u56fe\u91cd\u590d");
                if (!((SettingViewEo)settingViewEos.get(0)).getId().equals(id)) {
                    throw new BizException("\u914d\u7f6e\u89c6\u56fe\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
                }
            }
        }
    }

    List<SettingValueEo> getParentLevelValue(String bizSpaceCode, String bizIdCode, Long currentTenantId, List<String> settingCodes) {
        List<Object> globalSettingValues = new ArrayList<SettingValueEo>();
        if (StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            Long globalTenantId = this.userTenantService.getGlobalTenantId();
            if (currentTenantId.equals(globalTenantId)) {
                return globalSettingValues;
            }
            globalSettingValues = this.settingValueDas.getTenantSettingValueByCondition(settingCodes, globalTenantId);
        } else if (StringUtils.isNotBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            globalSettingValues = this.settingValueDas.getTenantSettingValueByCondition(settingCodes, currentTenantId);
        } else if (StringUtils.isNotBlank((CharSequence)bizIdCode)) {
            globalSettingValues = this.settingValueDas.getBizSpaceSettingValueByCondition(settingCodes, currentTenantId, bizSpaceCode);
        }
        return globalSettingValues;
    }

    private Comparator<ViewSettingTreeDto> getViewSettingTreeDtoComparator() {
        Comparator<ViewSettingTreeDto> bySortASC = Comparator.comparing(ViewSettingTreeDto::getSort, Comparator.nullsLast(Integer::compareTo));
        Comparator<ViewSettingTreeDto> byCodeASC = Comparator.comparing(ViewSettingTreeDto::getCode, String.CASE_INSENSITIVE_ORDER);
        return bySortASC.thenComparing(byCodeASC);
    }

    private Comparator<SettingValueTreeRespDto> getSettingValueTreeRespDtoComparator() {
        Comparator<SettingValueTreeRespDto> bySortASC = Comparator.comparing(ViewSettingTreeDto::getSort, Comparator.nullsLast(Integer::compareTo));
        Comparator<SettingValueTreeRespDto> byCodeASC = Comparator.comparing(ViewSettingTreeDto::getCode, String.CASE_INSENSITIVE_ORDER);
        return bySortASC.thenComparing(byCodeASC);
    }

    private List<String> getBundleCodes() {
        Long globalTenantId = this.userTenantService.getGlobalTenantId();
        Long currentTenantId = this.userTenantService.getCurrentTenantId();
        if (null != globalTenantId && globalTenantId.equals(currentTenantId)) {
            return this.bundleService.getEnableBundleCodes(Constants.ENABLE);
        }
        if (null != currentTenantId) {
            return this.bundleService.getTenantEnableBundleCodes(currentTenantId);
        }
        return null;
    }

    private boolean validateInputSettingValueScope(String settingCode, String settingValue) {
        SettingEo settingEo = this.settingService.queryEoByCode(settingCode);
        if (settingEo != null && StringUtils.isNotBlank((CharSequence)settingEo.getValueScope()) && StringUtils.isNotBlank((CharSequence)settingValue)) {
            return IntervalUtil.isInTheInterval(settingValue, settingEo.getValueScope());
        }
        return true;
    }
}

