/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.yundt.cube.center.func.api.dto.request.ITreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class TreeBuilder<T extends ITreeNode> {
    public List<T> buildByParentKey(List<T> src, Boolean isCompleteParentNode) {
        return this.buildByParentKey(src, isCompleteParentNode, null);
    }

    public List<T> buildByParentKey(List<T> src, Boolean isCompleteParentNode, Comparator<T> comparator) {
        if (null == src || 0 == src.size()) {
            return src;
        }
        if (isCompleteParentNode.booleanValue()) {
            src = this.completeParentNode(src);
        }
        Map<String, ITreeNode> map4node = src.stream().collect(Collectors.toMap(ITreeNode::getKey, t -> t, (k1, k2) -> k1));
        ArrayList<ITreeNode> resultList = new ArrayList<ITreeNode>();
        for (ITreeNode node : src) {
            if (null == node.getChildren()) {
                node.setChildren(new ArrayList());
            }
            if (node.isRootNode().booleanValue()) {
                resultList.add(node);
                continue;
            }
            ITreeNode parentNode = map4node.get(node.getParentKey());
            if (null != parentNode) {
                if (null == parentNode.getChildren()) {
                    parentNode.setChildren(new ArrayList());
                }
                parentNode.addChild((Object)node);
                continue;
            }
            resultList.add(node);
        }
        this.sortList(resultList, comparator);
        return resultList;
    }

    private void sortList(List<T> nodeList, Comparator<T> comparator) {
        if (null == nodeList || 0 == nodeList.size()) {
            return;
        }
        nodeList = this.sort(nodeList, comparator);
        nodeList.forEach(node -> this.sortList(node.getChildren(), comparator));
    }

    protected List<T> sort(List<T> nodeList, Comparator<T> comparator) {
        if (comparator != null) {
            Collections.sort(nodeList, comparator);
        } else {
            Collections.sort(nodeList);
        }
        return nodeList;
    }

    protected List<T> completeParentNode(List<T> src) {
        List<T> missingParentNodeList;
        Set<String> missingParentKeySet = this.missingParentKey(src);
        if (0 != missingParentKeySet.size() && null != (missingParentNodeList = this.queryNodeByKeys(missingParentKeySet)) && 0 != missingParentNodeList.size()) {
            src.addAll(missingParentNodeList);
            this.completeParentNode(src);
        }
        return src;
    }

    private Set<String> missingParentKey(List<T> src) {
        Map<String, String> map4node = src.stream().collect(Collectors.toMap(ITreeNode::getKey, ITreeNode::getKey));
        HashSet<String> missingParentKeySet = new HashSet<String>();
        for (ITreeNode node : src) {
            if (node.isRootNode().booleanValue() || map4node.containsKey(node.getParentKey())) continue;
            missingParentKeySet.add(node.getParentKey());
        }
        if (CollectionUtils.isNotEmpty(missingParentKeySet)) {
            missingParentKeySet.remove("");
            missingParentKeySet.remove(null);
        }
        return missingParentKeySet;
    }

    protected List<T> queryNodeByKeys(Set<String> keySet) {
        return new ArrayList();
    }
}

