/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.util;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.AbstractBaseDas;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.func.biz.util.SqlFilterBuilder;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public interface IDataImporter<EO extends CubeBaseEo, DTO, CODE, PRIMARY> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IDataImporter.class);

    public EO newEo();

    public CODE getCodeFromEo(EO var1);

    public CODE getCodeFromDto(DTO var1);

    default public void batchImport(int rule, List<DTO> dtoList, Date createDate, String key, AbstractBaseDas<EO, PRIMARY> abstractBaseDas) {
        HashMap importMap = Maps.newHashMap();
        for (DTO item : dtoList) {
            EO eo = this.newEo();
            BeanUtils.copyProperties(item, eo);
            this.commonFieldsSet(createDate, (CubeBaseEo)eo);
            importMap.put(this.getCodeFromDto(item), eo);
        }
        if (ImportRuleType.COVER.getCode() == rule) {
            LOGGER.info("\u8986\u76d6\u6a21\u5f0f");
            if (MapUtils.isNotEmpty((Map)importMap)) {
                long bt = System.currentTimeMillis();
                abstractBaseDas.delete(this.getParam((BaseEo)this.newEo(), key, importMap.keySet()));
                LOGGER.info("\u5220\u9664\u65e7\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - bt));
            }
        } else if (ImportRuleType.SKIP.getCode() == rule) {
            LOGGER.info("\u8df3\u8fc7\u6a21\u5f0f");
            CubeBaseEo selectParam = (CubeBaseEo)this.getParam((BaseEo)this.newEo(), key, importMap.keySet());
            List existedList = abstractBaseDas.select((BaseEo)selectParam);
            if (CollectionUtils.isNotEmpty((Collection)existedList)) {
                for (CubeBaseEo existedEo : existedList) {
                    importMap.remove(this.getCodeFromEo(existedEo));
                }
            }
        }
        if (MapUtils.isNotEmpty((Map)importMap)) {
            abstractBaseDas.insertBatch(new ArrayList(importMap.values()));
        }
    }

    default public <T extends BaseEo, K> T getParam(T t, String key, Collection<K> keys) {
        t.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter(key, keys).get());
        return t;
    }

    default public <T extends CubeBaseEo> void commonFieldsSet(Date createDate, T eo) {
        eo.setCreatePerson("\u7cfb\u7edf\u5bfc\u5165");
        eo.setUpdatePerson("\u7cfb\u7edf\u5bfc\u5165");
        eo.setExtension("");
        eo.setCreateTime(createDate);
        eo.setUpdateTime(new Date());
    }

    public static enum ImportRuleType {
        COVER(0),
        SKIP(1);

        private static Map<Integer, ImportRuleType> codeMapping;
        private final int code;

        private ImportRuleType(int code) {
            this.code = code;
        }

        public static ImportRuleType fromCode(int code) {
            return codeMapping.get(code);
        }

        public int getCode() {
            return this.code;
        }

        static {
            codeMapping = new HashMap<Integer, ImportRuleType>();
            for (ImportRuleType type : ImportRuleType.values()) {
                codeMapping.put(type.code, type);
            }
        }
    }
}

