/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.mq;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionImplScanReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionScanReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamItemReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamReqDto;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtensionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtensionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamItemEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="SYS_PARAM_JSON_MQ")
public class SysParamJsonMqProcess
implements IMessageProcessor<JSONObject> {
    private static final Logger logger = LoggerFactory.getLogger(SysParamJsonMqProcess.class);
    private static final String FORMAT = "[^\\u4E00-\\u9FA5\\uF900-\\uFA2D\\w-_]";
    @Resource
    private ICacheService cacheService;
    @Resource
    private SysParamDas sysParamDas;
    @Resource
    private SysParamItemDas sysParamItemDas;
    @Resource
    private BizExtensionDas bizExtensionDas;
    @Resource
    private BizExtImplDas bizExtImplDas;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(JSONObject jsonObject) {
        if (jsonObject != null && !jsonObject.isEmpty()) {
            logger.info("\u5f00\u59cb\u5904\u7406json\u6587\u4ef6\u6570\u636e\uff1a" + jsonObject.toJSONString());
            List<SysParamReqDto> sysParamReqDtos = this.getSysParamJsonReqDto(jsonObject);
            List<BizExtensionScanReqDto> bizExtensionScanReqDtos = this.getBizExtensionReqDto(jsonObject);
            Set<String> sysParamKeySet = new HashSet<String>();
            HashSet<String> extensionKeySet = new HashSet<String>();
            try {
                if (CollectionUtils.isNotEmpty(sysParamReqDtos)) {
                    Map<String, List<SysParamReqDto>> sysParamCodeMap = this.getSysParamCodeMap(sysParamReqDtos);
                    sysParamKeySet = sysParamCodeMap.keySet();
                    this.addCache(sysParamKeySet);
                }
                if (CollectionUtils.isNotEmpty(bizExtensionScanReqDtos)) {
                    Set<String> extensionKeys = bizExtensionScanReqDtos.stream().filter(r -> r.getBextCode() != null).map(BizExtensionScanReqDto::getBextCode).collect(Collectors.toSet());
                    this.addCache(extensionKeys);
                }
                this.handleSysParam(sysParamReqDtos);
                this.handleBizExtension(bizExtensionScanReqDtos);
                logger.info("json\u6587\u4ef6\u6570\u636e\u5904\u7406\u6210\u529f\uff1a" + jsonObject.toJSONString());
            }
            catch (Exception e) {
                throw new BizException("\u6570\u636e\u5904\u7406\u9519\u8bef\uff1a" + e.getMessage());
            }
            finally {
                this.removeCache(sysParamKeySet);
                this.removeCache(extensionKeySet);
            }
        } else {
            throw new BizException("JSONObject\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        return MessageResponse.SUCCESS;
    }

    private List<BizExtensionScanReqDto> getBizExtensionReqDto(JSONObject jsonObject) {
        ArrayList<BizExtensionScanReqDto> bizExtensionScanReqDtos = new ArrayList<BizExtensionScanReqDto>();
        Date date = new Date();
        JSONArray jsonArray = jsonObject.getJSONArray("extensions");
        if (jsonArray != null && !jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                BizExtensionScanReqDto bizExtensionScanReqDto = new BizExtensionScanReqDto();
                ArrayList<BizExtensionImplScanReqDto> bizExtensionImplScanReqDtos = new ArrayList<BizExtensionImplScanReqDto>();
                bizExtensionScanReqDto.setBextCode(jsonArray.getJSONObject(i).getString("code"));
                bizExtensionScanReqDto.setBextDesc(jsonArray.getJSONObject(i).getString("description"));
                bizExtensionScanReqDto.setBextName(jsonArray.getJSONObject(i).getString("description"));
                bizExtensionScanReqDto.setSource(jsonArray.getJSONObject(i).getString("source"));
                bizExtensionScanReqDto.setPriority(jsonArray.getJSONObject(i).getInteger("priority"));
                bizExtensionScanReqDto.setCurVerReleaseTime(date);
                String version = jsonArray.getJSONObject(i).getString("version");
                bizExtensionScanReqDto.setCurVer(version);
                JSONArray implJSONArray = jsonArray.getJSONObject(i).getJSONArray("impls");
                if (implJSONArray != null && !implJSONArray.isEmpty()) {
                    for (int j = 0; j < implJSONArray.size(); ++j) {
                        BizExtensionImplScanReqDto bizExtensionImplScanReqDto = new BizExtensionImplScanReqDto();
                        bizExtensionImplScanReqDto.setBextCode(bizExtensionScanReqDto.getBextCode());
                        bizExtensionImplScanReqDto.setBextImplCode(implJSONArray.getJSONObject(i).getString("code"));
                        bizExtensionImplScanReqDto.setBextImplDesc(implJSONArray.getJSONObject(i).getString("description"));
                        bizExtensionImplScanReqDto.setCurVer(version);
                        bizExtensionImplScanReqDto.setCurVerReleaseTime(date);
                        bizExtensionImplScanReqDtos.add(bizExtensionImplScanReqDto);
                    }
                    bizExtensionScanReqDto.setBizExtensionImplScanReqDtos(bizExtensionImplScanReqDtos);
                }
                bizExtensionScanReqDtos.add(bizExtensionScanReqDto);
            }
        }
        return bizExtensionScanReqDtos;
    }

    private List<SysParamReqDto> getSysParamJsonReqDto(JSONObject jsonObject) {
        ArrayList<SysParamReqDto> sysParamReqDtos = new ArrayList<SysParamReqDto>();
        JSONArray jsonArray = jsonObject.getJSONArray("parameters");
        if (jsonArray != null && !jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                SysParamReqDto sysParamReqDto = new SysParamReqDto();
                ArrayList<SysParamItemReqDto> sysParamItemReqDtos = new ArrayList<SysParamItemReqDto>();
                sysParamReqDto.setCode(jsonArray.getJSONObject(i).getString("code"));
                sysParamReqDto.setGroupCode(jsonArray.getJSONObject(i).getString("groupCode"));
                sysParamReqDto.setSelectType(jsonArray.getJSONObject(i).getInteger("selectType"));
                sysParamReqDto.setDefaultValue(jsonArray.getJSONObject(i).getString("defaultValue"));
                sysParamReqDto.setValueType(jsonArray.getJSONObject(i).getInteger("valueType"));
                sysParamReqDto.setName(jsonArray.getJSONObject(i).getString("description"));
                sysParamReqDto.setDescription(jsonArray.getJSONObject(i).getString("description"));
                sysParamReqDto.setSource(jsonArray.getJSONObject(i).getString("source"));
                sysParamReqDto.setGrade(Integer.valueOf(0));
                sysParamReqDto.setExtension("");
                sysParamReqDto.setReversion(jsonArray.getJSONObject(i).getString("version"));
                JSONObject valuesJSONObject = jsonArray.getJSONObject(i).getJSONObject("availableValues");
                if (valuesJSONObject != null && !valuesJSONObject.isEmpty()) {
                    for (String itemCode : valuesJSONObject.keySet()) {
                        SysParamItemReqDto sysParamItemReqDto = new SysParamItemReqDto();
                        sysParamItemReqDto.setParamCode(sysParamReqDto.getCode());
                        if (this.checkItemCode(itemCode)) {
                            sysParamItemReqDto.setItemCode(DigestUtils.md2Hex((String)itemCode));
                        } else {
                            sysParamItemReqDto.setItemCode(itemCode);
                        }
                        sysParamItemReqDto.setParamValue(itemCode);
                        String valueDesc = valuesJSONObject.getString(itemCode);
                        sysParamItemReqDto.setValueDesc(valueDesc);
                        sysParamItemReqDto.setExtension("");
                        sysParamItemReqDto.setSortNo(Integer.valueOf(0));
                        sysParamItemReqDtos.add(sysParamItemReqDto);
                    }
                    sysParamReqDto.setSysParamItemList(sysParamItemReqDtos);
                }
                sysParamReqDtos.add(sysParamReqDto);
            }
        }
        return sysParamReqDtos;
    }

    private boolean checkItemCode(String itemCode) {
        Pattern pattern = Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(itemCode);
        if (matcher.find()) {
            return true;
        }
        return itemCode.length() > 128;
    }

    private Map<String, List<SysParamReqDto>> getSysParamCodeMap(List<SysParamReqDto> sysParamReqDtos) {
        HashMap<String, List<SysParamReqDto>> sysParamReqDtoMap = new HashMap<String, List<SysParamReqDto>>();
        for (SysParamReqDto sysParamReqDto : sysParamReqDtos) {
            if (!StringUtils.isNotBlank((CharSequence)sysParamReqDto.getCode())) continue;
            String keyCode = sysParamReqDto.getCode().substring(0, sysParamReqDto.getCode().lastIndexOf(":") + 1);
            ArrayList<SysParamReqDto> list = new ArrayList<SysParamReqDto>();
            if (CollectionUtils.isNotEmpty((Collection)((Collection)sysParamReqDtoMap.get(keyCode)))) {
                list.addAll((Collection)sysParamReqDtoMap.get(keyCode));
            }
            list.add(sysParamReqDto);
            sysParamReqDtoMap.put(keyCode, list);
        }
        return sysParamReqDtoMap;
    }

    private void handleBizExtension(List<BizExtensionScanReqDto> bizExtensionScanReqDtos) {
        if (CollectionUtils.isNotEmpty(bizExtensionScanReqDtos)) {
            ArrayList<BizExtensionEo> bizExtensionUpdateEos = new ArrayList<BizExtensionEo>();
            ArrayList<BizExtensionEo> bizExtensionInsertEos = new ArrayList<BizExtensionEo>();
            ArrayList<BizExtImplEo> bizExtImplUpdateEos = new ArrayList<BizExtImplEo>();
            ArrayList<BizExtImplEo> bizExtImplInsertEos = new ArrayList<BizExtImplEo>();
            for (BizExtensionScanReqDto bizExtensionScanReqDto : bizExtensionScanReqDtos) {
                BizExtensionEo bizExtensionQueryEo = new BizExtensionEo();
                bizExtensionQueryEo.setBextCode(bizExtensionScanReqDto.getBextCode());
                List bizExtensionEos = this.bizExtensionDas.select((BaseEo)bizExtensionQueryEo);
                BizExtensionEo bizExtensionEo = new BizExtensionEo();
                DtoHelper.dto2Eo((BaseVo)bizExtensionScanReqDto, (BaseEo)bizExtensionEo);
                if (CollectionUtils.isNotEmpty((Collection)bizExtensionEos)) {
                    bizExtensionEo.setId(((BizExtensionEo)bizExtensionEos.get(0)).getId());
                    bizExtensionUpdateEos.add(bizExtensionEo);
                } else {
                    bizExtensionInsertEos.add(bizExtensionEo);
                }
                for (BizExtensionImplScanReqDto bizExtensionImplScanReqDto : bizExtensionScanReqDto.getBizExtensionImplScanReqDtos()) {
                    BizExtImplEo bizExtImplQueryEo = new BizExtImplEo();
                    bizExtImplQueryEo.setBextCode(bizExtensionImplScanReqDto.getBextCode());
                    bizExtImplQueryEo.setBextImplCode(bizExtensionImplScanReqDto.getBextImplCode());
                    List bizExtImplEos = this.bizExtImplDas.select((BaseEo)bizExtImplQueryEo);
                    BizExtImplEo bizExtImplEo = new BizExtImplEo();
                    DtoHelper.dto2Eo((BaseVo)bizExtensionImplScanReqDto, (BaseEo)bizExtImplEo);
                    if (CollectionUtils.isNotEmpty((Collection)bizExtImplEos)) {
                        bizExtImplEo.setId(((BizExtImplEo)bizExtImplEos.get(0)).getId());
                        bizExtImplUpdateEos.add(bizExtImplEo);
                        continue;
                    }
                    bizExtImplInsertEos.add(bizExtImplEo);
                }
            }
            for (BizExtensionEo bizExtensionEo : bizExtensionUpdateEos) {
                this.bizExtensionDas.updateSelective((BaseEo)bizExtensionEo);
            }
            this.bizExtensionDas.insertBatch(bizExtensionInsertEos);
            for (BizExtImplEo bizExtImplEo : bizExtImplUpdateEos) {
                this.bizExtImplDas.updateSelective((BaseEo)bizExtImplEo);
            }
            this.bizExtImplDas.insertBatch(bizExtImplInsertEos);
        }
    }

    private void handleSysParam(List<SysParamReqDto> sysParamReqDtos) {
        if (CollectionUtils.isNotEmpty(sysParamReqDtos)) {
            ArrayList<SysParamEo> sysParamUpdateList = new ArrayList<SysParamEo>();
            ArrayList<SysParamEo> sysParamInsertList = new ArrayList<SysParamEo>();
            ArrayList<SysParamItemEo> sysParamItemUpdateList = new ArrayList<SysParamItemEo>();
            ArrayList<SysParamItemEo> sysParamItemInsertList = new ArrayList<SysParamItemEo>();
            for (SysParamReqDto sysParamReqDto : sysParamReqDtos) {
                SysParamEo sysParamQueryEo = new SysParamEo();
                sysParamQueryEo.setCode(sysParamReqDto.getCode());
                List sysParamEos = this.sysParamDas.select((BaseEo)sysParamQueryEo);
                SysParamEo sysParamEo = new SysParamEo();
                DtoHelper.dto2Eo((BaseVo)sysParamReqDto, (BaseEo)sysParamEo);
                if (CollectionUtils.isNotEmpty((Collection)sysParamEos)) {
                    sysParamEo.setId(((SysParamEo)sysParamEos.get(0)).getId());
                    sysParamUpdateList.add(sysParamEo);
                } else {
                    sysParamInsertList.add(sysParamEo);
                }
                for (SysParamItemReqDto sysParamItemReqDto : sysParamReqDto.getSysParamItemList()) {
                    SysParamItemEo sysParamItemQueryEo = new SysParamItemEo();
                    sysParamItemQueryEo.setParamCode(sysParamReqDto.getCode());
                    sysParamItemQueryEo.setItemCode(sysParamItemReqDto.getItemCode());
                    List sysParamItemEos = this.sysParamItemDas.select((BaseEo)sysParamItemQueryEo);
                    SysParamItemEo sysParamItemEo = new SysParamItemEo();
                    DtoHelper.dto2Eo((BaseVo)sysParamItemReqDto, (BaseEo)sysParamItemEo);
                    if (CollectionUtils.isNotEmpty((Collection)sysParamEos)) {
                        sysParamItemEo.setId(((SysParamItemEo)sysParamItemEos.get(0)).getId());
                        sysParamItemUpdateList.add(sysParamItemEo);
                        continue;
                    }
                    sysParamItemInsertList.add(sysParamItemEo);
                }
            }
            for (SysParamEo sysParamEo : sysParamUpdateList) {
                this.sysParamDas.update((BaseEo)sysParamEo);
            }
            this.sysParamDas.insertBatch(sysParamInsertList);
            for (SysParamItemEo sysParamItemEo : sysParamItemUpdateList) {
                this.sysParamItemDas.update((BaseEo)sysParamItemEo);
            }
            this.sysParamItemDas.insertBatch(sysParamItemInsertList);
        }
    }

    private void addCache(Set<String> keySet) {
        for (String key : keySet) {
            boolean result = this.cacheService.setCache(key, (Object)key, 60);
            if (result) continue;
            throw new BizException("\u5f53\u524d\u9879\u76ee\u7248\u672c\u5df2\u6709\u91cd\u590d\u4efb\u52a1");
        }
    }

    private void removeCache(Set<String> keySet) {
        for (String key : keySet) {
            this.cacheService.delCache(key);
        }
    }
}

