/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityConfigReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityGroupTreeReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityOverviewQueryDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityRemoveDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionSingleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ConfigOverviewReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamSingleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityConfigDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityGroupRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityOverviewDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizExtensionQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SysParamRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.vo.AbilityConfigVo;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAbilityGroupService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAbilityService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizExtensionService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISysParamService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.TreeBuilder;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.vo.AbilityOverviewCacheVo;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityConfigRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityGroupDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtensionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceAbilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.CapabilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DocDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.GroupAbilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityGroupEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtensionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DocEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.GroupAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAbilityGroupEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizSpaceAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdGroupAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.vo.CapabilityAbilityOverviewVo;
import com.dtyunxi.yundt.cube.center.func.dao.vo.ConfigVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AbilityServiceImpl
implements IAbilityService {
    @Resource
    private AbilityDas abilityDas;
    @Resource
    private IAbilityGroupService iAbilityGroupService;
    @Resource
    private GroupAbilityRelationDas groupAbilityRelationDas;
    @Resource
    private AbilityGroupDas abilityGroupDas;
    @Resource
    private SysParamDas sysParamDas;
    @Resource
    private SysParamItemDas sysParamItemDas;
    @Resource
    private BizExtensionDas bizExtensionDas;
    @Resource
    private BizExtImplDas bizExtImplDas;
    @Resource
    private AbilityConfigRelationDas abilityConfigRelationDas;
    @Resource
    private BizSpaceAbilityRelationDas bizSpaceAbilityRelationDas;
    @Resource
    private DocDas docDas;
    @Resource
    private ISysParamService sysParamService;
    @Resource
    private IBizExtensionService bizExtensionService;
    @Resource
    private DomainDas domainDas;
    @Resource
    private CapabilityDas capabilityDas;
    @Resource
    private ICacheService cacheService;
    private static final String ABILITY_OVERVIEW_ROOT_CODE = "0";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addAbility(AbilityCreateReqDto reqDto) {
        if (null != reqDto.getStatus()) {
            if (!reqDto.getStatus().equals(AbilityConstants.ENABLE) && !reqDto.getStatus().equals(AbilityConstants.DISABLE)) {
                throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ": \u72b6\u6001\u8d4b\u503c\u4e0d\u6b63\u786e");
            }
        } else {
            reqDto.setStatus(AbilityConstants.ENABLE);
        }
        AbilityEo record = new AbilityEo();
        record.setCode(reqDto.getCode());
        if (this.abilityDas.count((BaseEo)record) > 0) {
            throw new BizException("\u80fd\u529b\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        }
        record = new AbilityEo();
        record.setName(reqDto.getName());
        if (this.abilityDas.count((BaseEo)record) > 0) {
            throw new BizException("\u80fd\u529b\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        }
        List sceneCodes = reqDto.getSceneCodes();
        List abilityGroupEos = this.abilityGroupDas.selectByCodes(sceneCodes, null, AbilityConstants.SCENE);
        if (sceneCodes.size() != abilityGroupEos.size()) {
            sceneCodes.removeAll(abilityGroupEos.stream().map(StdAbilityGroupEo::getCode).collect(Collectors.toList()));
            throw new BizException("\u4e0d\u5b58\u5728\u573a\u666f\u7f16\u7801\uff1a" + StringUtils.join((Iterable)sceneCodes, (String)","));
        }
        AbilityEo abilityEo = new AbilityEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)abilityEo);
        this.abilityDas.insert((BaseEo)abilityEo);
        List relationEos = sceneCodes.stream().map(e -> {
            GroupAbilityRelationEo relationEo = new GroupAbilityRelationEo();
            relationEo.setType(AbilityConstants.SCENE);
            relationEo.setAbilityGroupCode(e);
            relationEo.setAbilityCode(reqDto.getCode());
            relationEo.setExtension("");
            return relationEo;
        }).collect(Collectors.toList());
        this.groupAbilityRelationDas.insertBatch(relationEos);
        return abilityEo.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAbility(AbilityModifyReqDto reqDto) {
        List sceneCodes;
        if (null != reqDto.getStatus() && !reqDto.getStatus().equals(AbilityConstants.ENABLE) && !reqDto.getStatus().equals(AbilityConstants.DISABLE)) {
            throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ": \u72b6\u6001\u8d4b\u503c\u4e0d\u6b63\u786e");
        }
        AbilityEo abilityEo = this.abilityDas.selectByCode(reqDto.getCode());
        if (abilityEo == null) {
            throw new BizException("\u4e0d\u5b58\u5728\u80fd\u529b\u7f16\u7801\uff1a" + reqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            AbilityEo queryNameEo = new AbilityEo();
            queryNameEo.setName(reqDto.getName());
            List abilityEos = this.abilityDas.select((BaseEo)queryNameEo);
            if (CollectionUtils.isNotEmpty((Collection)abilityEos)) {
                if (abilityEos.size() == 1) {
                    AssertUtil.isTrue(((AbilityEo)abilityEos.get(0)).getId().equals(abilityEo.getId()), "\u80fd\u529b\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
                } else {
                    throw new BizException("\u4e00\u822c\u671f\u5f85\u53ea\u6709\u4e00\u6761\u6570\u636e");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(sceneCodes = reqDto.getSceneCodes()))) {
            List abilityGroupEos = this.abilityGroupDas.selectByCodes(sceneCodes, null, AbilityConstants.SCENE);
            if (CollectionUtils.isNotEmpty((Collection)sceneCodes) && sceneCodes.size() != abilityGroupEos.size()) {
                sceneCodes.removeAll(abilityGroupEos.stream().map(StdAbilityGroupEo::getCode).collect(Collectors.toList()));
                throw new BizException("\u4e0d\u5b58\u5728\u573a\u666f\u7f16\u7801\uff1a" + StringUtils.join((Iterable)sceneCodes, (String)","));
            }
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)abilityEo);
        this.abilityDas.updateSelective((BaseEo)abilityEo);
        if (CollectionUtils.isNotEmpty((Collection)sceneCodes)) {
            List oldRelationEos = this.groupAbilityRelationDas.selectByAbilityCodes(Collections.singletonList(reqDto.getCode()));
            List oldSceneCodes = oldRelationEos.stream().map(StdGroupAbilityRelationEo::getAbilityGroupCode).collect(Collectors.toList());
            List<Long> deleteIds = oldRelationEos.stream().filter(e -> !sceneCodes.contains(e.getAbilityGroupCode())).map(BaseEo::getId).collect(Collectors.toList());
            List inserts = sceneCodes.stream().filter(e -> !oldSceneCodes.contains(e)).map(e -> {
                GroupAbilityRelationEo relationEo = new GroupAbilityRelationEo();
                relationEo.setType(AbilityConstants.SCENE);
                relationEo.setAbilityGroupCode(e);
                relationEo.setAbilityCode(reqDto.getCode());
                relationEo.setExtension("");
                return relationEo;
            }).collect(Collectors.toList());
            if (deleteIds.size() > 0) {
                deleteIds.forEach(id -> this.groupAbilityRelationDas.logicDeleteById(id));
            }
            if (inserts.size() > 0) {
                this.groupAbilityRelationDas.insertBatch(inserts);
            }
        } else {
            GroupAbilityRelationEo groupAbilityRelationEo = new GroupAbilityRelationEo();
            groupAbilityRelationEo.setAbilityCode(abilityEo.getCode());
            this.groupAbilityRelationDas.logicDelete((BaseEo)groupAbilityRelationEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAbility(AbilityRemoveDto abilityRemoveDto) {
        String abilityCode = abilityRemoveDto.getCode();
        AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
        abilityConfigRelationEo.setAbilityCode(abilityCode);
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)this.abilityConfigRelationDas.select((BaseEo)abilityConfigRelationEo)), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u8be5\u80fd\u529b\u4e0b\u6709\u5173\u8054\u914d\u7f6e\u9879\uff0c\u4e0d\u80fd\u5220\u9664");
        BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
        bizSpaceAbilityRelationEo.setAbilityCode(abilityCode);
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)this.bizSpaceAbilityRelationDas.select((BaseEo)bizSpaceAbilityRelationEo)), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u8be5\u80fd\u529b\u5df2\u5173\u8054\u4e1a\u52a1\u7a7a\u95f4\uff0c\u4e0d\u80fd\u5220\u9664");
        AbilityEo abilityEo = new AbilityEo();
        DtoHelper.dto2Eo((BaseVo)abilityRemoveDto, (BaseEo)abilityEo);
        this.abilityDas.logicDelete((BaseEo)abilityEo);
        GroupAbilityRelationEo groupAbilityRelationEo = new GroupAbilityRelationEo();
        groupAbilityRelationEo.setAbilityCode(abilityRemoveDto.getCode());
        this.groupAbilityRelationDas.logicDelete((BaseEo)groupAbilityRelationEo);
    }

    @Override
    public AbilityQueryRespDto queryByCode(String code) {
        AbilityEo abilityEo = this.abilityDas.selectByCode(code);
        if (abilityEo == null) {
            throw new BizException("\u4e0d\u5b58\u5728\u80fd\u529b\u7f16\u7801\uff1a" + code);
        }
        AbilityQueryRespDto respDto = new AbilityQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)abilityEo, (BaseVo)respDto);
        List abilityGroupCodes = this.groupAbilityRelationDas.selectByAbilityCodes(Collections.singletonList(code)).stream().map(StdGroupAbilityRelationEo::getAbilityGroupCode).collect(Collectors.toList());
        if (abilityGroupCodes.size() > 0) {
            List list = this.abilityGroupDas.selectByCodes(abilityGroupCodes, null, AbilityConstants.SCENE).stream().map(e -> {
                AbilityGroupRespDto dto = new AbilityGroupRespDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)dto);
                return dto;
            }).collect(Collectors.toList());
            respDto.setScenes(list);
        }
        return respDto;
    }

    @Override
    public PageInfo<AbilityQueryRespDto> queryByPage(AbilityQueryReqDto abilityQueryReqDto, Integer pageNum, Integer pageSize) {
        AbilityEo queryEo = new AbilityEo();
        DtoHelper.dto2Eo((BaseVo)abilityQueryReqDto, (BaseEo)queryEo);
        PageInfo pageInfo = new PageInfo();
        if (StringUtils.isNotBlank((CharSequence)abilityQueryReqDto.getSceneCodes())) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            Object[] sceneCode = abilityQueryReqDto.getSceneCodes().split(",");
            ArrayList sceneCodes = new ArrayList(sceneCode.length);
            CollectionUtils.addAll(sceneCodes, (Object[])sceneCode);
            queryEo.setOrderByDesc("create_time");
            List abilityEos = this.abilityDas.selectAbilityEos(queryEo, sceneCodes);
            pageInfo = new PageInfo(abilityEos);
        } else {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            if (StringUtils.isNotBlank((CharSequence)abilityQueryReqDto.getCode())) {
                sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + abilityQueryReqDto.getCode() + "%")));
            }
            if (StringUtils.isNotBlank((CharSequence)abilityQueryReqDto.getName())) {
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + abilityQueryReqDto.getName() + "%")));
            }
            queryEo.setOrderByDesc("create_time");
            queryEo.setSqlFilters(sqlFilters);
            pageInfo = this.abilityDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), dtoList, AbilityQueryRespDto.class);
            for (AbilityQueryRespDto abilityQueryRespDto : dtoList) {
                GroupAbilityRelationEo groupAbilityRelationEo = new GroupAbilityRelationEo();
                groupAbilityRelationEo.setAbilityCode(abilityQueryRespDto.getCode());
                List groupAbilityRelationEos = this.groupAbilityRelationDas.select((BaseEo)groupAbilityRelationEo);
                if (CollectionUtils.isNotEmpty((Collection)groupAbilityRelationEos)) {
                    List abilityGroupCodes = groupAbilityRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityGroupCode())).map(StdGroupAbilityRelationEo::getAbilityGroupCode).collect(Collectors.toList());
                    List abilityGroupEos = this.abilityGroupDas.selectByCodes(abilityGroupCodes, null, AbilityConstants.SCENE);
                    ArrayList scenes = new ArrayList();
                    DtoHelper.eoList2DtoList((Collection)abilityGroupEos, scenes, AbilityGroupRespDto.class);
                    abilityQueryRespDto.setScenes(scenes);
                }
                AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
                abilityConfigRelationEo.setAbilityCode(abilityQueryRespDto.getCode());
                Integer configNum = this.abilityConfigRelationDas.count((BaseEo)abilityConfigRelationEo);
                abilityQueryRespDto.setConfigNum(configNum);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public AbilityOverviewDto queryAbilityOverview(AbilityOverviewQueryDto abilityOverviewQueryDto) {
        Integer domainOrSceneWithDoc = 0;
        if (null != abilityOverviewQueryDto && abilityOverviewQueryDto.getGroupWithDoc() == 1) {
            domainOrSceneWithDoc = 1;
        }
        ArrayList<AbilityOverviewDto> proccessrdTreeDtos = new ArrayList<AbilityOverviewDto>();
        AbilityOverviewDto rootDto = new AbilityOverviewDto();
        rootDto.setCode(ABILITY_OVERVIEW_ROOT_CODE);
        rootDto.setType(Integer.valueOf(0));
        rootDto.setName("\u9876\u7ea7\u8282\u70b9");
        rootDto.setSort(Integer.valueOf(0));
        rootDto.setChildren(new ArrayList());
        proccessrdTreeDtos.add(rootDto);
        List<AbilityOverviewDto> abilityOverviewDtos = this.getDomainAndSceneOverviewDtos(domainOrSceneWithDoc);
        if (CollectionUtils.isEmpty(abilityOverviewDtos)) {
            return rootDto;
        }
        proccessrdTreeDtos.addAll(abilityOverviewDtos);
        TreeBuilder<AbilityOverviewDto> treeBuilder = new TreeBuilder<AbilityOverviewDto>();
        List results = treeBuilder.buildByParentKey(proccessrdTreeDtos, false);
        if (CollectionUtils.isEmpty(results)) {
            return rootDto;
        }
        return (AbilityOverviewDto)results.get(0);
    }

    private List<AbilityOverviewDto> getDomainAndSceneOverviewDtos(Integer domainOrSceneWithDoc) {
        ArrayList<AbilityOverviewDto> abilityOverviewDtos;
        block9: {
            block7: {
                String abilityOverviewKey;
                block8: {
                    abilityOverviewDtos = new ArrayList<AbilityOverviewDto>();
                    if (null == domainOrSceneWithDoc || domainOrSceneWithDoc != 1) break block7;
                    abilityOverviewKey = "com.dtyunxi.yundt.cube.center.func.queryAbilityOverview";
                    String valueCache = (String)this.cacheService.getCache(abilityOverviewKey, String.class);
                    if (!StringUtils.isNotBlank((CharSequence)valueCache)) break block8;
                    List abilityOverviewCacheVos = JSONArray.parseArray((String)valueCache, AbilityOverviewCacheVo.class);
                    List docIds = abilityOverviewCacheVos.stream().map(AbilityOverviewCacheVo::getDocId).collect(Collectors.toList());
                    List docEos = this.docDas.queryByIds(docIds);
                    Map docId2DocMap = docEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
                    for (AbilityOverviewCacheVo v : abilityOverviewCacheVos) {
                        DocEo docEo = (DocEo)docId2DocMap.get(v.getDocId());
                        if (docEo == null || docEo.getStatus() == 0) continue;
                        AbilityOverviewDto abilityOverviewDto = new AbilityOverviewDto();
                        CubeBeanUtils.copyProperties((Object)abilityOverviewDto, (Object)v, (String[])new String[0]);
                        abilityOverviewDto.setStatus(Constants.ENABLE);
                        abilityOverviewDto.setDocId(docEo.getId());
                        abilityOverviewDto.setBrief(docEo.getBrief());
                        abilityOverviewDto.setDocName(docEo.getDocName());
                        abilityOverviewDto.setContent(docEo.getContent());
                        abilityOverviewDto.setDocUpdateTime(docEo.getUpdateTime());
                        abilityOverviewDtos.add(abilityOverviewDto);
                    }
                    break block9;
                }
                ArrayList<AbilityOverviewCacheVo> abilityOverviewCacheVos = new ArrayList<AbilityOverviewCacheVo>();
                List domainOverviewVos = this.docDas.queryDomainAbilityOverview();
                if (!CollectionUtils.isNotEmpty((Collection)domainOverviewVos)) break block9;
                ArrayList<String> domainCodes = new ArrayList<String>();
                Map code2DomainOverviewMap = domainOverviewVos.stream().collect(Collectors.toMap(CapabilityAbilityOverviewVo::getCode, Function.identity(), (k1, k2) -> k1));
                for (CapabilityAbilityOverviewVo overviewVo : code2DomainOverviewMap.values()) {
                    AbilityOverviewDto abilityOverviewDto = new AbilityOverviewDto();
                    CubeBeanUtils.copyProperties((Object)abilityOverviewDto, (Object)overviewVo, (String[])new String[0]);
                    abilityOverviewDtos.add(abilityOverviewDto);
                    domainCodes.add(overviewVo.getCode());
                    AbilityOverviewCacheVo domainOverviewCacheVo = new AbilityOverviewCacheVo();
                    CubeBeanUtils.copyProperties((Object)domainOverviewCacheVo, (Object)overviewVo, (String[])new String[0]);
                    abilityOverviewCacheVos.add(domainOverviewCacheVo);
                }
                List abilityOverviewVos = this.docDas.queryCapabilityAbilityOverview(domainCodes);
                if (CollectionUtils.isNotEmpty((Collection)abilityOverviewVos)) {
                    Map code2SceneOverviewMap = abilityOverviewVos.stream().collect(Collectors.toMap(CapabilityAbilityOverviewVo::getCode, Function.identity(), (k1, k2) -> k1));
                    for (CapabilityAbilityOverviewVo overviewVo : code2SceneOverviewMap.values()) {
                        AbilityOverviewDto abilityOverviewDto = new AbilityOverviewDto();
                        CubeBeanUtils.copyProperties((Object)abilityOverviewDto, (Object)overviewVo, (String[])new String[0]);
                        abilityOverviewDtos.add(abilityOverviewDto);
                        AbilityOverviewCacheVo sceneOverviewCacheVo = new AbilityOverviewCacheVo();
                        CubeBeanUtils.copyProperties((Object)sceneOverviewCacheVo, (Object)overviewVo, (String[])new String[0]);
                        abilityOverviewCacheVos.add(sceneOverviewCacheVo);
                    }
                }
                this.cacheService.add(abilityOverviewKey, (Object)JSON.toJSONString(abilityOverviewCacheVos), 900);
                break block9;
            }
            ArrayList<String> domainCodes = new ArrayList<String>();
            DomainEo domainEo = new DomainEo();
            List domainEos = this.domainDas.select((BaseEo)domainEo, Integer.valueOf(1), Integer.valueOf(64));
            for (DomainEo eo : domainEos) {
                AbilityOverviewDto domainDto = this.toAbilityOverviewDto(domainOrSceneWithDoc, eo.getCode(), eo.getName(), eo.getRemark(), Constants.ENABLE, ABILITY_OVERVIEW_ROOT_CODE, null);
                if (null == domainDto) continue;
                domainCodes.add(eo.getCode());
                abilityOverviewDtos.add(domainDto);
            }
            CapabilityEo capabilityEo = new CapabilityEo();
            capabilityEo.setParentCode("ROOT_NODE");
            capabilityEo.setStatus(Constants.ENABLE);
            if (CollectionUtils.isNotEmpty(domainCodes)) {
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"domain", (Object)StringUtils.join(domainCodes, (String)",")));
                capabilityEo.setSqlFilters(sqlFilters);
            }
            List capabilityEos = this.capabilityDas.select((BaseEo)capabilityEo, Integer.valueOf(1), Integer.valueOf(3000));
            for (CapabilityEo eo : capabilityEos) {
                AbilityOverviewDto abilityOverviewDto = this.toAbilityOverviewDto(domainOrSceneWithDoc, eo.getCode(), eo.getName(), eo.getDescr(), eo.getStatus(), eo.getDomain(), null);
                if (null == abilityOverviewDto) continue;
                abilityOverviewDtos.add(abilityOverviewDto);
            }
        }
        return abilityOverviewDtos;
    }

    private AbilityOverviewDto toAbilityOverviewDto(Integer domainOrSceneWithDoc, String code, String name, String remark, Integer status, String parentCode, Map<String, List<DocEo>> code2Doc) {
        AbilityOverviewDto abilityOverviewDto = new AbilityOverviewDto();
        abilityOverviewDto.setCode(code);
        abilityOverviewDto.setName(name);
        abilityOverviewDto.setRemark(remark);
        abilityOverviewDto.setStatus(status);
        abilityOverviewDto.setParentCode(parentCode);
        if (null != code2Doc && code2Doc.size() > 0) {
            List<DocEo> docEos = code2Doc.get(code);
            if (CollectionUtils.isEmpty(docEos) && domainOrSceneWithDoc == 1) {
                return null;
            }
            DocEo docEo = docEos.get(0);
            abilityOverviewDto.setDocId(docEo.getId());
            abilityOverviewDto.setDocName(docEo.getDocName());
            abilityOverviewDto.setBrief(docEo.getBrief());
            abilityOverviewDto.setContent(docEo.getContent());
            abilityOverviewDto.setDocUpdateTime(docEo.getUpdateTime());
        }
        return abilityOverviewDto;
    }

    @Override
    public List<AbilityOverviewDto> queryConfig(ConfigOverviewReqDto configOverviewReqDto) {
        List<String> abilityCodes = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)configOverviewReqDto.getCode())) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)configOverviewReqDto.getType()), CenterDataExceptionCode.PARAM_INVALID.getMsg());
            if ("bizSpace".equals(configOverviewReqDto.getType())) {
                BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
                bizSpaceAbilityRelationEo.setBizSpaceCode(configOverviewReqDto.getCode());
                List bizSpaceAbilityRelationEos = this.bizSpaceAbilityRelationDas.select((BaseEo)bizSpaceAbilityRelationEo);
                if (CollectionUtils.isNotEmpty((Collection)bizSpaceAbilityRelationEos)) {
                    abilityCodes = bizSpaceAbilityRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdBizSpaceAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
                }
            }
            if ("scene".equals(configOverviewReqDto.getType())) {
                GroupAbilityRelationEo groupAbilityRelationEo = new GroupAbilityRelationEo();
                groupAbilityRelationEo.setType(AbilityConstants.SCENE);
                groupAbilityRelationEo.setAbilityGroupCode(configOverviewReqDto.getCode());
                List groupAbilityRelationEos = this.groupAbilityRelationDas.select((BaseEo)groupAbilityRelationEo);
                if (CollectionUtils.isNotEmpty((Collection)groupAbilityRelationEos)) {
                    abilityCodes = groupAbilityRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdGroupAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
                }
            }
            if ("ability".equals(configOverviewReqDto.getType())) {
                abilityCodes.add(configOverviewReqDto.getCode());
            }
        } else {
            List sceneCodes;
            AbilityGroupTreeReqDto abilityGroupTreeReqDto = new AbilityGroupTreeReqDto();
            abilityGroupTreeReqDto.setStatus(AbilityConstants.ENABLE);
            abilityGroupTreeReqDto.setSort(AbilityConstants.TRUE);
            abilityGroupTreeReqDto.setType(AbilityConstants.SCENE);
            List<AbilityGroupEo> abilityGroupEos = this.iAbilityGroupService.queryAbilityGroupEos(abilityGroupTreeReqDto);
            if (CollectionUtils.isNotEmpty(abilityGroupEos) && CollectionUtils.isNotEmpty(sceneCodes = abilityGroupEos.stream().map(StdAbilityGroupEo::getCode).collect(Collectors.toList()))) {
                List groupAbilityRelationEos = this.groupAbilityRelationDas.selectByAbilityGroupCodes(sceneCodes, AbilityConstants.SCENE);
                abilityCodes = groupAbilityRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdGroupAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
            }
        }
        ArrayList<AbilityOverviewDto> abilityOverviewDtos = new ArrayList<AbilityOverviewDto>();
        if (CollectionUtils.isNotEmpty(abilityCodes)) {
            Map<String, ConfigVo> configMap = this.getConfigByAbilityCodes(abilityCodes);
            for (String abilityCode : configMap.keySet()) {
                List<AbilityOverviewDto> dtos = this.getConfig(configMap, abilityCode);
                abilityOverviewDtos.addAll(dtos);
            }
        }
        return abilityOverviewDtos;
    }

    private List<AbilityOverviewDto> getConfig(Map<String, ConfigVo> configMap, String abilityCode) {
        ConfigVo configVo = configMap.get(abilityCode);
        ArrayList<AbilityOverviewDto> abilityConfigTreeDtos = new ArrayList<AbilityOverviewDto>();
        if (null != configVo) {
            AbilityOverviewDto abilityConfigTreeDto;
            List sysParamEos = configVo.getSysParamEos();
            Map sysParamItemEos = configVo.getParamItemMap();
            List bizExceptions = configVo.getBizExtensionEos();
            Map bizExtImplEos = configVo.getBizExtImplMap();
            if (CollectionUtils.isNotEmpty((Collection)sysParamEos)) {
                for (SysParamEo sysParamEo : sysParamEos) {
                    abilityConfigTreeDto = new AbilityOverviewDto();
                    DtoHelper.eo2Dto((BaseEo)sysParamEo, (BaseVo)abilityConfigTreeDto);
                    abilityConfigTreeDto.setParentCode(abilityCode);
                    abilityConfigTreeDto.setType(Integer.valueOf(1));
                    List sysParamItems = (List)sysParamItemEos.get(sysParamEo.getCode());
                    if (CollectionUtils.isNotEmpty((Collection)sysParamItems)) {
                        List itemTrees = sysParamItems.stream().map(sysParamItemEo -> {
                            AbilityOverviewDto itemTree = new AbilityOverviewDto();
                            DtoHelper.eo2Dto((BaseEo)sysParamItemEo, (BaseVo)itemTree);
                            itemTree.setParentCode(sysParamItemEo.getParamCode());
                            itemTree.setCode(sysParamItemEo.getItemCode());
                            itemTree.setName(sysParamItemEo.getValueDesc());
                            return itemTree;
                        }).collect(Collectors.toList());
                        abilityConfigTreeDtos.addAll(itemTrees);
                    }
                    abilityConfigTreeDtos.add(abilityConfigTreeDto);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)bizExceptions)) {
                for (BizExtensionEo bizExtensionEo : bizExceptions) {
                    abilityConfigTreeDto = new AbilityOverviewDto();
                    DtoHelper.eo2Dto((BaseEo)bizExtensionEo, (BaseVo)abilityConfigTreeDto);
                    abilityConfigTreeDto.setCode(bizExtensionEo.getBextCode());
                    abilityConfigTreeDto.setParentCode(abilityCode);
                    abilityConfigTreeDto.setName(bizExtensionEo.getBextName());
                    abilityConfigTreeDto.setType(Integer.valueOf(2));
                    abilityConfigTreeDto.setSelectType(bizExtensionEo.getBextType());
                    List bizExtImpls = (List)bizExtImplEos.get(bizExtensionEo.getBextCode());
                    if (CollectionUtils.isNotEmpty((Collection)bizExtImpls)) {
                        List implTrees = bizExtImpls.stream().map(bizExtImplEo -> {
                            AbilityOverviewDto implTree = new AbilityOverviewDto();
                            DtoHelper.eo2Dto((BaseEo)bizExtImplEo, (BaseVo)implTree);
                            implTree.setParentCode(bizExtImplEo.getBextCode());
                            implTree.setCode(bizExtImplEo.getBextImplCode());
                            implTree.setName(bizExtImplEo.getBextImplName());
                            implTree.setRemark(bizExtImplEo.getBextImplDesc());
                            return implTree;
                        }).collect(Collectors.toList());
                        abilityConfigTreeDtos.addAll(implTrees);
                    }
                    abilityConfigTreeDtos.add(abilityConfigTreeDto);
                }
            }
        }
        return abilityConfigTreeDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processAbilityRelation(String code, Integer type, List<String> abilityCodes, Long tenantId) {
        List abilityEos = this.abilityDas.selectByCodes(abilityCodes, tenantId);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)abilityEos) && abilityEos.size() == abilityCodes.size(), CenterDataExceptionCode.RECORD_NOT_EXISTS + "\uff1a\u5173\u8054\u80fd\u529b\u4e0d\u5b58\u5728");
        AbilityConfigRelationEo queryRelationEo = new AbilityConfigRelationEo();
        queryRelationEo.setConfigCode(code);
        queryRelationEo.setType(type);
        List queryList = this.abilityConfigRelationDas.select((BaseEo)queryRelationEo);
        HashMap<String, String> abilityInsertMap = new HashMap<String, String>();
        for (String string : abilityCodes) {
            abilityInsertMap.put(string, string);
        }
        ArrayList<String> deleteAbilityCodes = new ArrayList<String>();
        if (abilityInsertMap.size() > 0) {
            for (AbilityConfigRelationEo relationEo : queryList) {
                if (abilityInsertMap.get(relationEo.getAbilityCode()) != null) continue;
                deleteAbilityCodes.add(relationEo.getAbilityCode());
            }
        }
        if (CollectionUtils.isNotEmpty(deleteAbilityCodes)) {
            BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"ability_code", (Object)StringUtils.join(deleteAbilityCodes, (String)",")));
            bizSpaceAbilityRelationEo.setSqlFilters(sqlFilters);
            List results = this.bizSpaceAbilityRelationDas.select((BaseEo)bizSpaceAbilityRelationEo);
            if (type.equals(AbilityConstants.PARAM)) {
                throw new BizException(CenterDataExceptionCode.RELATION_EXISTS.getCode(), "\u8be5\u4e1a\u52a1\u53c2\u6570\u5173\u8054\u7684\u80fd\u529b\u5df2\u88ab\u4e1a\u52a1\u7a7a\u95f4\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5173\u8054\u5173\u7cfb");
            }
            if (type.equals(AbilityConstants.EXTENSION)) {
                throw new BizException(CenterDataExceptionCode.RELATION_EXISTS.getCode(), "\u8be5\u6269\u5c55\u70b9\u5173\u8054\u7684\u80fd\u529b\u5df2\u88ab\u4e1a\u52a1\u7a7a\u95f4\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5173\u8054\u5173\u7cfb");
            }
        }
        AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
        abilityConfigRelationEo.setConfigCode(code);
        abilityConfigRelationEo.setType(type);
        this.abilityConfigRelationDas.delete((BaseEo)abilityConfigRelationEo);
        for (String abilityCode : abilityCodes) {
            abilityConfigRelationEo.setId(null);
            abilityConfigRelationEo.setAbilityCode(abilityCode);
            this.abilityConfigRelationDas.insert((BaseEo)abilityConfigRelationEo);
        }
    }

    @Override
    public List<AbilityConfigRelationEo> getAbilityConfigRelationEos(List<AbilityConfigVo> abilityConfigVos) {
        List<Object> abilityConfigRelationEos = new ArrayList<AbilityConfigRelationEo>();
        for (AbilityConfigVo abilityConfigVo : abilityConfigVos) {
            AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
            abilityConfigRelationEo.setConfigCode(abilityConfigVo.getConfigCode());
            abilityConfigRelationEo.setType(abilityConfigVo.getType());
            if (CollectionUtils.isNotEmpty((Collection)abilityConfigVo.getAbilityCodes())) {
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"ability_code", (Object)StringUtils.join((Iterable)abilityConfigVo.getAbilityCodes(), (String)",")));
                abilityConfigRelationEo.setSqlFilters(sqlFilters);
            }
            abilityConfigRelationEos = this.abilityConfigRelationDas.select((BaseEo)abilityConfigRelationEo);
        }
        return abilityConfigRelationEos;
    }

    @Override
    public AbilityConfigDto queryAbilityConfig(AbilityConfigReqDto abilityConfigReqDto) {
        AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
        abilityConfigRelationEo.setAbilityCode(abilityConfigReqDto.getCode());
        List abilityConfigRelationEos = this.abilityConfigRelationDas.select((BaseEo)abilityConfigRelationEo);
        ArrayList sysParamCodes = new ArrayList();
        ArrayList extCodes = new ArrayList();
        abilityConfigRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getConfigCode()) && r.getType() != null).map(relationEo -> {
            if (relationEo.getType().equals(AbilityConstants.PARAM)) {
                sysParamCodes.add(relationEo.getConfigCode());
            } else if (relationEo.getType().equals(AbilityConstants.EXTENSION)) {
                extCodes.add(relationEo.getConfigCode());
            }
            return null;
        }).collect(Collectors.toList());
        ArrayList sysParamRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty(sysParamCodes)) {
            SysParamSingleQueryReqDto sysParamSingleQueryReqDto = new SysParamSingleQueryReqDto();
            ArrayList<String> resList = new ArrayList<String>();
            String res = "item";
            resList.add(res);
            sysParamSingleQueryReqDto.setReses(resList);
            sysParamCodes.stream().map(s -> {
                SysParamRespDto sysParamRespDto = this.sysParamService.queryByCode((String)s, sysParamSingleQueryReqDto);
                sysParamRespDtos.add(sysParamRespDto);
                return null;
            }).collect(Collectors.toList());
        }
        ArrayList bizExtensionQueryRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty(extCodes)) {
            BizExtensionSingleQueryReqDto bizExtensionSingleQueryReqDto = new BizExtensionSingleQueryReqDto();
            bizExtensionSingleQueryReqDto.setRef("impl");
            extCodes.stream().map(e -> {
                BizExtensionQueryRespDto bizExtensionQueryRespDto = this.bizExtensionService.queryByCode((String)e, bizExtensionSingleQueryReqDto);
                bizExtensionQueryRespDtos.add(bizExtensionQueryRespDto);
                return null;
            }).collect(Collectors.toList());
        }
        AbilityConfigDto abilityConfigDto = new AbilityConfigDto();
        abilityConfigDto.setCode(abilityConfigReqDto.getCode());
        abilityConfigDto.setSysParamRespDtos(sysParamRespDtos);
        abilityConfigDto.setBizExtensionQueryRespDtos(bizExtensionQueryRespDtos);
        return abilityConfigDto;
    }

    @Override
    public Map<String, ConfigVo> getConfigByAbilityCodes(List<String> abilityCodes) {
        HashMap<String, ConfigVo> configMap = new HashMap<String, ConfigVo>();
        List abilityConfigRelationEos = this.abilityConfigRelationDas.selectByAbilityCodes(abilityCodes);
        if (CollectionUtils.isNotEmpty((Collection)abilityConfigRelationEos)) {
            Map<String, List<AbilityConfigRelationEo>> abilityCodeMap = abilityConfigRelationEos.stream().collect(Collectors.groupingBy(StdAbilityConfigRelationEo::getAbilityCode));
            for (String abilityCode : abilityCodeMap.keySet()) {
                List<AbilityConfigRelationEo> configRelationEos = abilityCodeMap.get(abilityCode);
                ConfigVo configVo = new ConfigVo();
                Map<Integer, List<AbilityConfigRelationEo>> typeMap = configRelationEos.stream().collect(Collectors.groupingBy(StdAbilityConfigRelationEo::getType));
                for (Integer type : typeMap.keySet()) {
                    Map<String, List<SysParamItemEo>> paramItemMap;
                    List configCodes = typeMap.get(type).stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getConfigCode())).map(StdAbilityConfigRelationEo::getConfigCode).collect(Collectors.toList());
                    if (type.equals(AbilityConstants.PARAM)) {
                        List sysParamEos = this.sysParamDas.selectByCodeList(configCodes);
                        configVo.setSysParamEos(sysParamEos);
                        List sysParamItemEos = this.sysParamItemDas.selectByParamCodes(configCodes);
                        paramItemMap = sysParamItemEos.stream().collect(Collectors.groupingBy(StdSysParamItemEo::getParamCode));
                        configVo.setParamItemMap(paramItemMap);
                    }
                    if (!type.equals(AbilityConstants.EXTENSION)) continue;
                    List bizExtensionEos = this.bizExtensionDas.selectByCodeList(configCodes);
                    configVo.setBizExtensionEos(bizExtensionEos);
                    List bizExtImplEos = this.bizExtImplDas.selectByBextCodes(configCodes);
                    paramItemMap = bizExtImplEos.stream().collect(Collectors.groupingBy(StdBizExtImplEo::getBextCode));
                    configVo.setBizExtImplMap(paramItemMap);
                }
                configMap.put(abilityCode, configVo);
            }
        }
        return configMap;
    }

    @Override
    public Map<String, List<AbilityEo>> getAbilityEos(List<String> relationCodes, Integer type) {
        HashMap<String, List<AbilityEo>> abilityMap = new HashMap<String, List<AbilityEo>>();
        List groupAbilityRelationEos = this.groupAbilityRelationDas.selectByAbilityGroupCodes(relationCodes, type);
        if (CollectionUtils.isNotEmpty((Collection)groupAbilityRelationEos)) {
            Map<String, List<GroupAbilityRelationEo>> map = groupAbilityRelationEos.stream().collect(Collectors.groupingBy(StdGroupAbilityRelationEo::getAbilityGroupCode));
            for (String abilityGroupCode : map.keySet()) {
                List<GroupAbilityRelationEo> relationEos = map.get(abilityGroupCode);
                List abilityCodes = relationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdGroupAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
                List abilityEos = this.abilityDas.selectByCodes(abilityCodes, null);
                if (!CollectionUtils.isNotEmpty((Collection)abilityEos)) continue;
                abilityMap.put(abilityGroupCode, abilityEos);
            }
        }
        return abilityMap;
    }

    @Override
    public void removeAbilityConfigRelation(String configCode, Integer type) {
        AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
        abilityConfigRelationEo.setConfigCode(configCode);
        abilityConfigRelationEo.setType(type);
        this.abilityConfigRelationDas.delete((BaseEo)abilityConfigRelationEo);
    }
}

