/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.dto.AppInstanceApiAuthStatusReqDto;
import com.dtyunxi.yundt.cube.center.data.enums.PermissionHolderTypeEnum;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstanceApiQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstanceApiReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstanceDtoQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiDetailRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppInstanceApiQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppInstanceDtoQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppInstanceDtoTreeRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.feign.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.func.biz.feign.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppInstanceApiService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizSpaceService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiPropPermissionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AppInstanceApiDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceAppInstanceRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiPropPermissionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AppInstanceApiEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceAppInstanceRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.CapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DomainAppEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdCapabilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdDomainAppEo;
import com.dtyunxi.yundt.cube.center.func.dao.mapper.AppInstanceApiMapper;
import com.dtyunxi.yundt.cube.center.func.dao.mapper.DomainAppMapper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AppInstanceApiServiceImpl
implements IAppInstanceApiService {
    private static final Logger logger = LoggerFactory.getLogger(AppInstanceApiServiceImpl.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("<([^>]+?)>");
    @Value(value="${api.access.auth.status:1}")
    private final Integer apiAuthStatus = 1;
    @Autowired
    private AppInstanceApiDas appInstanceApiDas;
    @Resource
    private AppInstanceApiMapper appInstanceApiMapper;
    @Resource
    private DomainAppMapper domainAppMapper;
    @Resource
    private ICapabilityService capabilityService;
    @Resource
    private ApiDas apiDas;
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Resource
    private BizSpaceAppInstanceRelationDas bizSpaceAppInstanceRelationDas;
    @Resource
    private IBizSpaceService bizSpaceService;
    @Resource
    private ApiPropPermissionDas apiPropPermissionDas;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAppInstanceApi(AppInstanceApiReqDto addReqDto) {
        this.paramsCheck(addReqDto);
        ArrayList<AppInstanceApiEo> instanceApiEoList = new ArrayList<AppInstanceApiEo>();
        for (AppInstanceApiReqDto.ApiReqDto apiReqDto : addReqDto.getApiList()) {
            AppInstanceApiEo instanceApiEo = this.getAppInstanceApiEo(addReqDto, apiReqDto);
            AppInstanceApiEo eo = (AppInstanceApiEo)this.appInstanceApiDas.selectOne((BaseEo)instanceApiEo);
            if (eo == null) {
                instanceApiEo.setApiName(apiReqDto.getApiName());
                instanceApiEo.setStatus(addReqDto.getStatus());
                instanceApiEo.setExtension("");
                instanceApiEoList.add(instanceApiEo);
                continue;
            }
            if (Objects.equals(eo.getStatus(), addReqDto.getStatus()) && Objects.equals(eo.getApiName(), apiReqDto.getApiName())) continue;
            eo.setStatus(addReqDto.getStatus());
            eo.setApiName(apiReqDto.getApiName());
            this.appInstanceApiDas.updateSelective((BaseEo)eo);
            this.delAppInstanceApiCache(addReqDto, eo);
        }
        if (!CollectionUtils.isEmpty(instanceApiEoList)) {
            this.appInstanceApiDas.insertBatch(instanceApiEoList);
        }
    }

    private void delAppInstanceApiCache(AppInstanceApiReqDto addReqDto, AppInstanceApiEo eo) {
        List<DomainAppEo> domainAppEoList = this.getDomainAppEoList(addReqDto.getModuleCode());
        String moduleCodeStr = null;
        if (!CollectionUtils.isEmpty(domainAppEoList)) {
            List domainList = domainAppEoList.stream().map(StdDomainAppEo::getDomain).collect(Collectors.toList());
            moduleCodeStr = org.apache.commons.lang3.StringUtils.join(domainList, (String)",");
        }
        String key = RedisKeyConstants.combineKey((String)"API_PERMISSION", (Object[])new Object[]{eo.getPath(), eo.getMethod(), moduleCodeStr, eo.getAppInstanceId(), eo.getStatus()});
        this.cacheService.delCache(key);
    }

    private AppInstanceApiEo getAppInstanceApiEo(AppInstanceApiReqDto addReqDto, AppInstanceApiReqDto.ApiReqDto apiReqDto) {
        AppInstanceApiEo instanceApiEo = new AppInstanceApiEo();
        instanceApiEo.setAppInstanceId(addReqDto.getAppInstanceId());
        instanceApiEo.setModuleCode(addReqDto.getModuleCode());
        instanceApiEo.setPath(apiReqDto.getPath());
        instanceApiEo.setMethod(apiReqDto.getMethod());
        return instanceApiEo;
    }

    private void paramsCheck(AppInstanceApiReqDto addReqDto) {
        List apiReqDtoList = addReqDto.getApiList();
        AssertUtil.isTrue(!CollectionUtils.isEmpty((Collection)apiReqDtoList), "API\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(addReqDto.getAppInstanceId() != null, "\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(!StringUtils.isEmpty((Object)addReqDto.getModuleCode()), "\u6240\u5c5e\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(addReqDto.getStatus() != null, "\u6388\u6743\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        for (AppInstanceApiReqDto.ApiReqDto apiReqDto : apiReqDtoList) {
            AssertUtil.isTrue(!StringUtils.isEmpty((Object)apiReqDto.getMethod()), "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(!StringUtils.isEmpty((Object)apiReqDto.getPath()), "API\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public PageInfo<AppInstanceApiQueryRespDto> queryByPage(AppInstanceApiQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        ApiEo apiEo = new ApiEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)apiEo);
        apiEo.setStatus(Integer.valueOf(1));
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (!StringUtils.isEmpty((Object)queryReqDto.getApiName())) {
            filters.add(SqlFilter.like((String)"api_name", (Object)("%" + queryReqDto.getApiName() + "%")));
            apiEo.setApiName(null);
        }
        if (!StringUtils.isEmpty((Object)queryReqDto.getPath())) {
            filters.add(SqlFilter.like((String)"path", (Object)("%" + queryReqDto.getPath() + "%")));
            apiEo.setPath(null);
        }
        if (!StringUtils.isEmpty((Object)queryReqDto.getFirstCapabilityCode())) {
            List<CapabilityEo> capabilityEoList = this.capabilityService.getChildrenEoByCapabilityCodeList(Arrays.asList(queryReqDto.getFirstCapabilityCode()));
            if (!CollectionUtils.isEmpty(capabilityEoList)) {
                List codeList = capabilityEoList.stream().map(StdCapabilityEo::getCode).collect(Collectors.toList());
                filters.add(SqlFilter.in((String)"capability_code", (Object)org.apache.commons.lang3.StringUtils.join(codeList, (String)",")));
                apiEo.setCapabilityCode(null);
            } else {
                return new PageInfo();
            }
        }
        apiEo.setSqlFilters(filters);
        apiEo.setOrderBy("module_code");
        PageInfo eoPageInfo = this.apiDas.selectPage((BaseEo)apiEo, pageNum, pageSize);
        PageInfo<AppInstanceApiQueryRespDto> dtoPageInfo = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, AppInstanceApiQueryRespDto.class);
        if (!CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            Integer status = this.getApiAuthStatusParam();
            List<AppInstanceApiEo> instanceApiEoList = this.getAppInstanceApiEoList(queryReqDto, status);
            block0: for (AppInstanceApiQueryRespDto respDto : dtoPageInfo.getList()) {
                respDto.setStatus(status);
                if (CollectionUtils.isEmpty(instanceApiEoList)) continue;
                for (AppInstanceApiEo eo : instanceApiEoList) {
                    if (!Objects.equals(respDto.getPath(), eo.getPath()) || !Objects.equals(respDto.getMethod(), eo.getMethod())) continue;
                    respDto.setStatus(eo.getStatus());
                    continue block0;
                }
            }
        }
        return dtoPageInfo;
    }

    private Integer getApiAuthStatusParam() {
        return this.apiAuthStatus;
    }

    private List<AppInstanceApiEo> getAppInstanceApiEoList(AppInstanceApiQueryReqDto queryReqDto, Integer status) {
        AppInstanceApiEo instanceApiEo = new AppInstanceApiEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)instanceApiEo);
        instanceApiEo.setApiName(null);
        instanceApiEo.setStatus(this.getInverseAuthStatus(status));
        if (!StringUtils.isEmpty((Object)queryReqDto.getPath())) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.like((String)"path", (Object)("%" + queryReqDto.getPath() + "%")));
            instanceApiEo.setPath(null);
            instanceApiEo.setSqlFilters(filters);
        }
        instanceApiEo.setOrderBy("module_code");
        return this.appInstanceApiDas.select((BaseEo)instanceApiEo);
    }

    private Integer getInverseAuthStatus(Integer status) {
        Integer inverseStatus = null;
        if (status != null) {
            inverseStatus = Constants.API_AUTH_ENABLE.equals(status) ? Constants.API_AUTH_DISABLE : Constants.API_AUTH_ENABLE;
        }
        return inverseStatus;
    }

    @Override
    public Boolean queryInstanceApiAuthStatus(AppInstanceApiAuthStatusReqDto queryReqDto) {
        AppInstanceApiEo eo = new AppInstanceApiEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)eo);
        Long instanceId = ServiceContext.getContext().getRequestInstanceId() == null ? queryReqDto.getInstanceId() : ServiceContext.getContext().getRequestInstanceId();
        queryReqDto.setInstanceId(instanceId);
        logger.info("queryInstanceApiAuthStatus request param:[{}]", (Object)JSONObject.toJSONString((Object)queryReqDto));
        eo.setAppInstanceId(instanceId);
        List<DomainAppEo> domainAppEoList = this.getDomainAppEoList(queryReqDto.getModuleCode());
        String moduleCodeStr = null;
        if (!CollectionUtils.isEmpty(domainAppEoList)) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            List domainList = domainAppEoList.stream().map(StdDomainAppEo::getDomain).collect(Collectors.toList());
            moduleCodeStr = org.apache.commons.lang3.StringUtils.join(domainList, (String)",");
            filters.add(SqlFilter.in((String)"module_code", (Object)moduleCodeStr));
            eo.setSqlFilters(filters);
            eo.setModuleCode(null);
        }
        Integer status = this.getApiAuthStatusParam();
        eo.setStatus(this.getInverseAuthStatus(status));
        String key = RedisKeyConstants.combineKey((String)"API_PERMISSION", (Object[])new Object[]{eo.getPath(), eo.getMethod(), moduleCodeStr, eo.getAppInstanceId(), eo.getStatus()});
        Boolean authStatus = (Boolean)this.cacheService.getCache(key, Boolean.class);
        if (authStatus == null) {
            authStatus = false;
            AppInstanceApiEo queryEo = (AppInstanceApiEo)this.appInstanceApiMapper.findColumn((BaseEo)eo, new String[]{"id"});
            if (Constants.API_AUTH_ENABLE.equals(status)) {
                if (queryEo == null) {
                    authStatus = true;
                }
            } else if (queryEo != null) {
                authStatus = true;
            }
            this.cacheService.setCache(key, (Object)authStatus, 1800);
        }
        return authStatus;
    }

    private List<DomainAppEo> getDomainAppEoList(String moduleCode) {
        String key = RedisKeyConstants.combineKey((String)"DOMAIN_APP_KEY", (Object[])new Object[]{moduleCode});
        String value = (String)this.cacheService.getCache(key, String.class);
        List domainAppEoList = null;
        if (!StringUtils.isEmpty((Object)value)) {
            domainAppEoList = JSON.parseArray((String)value, DomainAppEo.class);
        }
        if (CollectionUtils.isEmpty(domainAppEoList)) {
            DomainAppEo domainAppEo = new DomainAppEo();
            domainAppEo.setApplication(moduleCode);
            domainAppEoList = this.domainAppMapper.findListColumn((BaseEo)domainAppEo, new String[]{"id", "domain"});
            if (!CollectionUtils.isEmpty((Collection)domainAppEoList)) {
                this.cacheService.setCache(key, (Object)JSON.toJSONString((Object)domainAppEoList), 1800);
            }
        }
        return domainAppEoList;
    }

    @Override
    public AppInstanceDtoQueryRespDto queryDtoInfo(AppInstanceDtoQueryReqDto queryReqDto) {
        ApiEo apiEo;
        AssertUtil.isTrue(queryReqDto.getAppInstanceId() != null, "\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(queryReqDto.getApiId() != null, "API id\u4e0d\u80fd\u4e3a\u7a7a");
        AppInstanceDtoQueryRespDto respDto = new AppInstanceDtoQueryRespDto();
        AppInstanceDto appInstanceDto = (AppInstanceDto)((Object)this.applicationQueryApi.queryInsById(queryReqDto.getAppInstanceId(), null).getData());
        if (appInstanceDto != null) {
            respDto.setAppCode(appInstanceDto.getCode());
            respDto.setAppInsName(appInstanceDto.getAppInsName());
        }
        BizSpaceAppInstanceRelationEo relationEo = new BizSpaceAppInstanceRelationEo();
        relationEo.setAppInstanceId(queryReqDto.getAppInstanceId());
        BizSpaceAppInstanceRelationEo appInstanceRelationEo = (BizSpaceAppInstanceRelationEo)this.bizSpaceAppInstanceRelationDas.selectOne((BaseEo)relationEo);
        if (appInstanceRelationEo != null) {
            respDto.setBizSpaceCode(appInstanceRelationEo.getBizSpaceCode());
            BizSpaceReqDto bizSpaceReqDto = new BizSpaceReqDto();
            bizSpaceReqDto.setCode(appInstanceRelationEo.getBizSpaceCode());
            BizSpaceRespDto bizSpaceRespDto = this.bizSpaceService.queryByCode(bizSpaceReqDto);
            if (bizSpaceRespDto != null) {
                respDto.setBizSpaceName(bizSpaceRespDto.getName());
            }
        }
        if ((apiEo = (ApiEo)this.apiDas.selectByPrimaryKey(queryReqDto.getApiId())) != null) {
            respDto.setApiName(apiEo.getApiName());
            respDto.setPath(apiEo.getPath());
            ApiDetailRespDto.Param param = (ApiDetailRespDto.Param)JSONObject.parseObject((String)apiEo.getResponseParam(), ApiDetailRespDto.Param.class, (Feature[])new Feature[0]);
            String dtoCode = param.getType();
            ArrayList<AppInstanceDtoTreeRespDto> children = new ArrayList<AppInstanceDtoTreeRespDto>();
            if (dtoCode.contains("List<") || dtoCode.contains("PageInfo<")) {
                List properties = param.getProperties();
                if (!CollectionUtils.isEmpty((Collection)properties)) {
                    ApiDetailRespDto.Param param1 = (ApiDetailRespDto.Param)properties.get(0);
                    dtoCode = param1.getType();
                    param = param1;
                }
            } else {
                if (dtoCode.contains("RestResponse<java.util.Map")) {
                    return respDto;
                }
                if (dtoCode.contains("<")) {
                    Matcher matcher = PATH_PATTERN.matcher(dtoCode);
                    ArrayList<String> groupList = new ArrayList<String>();
                    while (matcher.find()) {
                        groupList.add(matcher.group());
                    }
                    if (!CollectionUtils.isEmpty(groupList)) {
                        for (String group : groupList) {
                            dtoCode = group.substring(1, group.length() - 1);
                        }
                    }
                }
            }
            ApiPropPermissionEo eo = new ApiPropPermissionEo();
            eo.setHolderType(Integer.valueOf(PermissionHolderTypeEnum.APPLICATION.getValue()));
            if (appInstanceDto != null) {
                eo.setHolderCode(appInstanceDto.getCode());
            }
            eo.setDtoCode(dtoCode);
            List permissionEoList = this.apiPropPermissionDas.select((BaseEo)eo);
            this.buildDtoTreeRespDto(children, param, 1, permissionEoList);
            respDto.setChildren(children);
            respDto.setDtoCode(dtoCode);
            if (!CollectionUtils.isEmpty((Collection)permissionEoList)) {
                respDto.setRemark(((ApiPropPermissionEo)permissionEoList.get(0)).getRemark());
            }
        }
        return respDto;
    }

    private List<AppInstanceDtoTreeRespDto> buildDtoTreeRespDto(List<AppInstanceDtoTreeRespDto> children, ApiDetailRespDto.Param param, int hierarchy, List<ApiPropPermissionEo> permissionEoList) {
        List properties = param.getProperties();
        if (!CollectionUtils.isEmpty((Collection)properties)) {
            for (ApiDetailRespDto.Param param2 : properties) {
                List properties2;
                ApiDetailRespDto.Param childrenParam = null;
                if (param2.getType().contains("List<") && !CollectionUtils.isEmpty((Collection)(properties2 = param2.getProperties()))) {
                    childrenParam = (ApiDetailRespDto.Param)properties2.get(0);
                    childrenParam.setName(param2.getName());
                }
                AppInstanceDtoTreeRespDto treeRespDto = new AppInstanceDtoTreeRespDto();
                if (hierarchy == 1) {
                    treeRespDto.setParentCode("0");
                } else {
                    treeRespDto.setParentCode(param.getName());
                }
                treeRespDto.setPropertyCode(param2.getName());
                treeRespDto.setName(param2.getDescription());
                treeRespDto.setDataType(param2.getType());
                treeRespDto.setHierarchy(Integer.valueOf(hierarchy));
                Integer status = this.getApiAuthStatusParam();
                treeRespDto.setStatus(status);
                if (!CollectionUtils.isEmpty(permissionEoList)) {
                    for (ApiPropPermissionEo eo : permissionEoList) {
                        if (!Objects.equals(eo.getPropertyCode(), param2.getName()) || !Objects.equals(hierarchy, eo.getHierarchy())) continue;
                        treeRespDto.setStatus(eo.getStatus());
                        treeRespDto.setId(eo.getId());
                        treeRespDto.setParentId(eo.getParentId());
                        break;
                    }
                }
                treeRespDto.setChildren(this.buildDtoTreeRespDto(new ArrayList<AppInstanceDtoTreeRespDto>(), childrenParam == null ? param2 : childrenParam, hierarchy + 1, permissionEoList));
                children.add(treeRespDto);
            }
        }
        return children;
    }
}

