/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.constants.ExtensionSelectType;
import com.dtyunxi.yundt.cube.center.func.api.constants.GradeType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingEditType;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingExtptExecMechanism;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingValueType;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtImplCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtImplRemoveDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtImplValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionImplModifyDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionImplModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionImplReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtensionSingleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizExtImplRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizExtImplValueRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizExtensionQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ConfigImportDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ConfigImportFailDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAbilityService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizExtensionService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.vo.BizExtensionImportVo;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityConfigRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtensionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ConfigScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtensionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ConfigScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplValueEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizExtensionServiceImpl
implements IBizExtensionService {
    private static final String FORMAT = "[^\\u4E00-\\u9FA5\\uF900-\\uFA2D\\w-_]";
    private static final String EXT_PART_IMPORT_SUCCESS = "4505";
    @Resource
    private BizExtensionDas bizExtensionDas;
    @Resource
    private BizExtImplDas bizExtImplDas;
    @Resource
    private BizExtImplValueDas bizExtImplValueDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IAbilityService iAbilityService;
    @Resource
    private AbilityDas abilityDas;
    @Resource
    private ConfigScopeDas configScopeDas;
    @Resource
    private BizExtImplScopeDas bizExtImplScopeDas;
    @Resource
    private AbilityConfigRelationDas abilityConfigRelationDas;
    @Resource
    private SettingDas settingDas;
    @Resource
    private SettingOptionDas settingOptionDas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addBizExtension(BizExtensionCreateReqDto addReqDto) {
        if (!this.checkFeild(addReqDto)) {
            throw new BizException("\u68c0\u67e5\u53c2\u6570\u5b57\u6bb5\u662f\u5426\u4e3a\u7a7a\u6216\u957f\u5ea6\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (StringUtils.isBlank((CharSequence)addReqDto.getBextCode()) || CollectionUtils.isEmpty((Collection)addReqDto.getBizExtensionImplReqDtos())) {
            throw new BizException("\u914d\u7f6e\u9879\u7f16\u7801\u6216\u914d\u7f6e\u9879\u9009\u9879\u8bf7\u6c42\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String bextCode = addReqDto.getBextCode();
        List bizExtensionImplReqDtos = addReqDto.getBizExtensionImplReqDtos();
        boolean result = this.cacheService.setCache(bextCode, (Object)bextCode, 60);
        if (!result) {
            throw new BizException("\u5f53\u524d\u9879\u76ee\u7248\u672c\u5df2\u6709\u91cd\u590d\u4efb\u52a1");
        }
        try {
            if (CollectionUtils.isNotEmpty((Collection)bizExtensionImplReqDtos)) {
                HashMap<String, String> bextImplCodeMap = new HashMap<String, String>();
                HashMap<String, String> bextImplNameMap = new HashMap<String, String>();
                for (BizExtensionImplReqDto implDto : bizExtensionImplReqDtos) {
                    if (!BizExtensionServiceImpl.checkImplCodeFormat(implDto.getBextImplCode())) {
                        throw new BizException(CenterDataExceptionCode.PARAM_INVALID.getCode(), "\u6269\u5c55\u70b9\u5b9e\u73b0code\u4e0d\u80fd\u4e3a\u7a7a\u6216\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e200");
                    }
                    String bextImplCode = implDto.getBextImplCode();
                    String bextImplName = implDto.getBextImplName();
                    AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bextImplName), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0name\u4e0d\u80fd\u4e3anull");
                    AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)bextImplCodeMap.get(bextImplCode))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0\u7f16\u7801\u5165\u53c2\u91cd\u590d");
                    bextImplCodeMap.put(bextImplCode, bextImplCode);
                    AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)bextImplNameMap.get(bextImplName))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0\u540d\u79f0\u5165\u53c2\u91cd\u590d");
                    bextImplNameMap.put(bextImplName, bextImplName);
                }
            }
            BizExtensionEo queryEo = new BizExtensionEo();
            queryEo.setBextCode(bextCode);
            if (this.bizExtensionDas.count((BaseEo)queryEo) > 0) {
                throw new BizException("\u6269\u5c55\u70b9\u5df2\u5b58\u5728");
            }
            BizExtensionEo bizExtensionEoName = new BizExtensionEo();
            bizExtensionEoName.setBextName(addReqDto.getBextName());
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)this.bizExtensionDas.select((BaseEo)bizExtensionEoName)), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u6269\u5c55\u70b9\u540d\u79f0\u91cd\u590d");
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)addReqDto.getAbilityCodes()), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u80fd\u529b");
            List abilityCodes = addReqDto.getAbilityCodes();
            List abilityEos = this.abilityDas.selectByCodes(abilityCodes, addReqDto.getTenantId());
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)abilityEos) && abilityEos.size() == abilityCodes.size(), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg() + "\uff1a\u5173\u8054\u80fd\u529b\u4e0d\u5b58\u5728");
            ArrayList<AbilityConfigRelationEo> abilityConfigRelationEos = new ArrayList<AbilityConfigRelationEo>();
            for (String abilityCode : abilityCodes) {
                AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
                abilityConfigRelationEo.setConfigCode(addReqDto.getBextCode());
                abilityConfigRelationEo.setType(AbilityConstants.EXTENSION);
                abilityConfigRelationEo.setAbilityCode(abilityCode);
                abilityConfigRelationEo.setExtension("");
                abilityConfigRelationEos.add(abilityConfigRelationEo);
            }
            this.abilityConfigRelationDas.insertBatch(abilityConfigRelationEos);
            BizExtensionEo bizExtensionEo = new BizExtensionEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)bizExtensionEo);
            bizExtensionEo.setCurVerReleaseTime(new Date());
            if (addReqDto.getGrade() == null) {
                bizExtensionEo.setGrade(Integer.valueOf(GradeType.APPINSTANCE.getCode()));
            }
            this.bizExtensionDas.insert((BaseEo)bizExtensionEo);
            if (CollectionUtils.isNotEmpty((Collection)bizExtensionImplReqDtos)) {
                ArrayList insertEos = new ArrayList();
                DtoHelper.dtoList2EoList((Collection)bizExtensionImplReqDtos, insertEos, BizExtImplEo.class);
                for (BizExtImplEo eo : insertEos) {
                    eo.setBextCode(bizExtensionEo.getBextCode());
                }
                this.bizExtImplDas.insertBatch(insertEos);
            }
            String string = bizExtensionEo.getBextCode();
            return string;
        }
        finally {
            this.cacheService.delCache(bextCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportDto importBizExtension(List<BizExtensionCreateReqDto> importReqDtoList, Integer portion) {
        List<SettingOptionEo> settingOptionEos;
        List<SettingEo> settingEos;
        BizExtensionImportVo bizExtensionImportVo;
        boolean part = false;
        if (portion != null && portion.equals(1)) {
            part = true;
        }
        ConfigImportDto configImportDto = new ConfigImportDto();
        ArrayList<ConfigImportFailDto> configImportFailDtos = new ArrayList<ConfigImportFailDto>();
        ArrayList<BizExtensionCreateReqDto> feildError = new ArrayList<BizExtensionCreateReqDto>();
        HashMap<String, BizExtensionCreateReqDto> errorExt = new HashMap<String, BizExtensionCreateReqDto>();
        HashMap<String, BizExtensionCreateReqDto> code2Ext = new HashMap<String, BizExtensionCreateReqDto>();
        HashMap name2Etx = new HashMap();
        block0: for (BizExtensionCreateReqDto bizExtensionCreateReqDto : importReqDtoList) {
            List bizExtensionImplReqDtos;
            SettingEo queryEo;
            if (bizExtensionCreateReqDto.getBextType() == null) {
                bizExtensionCreateReqDto.setBextType(Integer.valueOf(ExtensionSelectType.SINGLE_SELECT.getCode()));
            }
            if (!this.checkFeild(bizExtensionCreateReqDto)) {
                feildError.add(bizExtensionCreateReqDto);
                continue;
            }
            String bextCode = bizExtensionCreateReqDto.getBextCode();
            if (code2Ext.get(bextCode) != null) {
                errorExt.put(bextCode, bizExtensionCreateReqDto);
            } else {
                queryEo = new SettingEo();
                queryEo.setCode(bextCode);
                if (this.settingDas.count((BaseEo)queryEo) > 0) {
                    errorExt.put(bextCode, bizExtensionCreateReqDto);
                } else {
                    code2Ext.put(bextCode, bizExtensionCreateReqDto);
                }
            }
            if (name2Etx.get(bizExtensionCreateReqDto.getBextName()) != null) {
                errorExt.put(bizExtensionCreateReqDto.getBextName(), bizExtensionCreateReqDto);
            } else {
                queryEo = new SettingEo();
                queryEo.setName(bizExtensionCreateReqDto.getBextName());
                if (this.settingDas.count((BaseEo)queryEo) > 0) {
                    errorExt.put(bextCode, bizExtensionCreateReqDto);
                } else {
                    code2Ext.put(bextCode, bizExtensionCreateReqDto);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)(bizExtensionImplReqDtos = bizExtensionCreateReqDto.getBizExtensionImplReqDtos()))) continue;
            Set implCodes = bizExtensionImplReqDtos.stream().map(BizExtensionImplReqDto::getBextImplCode).collect(Collectors.toSet());
            if (implCodes != null && implCodes.size() != bizExtensionImplReqDtos.size()) {
                errorExt.put(bextCode, bizExtensionCreateReqDto);
            }
            HashMap<String, BizExtensionImplReqDto> hashMap = new HashMap<String, BizExtensionImplReqDto>();
            HashMap<String, BizExtensionImplReqDto> bextImplNameMap = new HashMap<String, BizExtensionImplReqDto>();
            for (BizExtensionImplReqDto implDto : bizExtensionImplReqDtos) {
                if (!BizExtensionServiceImpl.checkImplCodeFormat(implDto.getBextImplCode())) {
                    errorExt.put(bextCode, bizExtensionCreateReqDto);
                    continue block0;
                }
                if (StringUtils.isBlank((CharSequence)implDto.getBextImplName())) {
                    errorExt.put(bextCode, bizExtensionCreateReqDto);
                    continue block0;
                }
                if (hashMap.get(implDto.getBextImplCode()) != null) {
                    errorExt.put(bextCode, bizExtensionCreateReqDto);
                    continue block0;
                }
                hashMap.put(implDto.getBextImplCode(), implDto);
                if (bextImplNameMap.get(implDto.getBextImplName()) != null) {
                    errorExt.put(bextCode, bizExtensionCreateReqDto);
                    continue block0;
                }
                bextImplNameMap.put(implDto.getBextImplName(), implDto);
            }
        }
        List<BizExtensionEo> bizExtensionInsertEos = new ArrayList<BizExtensionEo>();
        List<BizExtImplEo> bizExtImplInsertEos = new ArrayList<BizExtImplEo>();
        ArrayList<Object> errorDtoList = new ArrayList<BizExtensionCreateReqDto>();
        if (errorExt.size() > 0) {
            errorDtoList = new ArrayList(errorExt.values());
        }
        if (CollectionUtils.isNotEmpty(feildError)) {
            errorDtoList.addAll(feildError);
        }
        if (errorDtoList.size() > 0 && errorDtoList.size() == importReqDtoList.size()) {
            configImportDto.setResultCode(CenterDataExceptionCode.CONFIG_IMPORT_ALL_FAIL.getCode());
            configImportDto.setResultMsg("\u63d0\u4ea4\u5931\u8d25\uff0c\u5168\u90e8\u6269\u5c55\u70b9\u5df2\u5b58\u5728\u6216\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
            configImportDto.setData(configImportFailDtos);
        } else if (errorDtoList.size() > 0 && errorDtoList.size() != importReqDtoList.size()) {
            if (part) {
                importReqDtoList.removeAll(errorDtoList);
                bizExtensionImportVo = this.proccessInsertEo(importReqDtoList);
                bizExtensionInsertEos = bizExtensionImportVo.getBizExtensionEos();
                bizExtImplInsertEos = bizExtensionImportVo.getBizExtImplEoList();
                configImportDto.setResultCode(EXT_PART_IMPORT_SUCCESS);
                configImportDto.setResultMsg("\u90e8\u5206\u6269\u5c55\u70b9\u5bfc\u5165\u65b0\u589e\u6210\u529f");
                for (BizExtensionCreateReqDto bizExtensionCreateReqDto : errorDtoList) {
                    ConfigImportFailDto configImportFailDto = new ConfigImportFailDto();
                    configImportFailDto.setCode(bizExtensionCreateReqDto.getBextCode());
                    configImportFailDto.setName(bizExtensionCreateReqDto.getBextName());
                    configImportFailDtos.add(configImportFailDto);
                }
                configImportDto.setData(configImportFailDtos);
            } else {
                configImportDto.setResultCode(CenterDataExceptionCode.CONFIG_IMPORT_PART_FAIL.getCode());
                configImportDto.setResultMsg("\u63d0\u4ea4\u5931\u8d25\uff0c\u90e8\u5206\u6269\u5c55\u70b9\u5df2\u5b58\u5728\u6216\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
                configImportDto.setData(configImportFailDtos);
            }
        } else if (errorDtoList.size() == 0) {
            bizExtensionImportVo = this.proccessInsertEo(importReqDtoList);
            bizExtensionInsertEos = bizExtensionImportVo.getBizExtensionEos();
            bizExtImplInsertEos = bizExtensionImportVo.getBizExtImplEoList();
            configImportDto.setResultCode("0");
            configImportDto.setResultMsg("\u5bfc\u5165\u6210\u529f");
            configImportDto.setData(configImportFailDtos);
        }
        if (CollectionUtils.isNotEmpty(bizExtensionInsertEos) && CollectionUtils.isNotEmpty(settingEos = this.bizExtension2Setting(bizExtensionInsertEos))) {
            this.settingDas.insertBatch(settingEos);
        }
        if (CollectionUtils.isNotEmpty(bizExtImplInsertEos) && CollectionUtils.isNotEmpty(settingOptionEos = this.bizExtImpl2SettingOption(bizExtImplInsertEos))) {
            this.settingOptionDas.insertBatch(settingOptionEos);
        }
        return configImportDto;
    }

    private List<SettingEo> bizExtension2Setting(List<BizExtensionEo> bizExtensionInsertEos) {
        ArrayList<SettingEo> settingEos = new ArrayList<SettingEo>();
        for (BizExtensionEo bizExtensionEo : bizExtensionInsertEos) {
            SettingEo settingEo = new SettingEo();
            settingEo.setCode(bizExtensionEo.getBextCode());
            settingEo.setName(bizExtensionEo.getBextName());
            settingEo.setDescr(bizExtensionEo.getBextDesc());
            settingEo.setValueType(Integer.valueOf(SettingValueType.SPIEXTPT.getCode()));
            settingEo.setEditType(Integer.valueOf(SettingEditType.CHOICE.getCode()));
            settingEo.setDisplayLevel(Integer.valueOf(3));
            settingEo.setViewVisible(Integer.valueOf(1));
            settingEo.setIsControlled(Integer.valueOf(1));
            settingEo.setCapabilityCode(bizExtensionEo.getCapabilityCode());
            if (bizExtensionEo.getBextType() != null) {
                if (bizExtensionEo.getBextType().equals(ExtensionSelectType.SINGLE_SELECT.getCode())) {
                    settingEo.setIsMultiChoice(Integer.valueOf(0));
                } else if (bizExtensionEo.getBextType().equals(ExtensionSelectType.MULTI_PARALLEL.getCode())) {
                    settingEo.setIsMultiChoice(Integer.valueOf(1));
                    settingEo.setExecMechanism(Integer.valueOf(SettingExtptExecMechanism.SEQUENTIAL.getCode()));
                } else if (bizExtensionEo.getBextType().equals(ExtensionSelectType.Multi_SERIAL.getCode())) {
                    settingEo.setIsMultiChoice(Integer.valueOf(1));
                    settingEo.setExecMechanism(Integer.valueOf(SettingExtptExecMechanism.PARALLEL.getCode()));
                }
            }
            settingEo.setExtension("");
            settingEos.add(settingEo);
        }
        return settingEos;
    }

    private List<SettingOptionEo> bizExtImpl2SettingOption(List<BizExtImplEo> bizExtImplInsertEos) {
        ArrayList<SettingOptionEo> settingOptionEos = new ArrayList<SettingOptionEo>();
        for (BizExtImplEo implEo : bizExtImplInsertEos) {
            SettingOptionEo settingOptionEo = new SettingOptionEo();
            settingOptionEo.setSettingCode(implEo.getBextCode());
            settingOptionEo.setCode(implEo.getBextImplCode());
            settingOptionEo.setName(implEo.getBextImplName());
            settingOptionEo.setOptionValue(implEo.getBextImplCode());
            settingOptionEo.setDescr(implEo.getBextImplDesc());
            settingOptionEo.setExtension("");
            settingOptionEos.add(settingOptionEo);
        }
        return settingOptionEos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBizExtension(String bextCode, BizExtensionModifyReqDto modifyReqDto) {
        List bizExtensionImplModifyDtos = modifyReqDto.getBizExtensionImplModifyDtos();
        if (CollectionUtils.isNotEmpty((Collection)bizExtensionImplModifyDtos)) {
            List bextImplCodes = bizExtensionImplModifyDtos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBextImplCode())).map(BizExtensionImplModifyDto::getBextImplCode).collect(Collectors.toList());
            HashMap<String, String> bextImplCodeMap = new HashMap<String, String>();
            HashMap<String, String> bextImplNameMap = new HashMap<String, String>();
            for (BizExtensionImplModifyDto implDto : bizExtensionImplModifyDtos) {
                Iterator bextImplCode = implDto.getBextImplCode();
                String bextImplName = implDto.getBextImplName();
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)((Object)bextImplCode)), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0code\u4e0d\u80fd\u4e3anull");
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bextImplName), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0name\u4e0d\u80fd\u4e3anull");
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)bextImplCodeMap.get(bextImplCode))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0\u7f16\u7801\u5165\u53c2\u91cd\u590d");
                bextImplCodeMap.put((String)((Object)bextImplCode), (String)((Object)bextImplCode));
                AssertUtil.isTrue(StringUtils.isBlank((CharSequence)((CharSequence)bextImplNameMap.get(bextImplName))), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0\u540d\u79f0\u5165\u53c2\u91cd\u590d");
                bextImplNameMap.put(bextImplName, bextImplName);
                BizExtImplEo bizExtImplName = new BizExtImplEo();
                bizExtImplName.setBextImplName(implDto.getBextImplName());
                bizExtImplName.setBextCode(bextCode);
                List resultsName = this.bizExtImplDas.select((BaseEo)bizExtImplName);
                if (!CollectionUtils.isNotEmpty((Collection)resultsName)) continue;
                if (resultsName.size() > 1) {
                    throw new BizException("\u5bf9\u5e94\u6570\u636e\u8fc7\u591a,\u4e00\u822c\u671f\u5f85\u53ea\u6709\u4e00\u4e2a\u6570\u636e");
                }
                String implCode = ((BizExtImplEo)resultsName.get(0)).getBextImplCode();
                if (implCode.equals(implDto.getBextImplCode()) || !bextImplCodes.contains(implCode)) continue;
                throw new BizException(CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getCode(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u6269\u5c55\u70b9\u5b9e\u73b0\u540d\u79f0\u91cd\u590d");
            }
        }
        BizExtensionEo bizExtensionEo = new BizExtensionEo();
        bizExtensionEo.setBextCode(bextCode);
        List bizExtensionEos = this.bizExtensionDas.select((BaseEo)bizExtensionEo);
        if (CollectionUtils.isEmpty((Collection)bizExtensionEos)) {
            throw new BizException("\u5bf9\u5e94\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (bizExtensionEos.size() > 1) {
            throw new BizException("\u5bf9\u5e94\u6570\u636e\u8fc7\u591a,\u4e00\u822c\u671f\u5f85\u53ea\u6709\u4e00\u4e2a\u6570\u636e");
        }
        if (StringUtils.isNotBlank((CharSequence)modifyReqDto.getBextName())) {
            BizExtensionEo bizExtensionName = new BizExtensionEo();
            bizExtensionName.setBextName(modifyReqDto.getBextName());
            List resultsName = this.bizExtensionDas.select((BaseEo)bizExtensionName);
            if (CollectionUtils.isNotEmpty((Collection)resultsName)) {
                if (resultsName.size() > 1) {
                    throw new BizException("\u5bf9\u5e94\u6570\u636e\u8fc7\u591a,\u4e00\u822c\u671f\u5f85\u53ea\u6709\u4e00\u4e2a\u6570\u636e");
                }
                if (!((BizExtensionEo)resultsName.get(0)).getBextCode().equals(modifyReqDto.getBextCode())) {
                    throw new BizException(CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getCode(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u6269\u5c55\u70b9\u540d\u79f0\u91cd\u590d");
                }
            }
        }
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAbilityCodes()), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u80fd\u529b");
        this.iAbilityService.processAbilityRelation(bextCode, AbilityConstants.EXTENSION, modifyReqDto.getAbilityCodes(), null);
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)bizExtensionEo, (String[])new String[]{"bext_code"});
        bizExtensionEo.setId(((BizExtensionEo)bizExtensionEos.get(0)).getId());
        this.bizExtensionDas.updateSelective((BaseEo)bizExtensionEo);
        List queryList = this.bizExtImplDas.selectByBextCodeAndBextImplCodes(bextCode, new ArrayList());
        List<String> deleteExtImplCodes = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)bizExtensionImplModifyDtos) && CollectionUtils.isNotEmpty((Collection)queryList)) {
            deleteExtImplCodes = queryList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBextImplCode())).map(StdBizExtImplEo::getBextImplCode).collect(Collectors.toList());
        } else if (CollectionUtils.isNotEmpty((Collection)bizExtensionImplModifyDtos) && CollectionUtils.isNotEmpty((Collection)queryList)) {
            HashMap<String, String> implInsertMap = new HashMap<String, String>();
            for (BizExtensionImplModifyDto imlModifyDto : bizExtensionImplModifyDtos) {
                String implCode = imlModifyDto.getBextImplCode();
                implInsertMap.put(implCode, implCode);
            }
            if (implInsertMap.size() > 0) {
                for (BizExtImplEo implEo : queryList) {
                    if (implInsertMap.get(implEo.getBextImplCode()) != null) continue;
                    deleteExtImplCodes.add(implEo.getBextImplCode());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(deleteExtImplCodes)) {
            this.checkExsitBizSpaceRelation(bextCode, deleteExtImplCodes);
        }
        BizExtImplEo bizExtImplEo = new BizExtImplEo();
        bizExtImplEo.setBextCode(bizExtensionEo.getBextCode());
        this.bizExtImplDas.logicDelete((BaseEo)bizExtImplEo);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getBizExtensionImplModifyDtos())) {
            ArrayList<BizExtImplEo> bizExtImplEos = new ArrayList<BizExtImplEo>();
            for (BizExtensionImplModifyDto bizExtensionImplModifyDto : modifyReqDto.getBizExtensionImplModifyDtos()) {
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bizExtensionImplModifyDto.getBextImplCode()), CenterDataExceptionCode.PARAM_INVALID.getMsg());
                BizExtImplEo insertImplEo = new BizExtImplEo();
                DtoHelper.dto2Eo((BaseVo)bizExtensionImplModifyDto, (BaseEo)insertImplEo);
                insertImplEo.setBextCode(bizExtensionEo.getBextCode());
                bizExtImplEos.add(insertImplEo);
            }
            this.bizExtImplDas.insertBatch(bizExtImplEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBizExtension(String bextCode) {
        this.checkExsitBizSpaceRelation(bextCode, new ArrayList<String>());
        BizExtensionEo bizExtensionEo = new BizExtensionEo();
        bizExtensionEo.setBextCode(bextCode);
        this.bizExtensionDas.logicDeleteByExample((BaseEo)bizExtensionEo);
        BizExtImplEo bizExtImplEo = new BizExtImplEo();
        bizExtImplEo.setBextCode(bextCode);
        this.bizExtImplDas.logicDeleteByExample((BaseEo)bizExtImplEo);
        this.iAbilityService.removeAbilityConfigRelation(bextCode, AbilityConstants.EXTENSION);
    }

    private void checkExsitBizSpaceRelation(String bextCode, List<String> bextImplCodes) {
        ConfigScopeEo configScopeEo = new ConfigScopeEo();
        configScopeEo.setConfigCode(bextCode);
        configScopeEo.setType(AbilityConstants.EXTENSION);
        if (CollectionUtils.isNotEmpty(bextImplCodes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"config_item_code", (Object)StringUtils.join(bextImplCodes, (String)",")));
            configScopeEo.setSqlFilters(sqlFilters);
        }
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)this.configScopeDas.select((BaseEo)configScopeEo)), CenterDataExceptionCode.RELATION_EXISTS.getMsg() + ":\u8be5\u6269\u5c55\u70b9\u88ab\u4e1a\u52a1\u7a7a\u95f4\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addBizExtImpl(BizExtImplCreateReqDto bizExtImplCreateReqDto) {
        if (StringUtils.isBlank((CharSequence)bizExtImplCreateReqDto.getBextCode()) || StringUtils.isBlank((CharSequence)bizExtImplCreateReqDto.getBextImplCode())) {
            throw new BizException("\u6269\u5c55\u70b9\u6216\u6269\u5c55\u70b9\u5b9e\u73b0\u4e0d\u80fd\u4e3anull");
        }
        BizExtImplEo bizExtImplEo = new BizExtImplEo();
        bizExtImplEo.setBextCode(bizExtImplCreateReqDto.getBextCode());
        bizExtImplEo.setBextImplCode(bizExtImplCreateReqDto.getBextImplCode());
        if (this.bizExtImplDas.count((BaseEo)bizExtImplEo) > 0) {
            throw new BizException("\u6269\u5c55\u70b9\u5b9e\u73b0\u5df2\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)bizExtImplCreateReqDto, (BaseEo)bizExtImplEo);
        this.bizExtImplDas.insert((BaseEo)bizExtImplEo);
        return bizExtImplEo.getBextImplCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBizExtImpl(BizExtensionImplModifyReqDto bizExtensionImplModifyReqDto) {
        BizExtImplEo bizExtImplEo = new BizExtImplEo();
        bizExtImplEo.setBextCode(bizExtensionImplModifyReqDto.getBextCode());
        bizExtImplEo.setBextImplCode(bizExtensionImplModifyReqDto.getBextImplCode());
        List bizExtImplEos = this.bizExtImplDas.select((BaseEo)bizExtImplEo);
        if (CollectionUtils.isEmpty((Collection)bizExtImplEos)) {
            BizExtImplEo insertEo = new BizExtImplEo();
            DtoHelper.dto2Eo((BaseVo)bizExtensionImplModifyReqDto, (BaseEo)insertEo);
            this.bizExtImplDas.insert((BaseEo)bizExtImplEo);
        } else if (bizExtImplEos.size() > 1) {
            throw new BizException("\u5bf9\u5e94\u6570\u636e\u8fc7\u591a,\u4e00\u822c\u671f\u5f85\u53ea\u6709\u4e00\u4e2a\u6570\u636e");
        }
        DtoHelper.dto2Eo((BaseVo)bizExtensionImplModifyReqDto, (BaseEo)bizExtImplEo, (String[])new String[]{"bext_code", "bext_impl_code"});
        bizExtImplEo.setId(((BizExtImplEo)bizExtImplEos.get(0)).getId());
        this.bizExtImplDas.updateSelective((BaseEo)bizExtImplEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBizExtImpl(BizExtImplRemoveDto bizExtImplRemoveDto) {
        BizExtImplEo bizExtImplEo = new BizExtImplEo();
        bizExtImplEo.setBextCode(bizExtImplRemoveDto.getBextCode());
        bizExtImplEo.setBextCode(bizExtImplRemoveDto.getBextImplCode());
        this.bizExtImplDas.logicDelete((BaseEo)bizExtImplEo);
    }

    @Override
    public PageInfo<BizExtensionQueryRespDto> queryByPage(BizExtensionQueryReqDto bizExtensionQueryReqDto, Integer pageNum, Integer pageSize) {
        boolean ability = true;
        boolean impl = true;
        if (StringUtils.isNotBlank((CharSequence)bizExtensionQueryReqDto.getRef())) {
            String[] ref = bizExtensionQueryReqDto.getRef().split(",");
            ability = Arrays.stream(ref).noneMatch("ability"::equals);
            impl = Arrays.stream(ref).noneMatch("impl"::equals);
        }
        BizExtensionEo queryEo = new BizExtensionEo();
        DtoHelper.dto2Eo((BaseVo)bizExtensionQueryReqDto, (BaseEo)queryEo);
        queryEo.setOrderByDesc("create_time");
        PageInfo pageInfo = new PageInfo();
        if (StringUtils.isNotBlank((CharSequence)bizExtensionQueryReqDto.getAbilityCodes())) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            Object[] abilityCode = bizExtensionQueryReqDto.getAbilityCodes().split(",");
            ArrayList abilityCodes = new ArrayList(abilityCode.length);
            CollectionUtils.addAll(abilityCodes, (Object[])abilityCode);
            List bizExtensionEos = this.bizExtensionDas.selectBizExtensionEos(queryEo, abilityCodes);
            pageInfo = new PageInfo(bizExtensionEos);
        } else {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            if (StringUtils.isNotBlank((CharSequence)bizExtensionQueryReqDto.getBextCode())) {
                sqlFilters.add(SqlFilter.like((String)"bext_code", (Object)("%" + bizExtensionQueryReqDto.getBextCode() + "%")));
                queryEo.setBextCode(null);
            }
            if (StringUtils.isNotBlank((CharSequence)bizExtensionQueryReqDto.getBextName())) {
                sqlFilters.add(SqlFilter.like((String)"bext_name", (Object)("%" + bizExtensionQueryReqDto.getBextName() + "%")));
                queryEo.setBextName(null);
            }
            queryEo.setSqlFilters(sqlFilters);
            pageInfo = this.bizExtensionDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        }
        ArrayList<BizExtensionQueryRespDto> dtoList = new ArrayList<BizExtensionQueryRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), dtoList, BizExtensionQueryRespDto.class);
            List<String> codeList = dtoList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getBextCode())).map(BizExtensionQueryRespDto::getBextCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(codeList) && impl) {
                this.setBizExtImplList(dtoList, codeList);
            }
            if (ability) {
                for (BizExtensionQueryRespDto bizExtensionQueryRespDto : dtoList) {
                    AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
                    abilityConfigRelationEo.setConfigCode(bizExtensionQueryRespDto.getBextCode());
                    abilityConfigRelationEo.setType(AbilityConstants.EXTENSION);
                    PageInfo abilityConfigRelationEoPageInfo = this.abilityConfigRelationDas.selectPage((BaseEo)abilityConfigRelationEo, Integer.valueOf(1), Integer.valueOf(1000));
                    if (abilityConfigRelationEoPageInfo == null || !CollectionUtils.isNotEmpty((Collection)abilityConfigRelationEoPageInfo.getList())) continue;
                    List abilityCodes = abilityConfigRelationEoPageInfo.getList().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdAbilityConfigRelationEo::getAbilityCode).collect(Collectors.toList());
                    List abilityEos = this.abilityDas.selectByCodes(abilityCodes, null);
                    ArrayList abilityRespDtos = new ArrayList();
                    DtoHelper.eoList2DtoList((Collection)abilityEos, abilityRespDtos, AbilityRespDto.class);
                    bizExtensionQueryRespDto.setAbilityRespDtos(abilityRespDtos);
                }
            }
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void setBizExtImplList(List<BizExtensionQueryRespDto> dtoList, List<String> codeList) {
        List implEoList = this.bizExtImplDas.selectByBextCodes(codeList);
        Map<String, List<BizExtImplEo>> implEoMap = implEoList.stream().collect(Collectors.groupingBy(StdBizExtImplEo::getBextCode));
        dtoList.forEach(dto -> {
            List eoList = (List)implEoMap.get(dto.getBextCode());
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)dto.getExtImplList(), BizExtImplRespDto.class);
        });
    }

    @Override
    public BizExtensionQueryRespDto queryByCode(String code, BizExtensionSingleQueryReqDto extensionSingleQueryReqDto) {
        BizExtensionQueryRespDto result = new BizExtensionQueryRespDto();
        BizExtensionEo bizExtensionEo = new BizExtensionEo();
        bizExtensionEo.setBextCode(code);
        List bizExtensionEos = this.bizExtensionDas.select((BaseEo)bizExtensionEo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)bizExtensionEos) && bizExtensionEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + "\u6216\u6570\u636e\u4e0d\u5b58\u5728\uff1a \u671f\u5f85\u4e00\u822c\u6709\u4e14\u53ea\u6709\u4e00\u6761\u6570\u636e");
        DtoHelper.eo2Dto((BaseEo)((BaseEo)bizExtensionEos.get(0)), (BaseVo)result);
        String ref = extensionSingleQueryReqDto.getRef();
        if (null != extensionSingleQueryReqDto && null != ref && ref.equals("impl")) {
            BizExtImplEo bizExtImplEo = new BizExtImplEo();
            bizExtImplEo.setBextCode(code);
            List bizExtImplEos = this.bizExtImplDas.select((BaseEo)bizExtImplEo);
            ArrayList bizExtImplRespDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)bizExtImplEos, bizExtImplRespDtos, BizExtImplRespDto.class);
            result.setExtImplList(bizExtImplRespDtos);
        }
        return result;
    }

    private boolean checkItemCode(String itemCode) {
        Pattern pattern = Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(itemCode);
        if (matcher.find()) {
            return true;
        }
        return itemCode.length() > 128;
    }

    @Override
    public List<BizExtImplValueEo> queryImpl(String code, String bizIdCode) {
        BizExtImplValueEo criteria = new BizExtImplValueEo();
        criteria.setBextCode(code);
        criteria.setBizIdCode(bizIdCode);
        return this.bizExtImplValueDas.select((BaseEo)criteria);
    }

    @Override
    public List<BizExtImplScopeEo> queryImplByCode4tenant(Long tenantId, String extensionCode) {
        AssertUtil.isTrue(extensionCode != null, "\u7f3a\u5c11extensionCode");
        AssertUtil.isTrue(tenantId != null, "\u7f3a\u5c11tenantId");
        BizExtImplScopeEo queryEo = new BizExtImplScopeEo();
        queryEo.setBextCode(extensionCode);
        queryEo.setTenantId(tenantId);
        return this.bizExtImplScopeDas.select((BaseEo)queryEo);
    }

    private void setExtImplValueList(Long tenantId, List<BizExtensionQueryRespDto> dtoList, List<String> codeList) {
        List extImplValueEoList = this.bizExtImplValueDas.selectByExtCodes(tenantId, null, codeList);
        Map<String, List<BizExtImplValueEo>> valueEoMap = extImplValueEoList.stream().collect(Collectors.groupingBy(StdBizExtImplValueEo::getBextCode));
        dtoList.forEach(extensionDto -> {
            List eoList = (List)valueEoMap.get(extensionDto.getBextCode());
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)extensionDto.getExtImplValueList(), BizExtImplValueRespDto.class);
        });
    }

    private void setExtImplList(Long tenantId, List<BizExtensionQueryRespDto> dtoList, List<String> codeList) {
        List bizExtImplScopeEoList = this.bizExtImplScopeDas.selectByExtCodes(tenantId, codeList);
        Map<String, List<BizExtImplScopeEo>> scopeEoMap = bizExtImplScopeEoList.stream().collect(Collectors.groupingBy(StdBizExtImplScopeEo::getBextCode));
        List bizExtImplEoList = this.bizExtImplDas.selectByBextCodes(codeList);
        Map<String, List<BizExtImplEo>> implEoMap = bizExtImplEoList.stream().collect(Collectors.groupingBy(StdBizExtImplEo::getBextCode));
        dtoList.forEach(extensionDto -> {
            ArrayList<BizExtImplEo> eoList = new ArrayList<BizExtImplEo>();
            List scopeEoList = (List)scopeEoMap.get(extensionDto.getBextCode());
            List implEoList = (List)implEoMap.get(extensionDto.getBextCode());
            Map<String, List<BizExtImplEo>> eoMap = implEoList.stream().collect(Collectors.groupingBy(StdBizExtImplEo::getBextImplCode));
            for (BizExtImplScopeEo eo : scopeEoList) {
                List<BizExtImplEo> list = eoMap.get(eo.getBextImplCode());
                if (!CollectionUtils.isNotEmpty(list)) continue;
                eoList.addAll(list);
            }
            DtoHelper.eoList2DtoList(eoList, (Collection)extensionDto.getExtImplList(), BizExtImplRespDto.class);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setBizExtImplValue(String bizSpaceCode, List<BizExtImplValueReqDto> extImplValueDtoList) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        AssertUtil.isTrue(tenantId != null, "tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(extImplValueDtoList), "\u6269\u5c55\u70b9\u5177\u4f53\u5b9e\u73b0\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        String bizIdCode = "tenantId=" + tenantId;
        Map<String, List<BizExtImplValueReqDto>> map = extImplValueDtoList.stream().collect(Collectors.groupingBy(BizExtImplValueReqDto::getBextCode));
        ArrayList<BizExtImplValueEo> valueEoList = new ArrayList<BizExtImplValueEo>();
        for (Map.Entry<String, List<BizExtImplValueReqDto>> entry : map.entrySet()) {
            String extCode = entry.getKey();
            BizExtensionEo extensionEo = this.bizExtensionDas.selectByExtCode(extCode);
            AssertUtil.isTrue(null != extensionEo, CenterDataExceptionCode.EXTENSION_NOT_EXISTS);
            this.bizExtImplValueDas.deleteByExtCodeAndBizIdCode(bizSpaceCode, extCode, bizIdCode);
            this.bizExtImplValueDas.deleteByExtCodeAndBizIdCode(bizSpaceCode, extCode, "");
            List<BizExtImplValueReqDto> dtoList = entry.getValue();
            for (BizExtImplValueReqDto valueDto : dtoList) {
                if (!StringUtils.isNotBlank((CharSequence)valueDto.getBextImplCode())) continue;
                BizExtImplValueEo extImplValueEo = new BizExtImplValueEo();
                DtoHelper.dto2Eo((BaseVo)valueDto, (BaseEo)extImplValueEo);
                extImplValueEo.setTenantId(tenantId);
                extImplValueEo.setBizIdCode("");
                if (StringUtils.isBlank((CharSequence)extImplValueEo.getExtension())) {
                    extImplValueEo.setExtension("");
                }
                valueEoList.add(extImplValueEo);
            }
        }
        this.bizExtImplValueDas.insertBatch(valueEoList);
    }

    @Override
    public List<ConfigScopeEo> queryConfigScope(Long tenantId, String extensionCode) {
        AssertUtil.isTrue(extensionCode != null, "\u7f3a\u5c11extensionCode");
        AssertUtil.isTrue(tenantId != null, "\u7f3a\u5c11tenantId");
        ConfigScopeEo configScopeEo = new ConfigScopeEo();
        configScopeEo.setConfigCode(extensionCode);
        configScopeEo.packBizIdCodeByTenantId(tenantId);
        configScopeEo.setType(AbilityConstants.EXTENSION);
        return this.configScopeDas.select((BaseEo)configScopeEo);
    }

    @Override
    public List<BizExtImplEo> queryExtImplByCode(Long tenantId, String bextCode) {
        BizExtImplEo queryEo = new BizExtImplEo();
        queryEo.setBextCode(bextCode);
        queryEo.setTenantId(tenantId);
        return this.bizExtImplDas.select((BaseEo)queryEo);
    }

    private BizExtensionImportVo proccessInsertEo(List<BizExtensionCreateReqDto> importReqDtoList) {
        BizExtensionImportVo bizExtensionImportVo = new BizExtensionImportVo();
        ArrayList<BizExtensionEo> bizExtensionEos = new ArrayList<BizExtensionEo>();
        ArrayList<BizExtImplEo> bizExtImplEos = new ArrayList<BizExtImplEo>();
        ArrayList<AbilityConfigRelationEo> abilityConfigRelationInsertEos = new ArrayList<AbilityConfigRelationEo>();
        for (BizExtensionCreateReqDto bizExtensionCreateReqDto : importReqDtoList) {
            String bextCode = bizExtensionCreateReqDto.getBextCode();
            BizExtensionEo bizExtensionEo = new BizExtensionEo();
            DtoHelper.dto2Eo((BaseVo)bizExtensionCreateReqDto, (BaseEo)bizExtensionEo);
            if (StringUtils.isBlank((CharSequence)bizExtensionCreateReqDto.getExtension())) {
                bizExtensionEo.setExtension("");
            }
            if (StringUtils.isBlank((CharSequence)bizExtensionCreateReqDto.getSource())) {
                bizExtensionEo.setSource("");
            }
            if (bizExtensionCreateReqDto.getGrade() == null) {
                bizExtensionEo.setGrade(Integer.valueOf(GradeType.APPINSTANCE.getCode()));
            }
            bizExtensionEo.setCapabilityCode(bizExtensionCreateReqDto.getCapabilityCode());
            bizExtensionEos.add(bizExtensionEo);
            List bizExtensionImplReqDtos = bizExtensionCreateReqDto.getBizExtensionImplReqDtos();
            if (CollectionUtils.isNotEmpty((Collection)bizExtensionImplReqDtos)) {
                for (BizExtensionImplReqDto implDto : bizExtensionImplReqDtos) {
                    BizExtImplEo bizExtImplEo = new BizExtImplEo();
                    DtoHelper.dto2Eo((BaseVo)implDto, (BaseEo)bizExtImplEo);
                    bizExtImplEo.setBextCode(bextCode);
                    if (StringUtils.isBlank((CharSequence)implDto.getExtension())) {
                        bizExtImplEo.setExtension("");
                    }
                    bizExtImplEos.add(bizExtImplEo);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)bizExtensionCreateReqDto.getAbilityCodes())) continue;
            for (String abilityCode : bizExtensionCreateReqDto.getAbilityCodes()) {
                AbilityConfigRelationEo abilityConfigRelationEo = new AbilityConfigRelationEo();
                abilityConfigRelationEo.setConfigCode(bextCode);
                abilityConfigRelationEo.setType(AbilityConstants.EXTENSION);
                abilityConfigRelationEo.setAbilityCode(abilityCode);
                abilityConfigRelationEo.setExtension("");
                abilityConfigRelationInsertEos.add(abilityConfigRelationEo);
            }
        }
        bizExtensionImportVo.setBizExtensionEos(bizExtensionEos);
        bizExtensionImportVo.setBizExtImplEoList(bizExtImplEos);
        bizExtensionImportVo.setAbilityConfigRelationInsertEos(abilityConfigRelationInsertEos);
        return bizExtensionImportVo;
    }

    private boolean checkFeild(BizExtensionCreateReqDto bizExtensionCreateReqDto) {
        if (!BizExtensionServiceImpl.checkCodeFormat(bizExtensionCreateReqDto.getBextCode())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)bizExtensionCreateReqDto.getBextName())) {
            return false;
        }
        if (bizExtensionCreateReqDto.getBextName().length() > 20) {
            return false;
        }
        return bizExtensionCreateReqDto.getBextType() != null && ExtensionSelectType.fromCode((int)bizExtensionCreateReqDto.getBextType()) != null;
    }

    private static boolean checkCodeFormat(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        if (str.length() > 200) {
            return false;
        }
        Pattern pattern = Pattern.compile("([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*");
        return pattern.matcher(str).matches();
    }

    private static boolean checkImplCodeFormat(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        if (str.length() > 200) {
            return false;
        }
        Pattern pattern = Pattern.compile("([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*");
        return pattern.matcher(str).matches();
    }
}

