/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizRuleBasicReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizRuleReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizRuleRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizRuleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IRBizRuleSpaceIdentityService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.BizIdServiceImpl;
import com.dtyunxi.yundt.cube.center.func.biz.support.BusinessIdentityIdentifyService;
import com.dtyunxi.yundt.cube.center.func.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizRuleDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizRuleObjPropertyDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizRuleSpaceIdentityDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizRuleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizRuleObjPropertyEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizRuleSpaceIdentityEo;
import com.github.pagehelper.PageInfo;
import com.googlecode.aviator.AviatorEvaluator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizRuleServiceImpl
implements IBizRuleService {
    private static final Logger logger = LoggerFactory.getLogger(BizRuleServiceImpl.class);
    @Resource
    private BizIdServiceImpl bizIdService;
    @Resource
    private BizRuleDas bizRuleDas;
    @Resource
    private RBizRuleSpaceIdentityDas bizRuleSpaceIdentityDas;
    @Resource
    private IRBizRuleSpaceIdentityService rBizRuleSpaceIdentityService;
    @Resource
    private BusinessIdentityIdentifyService businessIdentityIdentifyService;
    @Resource
    private RBizRuleObjPropertyDas rBizRuleObjDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(BizRuleReqDto addDto) {
        this.checkNameUniqueUnderBizIdentity(addDto, null);
        BizRuleEo insertEo = new BizRuleEo();
        DtoHelper.dto2Eo((BaseVo)addDto, (BaseEo)insertEo);
        insertEo.setTextExpression(addDto.getExpression());
        insertEo.setId(this.bizRuleDas.getId());
        insertEo.setCodeExpression(this.businessIdentityIdentifyService.expressionConvert(addDto.getExpression(), insertEo.getId()));
        try {
            AviatorEvaluator.compile((String)insertEo.getCodeExpression());
        }
        catch (Exception e) {
            throw new BizException("\u89c4\u5219\u8868\u8fbe\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u786e\u8ba4\u65e0\u8bef\u540e\u91cd\u65b0\u586b\u5199");
        }
        if (addDto.getStatus() == null) {
            addDto.setStatus(AbilityConstants.ENABLE);
        }
        this.bizRuleDas.insert((BaseEo)insertEo);
        if (insertEo.getId() == null) {
            throw new BizException("\u65b0\u589e\u4e1a\u52a1\u89c4\u5219\u5f02\u5e38\uff0c\u4fdd\u5b58\u6570\u636e\u5931\u8d25");
        }
        this.saveRelationData(addDto, insertEo.getId());
        this.bizIdService.clearBizIdMapCache();
        return insertEo.getId();
    }

    private void checkNameUniqueUnderBizIdentity(BizRuleReqDto addDto, Long id) {
        BizRuleEo selectParam = new BizRuleEo();
        selectParam.setName(addDto.getName());
        if (id != null) {
            selectParam.setSqlFilters(SqlFilterBuilder.buildNotEqualsSqlFilter("id", id).get());
        }
        StringBuilder extSql = new StringBuilder();
        extSql.append(String.format(" and id in (select biz_rule_id from bd_r_biz_rule_space_identity t0 where t0.biz_identity_code='%s')", addDto.getBizIdentityCode()));
        List existedList = this.bizRuleDas.selectWithExtSql((BaseEo)selectParam, extSql.toString());
        if (CollectionUtils.isNotEmpty((Collection)existedList)) {
            throw new BizException("\u4e1a\u52a1\u89c4\u5219\u540d\u79f0\u5728\u4e1a\u52a1\u8eab\u4efd\u4e0b\u4e0d\u80fd\u91cd\u590d");
        }
    }

    private void saveRelationData(BizRuleReqDto addDto, Long bizRuleId) {
        RBizRuleSpaceIdentityEo rBizRuleSpaceIdentityEo = new RBizRuleSpaceIdentityEo();
        rBizRuleSpaceIdentityEo.setBizIdentityCode(addDto.getBizIdentityCode());
        rBizRuleSpaceIdentityEo.setBizSpaceCode(addDto.getBizSpaceCode());
        rBizRuleSpaceIdentityEo.setBizRuleId(bizRuleId);
        this.bizRuleSpaceIdentityDas.insert((BaseEo)rBizRuleSpaceIdentityEo);
        if (rBizRuleSpaceIdentityEo.getId() == null) {
            logger.warn("\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u3001\u4e1a\u52a1\u7a7a\u95f4\u3001\u4e1a\u52a1\u8eab\u4efd\u5173\u7cfb\u8bb0\u5f55\u5931\u8d25\uff1a{}", (Object)bizRuleId);
        }
    }

    @Override
    public BizRuleRespDto getDetail(Long id) {
        BizRuleEo bizRuleEo = (BizRuleEo)this.bizRuleDas.selectByPrimaryKey(id);
        if (bizRuleEo == null) {
            throw new BizException("\u4e1a\u52a1\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        BizRuleRespDto detail = new BizRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)bizRuleEo, (BaseVo)detail);
        detail.setExpression(bizRuleEo.getTextExpression());
        detail.setOwners(this.rBizRuleSpaceIdentityService.queryOwnersOfRules(Collections.singletonList(id)));
        return detail;
    }

    @Override
    public PageInfo<BizRuleRespDto> queryPage(BizRuleQueryReqDto query) {
        BizRuleEo selectParam = new BizRuleEo();
        DtoHelper.dto2Eo((BaseVo)query, (BaseEo)selectParam);
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)query.getName())) {
            sqlFilters.add(SqlFilterBuilder.buildFuzzyParam(query.getName(), "name"));
            selectParam.setName(null);
        }
        selectParam.setSqlFilters(sqlFilters);
        String extSql = "";
        if (StringUtils.isNotEmpty((CharSequence)query.getBizIdentityCode())) {
            extSql = StringUtils.isNotEmpty((CharSequence)query.getBizSpaceCode()) ? String.format(" exists( SELECT 1 FROM bd_r_biz_rule_space_identity inner_t WHERE inner_t.biz_rule_id=bd_biz_rule.id and inner_t.biz_identity_code ='%s' and inner_t.biz_space_code='%s')", query.getBizIdentityCode(), query.getBizSpaceCode()) : String.format(" exists( SELECT 1 FROM bd_r_biz_rule_space_identity inner_t WHERE inner_t.biz_rule_id=bd_biz_rule.id and inner_t.biz_identity_code ='%s')", query.getBizIdentityCode());
        } else if (StringUtils.isNotEmpty((CharSequence)query.getBizSpaceCode())) {
            extSql = String.format(" exists( SELECT 1 FROM bd_r_biz_rule_space_identity inner_t WHERE inner_t.biz_rule_id=bd_biz_rule.id and inner_t.biz_space_code='%s')", query.getBizSpaceCode());
        }
        PageInfo finalPageInfo = new PageInfo();
        selectParam.setOrderByDesc("create_time");
        PageInfo pageInfo = this.bizRuleDas.selectPageWithExtSql((BaseEo)selectParam, Integer.valueOf(query.getPageNum()), Integer.valueOf(query.getPageSize()), extSql);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            HashMap id2DtoMap = new HashMap();
            List list = pageInfo.getList().stream().map(eo -> {
                BizRuleRespDto bizRuleRespDto = new BizRuleRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)bizRuleRespDto);
                bizRuleRespDto.setExpression(eo.getTextExpression());
                id2DtoMap.put(eo.getId(), bizRuleRespDto);
                return bizRuleRespDto;
            }).collect(Collectors.toList());
            List<BizRuleRespDto.BizIdentity2Space> owners = this.rBizRuleSpaceIdentityService.queryOwnersOfRules(id2DtoMap.keySet());
            for (BizRuleRespDto.BizIdentity2Space owner : owners) {
                BizRuleRespDto bizRuleRespDto = (BizRuleRespDto)id2DtoMap.get(owner.getBizRuleId());
                if (bizRuleRespDto == null) continue;
                if (bizRuleRespDto.getOwners() == null) {
                    bizRuleRespDto.setOwners(new LinkedList());
                }
                bizRuleRespDto.getOwners().add(owner);
            }
            BeanUtils.copyProperties((Object)pageInfo, (Object)finalPageInfo);
            finalPageInfo.setList(list);
            return finalPageInfo;
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)finalPageInfo);
        return finalPageInfo;
    }

    @Override
    public void enable(Long id) {
        BizRuleEo bizRuleEo = (BizRuleEo)this.bizRuleDas.selectByPrimaryKey(id);
        if (bizRuleEo == null) {
            throw new BizException("\u4e1a\u52a1\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u542f\u7528\u5931\u8d25");
        }
        BizRuleEo enableEo = new BizRuleEo();
        enableEo.setId(id);
        enableEo.setStatus(AbilityConstants.ENABLE);
        this.bizRuleDas.updateSelective((BaseEo)enableEo);
        this.bizIdService.clearBizIdMapCache();
    }

    @Override
    public void disable(Long id) {
        BizRuleEo bizRuleEo = (BizRuleEo)this.bizRuleDas.selectByPrimaryKey(id);
        if (bizRuleEo == null) {
            throw new BizException("\u4e1a\u52a1\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u7981\u7528\u5931\u8d25");
        }
        BizRuleEo disableEo = new BizRuleEo();
        disableEo.setId(id);
        disableEo.setStatus(AbilityConstants.DISABLE);
        this.bizRuleDas.updateSelective((BaseEo)disableEo);
        this.bizIdService.clearBizIdMapCache();
    }

    @Override
    public void delete(Long id) {
        this.bizRuleDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(Long id, BizRuleReqDto editDto) {
        this.checkNameUniqueUnderBizIdentity(editDto, id);
        BizRuleEo bizRuleEo = (BizRuleEo)this.bizRuleDas.selectByPrimaryKey(id);
        if (bizRuleEo == null) {
            throw new BizException("\u4e1a\u52a1\u89c4\u5219\u4e0d\u5b58\u5728,\u7f16\u8f91\u5931\u8d25");
        }
        DtoHelper.dto2Eo((BaseVo)editDto, (BaseEo)bizRuleEo);
        RBizRuleObjPropertyEo deleteParam1 = new RBizRuleObjPropertyEo();
        deleteParam1.setBizRuleId(id);
        this.rBizRuleObjDas.delete((BaseEo)deleteParam1);
        bizRuleEo.setTextExpression(editDto.getExpression());
        bizRuleEo.setCodeExpression(this.businessIdentityIdentifyService.expressionConvert(editDto.getExpression(), id));
        try {
            AviatorEvaluator.compile((String)bizRuleEo.getCodeExpression());
        }
        catch (Exception e) {
            throw new BizException("\u89c4\u5219\u8868\u8fbe\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u786e\u8ba4\u65e0\u8bef\u540e\u91cd\u65b0\u586b\u5199");
        }
        this.bizRuleDas.updateSelective((BaseEo)bizRuleEo);
        RBizRuleSpaceIdentityEo deleteParam = new RBizRuleSpaceIdentityEo();
        deleteParam.setBizRuleId(id);
        this.bizRuleSpaceIdentityDas.delete((BaseEo)deleteParam);
        this.saveRelationData(editDto, id);
        this.bizIdService.clearBizIdMapCache();
    }

    @Override
    public List<BizRuleBasicReqDto> queryByBizSpaceCodeAndBizIdentityCodes(String bizSpaceCode, Collection<String> bizIdentityCodes) {
        return null;
    }
}

